/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.impl.FSIteratorImplBase;
import com.ibm.uima.cas.text.AnnotationFS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;

public class UnambiguousIteratorImpl
extends FSIteratorImplBase {
    private ArrayList list;
    private int pos;

    private UnambiguousIteratorImpl() {
        this.pos = 0;
    }

    public UnambiguousIteratorImpl(FSIterator fSIterator) {
        this();
        this.list = new ArrayList();
        fSIterator.moveToFirst();
        if (!fSIterator.isValid()) {
            return;
        }
        AnnotationFS annotationFS = (AnnotationFS)fSIterator.get();
        this.list.add(annotationFS);
        fSIterator.moveToNext();
        while (fSIterator.isValid()) {
            AnnotationFS annotationFS2 = (AnnotationFS)fSIterator.get();
            if (annotationFS.getEnd() <= annotationFS2.getBegin()) {
                annotationFS = annotationFS2;
                this.list.add(annotationFS);
            }
            fSIterator.moveToNext();
        }
    }

    public UnambiguousIteratorImpl(FSIterator fSIterator, int n, int n2, boolean bl) {
        this.initUnambiguousSubiterator(fSIterator, n, n2, bl);
    }

    private void initUnambiguousSubiterator(FSIterator fSIterator, int n, int n2, boolean bl) {
        this.list = new ArrayList();
        fSIterator.moveToFirst();
        while (fSIterator.isValid() && n > ((AnnotationFS)fSIterator.get()).getBegin()) {
            fSIterator.moveToNext();
        }
        if (!fSIterator.isValid()) {
            this.pos = 0;
            return;
        }
        AnnotationFS annotationFS = (AnnotationFS)fSIterator.get();
        this.list.add(annotationFS);
        fSIterator.moveToNext();
        while (fSIterator.isValid()) {
            AnnotationFS annotationFS2 = (AnnotationFS)fSIterator.get();
            if (annotationFS2.getBegin() < annotationFS.getEnd()) {
                fSIterator.moveToNext();
                continue;
            }
            if (annotationFS2.getBegin() > n2) break;
            if (!bl || annotationFS.getEnd() <= n2) {
                annotationFS = annotationFS2;
                this.list.add(annotationFS);
            }
            fSIterator.moveToNext();
        }
    }

    public boolean isValid() {
        return this.pos >= 0 && this.pos < this.list.size();
    }

    public FeatureStructure get() throws NoSuchElementException {
        if (this.isValid()) {
            return (FeatureStructure)this.list.get(this.pos);
        }
        throw new NoSuchElementException();
    }

    public void moveToNext() {
        ++this.pos;
    }

    public void moveToPrevious() {
        --this.pos;
    }

    public void moveToFirst() {
        this.pos = 0;
    }

    public void moveToLast() {
        this.pos = this.list.size() - 1;
    }

    public void moveTo(FeatureStructure featureStructure) {
        int n = Collections.binarySearch(this.list, featureStructure);
        this.pos = n >= 0 ? n : -n - 1;
    }

    public FSIterator copy() {
        UnambiguousIteratorImpl unambiguousIteratorImpl = new UnambiguousIteratorImpl();
        unambiguousIteratorImpl.list = this.list;
        unambiguousIteratorImpl.pos = this.pos;
        return unambiguousIteratorImpl;
    }
}

