/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import java.util.StringTokenizer;

abstract class TypeSystemUtils {
    TypeSystemUtils() {
    }

    static boolean isIdentifier(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (string == null || n == 0) {
            return false;
        }
        int n2 = 0;
        if (!TypeSystemUtils.isIdentifierStart(string.charAt(n2))) {
            return false;
        }
        ++n2;
        while (n2 < n) {
            if (!TypeSystemUtils.isIdentifierChar(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static boolean isNonQualifiedName(String string) {
        return TypeSystemUtils.isIdentifier(string);
    }

    static boolean isIdentifierStart(char c) {
        return Character.isLetter(c);
    }

    static boolean isIdentifierChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    static boolean isTypeName(String string) {
        String string2 = ".";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        while (stringTokenizer.hasMoreTokens()) {
            if (!TypeSystemUtils.isIdentifier(stringTokenizer.nextToken())) {
                return false;
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            if (!stringTokenizer.nextToken().equals(string2)) {
                return false;
            }
            if (stringTokenizer.hasMoreTokens()) continue;
            return false;
        }
        return true;
    }

    static boolean isTypeNameSpaceName(String string) {
        return TypeSystemUtils.isTypeName(string);
    }

    static class ParsingError {
        private int errorCode;
        private int errorPosition;

        ParsingError() {
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public int getErrorPosition() {
            return this.errorPosition;
        }

        public void setErrorCode(int n) {
            this.errorCode = n;
        }

        public void setErrorPosition(int n) {
            this.errorPosition = n;
        }
    }

    static class FeatureParse
    extends TypeSystemParse {
        private TypeParse type;
        private String name;

        FeatureParse() {
        }

        public String getName() {
            return this.name;
        }

        public TypeParse getType() {
            return this.type;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setType(TypeParse typeParse) {
            this.type = typeParse;
        }
    }

    static class TypeParse
    extends TypeSystemParse {
        private String name;
        private NameSpaceParse nameSpace;

        TypeParse() {
        }

        TypeParse(String string) {
            this();
            this.name = string;
        }

        boolean isQualified() {
            return this.nameSpace != null;
        }

        String getName() {
            return this.name;
        }

        NameSpaceParse getNameSpace() {
            return this.nameSpace;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setNameSpace(NameSpaceParse nameSpaceParse) {
            this.nameSpace = nameSpaceParse;
        }
    }

    static class NameSpaceParse
    extends TypeSystemParse {
        private String name;

        NameSpaceParse() {
        }

        String getName() {
            return this.name;
        }

        void setName(String string) {
            this.name = string;
        }
    }

    static abstract class TypeSystemParse {
        private ParsingError error = null;

        protected TypeSystemParse() {
        }

        boolean hasError() {
            return this.error != null;
        }

        ParsingError getError() {
            return this.error;
        }

        void setError(ParsingError parsingError) {
            this.error = parsingError;
        }
    }
}

