/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.impl.TypeSystemImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TypeImpl
implements Type,
Comparable {
    private final String name;
    private final int code;
    private final TypeSystemImpl ts;
    private boolean isFeatureFinal;
    private boolean isInheritanceFinal;

    private TypeImpl() {
        this.name = null;
        this.code = 0;
        this.ts = null;
    }

    TypeImpl(String string, int n, TypeSystemImpl typeSystemImpl) {
        this.name = string;
        this.code = n;
        this.ts = typeSystemImpl;
        this.isInheritanceFinal = false;
        this.isFeatureFinal = false;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public Vector getAppropriateFeatures() {
        return new Vector(this.getFeatures());
    }

    public int getNumberOfFeatures() {
        return this.ts.getAppropriateFeatures(this.code).length;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    public int getCode() {
        return this.code;
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        TypeImpl typeImpl = (TypeImpl)object;
        return this.code < typeImpl.code ? -1 : 1;
    }

    public Feature getFeatureByBaseName(String string) {
        return this.ts.getFeatureByFullName(this.name + ':' + string);
    }

    public String getShortName() {
        int n = this.name.lastIndexOf(46);
        if (n >= 0) {
            return this.name.substring(n + 1, this.name.length());
        }
        return this.name;
    }

    public boolean isPrimitive() {
        return !this.getTypeSystem().getLowLevelTypeSystem().ll_isRefType(this.code);
    }

    public boolean isFeatureFinal() {
        return this.isFeatureFinal;
    }

    public boolean isInheritanceFinal() {
        return this.isInheritanceFinal;
    }

    void setFeatureFinal() {
        this.isFeatureFinal = true;
    }

    void setInheritanceFinal() {
        this.isInheritanceFinal = true;
    }

    public Feature getFeature(String string) {
        return this.getFeatureByBaseName(string);
    }

    public List getFeatures() {
        int[] nArray = this.ts.getAppropriateFeatures(this.code);
        ArrayList<Feature> arrayList = new ArrayList<Feature>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.ts.getFeature(nArray[i]));
        }
        return arrayList;
    }

    public boolean isArray() {
        return this.ts.ll_isArrayType(this.code);
    }

    public Type getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return this.ts.ll_getTypeForCode(this.ts.ll_getComponentType(this.code));
    }
}

