/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.CASException;
import com.ibm.uima.cas.FSIndex;
import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.SofaFS;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.admin.CASAdminException;
import com.ibm.uima.cas.impl.AnnotationIndexImpl;
import com.ibm.uima.cas.impl.CASCompleteSerializer;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.CASMgrSerializer;
import com.ibm.uima.cas.impl.FSIndexRepositoryImpl;
import com.ibm.uima.cas.impl.FeatureImpl;
import com.ibm.uima.cas.impl.TCASSerializer;
import com.ibm.uima.cas.impl.TypeImpl;
import com.ibm.uima.cas.impl.TypeSystemImpl;
import com.ibm.uima.cas.text.AnnotationFS;
import com.ibm.uima.cas.text.Language;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.cas.text.TCASException;
import com.ibm.uima.cas.text.TCASMgr;
import com.ibm.uima.cas.text.TCASRuntimeException;
import com.ibm.uima.jcas.impl.JCas;
import java.util.ArrayList;

public class TCASImpl
extends CASImpl
implements TCAS,
TCASMgr {
    protected Type annotType;
    protected Feature sofaFeat;
    protected Feature startFeat;
    protected Feature endFeat;
    protected Type docType;
    protected Feature langFeat;
    protected int annotTypeCode;
    protected int startFeatCode;
    protected int endFeatCode;
    protected int langFeatCode;
    private boolean canSetText = true;
    private String documentText;

    public TCASImpl() {
        this(500000);
    }

    public TCASImpl(int n) {
        super(n);
        this.initTypeSystem(false);
    }

    public TCASImpl(CAS cAS, SofaFS sofaFS) {
        super(cAS);
        this.initTypeSystem(true);
        this.mySofaRef = sofaFS.getSofaRef();
        this.initFSClassRegistry();
        this.indexRepository = (FSIndexRepositoryImpl)((CASImpl)cAS).getSofaIndexRepository(sofaFS);
        if (null == this.indexRepository) {
            this.indexRepository = new FSIndexRepositoryImpl(this, (FSIndexRepositoryImpl)cAS.getIndexRepository());
            this.indexRepository.commit();
            ((CASImpl)cAS).setSofaIndexRepository(sofaFS, this.indexRepository);
        }
        this.annotType = this.ts.getType("uima.tcas.Annotation");
        this.sofaFeat = this.ts.getFeatureByFullName("uima.tcas.Annotation:sofa");
        this.startFeat = this.ts.getFeatureByFullName("uima.tcas.Annotation:begin");
        this.endFeat = this.ts.getFeatureByFullName("uima.tcas.Annotation:end");
        this.docType = this.ts.getType("uima.tcas.DocumentAnnotation");
        this.langFeat = this.docType.getFeatureByBaseName("language");
        this.startFeatCode = ((FeatureImpl)this.startFeat).getCode();
        this.endFeatCode = ((FeatureImpl)this.endFeat).getCode();
        this.langFeatCode = this.getLowLevelCAS().ll_getTypeSystem().ll_getCodeForFeature(this.langFeat);
        this.annotTypeCode = ((TypeImpl)this.annotType).getCode();
        this.startFeatCode = ((FeatureImpl)this.startFeat).getCode();
        this.endFeatCode = ((FeatureImpl)this.endFeat).getCode();
        this.langFeatCode = this.getLowLevelCAS().ll_getTypeSystem().ll_getCodeForFeature(this.langFeat);
    }

    public void updateDocumentAnnotation() {
        String string;
        Type type = this.ts.getType("uima.cas.Sofa");
        Feature feature = type.getFeatureByBaseName("sofaString");
        this.documentText = string = this.getSofa(this.mySofaRef).getStringValue(feature);
        if (null != string) {
            this.getDocumentAnnotation().setIntValue(this.endFeat, string.length());
        }
    }

    public TCASImpl(TypeSystemImpl typeSystemImpl, int n) {
        super(typeSystemImpl, n);
        this.initTypeSystem(false);
    }

    public TCASImpl(CASMgrSerializer cASMgrSerializer) {
        super(cASMgrSerializer);
        this.initTypeSystem(true);
    }

    public void initTypeSystem(boolean bl) {
        if (bl) {
            this.annotType = this.ts.getType("uima.tcas.Annotation");
            this.sofaFeat = this.ts.getFeatureByFullName("uima.tcas.Annotation:sofa");
            this.startFeat = this.ts.getFeatureByFullName("uima.tcas.Annotation:begin");
            this.endFeat = this.ts.getFeatureByFullName("uima.tcas.Annotation:end");
            this.docType = this.ts.getType("uima.tcas.DocumentAnnotation");
            this.langFeat = this.docType.getFeatureByBaseName("language");
        }
    }

    public void initTCASIndexes() throws TCASException {
        throw new TCASException(3);
    }

    protected JCas getJCas(JCas jCas) throws CASException {
        this.jcas = JCas.getJCas(this);
        return this.jcas;
    }

    public void setDocumentText(String string) throws TCASRuntimeException {
        if (!this.canSetText) {
            throw new TCASRuntimeException(0);
        }
        this.getSofa(this.mySofaRef).setLocalSofaData(string);
    }

    public void setDocumentLanguage(String string) throws TCASRuntimeException {
        if (!this.canSetText) {
            throw new TCASRuntimeException(0);
        }
        TCASImpl tCASImpl = this;
        int n = tCASImpl.ll_getFSRef(this.getDocumentAnnotation());
        string = Language.normalize(string);
        tCASImpl.ll_setStringValue(n, this.langFeatCode, string);
    }

    public String getDocumentLanguage() {
        TCASImpl tCASImpl = this;
        int n = tCASImpl.ll_getFSRef(this.getDocumentAnnotation());
        return tCASImpl.ll_getStringValue(n, this.langFeatCode);
    }

    private AnnotationFS createDocumentAnnotation(int n) {
        FSIterator fSIterator = this.getAnnotationIndex(this.docType).iterator();
        ArrayList<FeatureStructure> arrayList = new ArrayList<FeatureStructure>();
        while (fSIterator.isValid()) {
            arrayList.add(fSIterator.get());
            fSIterator.moveToNext();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.getIndexRepository().removeFS((FeatureStructure)arrayList.get(i));
        }
        AnnotationFS annotationFS = this.createAnnotation(this.docType, 0, n);
        this.getIndexRepository().addFS(annotationFS);
        annotationFS.setStringValue(this.langFeat, "x-unspecified");
        return annotationFS;
    }

    public String getDocumentText() {
        return this.documentText;
    }

    public Type getAnnotationType() {
        return this.annotType;
    }

    public boolean isAnnotationType(Type type) {
        return this.getTypeSystem().subsumes(this.annotType, type);
    }

    public boolean isAnnotationType(int n) {
        return this.ts.subsumes(this.annotTypeCode, n);
    }

    public FSIndex getAnnotationIndex() {
        return new AnnotationIndexImpl(this.indexRepository.getIndex("AnnotationIndex"));
    }

    public FSIndex getAnnotationIndex(Type type) {
        return new AnnotationIndexImpl(this.getIndexRepository().getIndex("AnnotationIndex", type));
    }

    public AnnotationFS createAnnotation(Type type, int n, int n2) {
        FeatureStructure featureStructure = this.createFS(type);
        int n3 = this.ll_getFSRef(featureStructure);
        this.setSofaFeat(n3, this.mySofaRef);
        this.setStartFeat(n3, n);
        this.setEndFeat(n3, n2);
        return (AnnotationFS)featureStructure;
    }

    private void setStartFeat(int n, int n2) {
        this.setFeatureValue(n, this.startFeatCode, n2);
    }

    private void setEndFeat(int n, int n2) {
        this.setFeatureValue(n, this.endFeatCode, n2);
    }

    int getStartFeat(int n) {
        return this.getFeatureValue(n, this.startFeatCode);
    }

    int getEndFeat(int n) {
        return this.getFeatureValue(n, this.endFeatCode);
    }

    public Feature getEndFeature() {
        return this.endFeat;
    }

    public Feature getBeginFeature() {
        return this.startFeat;
    }

    public AnnotationFS getDocumentAnnotation() {
        FSIterator fSIterator = this.getAnnotationIndex(this.docType).iterator();
        if (fSIterator.isValid()) {
            return (AnnotationFS)fSIterator.get();
        }
        return this.createDocumentAnnotation(0);
    }

    boolean isBuiltinType(Type type) {
        return type == this.annotType || super.isBuiltinType(type);
    }

    public TCAS getTCAS() {
        return this;
    }

    public SofaFS getSofa() {
        return this.getSofa(this.mySofaRef);
    }

    public void reinit(TCASSerializer tCASSerializer) {
        super.reinit(tCASSerializer);
    }

    public void reinit(CASCompleteSerializer cASCompleteSerializer) {
        super.reinit(cASCompleteSerializer);
        this.initTypeSystem(true);
    }

    public void reset() {
        super.reset();
        this.getBaseCAS().createDefaultSofa();
    }

    public void resetNoQuestions() {
        this.indexRepository.flush();
        this.documentText = null;
        if (this.jcas != null) {
            try {
                JCas.clearData(this);
            }
            catch (CASException cASException) {
                CASAdminException cASAdminException = new CASAdminException(10);
                cASAdminException.addArgument(cASException.getMessage());
                throw cASAdminException;
            }
        }
    }

    public void enableSetText(boolean bl) {
        this.canSetText = bl;
    }

    public void setCAS(CAS cAS) {
        super.setCAS(cAS);
    }

    public void setTCAS(TCAS tCAS) {
        this.setCAS(tCAS);
    }

    public boolean isBackwardCompatibleCas() {
        return true;
    }
}

