/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.impl.FSIteratorImplBase;
import com.ibm.uima.cas.text.AnnotationFS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;

public class Subiterator
extends FSIteratorImplBase {
    private ArrayList list = new ArrayList();
    private int pos = 0;

    private Subiterator() {
    }

    Subiterator(FSIterator fSIterator) {
        this();
        fSIterator.moveToFirst();
        if (!fSIterator.isValid()) {
            return;
        }
        AnnotationFS annotationFS = (AnnotationFS)fSIterator.get();
        this.list.add(annotationFS);
        fSIterator.moveToNext();
        while (fSIterator.isValid()) {
            AnnotationFS annotationFS2 = (AnnotationFS)fSIterator.get();
            if (annotationFS.getEnd() <= annotationFS2.getBegin()) {
                annotationFS = annotationFS2;
                this.list.add(annotationFS);
            }
            fSIterator.moveToNext();
        }
    }

    Subiterator(FSIterator fSIterator, AnnotationFS annotationFS, boolean bl, boolean bl2) {
        this();
        if (bl) {
            this.initAmbiguousSubiterator(fSIterator, annotationFS, bl2);
        } else {
            this.initUnambiguousSubiterator(fSIterator, annotationFS, bl2);
        }
    }

    private void initAmbiguousSubiterator(FSIterator fSIterator, AnnotationFS annotationFS, boolean bl) {
        AnnotationFS annotationFS2;
        int n = annotationFS.getBegin();
        int n2 = annotationFS.getEnd();
        fSIterator.moveTo(annotationFS);
        if (fSIterator.isValid() && ((Object)fSIterator.get()).equals(annotationFS)) {
            fSIterator.moveToNext();
        }
        while (fSIterator.isValid() && ((AnnotationFS)fSIterator.get()).getBegin() < n) {
            fSIterator.moveToNext();
        }
        while (fSIterator.isValid() && (annotationFS2 = (AnnotationFS)fSIterator.get()).getBegin() <= n2) {
            fSIterator.moveToNext();
            if (bl && annotationFS2.getEnd() > n2) continue;
            this.list.add(annotationFS2);
        }
    }

    private void initUnambiguousSubiterator(FSIterator fSIterator, AnnotationFS annotationFS, boolean bl) {
        int n = annotationFS.getBegin();
        int n2 = annotationFS.getEnd();
        fSIterator.moveTo(annotationFS);
        if (fSIterator.isValid() && ((Object)fSIterator.get()).equals(annotationFS)) {
            fSIterator.moveToNext();
        }
        if (!fSIterator.isValid()) {
            return;
        }
        annotationFS = (AnnotationFS)fSIterator.get();
        this.list = new ArrayList();
        while (fSIterator.isValid() && (n > annotationFS.getBegin() || bl && annotationFS.getEnd() > n2)) {
            fSIterator.moveToNext();
        }
        if (!fSIterator.isValid()) {
            return;
        }
        AnnotationFS annotationFS2 = (AnnotationFS)fSIterator.get();
        this.list.add(annotationFS2);
        fSIterator.moveToNext();
        while (fSIterator.isValid()) {
            AnnotationFS annotationFS3 = (AnnotationFS)fSIterator.get();
            if (annotationFS3.getBegin() < annotationFS2.getEnd()) {
                fSIterator.moveToNext();
                continue;
            }
            if (annotationFS3.getBegin() > n2) break;
            if (!bl || annotationFS3.getEnd() <= n2) {
                annotationFS2 = annotationFS3;
                this.list.add(annotationFS2);
            }
            fSIterator.moveToNext();
        }
    }

    public boolean isValid() {
        return this.pos >= 0 && this.pos < this.list.size();
    }

    public FeatureStructure get() throws NoSuchElementException {
        if (this.isValid()) {
            return (FeatureStructure)this.list.get(this.pos);
        }
        throw new NoSuchElementException();
    }

    public void moveToNext() {
        ++this.pos;
    }

    public void moveToPrevious() {
        --this.pos;
    }

    public void moveToFirst() {
        this.pos = 0;
    }

    public void moveToLast() {
        this.pos = this.list.size() - 1;
    }

    public void moveTo(FeatureStructure featureStructure) {
        int n = Collections.binarySearch(this.list, featureStructure);
        this.pos = n >= 0 ? n : -n - 1;
    }

    public FSIterator copy() {
        Subiterator subiterator = new Subiterator();
        subiterator.list = this.list;
        subiterator.pos = this.pos;
        return subiterator;
    }
}

