/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.util.IntArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;

final class StringHeap {
    private static final int DEFAULT_REF_HEAP_BASE_SIZE = 5000;
    private static final int DEFAULT_REF_HEAP_MULT_LIMIT = 5120000;
    private static final int DEFAULT_STRING_HEAP_BASE_SIZE = 20000;
    private static final int DEFAULT_STRING_HEAP_MULT_LIMIT = 20480000;
    private static final int MIN_REF_HEAP_BASE_SIZE = 1024;
    private static final int MIN_STR_HEAP_BASE_SIZE = 32768;
    protected static final int REF_HEAP_CELL_SIZE = 3;
    protected static final int CHAR_HEAP_POINTER_OFFSET = 0;
    protected static final int CHAR_HEAP_STRLEN_OFFSET = 1;
    protected static final int STRING_LIST_ADDR_OFFSET = 2;
    private static final int GROWTH_FACTOR = 4;
    private static final int NULL = 0;
    protected static final int FIRST_CELL_REF = 3;
    private final int refHeapBaseSize;
    private final int refHeapMultLimit;
    private final int strHeapBaseSize;
    private final int strHeapMultLimit;
    protected int refHeapPos = 3;
    protected int[] refHeap;
    protected ArrayList stringList;
    protected int charHeapPos = 0;
    protected char[] stringHeap;

    StringHeap() {
        this(5000, 5120000, 20000, 20480000);
    }

    StringHeap(int n, int n2, int n3, int n4) {
        this.refHeapBaseSize = n < 1024 ? 1024 : n;
        this.refHeapMultLimit = n2 < 5120000 ? 5120000 : n2;
        this.strHeapBaseSize = n3 < 32768 ? 32768 : n3;
        this.strHeapMultLimit = n4 < 20480000 ? 20480000 : n4;
        this.initMemory();
    }

    private static final int cas2refHeapPointer(int n) {
        return n * 3;
    }

    private static final int refHeap2casPointer(int n) {
        return n / 3;
    }

    private final void initMemory() {
        this.refHeap = new int[this.refHeapBaseSize];
        this.stringHeap = new char[this.strHeapBaseSize];
        this.stringList = new ArrayList();
        this.stringList.add(null);
    }

    final void reset() {
        this.reset(false);
    }

    final void reset(boolean bl) {
        if (bl) {
            this.initMemory();
        } else {
            Arrays.fill(this.refHeap, 0, this.refHeapPos, 0);
            this.stringList = new ArrayList();
            this.stringList.add(null);
        }
        this.refHeapPos = 3;
        this.charHeapPos = 0;
    }

    String getStringForCode(int n) {
        if (n == 0) {
            return null;
        }
        int n2 = StringHeap.cas2refHeapPointer(n);
        int n3 = this.refHeap[n2 + 2];
        if (n3 != 0) {
            return (String)this.stringList.get(n3);
        }
        int n4 = this.refHeap[n2 + 0];
        int n5 = this.refHeap[n2 + 1];
        return new String(this.stringHeap, n4, n5);
    }

    int copyCharsToBuffer(int n, char[] cArray, int n2) {
        int n3 = StringHeap.cas2refHeapPointer(n);
        int n4 = this.refHeap[n3 + 2];
        int n5 = this.refHeap[n3 + 0];
        int n6 = cArray.length - n2;
        if (n4 == 0) {
            int n7 = this.refHeap[n3 + 1];
            int n8 = n7 < n6 ? n7 : n6;
            for (int i = 0; i < n8; ++i) {
                cArray[n2] = this.stringHeap[n5];
                ++n2;
                ++n5;
            }
            return n7;
        }
        int n9 = this.refHeap[n3 + 2];
        String string = (String)this.stringList.get(n9);
        int n10 = string.length();
        int n11 = n10 < n6 ? n10 : n6;
        for (int i = 0; i < n11; ++i) {
            cArray[n2 + i] = string.charAt(i);
        }
        return n10;
    }

    int addString(String string) {
        int n;
        int n2 = this.refHeapPos;
        this.refHeapPos += 3;
        this.ensureRefHeapSize();
        this.refHeap[n2 + 2] = n = this.stringList.size();
        if (string != null) {
            this.refHeap[n2 + 1] = string.length();
        }
        this.stringList.add(string);
        return StringHeap.refHeap2casPointer(n2);
    }

    int cloneStringReference(int n) {
        int n2 = StringHeap.cas2refHeapPointer(n);
        int n3 = this.refHeap[n2 + 2];
        int n4 = this.refHeap[n2 + 1];
        int n5 = this.refHeapPos;
        this.refHeapPos += 3;
        this.ensureRefHeapSize();
        this.refHeap[n5 + 2] = n3;
        this.refHeap[n5 + 1] = n4;
        return StringHeap.refHeap2casPointer(n5);
    }

    private final void ensureRefHeapSize() {
        this.refHeap = IntArrayUtils.ensure_size(this.refHeap, this.refHeapPos, 4, this.refHeapMultLimit);
    }

    int addCharBuffer(char[] cArray, int n, int n2) {
        int n3;
        int n4 = this.refHeapPos;
        this.refHeapPos += 3;
        this.ensureRefHeapSize();
        this.refHeap[n4 + 0] = n3 = this.charHeapPos;
        this.refHeap[n4 + 1] = n2;
        this.charHeapPos += n2;
        this.ensureCharHeapSize();
        System.arraycopy(cArray, n, this.stringHeap, n3, n2);
        return StringHeap.refHeap2casPointer(n4);
    }

    private void ensureCharHeapSize() {
        this.stringHeap = IntArrayUtils.ensure_size(this.stringHeap, this.charHeapPos, 4, this.strHeapMultLimit);
    }

    final boolean isStringCode(int n) {
        int n2 = StringHeap.cas2refHeapPointer(n);
        return this.isValidRef(n2);
    }

    private final boolean isValidRef(int n) {
        return n >= 3 && n < this.refHeapPos;
    }

    final boolean isJavaString(int n) {
        int n2 = StringHeap.cas2refHeapPointer(n);
        if (!this.isValidRef(n2)) {
            return false;
        }
        return this.refHeap[n2 + 2] != 0;
    }

    final boolean isCharArray(int n) {
        int n2 = StringHeap.cas2refHeapPointer(n);
        if (!this.isValidRef(n2)) {
            return false;
        }
        return this.refHeap[n2 + 0] != 0;
    }

    final int getCharArrayLength(int n) {
        int n2 = StringHeap.cas2refHeapPointer(n);
        return this.refHeap[n2 + 1];
    }

    final int getLeastStringCode() {
        return StringHeap.refHeap2casPointer(3);
    }

    final int getLargestStringCode() {
        return StringHeap.refHeap2casPointer(this.refHeapPos) - 1;
    }
}

