/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.StringArrayFS;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FSGenerator;
import com.ibm.uima.cas.impl.FeatureStructureImplC;

public class StringArrayFSImpl
extends FeatureStructureImplC
implements StringArrayFS {
    private StringArrayFSImpl() {
    }

    public StringArrayFSImpl(int n, CASImpl cASImpl) {
        super(cASImpl, n);
    }

    static FSGenerator generator() {
        return new StringArrayGenerator();
    }

    public int size() {
        return this.casImpl.getArraySize(this.addr);
    }

    public String get(int n) {
        if (n < 0 || n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.casImpl.getStringForCode(this.casImpl.getArrayValue(this.addr, n));
    }

    public void set(int n, String string) throws ArrayIndexOutOfBoundsException {
        this.casImpl.setArrayValue(this.addr, n, this.casImpl.addString(string));
    }

    public void copyFromArray(String[] stringArray, int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n2 + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n2 += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < n3; ++i) {
            this.casImpl.heap.heap[n2] = this.casImpl.addString(stringArray[n]);
            ++n2;
            ++n;
        }
    }

    public void copyToArray(int n, String[] stringArray, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            stringArray[n2] = this.casImpl.ll_getStringArrayValue(this.addr, n);
            ++n2;
            ++n;
        }
    }

    public String[] toArray() {
        int n = this.size();
        String[] stringArray = new String[n];
        this.copyToArray(0, stringArray, 0, n);
        return stringArray;
    }

    private static class StringArrayGenerator
    implements FSGenerator {
        private StringArrayGenerator() {
        }

        public FeatureStructure createFS(int n, CASImpl cASImpl) {
            return new StringArrayFSImpl(n, cASImpl);
        }
    }
}

