/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.XmiSerializationSharedData;
import com.ibm.uima.util.IntVector;
import com.ibm.uima.util.Level;
import com.ibm.uima.util.Logger;
import com.ibm.uima.util.rb_trees.IntRedBlackTree;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ListUtils {
    CASImpl cas;
    private int intListType;
    private int floatListType;
    private int stringListType;
    private int fsListType;
    private int neIntListType;
    private int neFloatListType;
    private int neStringListType;
    private int neFsListType;
    private int eIntListType;
    private int eFloatListType;
    private int eStringListType;
    private int eFsListType;
    private int intHeadFeat;
    private int intTailFeat;
    private int floatHeadFeat;
    private int floatTailFeat;
    private int stringHeadFeat;
    private int stringTailFeat;
    private int fsHeadFeat;
    private int fsTailFeat;
    private Logger logger;
    private ErrorHandler eh;

    public ListUtils(CASImpl cASImpl, Logger logger, ErrorHandler errorHandler) {
        this.cas = cASImpl;
        this.logger = logger;
        this.eh = errorHandler;
        this.intListType = cASImpl.ts.getTypeCode("uima.cas.IntegerList");
        this.floatListType = cASImpl.ts.getTypeCode("uima.cas.FloatList");
        this.stringListType = cASImpl.ts.getTypeCode("uima.cas.StringList");
        this.fsListType = cASImpl.ts.getTypeCode("uima.cas.FSList");
        this.neIntListType = cASImpl.ts.getTypeCode("uima.cas.NonEmptyIntegerList");
        this.neFloatListType = cASImpl.ts.getTypeCode("uima.cas.NonEmptyFloatList");
        this.neStringListType = cASImpl.ts.getTypeCode("uima.cas.NonEmptyStringList");
        this.neFsListType = cASImpl.ts.getTypeCode("uima.cas.NonEmptyFSList");
        this.eIntListType = cASImpl.ts.getTypeCode("uima.cas.EmptyIntegerList");
        this.eFloatListType = cASImpl.ts.getTypeCode("uima.cas.EmptyFloatList");
        this.eStringListType = cASImpl.ts.getTypeCode("uima.cas.EmptyStringList");
        this.eFsListType = cASImpl.ts.getTypeCode("uima.cas.EmptyFSList");
        this.intHeadFeat = cASImpl.ts.getFeatureCode("uima.cas.NonEmptyIntegerList:head");
        this.floatHeadFeat = cASImpl.ts.getFeatureCode("uima.cas.NonEmptyFloatList:head");
        this.stringHeadFeat = cASImpl.ts.getFeatureCode("uima.cas.NonEmptyStringList:head");
        this.fsHeadFeat = cASImpl.ts.getFeatureCode("uima.cas.NonEmptyFSList:head");
        this.intTailFeat = cASImpl.ts.getFeatureCode("uima.cas.NonEmptyIntegerList:tail");
        this.floatTailFeat = cASImpl.ts.getFeatureCode("uima.cas.NonEmptyFloatList:tail");
        this.stringTailFeat = cASImpl.ts.getFeatureCode("uima.cas.NonEmptyStringList:tail");
        this.fsTailFeat = cASImpl.ts.getFeatureCode("uima.cas.NonEmptyFSList:tail");
    }

    public boolean isIntListType(int n) {
        return n == this.intListType || n == this.neIntListType || n == this.eIntListType;
    }

    public boolean isFloatListType(int n) {
        return n == this.floatListType || n == this.neFloatListType || n == this.eFloatListType;
    }

    public boolean isStringListType(int n) {
        return n == this.stringListType || n == this.neStringListType || n == this.eStringListType;
    }

    public boolean isFsListType(int n) {
        return n == this.fsListType || n == this.neFsListType || n == this.eFsListType;
    }

    public boolean isListType(int n) {
        return this.isIntListType(n) || this.isFloatListType(n) || this.isStringListType(n) || this.isFsListType(n);
    }

    public String[] intListToStringArray(int n) throws SAXException {
        IntRedBlackTree intRedBlackTree = new IntRedBlackTree();
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        while (this.cas.getHeapValue(n3) == this.neIntListType) {
            if (!intRedBlackTree.put(n3, n3)) {
                bl = true;
                break;
            }
            ++n2;
            n3 = this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.intTailFeat));
        }
        String[] stringArray = new String[n2];
        n3 = n;
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = Integer.toString(this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.intHeadFeat)));
            n3 = this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.intTailFeat));
        }
        if (bl) {
            this.reportWarning("Found a cycle in an IntegerList.  List truncated to " + Arrays.asList(stringArray).toString());
        }
        return stringArray;
    }

    public String[] floatListToStringArray(int n) throws SAXException {
        boolean bl = false;
        IntRedBlackTree intRedBlackTree = new IntRedBlackTree();
        int n2 = 0;
        int n3 = n;
        while (this.cas.getHeapValue(n3) == this.neFloatListType) {
            if (!intRedBlackTree.put(n3, n3)) {
                bl = true;
                break;
            }
            ++n2;
            n3 = this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.floatTailFeat));
        }
        String[] stringArray = new String[n2];
        n3 = n;
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = Float.toString(CASImpl.int2float(this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.floatHeadFeat))));
            n3 = this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.floatTailFeat));
        }
        if (bl) {
            this.reportWarning("Found a cycle in a FloatList.  List truncated to " + Arrays.asList(stringArray).toString() + ".");
        }
        return stringArray;
    }

    public String[] stringListToStringArray(int n) throws SAXException {
        boolean bl = false;
        IntRedBlackTree intRedBlackTree = new IntRedBlackTree();
        int n2 = 0;
        int n3 = n;
        while (this.cas.getHeapValue(n3) == this.neStringListType) {
            if (!intRedBlackTree.put(n3, n3)) {
                bl = true;
                break;
            }
            ++n2;
            n3 = this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.stringTailFeat));
        }
        String[] stringArray = new String[n2];
        n3 = n;
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = this.cas.getStringForCode(this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.stringHeadFeat)));
            n3 = this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.stringTailFeat));
        }
        if (bl) {
            this.reportWarning("Found a cycle in a StringList.  List truncated to " + Arrays.asList(stringArray).toString() + ".");
        }
        return stringArray;
    }

    public String[] fsListToXmiIdStringArray(int n, XmiSerializationSharedData xmiSerializationSharedData) throws SAXException {
        boolean bl = false;
        IntRedBlackTree intRedBlackTree = new IntRedBlackTree();
        int n2 = 0;
        int n3 = n;
        while (this.cas.getHeapValue(n3) == this.neFsListType) {
            if (!intRedBlackTree.put(n3, n3)) {
                bl = true;
                break;
            }
            ++n2;
            n3 = this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.fsTailFeat));
        }
        String[] stringArray = new String[n2];
        n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.fsHeadFeat));
            stringArray[i] = xmiSerializationSharedData != null ? xmiSerializationSharedData.getXmiId(n4) : Integer.toString(n4);
            if (stringArray[i] == null) {
                stringArray[i] = "0";
            }
            n3 = this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.fsTailFeat));
        }
        if (bl) {
            this.reportWarning("Found a cycle in an FSList.  List truncated to " + Arrays.asList(stringArray).toString() + ".");
        }
        return stringArray;
    }

    public int[] fsListToAddressArray(int n) throws SAXException {
        boolean bl = false;
        IntRedBlackTree intRedBlackTree = new IntRedBlackTree();
        int n2 = 0;
        int n3 = n;
        while (this.cas.getHeapValue(n3) == this.neFsListType) {
            if (!intRedBlackTree.put(n3, n3)) {
                bl = true;
                break;
            }
            ++n2;
            n3 = this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.fsTailFeat));
        }
        int[] nArray = new int[n2];
        n3 = n;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.fsHeadFeat));
            n3 = this.cas.getHeapValue(n3 + this.cas.getFeatureOffset(this.fsTailFeat));
        }
        if (bl) {
            this.reportWarning("Found a cycle in an FSList.  List truncated where cycle occurs.");
        }
        return nArray;
    }

    public int createIntList(List list) {
        int n = this.cas.createTempFS(this.eIntListType);
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            int n2 = Integer.parseInt((String)listIterator.previous());
            int n3 = this.cas.createTempFS(this.neIntListType);
            this.cas.setFeatureValue(n3, this.intHeadFeat, n2);
            this.cas.setFeatureValue(n3, this.intTailFeat, n);
            n = n3;
        }
        return n;
    }

    public int createFloatList(List list) {
        int n = this.cas.createTempFS(this.eFloatListType);
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            float f = Float.parseFloat((String)listIterator.previous());
            int n2 = this.cas.createTempFS(this.neFloatListType);
            this.cas.setFeatureValue(n2, this.floatHeadFeat, CASImpl.float2int(f));
            this.cas.setFeatureValue(n2, this.floatTailFeat, n);
            n = n2;
        }
        return n;
    }

    public int createStringList(List list) {
        int n = this.cas.createTempFS(this.eStringListType);
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            String string = (String)listIterator.previous();
            int n2 = this.cas.createTempFS(this.neStringListType);
            this.cas.setFeatureValue(n2, this.stringHeadFeat, this.cas.addString(string));
            this.cas.setFeatureValue(n2, this.stringTailFeat, n);
            n = n2;
        }
        return n;
    }

    public int createFsList(List list, IntVector intVector) {
        int n = this.cas.createTempFS(this.eFsListType);
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            int n2 = Integer.parseInt((String)listIterator.previous());
            int n3 = this.cas.createTempFS(this.neFsListType);
            intVector.add(n3);
            this.cas.setFeatureValue(n3, this.fsHeadFeat, n2);
            this.cas.setFeatureValue(n3, this.fsTailFeat, n);
            n = n3;
        }
        return n;
    }

    private void reportWarning(String string) throws SAXException {
        if (this.logger != null) {
            this.logger.log(Level.WARNING, string);
        }
        if (this.eh != null) {
            this.eh.warning(new SAXParseException(string, null));
        }
    }
}

