/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.CASException;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.admin.LinearTypeOrder;
import com.ibm.uima.cas.admin.LinearTypeOrderBuilder;
import com.ibm.uima.cas.impl.LowLevelTypeSystem;
import com.ibm.uima.cas.impl.TypeImpl;
import com.ibm.uima.cas.impl.TypeSystemImpl;
import com.ibm.uima.util.GraphNode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class LinearTypeOrderBuilderImpl
implements LinearTypeOrderBuilder {
    private Graph order = new Graph();
    private TypeSystem ts;

    public LinearTypeOrderBuilderImpl(TypeSystem typeSystem) {
        this.ts = typeSystem;
    }

    public static LinearTypeOrder createTypeOrder(int[] nArray, TypeSystem typeSystem) {
        return new TotalTypeOrder(nArray, typeSystem);
    }

    public void add(String[] stringArray) throws CASException {
        int n = stringArray.length - 1;
        for (int i = 0; i < n; ++i) {
            boolean bl = this.add(stringArray[i], stringArray[i + 1]);
            if (bl) continue;
            CASException cASException = new CASException(4);
            cASException.addArgument(stringArray[i]);
            cASException.addArgument(stringArray[i + 1]);
            throw cASException;
        }
    }

    public LinearTypeOrder getOrder() throws CASException {
        LinearTypeOrderBuilderImpl linearTypeOrderBuilderImpl = new LinearTypeOrderBuilderImpl(this.ts);
        linearTypeOrderBuilderImpl.order = this.order.copy();
        TotalTypeOrder totalTypeOrder = new TotalTypeOrder(linearTypeOrderBuilderImpl.getTheOrder(), this.ts);
        return totalTypeOrder;
    }

    private String[] linearize() {
        String[] stringArray = new String[this.order.size()];
        block0: for (int i = 0; i < stringArray.length; ++i) {
            Iterator iterator = this.order.nodeMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                Node node = this.order.getNode((String)iterator.next());
                if (node.inRank() != 0) continue;
                stringArray[i] = string = (String)node.getElement();
                this.order.removeNode(string);
                continue block0;
            }
        }
        return stringArray;
    }

    private LinearTypeOrder getOrderNoInheritance() throws CASException {
        Graph graph = this.order.copy();
        Iterator iterator = this.ts.getTypeIterator();
        while (iterator.hasNext()) {
            graph.getNode(((Type)iterator.next()).getName());
        }
        String[] stringArray = new String[graph.size()];
        block1: for (int i = 0; i < stringArray.length; ++i) {
            iterator = graph.nodeMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                Node node = graph.getNode((String)iterator.next());
                if (node.inRank() != 0) continue;
                stringArray[i] = string = (String)node.getElement();
                graph.removeNode(string);
                continue block1;
            }
        }
        TotalTypeOrder totalTypeOrder = new TotalTypeOrder(stringArray, this.ts);
        return totalTypeOrder;
    }

    private boolean add(String string, String string2) {
        Node node;
        Node node2 = this.order.getNode(string);
        if (this.order.pathFromTo(node2, node = this.order.getNode(string2))) {
            return true;
        }
        if (this.order.pathFromTo(node, node2)) {
            return false;
        }
        node2.addSuccessor(node);
        node.addPredecessor(node2);
        return true;
    }

    private void addInheritanceDefaults() throws CASException {
        LinearTypeOrder linearTypeOrder = this.getOrderNoInheritance();
        TypeTree typeTree = new TypeTree(this.ts);
        typeTree.reorder(linearTypeOrder);
        ArrayList arrayList = typeTree.getPreOrder();
        int n = arrayList.size() - 1;
        for (int i = 0; i < n; ++i) {
            this.add(((Type)arrayList.get(i)).getName(), ((Type)arrayList.get(i + 1)).getName());
        }
    }

    private String[] getTheOrder() throws CASException {
        LinearTypeOrder linearTypeOrder = this.getOrderNoInheritance();
        TypeTree typeTree = new TypeTree(this.ts);
        typeTree.reorder(linearTypeOrder);
        ArrayList arrayList = typeTree.getPreOrder();
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((Type)arrayList.get(i)).getName();
        }
        return stringArray;
    }

    private class Graph {
        private final HashMap nodeMap = new HashMap();

        private Graph() {
        }

        private int size() {
            return this.nodeMap.size();
        }

        private Node getNode(String string) {
            Node node = (Node)this.nodeMap.get(string);
            if (node == null) {
                node = new Node(string);
                this.nodeMap.put(string, node);
            }
            return node;
        }

        private Graph copy() {
            String string;
            Graph graph = new Graph();
            Iterator iterator = this.nodeMap.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                graph.nodeMap.put(string, graph.getNode(string));
            }
            iterator = this.nodeMap.keySet().iterator();
            while (iterator.hasNext()) {
                int n;
                string = (String)iterator.next();
                Node node = (Node)this.nodeMap.get(string);
                Node node2 = (Node)graph.nodeMap.get(string);
                for (n = 0; n < node.inRank(); ++n) {
                    string = (String)node.getPredecessor(n).getElement();
                    node2.addPredecessor(graph.getNode(string));
                }
                for (n = 0; n < node.outRank(); ++n) {
                    string = (String)node.getSuccessor(n).getElement();
                    node2.addSuccessor(graph.getNode(string));
                }
            }
            return graph;
        }

        private void removeNode(String string) {
            Node node = (Node)this.nodeMap.get(string);
            if (node == null) {
                return;
            }
            this.nodeMap.remove(string);
            int n = node.outRank();
            for (int i = 0; i < n; ++i) {
                ((Node)node.getSuccessor(i)).removeAncestor(node);
            }
        }

        private boolean pathFromTo(Node node, Node node2) {
            HashMap hashMap = new HashMap();
            return this.pathFromTo(node, node2, hashMap);
        }

        private boolean pathFromTo(Node node, Node node2, HashMap hashMap) {
            if (node == node2) {
                return true;
            }
            if (hashMap.containsKey(node)) {
                return false;
            }
            hashMap.put(node, node);
            for (int i = 0; i < node.outRank(); ++i) {
                if (!this.pathFromTo((Node)node.getSuccessor(i), node2, hashMap)) continue;
                return true;
            }
            return false;
        }
    }

    private static class Node
    extends GraphNode {
        private Node(Object object) {
            super(object);
        }

        private void removeAncestor(Node node) {
            int n = this.predecessors.size();
            for (int i = 0; i < n; ++i) {
                if (this.predecessors.get(i) != node) continue;
                this.predecessors.remove(i);
                return;
            }
        }

        private int outRank() {
            return this.getNbrSucc();
        }

        private int inRank() {
            return this.getNbrPred();
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class TotalTypeOrder
    implements LinearTypeOrder {
        private BitSet[] lt;
        private int[] order;

        private TotalTypeOrder(String[] stringArray, TypeSystem typeSystem) throws CASException {
            this(TotalTypeOrder.encodeTypeList(stringArray, typeSystem), typeSystem);
        }

        private static int[] encodeTypeList(String[] stringArray, TypeSystem typeSystem) throws CASException {
            int[] nArray = new int[stringArray.length];
            LowLevelTypeSystem lowLevelTypeSystem = (LowLevelTypeSystem)((Object)typeSystem);
            for (int i = 0; i < nArray.length; ++i) {
                int n = lowLevelTypeSystem.ll_getCodeForTypeName(stringArray[i]);
                if (n == 0) {
                    CASException cASException = new CASException(9);
                    cASException.addArgument(stringArray[i]);
                    throw cASException;
                }
                nArray[i] = n;
            }
            return nArray;
        }

        private TotalTypeOrder(int[] nArray, TypeSystem typeSystem) {
            int n;
            int n2;
            TypeSystemImpl typeSystemImpl = (TypeSystemImpl)typeSystem;
            this.lt = new BitSet[nArray.length + 1];
            this.order = nArray;
            for (n2 = n = typeSystemImpl.getSmallestType(); n2 < this.lt.length; ++n2) {
                this.lt[n2] = new BitSet(this.lt.length);
            }
            for (n2 = 0; n2 < nArray.length; ++n2) {
                for (int i = 0; i < n2; ++i) {
                    this.lt[nArray[i]].set(nArray[n2]);
                }
            }
        }

        public boolean lessThan(Type type, Type type2) {
            return this.lt[((TypeImpl)type).getCode()].get(((TypeImpl)type2).getCode());
        }

        public boolean lessThan(int n, int n2) {
            return this.lt[n].get(n2);
        }

        public int[] getOrder() {
            return this.order;
        }
    }

    private static class TypeTree {
        private TreeNode root = null;
        private TypeSystem ts1 = null;

        private TypeTree(TypeSystem typeSystem) {
            this.ts1 = typeSystem;
            this.root = new TreeNode(typeSystem.getTopType());
            this.encodeSubtypes(typeSystem.getTopType(), this.root);
        }

        private void encodeSubtypes(Type type, TreeNode treeNode) {
            List list = this.ts1.getDirectSubtypes(type);
            for (int i = 0; i < list.size(); ++i) {
                Type type2 = (Type)list.get(i);
                TreeNode treeNode2 = new TreeNode(type2);
                treeNode.addSuccessor(treeNode2);
                this.encodeSubtypes(type2, treeNode2);
            }
        }

        private void reorder(LinearTypeOrder linearTypeOrder) {
            TreeNodeComparator treeNodeComparator = new TreeNodeComparator(linearTypeOrder);
            this.reorder(this.root, treeNodeComparator);
        }

        private void reorder(TreeNode treeNode, TreeNodeComparator treeNodeComparator) {
            ArrayList arrayList = treeNode.getDtrs();
            Collections.sort(arrayList, treeNodeComparator);
            for (int i = 0; i < arrayList.size(); ++i) {
                this.reorder((TreeNode)arrayList.get(i), treeNodeComparator);
            }
        }

        private ArrayList getPreOrder() {
            ArrayList arrayList = new ArrayList();
            this.computePreOrder(this.root, arrayList);
            return arrayList;
        }

        private void computePreOrder(TreeNode treeNode, ArrayList arrayList) {
            arrayList.add(treeNode.getElement());
            ArrayList arrayList2 = treeNode.getDtrs();
            for (int i = 0; i < arrayList2.size(); ++i) {
                this.computePreOrder((TreeNode)arrayList2.get(i), arrayList);
            }
        }
    }

    private static class TreeNode
    extends GraphNode {
        public TreeNode(Object object) {
            super(object);
        }

        private ArrayList getDtrs() {
            return this.successors;
        }
    }

    private static class TreeNodeComparator
    implements Comparator {
        private LinearTypeOrder compOrder;

        private TreeNodeComparator(LinearTypeOrder linearTypeOrder) {
            this.compOrder = linearTypeOrder;
        }

        public int compare(Object object, Object object2) {
            Type type;
            Type type2 = (Type)((TreeNode)object).getElement();
            if (this.compOrder.lessThan(type2, type = (Type)((TreeNode)object2).getElement())) {
                return -1;
            }
            if (this.compOrder.lessThan(type, type2)) {
                return 1;
            }
            return 0;
        }
    }
}

