/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.impl.LowLevelCAS;
import com.ibm.uima.cas.impl.LowLevelIndex;
import com.ibm.uima.cas.impl.LowLevelIterator;
import com.ibm.uima.cas.impl.LowLevelTypeSystem;
import java.util.NoSuchElementException;

public class LLUnambiguousIteratorImpl
implements LowLevelIterator {
    private final int[] annots;
    private int pos = 0;
    private final int size;
    private final LowLevelIterator theIterator;
    private final LowLevelCAS theCas;

    public LLUnambiguousIteratorImpl(LowLevelIterator lowLevelIterator, LowLevelCAS lowLevelCAS) {
        this.theCas = lowLevelCAS;
        this.theIterator = lowLevelIterator;
        this.annots = new int[lowLevelIterator.ll_indexSize()];
        LowLevelTypeSystem lowLevelTypeSystem = lowLevelCAS.ll_getTypeSystem();
        int n = lowLevelTypeSystem.ll_getCodeForTypeName("uima.tcas.Annotation");
        int n2 = lowLevelTypeSystem.ll_getCodeForFeatureName("uima.tcas.Annotation:begin");
        int n3 = lowLevelTypeSystem.ll_getCodeForFeatureName("uima.tcas.Annotation:end");
        int n4 = 0;
        lowLevelIterator.moveToFirst();
        int n5 = 0;
        while (lowLevelIterator.isValid()) {
            int n6 = lowLevelIterator.ll_get();
            int n7 = lowLevelCAS.ll_getFSRefType(n6);
            if (lowLevelTypeSystem.ll_subsumes(n, n7) && (n5 == 0 || lowLevelCAS.ll_getIntValue(n6, n2) >= n4)) {
                this.annots[n5] = n6;
                n4 = lowLevelCAS.ll_getIntValue(n6, n3);
                ++n5;
            }
            lowLevelIterator.moveToNext();
        }
        this.size = n5;
    }

    public void moveToFirst() {
        this.pos = 0;
    }

    public void moveToLast() {
        this.pos = this.size - 1;
    }

    public boolean isValid() {
        return this.pos >= 0 && this.pos < this.size;
    }

    public int ll_get() throws NoSuchElementException {
        if (!this.isValid()) {
            throw new NoSuchElementException();
        }
        return this.annots[this.pos];
    }

    public void moveToNext() {
        ++this.pos;
    }

    public void moveToPrevious() {
        --this.pos;
    }

    public void moveTo(int n) {
        int n2 = this.binarySearch(this.annots, n, 0, this.size);
        this.pos = n2 >= 0 ? n2 : -(n2 + 1);
    }

    public Object copy() {
        LLUnambiguousIteratorImpl lLUnambiguousIteratorImpl = new LLUnambiguousIteratorImpl(this.theIterator, this.theCas);
        lLUnambiguousIteratorImpl.pos = this.pos;
        return lLUnambiguousIteratorImpl;
    }

    public int ll_indexSize() {
        return this.size;
    }

    public LowLevelIndex ll_getIndex() {
        return this.theIterator.ll_getIndex();
    }

    private final int binarySearch(int[] nArray, int n, int n2, int n3) {
        --n3;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = this.ll_getIndex().ll_compare(n, nArray[n4]);
            if (n5 == 0) {
                return n4;
            }
            if (n2 == n3) {
                if (n5 < 0) {
                    return -n4 - 1;
                }
                return -n4 - 2;
            }
            if (n5 < 0) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        return -n2 - 1;
    }
}

