/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.IntArrayFS;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FSGenerator;
import com.ibm.uima.cas.impl.FeatureStructureImplC;

public class IntArrayFSImpl
extends FeatureStructureImplC
implements IntArrayFS {
    private IntArrayFSImpl() {
    }

    public IntArrayFSImpl(int n, CASImpl cASImpl) {
        super(cASImpl, n);
    }

    static FSGenerator generator() {
        return new IntArrayFSGenerator();
    }

    public int size() {
        return this.casImpl.getArraySize(this.addr);
    }

    public int get(int n) {
        return this.casImpl.getArrayValue(this.addr, n);
    }

    public void set(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.casImpl.setArrayValue(this.addr, n, n2);
    }

    public void copyFromArray(int[] nArray, int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n2 + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n2 += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < n3; ++i) {
            this.casImpl.heap.heap[n2] = nArray[n];
            ++n2;
            ++n;
        }
    }

    public void copyToArray(int n, int[] nArray, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < n3; ++i) {
            nArray[n2] = this.casImpl.heap.heap[n];
            ++n2;
            ++n;
        }
    }

    public int[] toArray() {
        int n = this.size();
        int[] nArray = new int[n];
        this.copyToArray(0, nArray, 0, n);
        return nArray;
    }

    public String[] toStringArray() {
        int n = this.size();
        String[] stringArray = new String[n];
        this.copyToArray(0, stringArray, 0, n);
        return stringArray;
    }

    public void copyToArray(int n, String[] stringArray, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < n3; ++i) {
            stringArray[n2] = Integer.toString(this.casImpl.heap.heap[n]);
            ++n2;
            ++n;
        }
    }

    public void copyFromArray(String[] stringArray, int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        this.copyFromArray(nArray, n, n2, n3);
    }

    private static class IntArrayFSGenerator
    implements FSGenerator {
        private IntArrayFSGenerator() {
        }

        public FeatureStructure createFS(int n, CASImpl cASImpl) {
            return new IntArrayFSImpl(n, cASImpl);
        }
    }
}

