/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.util.IntArrayUtils;
import com.ibm.uima.util.SortedIntSet;
import java.util.Arrays;

public final class Heap {
    public static final int MIN_PAGE_SIZE = 1000;
    public static final int DEFAULT_PAGE_SIZE = 500000;
    private int PAGE_SIZE;
    int[] heap;
    private int tempPos;
    private int tempMax;
    private int permPos;
    private int permMax;
    private SortedIntSet availablePages;
    private SortedIntSet tempPages;
    private static final int SIZE_POS = 0;
    private static final int TMPP_POS = 1;
    private static final int TMPM_POS = 2;
    private static final int PRMP_POS = 3;
    private static final int PRMM_POS = 4;
    private static final int PGSZ_POS = 5;
    private static final int AVSZ_POS = 6;
    private static final int AVST_POS = 7;

    public Heap() {
        this(500000);
    }

    public Heap(int n) {
        if (n < 1000) {
            n = 1000;
        }
        this.PAGE_SIZE = n;
        this.initHeap();
    }

    private final void initHeap() {
        this.heap = new int[0];
        this.availablePages = new SortedIntSet();
        this.tempPages = new SortedIntSet();
        this.newTempPage();
    }

    void reinit(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            this.reinitNoMetaData(nArray2);
            return;
        }
        int n2 = nArray[0];
        this.tempPos = nArray[1];
        this.tempMax = nArray[2];
        this.permPos = nArray[3];
        this.permMax = nArray[4];
        this.PAGE_SIZE = nArray[5];
        this.heap = new int[n2];
        System.arraycopy(nArray2, 0, this.heap, 0, nArray2.length);
        int n3 = 7 + nArray[6];
        this.availablePages = new SortedIntSet();
        for (n = 7; n < n3; ++n) {
            this.availablePages.add(nArray[n]);
        }
        this.tempPages = new SortedIntSet();
        for (n = n3; n < nArray.length; ++n) {
            this.tempPages.add(nArray[n]);
        }
    }

    private void reinitNoMetaData(int[] nArray) {
        this.PAGE_SIZE = nArray.length < 1000 ? 1000 : nArray.length;
        this.availablePages = new SortedIntSet();
        this.tempPages = new SortedIntSet();
        if (nArray.length >= this.PAGE_SIZE) {
            this.heap = nArray;
        } else {
            System.arraycopy(nArray, 0, this.heap, 0, nArray.length);
        }
        this.tempPages.add(0);
        int n = this.PAGE_SIZE * 2;
        int n2 = 1;
        while (n <= this.heap.length) {
            this.availablePages.add(n2);
            n += this.PAGE_SIZE;
            ++n2;
        }
        this.tempPos = nArray.length;
        this.tempMax = this.PAGE_SIZE;
    }

    void reinitSizeOnly(int n) {
        this.PAGE_SIZE = n < 1000 ? 1000 : n;
        this.availablePages = new SortedIntSet();
        this.tempPages = new SortedIntSet();
        this.heap = new int[this.PAGE_SIZE];
        this.tempPages.add(0);
        int n2 = this.PAGE_SIZE * 2;
        int n3 = 1;
        while (n2 <= this.heap.length) {
            this.availablePages.add(n3);
            n2 += this.PAGE_SIZE;
            ++n3;
        }
        this.tempPos = n;
        this.tempMax = this.PAGE_SIZE;
    }

    int getCurrentTempSize() {
        return this.tempPos;
    }

    int[] getMetaData() {
        int n;
        int n2;
        int n3 = 7 + this.availablePages.size() + this.tempPages.size();
        int[] nArray = new int[n3];
        nArray[0] = this.heap.length;
        nArray[1] = this.tempPos;
        nArray[2] = this.tempMax;
        nArray[3] = this.permPos;
        nArray[4] = this.permMax;
        nArray[5] = this.PAGE_SIZE;
        nArray[6] = n2 = this.availablePages.size();
        int[] nArray2 = this.availablePages.toArray();
        for (n = 0; n < nArray2.length; ++n) {
            nArray[n + 7] = nArray2[n];
        }
        n = 7 + n2;
        nArray2 = this.tempPages.toArray();
        for (int i = 0; i < nArray2.length; ++i) {
            nArray[i + n] = nArray2[i];
        }
        return nArray;
    }

    private int newPage() {
        int n = this.heap.length;
        this.heap = IntArrayUtils.ensure_size(this.heap, n + this.PAGE_SIZE, 2, this.PAGE_SIZE);
        return n;
    }

    private void newTempPage() {
        if (this.availablePages.size() > 0) {
            int n = this.availablePages.get(0);
            this.availablePages.remove(n);
            this.tempPages.add(n);
            if (n == 0) {
                this.tempPos = 1;
                this.tempMax = this.PAGE_SIZE;
            } else {
                this.tempPos = n * this.PAGE_SIZE;
                this.tempMax = this.tempPos + this.PAGE_SIZE;
            }
            return;
        }
        int n = this.newPage();
        this.tempPos = n == 0 ? 1 : n;
        this.tempMax = n + this.PAGE_SIZE;
        this.tempPages.add(n / this.PAGE_SIZE);
    }

    private void newPermPage() {
        int n;
        this.permPos = n = this.newPage();
        this.permMax = n + this.PAGE_SIZE;
    }

    public void resetTempHeap() {
        this.resetTempHeap(false);
    }

    void resetTempHeap(boolean bl) {
        if (bl) {
            this.initHeap();
        } else {
            for (int i = 0; i < this.tempPages.size(); ++i) {
                int n = this.tempPages.get(i);
                int n2 = this.PAGE_SIZE * n;
                int n3 = n2 + this.PAGE_SIZE;
                if (n2 <= this.tempPos && this.tempPos < n3) {
                    n3 = this.tempPos;
                }
                Arrays.fill(this.heap, n2, n3, 0);
            }
            this.availablePages.union(this.tempPages);
            this.tempPages.removeAll();
            this.newTempPage();
        }
    }

    public int addToTempHeap(int[] nArray) {
        if (this.tempPos + nArray.length >= this.tempMax) {
            this.newTempPage();
        }
        System.arraycopy(nArray, 0, this.heap, this.tempPos, nArray.length);
        int n = this.tempPos;
        this.tempPos += nArray.length;
        return n;
    }

    public int addToTempHeap(int n, int n2) {
        if (this.tempPos + n >= this.tempMax) {
            this.newTempPage();
        }
        int n3 = this.tempPos;
        this.tempPos += n;
        this.heap[n3] = n2;
        return n3;
    }

    public int addToHeap(int[] nArray) {
        if (nArray.length > this.PAGE_SIZE) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.permPos + nArray.length >= this.permMax) {
            this.newPermPage();
        }
        System.arraycopy(nArray, 0, this.heap, this.permPos, nArray.length);
        int n = this.permPos;
        this.permPos += nArray.length;
        return n;
    }

    public int addToHeap(int n, int n2) {
        if (n > this.PAGE_SIZE) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.permPos + n >= this.permMax) {
            this.newPermPage();
        }
        int n3 = this.permPos;
        this.permPos += n;
        this.heap[n3] = n2;
        return n3;
    }
}

