/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.FloatArrayFS;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FSGenerator;
import com.ibm.uima.cas.impl.FeatureStructureImplC;

public class FloatArrayFSImpl
extends FeatureStructureImplC
implements FloatArrayFS {
    private FloatArrayFSImpl() {
    }

    public FloatArrayFSImpl(int n, CASImpl cASImpl) {
        super(cASImpl, n);
    }

    static FSGenerator generator() {
        return new FloatArrayFSGenerator();
    }

    public int size() {
        return this.casImpl.getArraySize(this.addr);
    }

    public float get(int n) {
        if (n < 0 || n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return CASImpl.int2float(this.casImpl.getArrayValue(this.addr, n));
    }

    public void set(int n, float f) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.casImpl.setArrayValue(this.addr, n, CASImpl.float2int(f));
    }

    public void copyFromArray(float[] fArray, int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n2 + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n2 += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < n3; ++i) {
            this.casImpl.heap.heap[n2] = CASImpl.float2int(fArray[n]);
            ++n2;
            ++n;
        }
    }

    public void copyToArray(int n, float[] fArray, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < n3; ++i) {
            fArray[n2] = CASImpl.int2float(this.casImpl.heap.heap[n]);
            ++n2;
            ++n;
        }
    }

    public float[] toArray() {
        int n = this.size();
        float[] fArray = new float[n];
        this.copyToArray(0, fArray, 0, n);
        return fArray;
    }

    public void copyToArray(int n, String[] stringArray, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < n3; ++i) {
            stringArray[n2] = Float.toString(CASImpl.int2float(this.casImpl.heap.heap[n]));
            ++n2;
            ++n;
        }
    }

    public void copyFromArray(String[] stringArray, int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        float[] fArray = new float[n3];
        for (int i = 0; i < n3; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        this.copyFromArray(fArray, n, n2, n3);
    }

    public String[] toStringArray() {
        int n = this.size();
        String[] stringArray = new String[n];
        this.copyToArray(0, stringArray, 0, n);
        return stringArray;
    }

    private static class FloatArrayFSGenerator
    implements FSGenerator {
        private FloatArrayFSGenerator() {
        }

        public FeatureStructure createFS(int n, CASImpl cASImpl) {
            return new FloatArrayFSImpl(n, cASImpl);
        }
    }
}

