/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.CASRuntimeException;
import com.ibm.uima.cas.FeatureValuePath;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.LowLevelCAS;
import com.ibm.uima.cas.impl.LowLevelTypeSystem;
import com.ibm.uima.cas.impl.TCASImpl;
import com.ibm.uima.cas.impl.TypeSystemImpl;
import com.ibm.uima.cas.text.AnnotationFS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;

public class FeatureValuePathImpl
implements FeatureValuePath {
    private static final boolean CAS_TYPE_CHECKS = true;
    private static final HashMap CONTAINER_TO_ELEMENTYPE_MAP;
    private static final HashMap LIST_TO_ARRAYTYPE_MAP;
    private static final String COVERED_TEXT = "coveredText()";
    private static final String[] EMPTY_LIST_TYPE_NAMES;
    private static final String FS_ID = "fsId()";
    private static final int LAST_ARRAY_ENTRY = -1;
    private static final String LAST_ARRAY_ENTRY_MARKER = "last";
    private static final String[] LIST_TYPE_NAMES;
    private static final String[] SIMPLE_VAL_TYPES;
    private static final int TYPE_CLASS_FLOATLIST = 2;
    private static final int TYPE_CLASS_FSLIST = 0;
    private static final int TYPE_CLASS_INTEGERLIST = 1;
    private static final int TYPE_CLASS_STRINGLIST = 3;
    private static final String TYPE_NAME = "typeName()";
    private static final String UNIQUE_ID = "uniqueId()";
    private static final int USE_ALL_ENTRIES = -2;
    private int arrayIndex;
    private final FeatureValuePathImpl childPath;
    private Type[] emptyListTypes;
    private int featureCode;
    private String featureName;
    private int featureRangeType;
    private int headFeature;
    private boolean isArrayOrList;
    private boolean isArrayType;
    private boolean isBracketsOnly;
    private boolean isCoveredTextFeature;
    private boolean isFsIdFeature;
    private boolean isListType;
    private boolean isSimpleRangeType;
    private boolean isTypeNameFeature;
    private boolean isUniqueIdFeature;
    private int listType;
    private int tailFeature;
    private int typeCode;
    private final String typeNameInSnippet;
    private String valueTypeName;

    public static FeatureValuePathImpl getFeaturePath(String string) throws CASRuntimeException {
        Object object;
        if (string == null || string.length() == 0) {
            return null;
        }
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            object = (String)stringTokenizer.nextElement();
            stringArray[n] = object;
            ++n;
        }
        object = new FeatureValuePathImpl(stringArray[stringArray.length - 1], null);
        for (int i = stringArray.length - 2; i >= 0; --i) {
            object = new FeatureValuePathImpl(stringArray[i], (FeatureValuePathImpl)object);
        }
        return object;
    }

    private FeatureValuePathImpl(String string, FeatureValuePathImpl featureValuePathImpl) throws CASRuntimeException {
        if (string == null || string.length() == 0) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(25);
            cASRuntimeException.addArgument(string);
            throw cASRuntimeException;
        }
        this.childPath = featureValuePathImpl;
        this.typeNameInSnippet = this.getTypeInSnippet(string);
        this.featureName = this.getFeatureInSnippet(string);
        this.isArrayOrList = false;
        this.isArrayType = false;
        this.determineArray();
        this.isListType = false;
        this.isCoveredTextFeature = COVERED_TEXT.equals(this.featureName);
        this.isFsIdFeature = FS_ID.equals(this.featureName);
        this.isTypeNameFeature = TYPE_NAME.equals(this.featureName);
        this.isUniqueIdFeature = UNIQUE_ID.equals(this.featureName);
        boolean bl = this.isBracketsOnly = this.isArrayOrList && this.featureName.length() == 0;
        if ((this.isCoveredTextFeature || this.isFsIdFeature || this.isUniqueIdFeature || this.isTypeNameFeature) && featureValuePathImpl != null) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(25);
            cASRuntimeException.addArgument(string);
            throw cASRuntimeException;
        }
    }

    public Object evaluate(int n, LowLevelCAS lowLevelCAS) {
        String string = this.getValueType();
        if ("uima.cas.Float".equals(string)) {
            return this.evaluateAsFloat(n, lowLevelCAS);
        }
        if ("uima.cas.FloatArray".equals(string)) {
            return this.evaluateAsFloatArray(n, lowLevelCAS);
        }
        if ("uima.cas.Integer".equals(string)) {
            return this.evaluateAsInt(n, lowLevelCAS);
        }
        if ("uima.cas.IntegerArray".equals(string)) {
            return this.evaluateAsIntArray(n, lowLevelCAS);
        }
        if ("uima.cas.String".equals(string)) {
            return this.evaluateAsString(n, lowLevelCAS);
        }
        if ("uima.cas.StringArray".equals(string)) {
            return this.evaluateAsStringArray(n, lowLevelCAS);
        }
        throw new IllegalStateException("unknown value type");
    }

    public Float evaluateAsFloat(int n, LowLevelCAS lowLevelCAS) {
        if (n == 0) {
            return null;
        }
        if (this.isArrayType) {
            if (this.arrayIndex == -2) {
                throw new IllegalStateException("feature path denotes an array");
            }
            int n2 = this.isBracketsOnly ? n : lowLevelCAS.ll_getRefValue(n, this.featureCode);
            int n3 = ((CASImpl)lowLevelCAS).getArraySize(n2);
            if (this.arrayIndex >= n3) {
                return null;
            }
            int n4 = lowLevelCAS.ll_getTypeClass(this.featureRangeType);
            switch (n4) {
                case 5: {
                    int n5 = this.getArrayIndex(n3);
                    return new Float(lowLevelCAS.ll_getFloatArrayValue(n2, n5, false));
                }
                case 7: {
                    int n6 = this.getFsAtIndex(n2, lowLevelCAS, n3);
                    return this.childPath.evaluateAsFloat(n6, lowLevelCAS);
                }
            }
            throw new IllegalStateException("feature path snippet is neither float nor fs array");
        }
        if (this.isListType) {
            if (this.arrayIndex == -2) {
                throw new IllegalStateException("feature path denotes an array");
            }
            int n7 = this.isBracketsOnly ? n : lowLevelCAS.ll_getRefValue(n, this.featureCode);
            switch (this.listType) {
                case 2: {
                    return (Float)this.getValueAtListIndex(lowLevelCAS, n7);
                }
                case 0: {
                    int n8 = this.getFsAtListIndex(lowLevelCAS, n7);
                    if (n8 != 0) {
                        return this.childPath.evaluateAsFloat(n8, lowLevelCAS);
                    }
                    return null;
                }
            }
            throw new IllegalStateException("feature path snippet is neither float nor fs list");
        }
        if (this.childPath != null) {
            int n9 = lowLevelCAS.ll_getRefValue(n, this.featureCode, true);
            return this.childPath.evaluateAsFloat(n9, lowLevelCAS);
        }
        if (this.isCoveredTextFeature || this.isUniqueIdFeature || this.isFsIdFeature || this.isTypeNameFeature) {
            throw new IllegalStateException("feature path does not denote a float");
        }
        int n10 = lowLevelCAS.ll_getTypeClass(this.featureRangeType);
        switch (n10) {
            case 2: {
                return new Float(lowLevelCAS.ll_getFloatValue(n, this.featureCode, true));
            }
        }
        throw new IllegalStateException("feature path does not denote a float");
    }

    public Float[] evaluateAsFloatArray(int n, LowLevelCAS lowLevelCAS) {
        if (!this.getValueType().equals("uima.cas.FloatArray")) {
            throw new IllegalStateException("Feature path does not denote a float array");
        }
        if (n == 0) {
            return null;
        }
        if (this.isArrayType) {
            int n2 = this.isBracketsOnly ? n : lowLevelCAS.ll_getRefValue(n, this.featureCode);
            int n3 = ((CASImpl)lowLevelCAS).getArraySize(n2);
            if (this.arrayIndex >= n3) {
                return null;
            }
            if (this.arrayIndex == -2) {
                Float[] floatArray = new Float[n3];
                if (this.childPath != null) {
                    for (int i = 0; i < n3; ++i) {
                        int n4 = lowLevelCAS.ll_getRefArrayValue(n2, i, true);
                        floatArray[i] = this.childPath.evaluateAsFloat(n4, lowLevelCAS);
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        floatArray[i] = new Float(lowLevelCAS.ll_getFloatArrayValue(n2, i));
                    }
                }
                return floatArray;
            }
            int n5 = this.getFsAtIndex(n2, lowLevelCAS, n3);
            return this.childPath.evaluateAsFloatArray(n5, lowLevelCAS);
        }
        if (this.isListType) {
            int n6;
            int n7 = n6 = this.isBracketsOnly ? n : lowLevelCAS.ll_getRefValue(n, this.featureCode);
            if (this.arrayIndex == -2) {
                ArrayList arrayList = (ArrayList)this.getValueAtListIndex(lowLevelCAS, n6);
                if (arrayList == null) {
                    return null;
                }
                Float[] floatArray = new Float[arrayList.size()];
                if (this.childPath != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        int n8 = (Integer)arrayList.get(i);
                        floatArray[i] = this.childPath.evaluateAsFloat(n8, lowLevelCAS);
                    }
                } else {
                    arrayList.toArray(floatArray);
                }
                return floatArray;
            }
            int n9 = this.getFsAtListIndex(lowLevelCAS, n6);
            return this.childPath.evaluateAsFloatArray(n9, lowLevelCAS);
        }
        int n10 = lowLevelCAS.ll_getRefValue(n, this.featureCode, true);
        return this.childPath.evaluateAsFloatArray(n10, lowLevelCAS);
    }

    public Integer evaluateAsInt(int n, LowLevelCAS lowLevelCAS) {
        if (n == 0) {
            return null;
        }
        if (this.isArrayType) {
            if (this.arrayIndex == -2) {
                throw new IllegalStateException("feature path denotes an array");
            }
            int n2 = this.isBracketsOnly ? n : lowLevelCAS.ll_getRefValue(n, this.featureCode);
            int n3 = ((CASImpl)lowLevelCAS).getArraySize(n2);
            if (this.arrayIndex >= n3) {
                return null;
            }
            int n4 = lowLevelCAS.ll_getTypeClass(this.featureRangeType);
            switch (n4) {
                case 4: {
                    int n5 = this.getArrayIndex(n3);
                    return new Integer(lowLevelCAS.ll_getIntArrayValue(n2, n5, false));
                }
                case 7: {
                    int n6 = this.getFsAtIndex(n2, lowLevelCAS, n3);
                    return this.childPath.evaluateAsInt(n6, lowLevelCAS);
                }
            }
            throw new IllegalStateException("feature path snippet is neither int nor fs array");
        }
        if (this.isListType) {
            if (this.arrayIndex == -2) {
                throw new IllegalStateException("feature path denotes an array");
            }
            int n7 = this.isBracketsOnly ? n : lowLevelCAS.ll_getRefValue(n, this.featureCode);
            switch (this.listType) {
                case 1: {
                    return (Integer)this.getValueAtListIndex(lowLevelCAS, n7);
                }
                case 0: {
                    int n8 = this.getFsAtListIndex(lowLevelCAS, n7);
                    if (n8 != 0) {
                        return this.childPath.evaluateAsInt(n8, lowLevelCAS);
                    }
                    return null;
                }
            }
            throw new IllegalStateException("feature path snippet is neither int nor fs list");
        }
        if (this.childPath != null) {
            int n9 = lowLevelCAS.ll_getRefValue(n, this.featureCode, true);
            return this.childPath.evaluateAsInt(n9, lowLevelCAS);
        }
        if (this.isCoveredTextFeature || this.isTypeNameFeature) {
            throw new IllegalStateException("feature path does not denote an int");
        }
        if (this.isFsIdFeature) {
            return new Integer(n);
        }
        if (this.isUniqueIdFeature) {
            return new Integer(n);
        }
        int n10 = lowLevelCAS.ll_getTypeClass(this.featureRangeType);
        switch (n10) {
            case 1: {
                return new Integer(lowLevelCAS.ll_getIntValue(n, this.featureCode, true));
            }
        }
        throw new IllegalStateException("feature path does not denote an int");
    }

    public Integer[] evaluateAsIntArray(int n, LowLevelCAS lowLevelCAS) {
        if (!this.getValueType().equals("uima.cas.IntegerArray")) {
            throw new IllegalStateException("Feature path does not denote an int array");
        }
        if (n == 0) {
            return null;
        }
        if (this.isArrayType) {
            int n2 = this.isBracketsOnly ? n : lowLevelCAS.ll_getRefValue(n, this.featureCode);
            int n3 = ((CASImpl)lowLevelCAS).getArraySize(n2);
            if (this.arrayIndex >= n3) {
                return null;
            }
            if (this.arrayIndex == -2) {
                Integer[] integerArray = new Integer[n3];
                if (this.childPath != null) {
                    for (int i = 0; i < n3; ++i) {
                        int n4 = lowLevelCAS.ll_getRefArrayValue(n2, i, true);
                        integerArray[i] = this.childPath.evaluateAsInt(n4, lowLevelCAS);
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        integerArray[i] = new Integer(lowLevelCAS.ll_getIntArrayValue(n2, i));
                    }
                }
                return integerArray;
            }
            int n5 = this.getFsAtIndex(n2, lowLevelCAS, n3);
            return this.childPath.evaluateAsIntArray(n5, lowLevelCAS);
        }
        if (this.isListType) {
            int n6;
            int n7 = n6 = this.isBracketsOnly ? n : lowLevelCAS.ll_getRefValue(n, this.featureCode);
            if (this.arrayIndex == -2) {
                ArrayList arrayList = (ArrayList)this.getValueAtListIndex(lowLevelCAS, n6);
                if (arrayList == null) {
                    return null;
                }
                Integer[] integerArray = new Integer[arrayList.size()];
                if (this.childPath != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        int n8 = (Integer)arrayList.get(i);
                        integerArray[i] = this.childPath.evaluateAsInt(n8, lowLevelCAS);
                    }
                } else {
                    arrayList.toArray(integerArray);
                }
                return integerArray;
            }
            int n9 = this.getFsAtListIndex(lowLevelCAS, n6);
            return this.childPath.evaluateAsIntArray(n9, lowLevelCAS);
        }
        int n10 = lowLevelCAS.ll_getRefValue(n, this.featureCode, true);
        return this.childPath.evaluateAsIntArray(n10, lowLevelCAS);
    }

    public String evaluateAsString(int n, LowLevelCAS lowLevelCAS) {
        if (n == 0) {
            return null;
        }
        if (this.isArrayType) {
            if (this.arrayIndex == -2) {
                throw new IllegalStateException("feature path denotes an array");
            }
            int n2 = this.isBracketsOnly ? n : lowLevelCAS.ll_getRefValue(n, this.featureCode);
            int n3 = ((CASImpl)lowLevelCAS).getArraySize(n2);
            if (this.arrayIndex >= n3) {
                return null;
            }
            int n4 = lowLevelCAS.ll_getTypeClass(this.featureRangeType);
            switch (n4) {
                case 6: {
                    int n5 = this.getArrayIndex(n3);
                    return lowLevelCAS.ll_getStringArrayValue(n2, n5, false);
                }
                case 7: {
                    int n6 = this.getFsAtIndex(n2, lowLevelCAS, n3);
                    return this.childPath.evaluateAsString(n6, lowLevelCAS);
                }
            }
            throw new IllegalStateException("feature path snippet is neither string nor fs array");
        }
        if (this.isListType) {
            if (this.arrayIndex == -2) {
                throw new IllegalStateException("feature path denotes an array");
            }
            int n7 = this.isBracketsOnly ? n : lowLevelCAS.ll_getRefValue(n, this.featureCode);
            switch (this.listType) {
                case 3: {
                    return (String)this.getValueAtListIndex(lowLevelCAS, n7);
                }
                case 0: {
                    int n8 = this.getFsAtListIndex(lowLevelCAS, n7);
                    if (n8 != 0) {
                        return this.childPath.evaluateAsString(n8, lowLevelCAS);
                    }
                    return null;
                }
            }
            throw new IllegalStateException("feature path snippet is neither float nor fs list");
        }
        if (this.childPath != null) {
            int n9 = lowLevelCAS.ll_getRefValue(n, this.featureCode, true);
            return this.childPath.evaluateAsString(n9, lowLevelCAS);
        }
        if (this.isCoveredTextFeature) {
            AnnotationFS annotationFS = (AnnotationFS)lowLevelCAS.ll_getFSForRef(n);
            return annotationFS.getCoveredText();
        }
        if (this.isTypeNameFeature) {
            Type type = lowLevelCAS.ll_getTypeSystem().ll_getTypeForCode(lowLevelCAS.ll_getFSRefType(n));
            return type.getName();
        }
        if (this.isFsIdFeature) {
            throw new IllegalStateException("feature path denotes fsId()");
        }
        if (this.isUniqueIdFeature) {
            throw new IllegalStateException("feature path denotes uniqueId()");
        }
        int n10 = lowLevelCAS.ll_getTypeClass(this.featureRangeType);
        switch (n10) {
            case 3: {
                return lowLevelCAS.ll_getStringValue(n, this.featureCode, true);
            }
            case 2: {
                throw new IllegalStateException("feature path denotes a float");
            }
            case 1: {
                throw new IllegalStateException("feature path denotes an int");
            }
        }
        throw new IllegalStateException("feature path does not denote a string");
    }

    public String[] evaluateAsStringArray(int n, LowLevelCAS lowLevelCAS) {
        if (!this.getValueType().equals("uima.cas.StringArray")) {
            throw new IllegalStateException("Feature path does not denote a String array");
        }
        if (n == 0) {
            return null;
        }
        if (this.isArrayType) {
            int n2 = this.isBracketsOnly ? n : lowLevelCAS.ll_getRefValue(n, this.featureCode);
            int n3 = ((CASImpl)lowLevelCAS).getArraySize(n2);
            if (this.arrayIndex >= n3) {
                return null;
            }
            if (this.arrayIndex == -2) {
                String[] stringArray = new String[n3];
                if (this.childPath != null) {
                    for (int i = 0; i < n3; ++i) {
                        int n4 = lowLevelCAS.ll_getRefArrayValue(n2, i, true);
                        stringArray[i] = this.childPath.evaluateAsString(n4, lowLevelCAS);
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        stringArray[i] = lowLevelCAS.ll_getStringArrayValue(n2, i);
                    }
                }
                return stringArray;
            }
            int n5 = this.getFsAtIndex(n2, lowLevelCAS, n3);
            return this.childPath.evaluateAsStringArray(n5, lowLevelCAS);
        }
        if (this.isListType) {
            int n6;
            int n7 = n6 = this.isBracketsOnly ? n : lowLevelCAS.ll_getRefValue(n, this.featureCode);
            if (this.arrayIndex == -2) {
                ArrayList arrayList = (ArrayList)this.getValueAtListIndex(lowLevelCAS, n6);
                if (arrayList == null) {
                    return null;
                }
                String[] stringArray = new String[arrayList.size()];
                if (this.childPath != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        int n8 = (Integer)arrayList.get(i);
                        stringArray[i] = this.childPath.evaluateAsString(n8, lowLevelCAS);
                    }
                } else {
                    arrayList.toArray(stringArray);
                }
                return stringArray;
            }
            int n9 = this.getFsAtListIndex(lowLevelCAS, n6);
            return this.childPath.evaluateAsStringArray(n9, lowLevelCAS);
        }
        int n10 = lowLevelCAS.ll_getRefValue(n, this.featureCode, true);
        return this.childPath.evaluateAsStringArray(n10, lowLevelCAS);
    }

    public int getFSType() {
        if (this.isSimpleRangeType) {
            return this.typeCode;
        }
        return this.childPath.getFSType();
    }

    public String getValueType() {
        if (this.valueTypeName == null) {
            this.valueTypeName = this.childPath.getValueType();
            if (this.arrayIndex == -2) {
                if ("uima.cas.String".equals(this.valueTypeName)) {
                    this.valueTypeName = "uima.cas.StringArray";
                } else if ("uima.cas.Integer".equals(this.valueTypeName)) {
                    this.valueTypeName = "uima.cas.IntegerArray";
                } else if ("uima.cas.Float".equals(this.valueTypeName)) {
                    this.valueTypeName = "uima.cas.FloatArray";
                }
            }
        }
        return this.valueTypeName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.typeNameInSnippet != null) {
            stringBuffer.append(this.typeNameInSnippet);
            stringBuffer.append(':');
        }
        stringBuffer.append(this.featureName);
        if (this.isArrayOrList) {
            stringBuffer.append("[");
            if (!this.isBracketsOnly && this.arrayIndex >= 0) {
                stringBuffer.append(this.arrayIndex);
            }
            if (this.arrayIndex == -1) {
                stringBuffer.append(LAST_ARRAY_ENTRY_MARKER);
            }
            stringBuffer.append("]");
        }
        if (this.childPath != null) {
            stringBuffer.append("/");
            stringBuffer.append(this.childPath.toString());
        }
        return stringBuffer.toString();
    }

    public void typeSystemInit(int n, LowLevelTypeSystem lowLevelTypeSystem) throws CASRuntimeException {
        int n2;
        int n3;
        Object object;
        if (this.typeNameInSnippet != null) {
            n = lowLevelTypeSystem.ll_getCodeForTypeName(this.typeNameInSnippet);
        }
        if (n == 0) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(25);
            cASRuntimeException.addArgument(this.typeNameInSnippet);
            throw cASRuntimeException;
        }
        int n4 = 0;
        if (!this.isBuiltInFeature() && !this.isBracketsOnly) {
            Object object2;
            object = lowLevelTypeSystem.ll_getAppropriateFeatures(n);
            n3 = 0;
            for (n2 = 0; n2 < ((int[])object).length && n3 == 0; ++n2) {
                object2 = lowLevelTypeSystem.ll_getFeatureForCode((int)object[n2]);
                n3 = object2.getShortName().equals(this.featureName) ? 1 : 0;
            }
            if (n3 != 0) {
                this.featureCode = (int)object[n2 - 1];
                n4 = lowLevelTypeSystem.ll_getRangeType(this.featureCode);
            } else {
                object2 = new CASRuntimeException(3);
                Type type = lowLevelTypeSystem.ll_getTypeForCode(n);
                ((CASRuntimeException)object2).addArgument(this.featureName);
                ((CASRuntimeException)object2).addArgument(type.getName());
                throw object2;
            }
        }
        if (this.isBracketsOnly) {
            n4 = n;
        }
        this.typeCode = n;
        object = lowLevelTypeSystem.ll_getTypeForCode(n4);
        this.featureRangeType = n4;
        if (this.isBuiltInFeature()) {
            this.isSimpleRangeType = true;
        } else {
            boolean bl = this.isSimpleRangeType = Arrays.binarySearch(SIMPLE_VAL_TYPES, object.getName()) >= 0;
        }
        if (this.isArrayOrList) {
            n3 = lowLevelTypeSystem.ll_getCodeForTypeName("uima.cas.ArrayBase");
            this.isArrayType = ((TypeSystemImpl)lowLevelTypeSystem).subsumes(n3, n4);
            if (!this.isArrayType) {
                for (n2 = 0; n2 < LIST_TYPE_NAMES.length && !this.isListType; ++n2) {
                    int n5 = lowLevelTypeSystem.ll_getCodeForTypeName(LIST_TYPE_NAMES[n2]);
                    this.isListType = ((TypeSystemImpl)lowLevelTypeSystem).subsumes(n5, n4);
                    if (!this.isListType) continue;
                    this.listType = n2;
                }
                switch (this.listType) {
                    case 0: {
                        this.headFeature = lowLevelTypeSystem.ll_getCodeForFeatureName("uima.cas.NonEmptyFSList:head");
                        this.tailFeature = lowLevelTypeSystem.ll_getCodeForFeatureName("uima.cas.NonEmptyFSList:tail");
                        break;
                    }
                    case 3: {
                        this.headFeature = lowLevelTypeSystem.ll_getCodeForFeatureName("uima.cas.NonEmptyStringList:head");
                        this.tailFeature = lowLevelTypeSystem.ll_getCodeForFeatureName("uima.cas.NonEmptyStringList:tail");
                        break;
                    }
                    case 1: {
                        this.headFeature = lowLevelTypeSystem.ll_getCodeForFeatureName("uima.cas.NonEmptyIntegerList:head");
                        this.tailFeature = lowLevelTypeSystem.ll_getCodeForFeatureName("uima.cas.NonEmptyIntegerList:tail");
                        break;
                    }
                    case 2: {
                        this.headFeature = lowLevelTypeSystem.ll_getCodeForFeatureName("uima.cas.NonEmptyFloatList:head");
                        this.tailFeature = lowLevelTypeSystem.ll_getCodeForFeatureName("uima.cas.NonEmptyFloatList:tail");
                        break;
                    }
                }
                this.emptyListTypes = new Type[EMPTY_LIST_TYPE_NAMES.length];
                for (n2 = 0; n2 < EMPTY_LIST_TYPE_NAMES.length; ++n2) {
                    this.emptyListTypes[n2] = lowLevelTypeSystem.ll_getTypeForCode(lowLevelTypeSystem.ll_getCodeForTypeName(EMPTY_LIST_TYPE_NAMES[n2]));
                }
            }
        }
        if (this.childPath != null) {
            if (this.isSimpleRangeType & (!this.childPath.isBracketsOnly() && !this.childPath.isFsIdFeature)) {
                CASRuntimeException cASRuntimeException = new CASRuntimeException(25);
                cASRuntimeException.addArgument(this.featureName);
                throw cASRuntimeException;
            }
            this.childPath.typeSystemInit(n4, lowLevelTypeSystem);
        } else if (this.isCoveredTextFeature) {
            n3 = lowLevelTypeSystem.ll_getCodeForTypeName("uima.tcas.Annotation");
            if (!((TypeSystemImpl)lowLevelTypeSystem).subsumes(n3, n)) {
                CASRuntimeException cASRuntimeException = new CASRuntimeException(25);
                cASRuntimeException.addArgument(this.typeNameInSnippet);
                throw cASRuntimeException;
            }
            this.valueTypeName = SIMPLE_VAL_TYPES[Arrays.binarySearch(SIMPLE_VAL_TYPES, "uima.cas.String")];
        } else if (this.isFsIdFeature) {
            this.valueTypeName = SIMPLE_VAL_TYPES[Arrays.binarySearch(SIMPLE_VAL_TYPES, "uima.cas.Integer")];
        } else if (this.isUniqueIdFeature) {
            this.valueTypeName = SIMPLE_VAL_TYPES[Arrays.binarySearch(SIMPLE_VAL_TYPES, "uima.cas.Integer")];
        } else if (this.isTypeNameFeature) {
            this.valueTypeName = SIMPLE_VAL_TYPES[Arrays.binarySearch(SIMPLE_VAL_TYPES, "uima.cas.String")];
        } else {
            if (!this.isSimpleRangeType) {
                CASRuntimeException cASRuntimeException = new CASRuntimeException(26);
                throw cASRuntimeException;
            }
            this.valueTypeName = this.isArrayOrList && this.arrayIndex != -2 ? (String)CONTAINER_TO_ELEMENTYPE_MAP.get(object.getName()) : (this.isListType ? (String)LIST_TO_ARRAYTYPE_MAP.get(object.getName()) : SIMPLE_VAL_TYPES[Arrays.binarySearch(SIMPLE_VAL_TYPES, object.getName())]);
        }
    }

    private boolean isBuiltInFeature() {
        return this.isFsIdFeature || this.isUniqueIdFeature || this.isCoveredTextFeature || this.isTypeNameFeature;
    }

    private final void determineArray() throws CASRuntimeException {
        int n = this.featureName.indexOf(91);
        if (n == -1) {
            return;
        }
        int n2 = this.featureName.indexOf(93);
        if (n2 == -1) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(25);
            cASRuntimeException.addArgument(this.toString());
            throw cASRuntimeException;
        }
        this.isArrayOrList = true;
        String string = this.featureName.substring(n + 1, n2);
        this.featureName = this.featureName.substring(0, n);
        if (string.equals("")) {
            this.arrayIndex = -2;
        } else if (LAST_ARRAY_ENTRY_MARKER.equalsIgnoreCase(string)) {
            this.arrayIndex = -1;
        } else {
            try {
                this.arrayIndex = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                CASRuntimeException cASRuntimeException = new CASRuntimeException(25);
                cASRuntimeException.addArgument(this.toString());
                throw cASRuntimeException;
            }
        }
    }

    private int getArrayIndex(int n) {
        return -1 != this.arrayIndex ? this.arrayIndex : n - 1;
    }

    private final String getFeatureInSnippet(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private int getFsAtIndex(int n, LowLevelCAS lowLevelCAS, int n2) {
        if (!this.isArrayType) {
            throw new IllegalStateException("FeaturePath is not an array");
        }
        int n3 = this.getArrayIndex(n2);
        int n4 = lowLevelCAS.ll_getRefArrayValue(n, n3, true);
        return n4;
    }

    private int getFsAtListIndex(LowLevelCAS lowLevelCAS, int n) {
        if (this.arrayIndex == -2 || this.listType != 0) {
            throw new IllegalStateException("feature does not denote an fs list, or does not denote a singel array entry");
        }
        Object object = this.getValueAtListIndex(lowLevelCAS, n);
        if (object != null) {
            return (Integer)object;
        }
        return 0;
    }

    private Object getHeadValue(LowLevelCAS lowLevelCAS, int n) {
        if (n == 0) {
            return null;
        }
        switch (this.listType) {
            case 3: {
                return lowLevelCAS.ll_getStringValue(n, this.headFeature);
            }
            case 1: {
                return new Integer(lowLevelCAS.ll_getIntValue(n, this.headFeature));
            }
            case 2: {
                return new Float(lowLevelCAS.ll_getFloatValue(n, this.headFeature));
            }
            case 0: {
                return new Integer(lowLevelCAS.ll_getRefValue(n, this.headFeature));
            }
        }
        return null;
    }

    private final String getTypeInSnippet(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    private Object getValueAtIndexRec(LowLevelCAS lowLevelCAS, int n, ArrayList arrayList, int n2) {
        if (n == 0) {
            return null;
        }
        int n3 = lowLevelCAS.ll_getFSRefType(n);
        if (this.isEmptyList(lowLevelCAS, n3)) {
            return null;
        }
        int n4 = lowLevelCAS.ll_getRefValue(n, this.tailFeature);
        switch (this.arrayIndex) {
            case -2: {
                arrayList.add(this.getHeadValue(lowLevelCAS, n));
                return this.getValueAtIndexRec(lowLevelCAS, n4, arrayList, ++n2);
            }
            case -1: {
                Object object = this.getValueAtIndexRec(lowLevelCAS, n4, arrayList, ++n2);
                if (object != null) {
                    return object;
                }
                return this.getHeadValue(lowLevelCAS, n);
            }
        }
        if (n2 == this.arrayIndex) {
            return this.getHeadValue(lowLevelCAS, n);
        }
        return this.getValueAtIndexRec(lowLevelCAS, n4, arrayList, ++n2);
    }

    private Object getValueAtListIndex(LowLevelCAS lowLevelCAS, int n) {
        ArrayList arrayList = new ArrayList();
        Object object = this.getValueAtIndexRec(lowLevelCAS, n, arrayList, 0);
        if (arrayList.isEmpty()) {
            return object;
        }
        return arrayList;
    }

    private boolean isBracketsOnly() {
        return this.isBracketsOnly;
    }

    private boolean isEmptyList(LowLevelCAS lowLevelCAS, int n) {
        Type type = lowLevelCAS.ll_getTypeSystem().ll_getTypeForCode(n);
        TypeSystem typeSystem = ((TCASImpl)lowLevelCAS).getTypeSystem();
        boolean bl = false;
        for (int i = 0; i < this.emptyListTypes.length && !bl; ++i) {
            bl = typeSystem.subsumes(this.emptyListTypes[i], type);
        }
        return bl;
    }

    static {
        EMPTY_LIST_TYPE_NAMES = new String[]{"uima.cas.EmptyFSList", "uima.cas.EmptyIntegerList", "uima.cas.EmptyFloatList", "uima.cas.EmptyStringList"};
        LIST_TYPE_NAMES = new String[]{"uima.cas.FSList", "uima.cas.IntegerList", "uima.cas.FloatList", "uima.cas.StringList"};
        SIMPLE_VAL_TYPES = new String[]{"uima.cas.String", "uima.cas.StringArray", "uima.cas.Integer", "uima.cas.IntegerArray", "uima.cas.Float", "uima.cas.FloatArray", "uima.cas.IntegerList", "uima.cas.FloatList", "uima.cas.StringList"};
        Arrays.sort(SIMPLE_VAL_TYPES);
        CONTAINER_TO_ELEMENTYPE_MAP = new HashMap();
        CONTAINER_TO_ELEMENTYPE_MAP.put("uima.cas.IntegerArray", "uima.cas.Integer");
        CONTAINER_TO_ELEMENTYPE_MAP.put("uima.cas.StringArray", "uima.cas.String");
        CONTAINER_TO_ELEMENTYPE_MAP.put("uima.cas.FloatArray", "uima.cas.Float");
        CONTAINER_TO_ELEMENTYPE_MAP.put("uima.cas.IntegerList", "uima.cas.Integer");
        CONTAINER_TO_ELEMENTYPE_MAP.put("uima.cas.StringList", "uima.cas.String");
        CONTAINER_TO_ELEMENTYPE_MAP.put("uima.cas.FloatList", "uima.cas.Float");
        LIST_TO_ARRAYTYPE_MAP = new HashMap();
        LIST_TO_ARRAYTYPE_MAP.put("uima.cas.IntegerList", "uima.cas.IntegerArray");
        LIST_TO_ARRAYTYPE_MAP.put("uima.cas.StringList", "uima.cas.StringArray");
        LIST_TO_ARRAYTYPE_MAP.put("uima.cas.FloatList", "uima.cas.FloatArray");
    }
}

