/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.CASRuntimeException;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FeatureImpl;
import com.ibm.uima.cas.impl.LowLevelCAS;
import com.ibm.uima.cas.impl.LowLevelTypeSystem;
import com.ibm.uima.cas.impl.StringTypeImpl;
import com.ibm.uima.cas.impl.TypeImpl;
import com.ibm.uima.cas.impl.TypeSystemImpl;
import com.ibm.uima.util.IntSet;
import com.ibm.uima.util.StringUtils;
import com.ibm.uima.util.rb_trees.RedBlackTree;
import java.util.Arrays;
import java.util.List;

public abstract class FeatureStructureImpl
implements FeatureStructure,
Cloneable {
    public abstract int getAddress();

    protected abstract CASImpl getCASImpl();

    public Type getType() {
        return this.getCASImpl().getTypeSystemImpl().getType(this.getCASImpl().getHeapValue(this.getAddress()));
    }

    public void setFeatureValue(Feature feature, FeatureStructure featureStructure) {
        int n = this.getCASImpl().ll_getFSRef(featureStructure);
        int n2 = ((FeatureImpl)feature).getCode();
        int n3 = this.getCASImpl().getTypeSystemImpl().range(n2);
        if (n == 0) {
            this.setNullValue(n2, n3);
            return;
        }
        int n4 = this.getCASImpl().getHeapValue(this.getAddress());
        int n5 = this.getCASImpl().getHeapValue(n);
        if (!this.getCASImpl().getTypeSystemImpl().isApprop(n4, n2)) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(2);
            cASRuntimeException.addArgument(feature.getName());
            cASRuntimeException.addArgument(this.getType().getName());
            throw cASRuntimeException;
        }
        if (!this.getCASImpl().getTypeSystemImpl().subsumes(n3, n5)) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(4);
            cASRuntimeException.addArgument(feature.getName());
            cASRuntimeException.addArgument(feature.getRange().getName());
            cASRuntimeException.addArgument(featureStructure.getType().getName());
            throw cASRuntimeException;
        }
        this.getCASImpl().setFeatureValue(this.getAddress(), n2, n);
    }

    private final void setNullValue(int n, int n2) {
        if (this.getCASImpl().isIntType(n2) || this.getCASImpl().isFloatType(n2) || this.getCASImpl().isStringType(n2)) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(5);
            cASRuntimeException.addArgument(this.getCASImpl().getTypeSystemImpl().getFeature(n).getName());
            throw cASRuntimeException;
        }
        this.getCASImpl().setFeatureValue(this.getAddress(), n, 0);
    }

    public void setIntValue(Feature feature, int n) {
        TypeSystemImpl typeSystemImpl = this.getCASImpl().getTypeSystemImpl();
        if (!typeSystemImpl.subsumes(((TypeImpl)feature.getDomain()).getCode(), this.getCASImpl().getHeapValue(this.getAddress()))) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feature, this.getType());
        }
        if (!typeSystemImpl.subsumes(((TypeImpl)feature.getRange()).getCode(), ((TypeImpl)typeSystemImpl.getType("uima.cas.Integer")).getCode())) {
            FeatureStructureImpl.throwIllegalRangeExc(feature, typeSystemImpl.getType("uima.cas.Integer"));
        }
        int n2 = ((FeatureImpl)feature).getCode();
        this.getCASImpl().setFeatureValue(this.getAddress(), n2, n);
    }

    public void setFloatValue(Feature feature, float f) {
        TypeSystemImpl typeSystemImpl = this.getCASImpl().getTypeSystemImpl();
        if (!typeSystemImpl.subsumes(((TypeImpl)feature.getDomain()).getCode(), this.getCASImpl().getHeapValue(this.getAddress()))) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feature, this.getType());
        }
        if (!typeSystemImpl.subsumes(((TypeImpl)feature.getRange()).getCode(), ((TypeImpl)typeSystemImpl.getType("uima.cas.Float")).getCode())) {
            FeatureStructureImpl.throwIllegalRangeExc(feature, typeSystemImpl.getType("uima.cas.Float"));
        }
        int n = ((FeatureImpl)feature).getCode();
        this.getCASImpl().setFloatValue(this.getAddress(), n, f);
    }

    public void setStringValue(Feature feature, String string) {
        int n;
        Object[] objectArray;
        TypeSystemImpl typeSystemImpl = this.getCASImpl().getTypeSystemImpl();
        int n2 = ((FeatureImpl)feature).getCode();
        int n3 = typeSystemImpl.range(n2);
        int n4 = this.getCASImpl().getHeapValue(this.getAddress());
        int n5 = ((TypeImpl)this.getCASImpl().getTypeSystem().getType("uima.cas.String")).getCode();
        if (!typeSystemImpl.isApprop(n4, n2)) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(3);
            cASRuntimeException.addArgument(feature.getName());
            cASRuntimeException.addArgument(this.getType().getName());
            throw cASRuntimeException;
        }
        if (!typeSystemImpl.subsumes(n5, n3)) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(2);
            cASRuntimeException.addArgument(feature.getRange().getName());
            cASRuntimeException.addArgument(this.getCASImpl().getTypeSystem().getType("uima.cas.String").getName());
            throw cASRuntimeException;
        }
        if (n5 != n3 && Arrays.binarySearch(objectArray = typeSystemImpl.getStringSet(n = ((StringTypeImpl)typeSystemImpl.getType(n3)).getStringSet()), string) < 0) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(7);
            cASRuntimeException.addArgument(string);
            cASRuntimeException.addArgument(typeSystemImpl.getTypeName(n3));
            throw cASRuntimeException;
        }
        this.getCASImpl().setStringValue(this.getAddress(), n2, string);
    }

    public void setFeatureValueFromString(Feature feature, String string) throws CASRuntimeException {
        Type type = feature.getRange();
        if (!type.isPrimitive()) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(2);
            cASRuntimeException.addArgument(feature.getName());
            cASRuntimeException.addArgument(feature.getName());
            cASRuntimeException.addArgument(type.getName());
            throw cASRuntimeException;
        }
        int n = ((TypeImpl)type).getCode();
        if (this.getCASImpl().isStringType(n)) {
            this.setStringValue(feature, string);
        } else if (this.getCASImpl().isIntType(n)) {
            int n2 = Integer.parseInt(string);
            this.setIntValue(feature, n2);
        } else if (this.getCASImpl().isFloatType(n)) {
            float f = Float.parseFloat(string);
            this.setFloatValue(feature, f);
        } else {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(2);
            cASRuntimeException.addArgument(feature.getName());
            cASRuntimeException.addArgument(feature.getName());
            cASRuntimeException.addArgument(type.getName());
            throw cASRuntimeException;
        }
    }

    public FeatureStructure getFeatureValue(Feature feature) throws CASRuntimeException {
        TypeSystemImpl typeSystemImpl = this.getCASImpl().getTypeSystemImpl();
        int n = ((FeatureImpl)feature).getCode();
        if (!typeSystemImpl.isApprop(this.getCASImpl().getHeapValue(this.getAddress()), n)) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(3);
            cASRuntimeException.addArgument(feature.getName());
            cASRuntimeException.addArgument(this.getType().getName());
            throw cASRuntimeException;
        }
        int n2 = typeSystemImpl.ll_getRangeType(n);
        if (!this.getCASImpl().isFSRefType(n2)) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(5);
            cASRuntimeException.addArgument(feature.getName());
            throw cASRuntimeException;
        }
        int n3 = this.getCASImpl().getFeatureValue(this.getAddress(), n);
        return this.getCASImpl().createFS(n3);
    }

    public int getIntValue(Feature feature) {
        TypeSystemImpl typeSystemImpl = this.getCASImpl().getTypeSystemImpl();
        if (!typeSystemImpl.subsumes(feature.getDomain(), this.getType())) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feature, this.getType());
        }
        if (!typeSystemImpl.subsumes(feature.getRange(), typeSystemImpl.getType("uima.cas.Integer"))) {
            FeatureStructureImpl.throwIllegalRangeExc(feature, typeSystemImpl.getType("uima.cas.Integer"));
        }
        int n = ((FeatureImpl)feature).getCode();
        return this.getCASImpl().getFeatureValue(this.getAddress(), n);
    }

    public float getFloatValue(Feature feature) throws CASRuntimeException {
        TypeSystemImpl typeSystemImpl = this.getCASImpl().getTypeSystemImpl();
        if (!typeSystemImpl.subsumes(feature.getDomain(), this.getType())) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feature, this.getType());
        }
        if (!typeSystemImpl.subsumes(feature.getRange(), typeSystemImpl.getType("uima.cas.Float"))) {
            FeatureStructureImpl.throwIllegalRangeExc(feature, typeSystemImpl.getType("uima.cas.Float"));
        }
        int n = ((FeatureImpl)feature).getCode();
        return this.getCASImpl().getFloatValue(this.getAddress(), n);
    }

    public String getStringValue(Feature feature) throws CASRuntimeException {
        int n = ((TypeImpl)this.getType()).getCode();
        int n2 = ((TypeImpl)feature.getDomain()).getCode();
        int n3 = ((TypeImpl)this.getCASImpl().getTypeSystem().getType("uima.cas.String")).getCode();
        int n4 = ((TypeImpl)feature.getRange()).getCode();
        TypeSystemImpl typeSystemImpl = (TypeSystemImpl)this.getCASImpl().getTypeSystem();
        if (!typeSystemImpl.subsumes(n2, n)) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feature, this.getType());
        }
        if (!typeSystemImpl.subsumes(n3, n4)) {
            FeatureStructureImpl.throwIllegalRangeExc(feature, this.getCASImpl().getTypeSystem().getType("uima.cas.String"));
        }
        return this.getCASImpl().getStringValue(this.getAddress(), ((FeatureImpl)feature).getCode());
    }

    public String getFeatureValueAsString(Feature feature) throws CASRuntimeException {
        Type type = feature.getRange();
        if (!type.isPrimitive()) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(2);
            cASRuntimeException.addArgument(feature.getName());
            cASRuntimeException.addArgument(feature.getName());
            cASRuntimeException.addArgument(type.getName());
            throw cASRuntimeException;
        }
        int n = ((TypeImpl)type).getCode();
        if (this.getCASImpl().isStringType(n)) {
            return this.getStringValue(feature);
        }
        if (this.getCASImpl().isIntType(n)) {
            int n2 = this.getIntValue(feature);
            return Integer.toString(n2);
        }
        if (this.getCASImpl().isFloatType(n)) {
            float f = this.getFloatValue(feature);
            return Float.toString(f);
        }
        CASRuntimeException cASRuntimeException = new CASRuntimeException(2);
        cASRuntimeException.addArgument(feature.getName());
        cASRuntimeException.addArgument(feature.getName());
        cASRuntimeException.addArgument(type.getName());
        throw cASRuntimeException;
    }

    private static final void throwIllegalRangeExc(Feature feature, Type type) throws CASRuntimeException {
        CASRuntimeException cASRuntimeException = new CASRuntimeException(4);
        cASRuntimeException.addArgument(feature.getName());
        cASRuntimeException.addArgument(type.getName());
        cASRuntimeException.addArgument(feature.getRange().getName());
        throw cASRuntimeException;
    }

    private static final void throwUndefinedFeatureExc(Feature feature, Type type) throws CASRuntimeException {
        CASRuntimeException cASRuntimeException = new CASRuntimeException(3);
        cASRuntimeException.addArgument(feature.getName());
        cASRuntimeException.addArgument(type.getName());
        throw cASRuntimeException;
    }

    private final void getPrintRefs(PrintReferences printReferences) {
        this.getPrintRefs(printReferences, this.getAddress());
    }

    private final void getPrintRefs(PrintReferences printReferences, int n) {
        boolean bl = printReferences.addReference(n);
        if (bl) {
            return;
        }
        LowLevelCAS lowLevelCAS = this.getCASImpl().getLowLevelCAS();
        LowLevelTypeSystem lowLevelTypeSystem = lowLevelCAS.ll_getTypeSystem();
        int n2 = lowLevelCAS.ll_getFSRefType(n, true);
        int[] nArray = lowLevelTypeSystem.ll_getAppropriateFeatures(n2);
        for (int i = 0; i < nArray.length; ++i) {
            int n3;
            if (!lowLevelCAS.ll_isRefType(lowLevelTypeSystem.ll_getRangeType(nArray[i])) || (n3 = lowLevelCAS.ll_getRefValue(n, nArray[i])) == 0) continue;
            this.getPrintRefs(printReferences, n3);
        }
    }

    public String toString() {
        return this.toString(3);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.prettyPrint(0, n, stringBuffer, true, null);
        return stringBuffer.toString();
    }

    public void prettyPrint(int n, int n2, StringBuffer stringBuffer, boolean bl) {
        this.prettyPrint(n, n2, stringBuffer, bl, null);
    }

    public void prettyPrint(int n, int n2, StringBuffer stringBuffer, boolean bl, String string) {
        PrintReferences printReferences = new PrintReferences();
        this.getPrintRefs(printReferences);
        this.prettyPrint(n, n2, stringBuffer, bl, string, printReferences);
    }

    public void prettyPrint(int n, int n2, StringBuffer stringBuffer, boolean bl, String string, PrintReferences printReferences) {
        Object object;
        n += n2;
        int n3 = printReferences.printInfo(this.getAddress());
        if (n3 != 0) {
            stringBuffer.append(printReferences.getLabel(this.getAddress()));
            if (n3 == 2) {
                stringBuffer.append('\n');
                return;
            }
            stringBuffer.append(' ');
        }
        if (bl) {
            stringBuffer.append(this.getType().getShortName());
        } else {
            stringBuffer.append(this.getType().getName());
        }
        if (string != null) {
            stringBuffer.append(" \"" + string + "\"");
        }
        stringBuffer.append("\n");
        LowLevelTypeSystem lowLevelTypeSystem = this.getCASImpl().ll_getTypeSystem();
        int n4 = this.getCASImpl().ll_getTypeClass(lowLevelTypeSystem.ll_getCodeForType(this.getType()));
        switch (n4) {
            case 6: {
                int n5;
                int n6 = this.getCASImpl().ll_getArraySize(this.getAddress());
                StringUtils.printSpaces(n, stringBuffer);
                stringBuffer.append("Array length: " + n6 + "\n");
                if (n6 <= 0) break;
                StringUtils.printSpaces(n, stringBuffer);
                stringBuffer.append("Array elements: [");
                for (n5 = 0; n5 < n6; ++n5) {
                    if (n5 > 0) {
                        stringBuffer.append(", ");
                    }
                    object = this.getCASImpl().ll_getStringArrayValue(this.getAddress(), n5);
                    stringBuffer.append("\"" + (String)object + "\"");
                }
                stringBuffer.append("]\n");
                break;
            }
            case 4: {
                int n5;
                int n6 = this.getCASImpl().ll_getArraySize(this.getAddress());
                StringUtils.printSpaces(n, stringBuffer);
                stringBuffer.append("Array length: " + n6 + "\n");
                if (n6 <= 0) break;
                StringUtils.printSpaces(n, stringBuffer);
                stringBuffer.append("Array elements: [");
                for (n5 = 0; n5 < n6; ++n5) {
                    if (n5 > 0) {
                        stringBuffer.append(", ");
                    }
                    int n7 = this.getCASImpl().ll_getIntArrayValue(this.getAddress(), n5);
                    stringBuffer.append(n7);
                }
                stringBuffer.append("]\n");
                break;
            }
            case 5: {
                int n5;
                int n6 = this.getCASImpl().ll_getArraySize(this.getAddress());
                StringUtils.printSpaces(n, stringBuffer);
                stringBuffer.append("Array length: " + n6 + "\n");
                if (n6 <= 0) break;
                StringUtils.printSpaces(n, stringBuffer);
                stringBuffer.append("Array elements: [");
                for (n5 = 0; n5 < n6; ++n5) {
                    if (n5 > 0) {
                        stringBuffer.append(", ");
                    }
                    float f = this.getCASImpl().ll_getFloatArrayValue(this.getAddress(), n5);
                    stringBuffer.append(f);
                }
                stringBuffer.append("]\n");
                break;
            }
        }
        List list = this.getType().getFeatures();
        for (int i = 0; i < list.size(); ++i) {
            StringUtils.printSpaces(n, stringBuffer);
            Feature feature = (Feature)list.get(i);
            stringBuffer.append(feature.getShortName() + ": ");
            object = feature.getRange();
            if (object.equals(this.getCASImpl().getTypeSystem().getType("uima.cas.Integer"))) {
                stringBuffer.append(this.getIntValue(feature) + "\n");
                continue;
            }
            if (object.equals(this.getCASImpl().getTypeSystem().getType("uima.cas.Float"))) {
                stringBuffer.append(this.getFloatValue(feature) + "\n");
                continue;
            }
            if (object.equals(this.getCASImpl().getTypeSystem().getType("uima.cas.String")) || this.getCAS().getTypeSystem().getParent((Type)object) != null && this.getCAS().getTypeSystem().getParent((Type)object).equals(this.getCASImpl().getTypeSystem().getType("uima.cas.String"))) {
                String string2 = this.getStringValue(feature);
                string2 = string2 == null ? "<null>" : "\"" + string2 + "\"";
                stringBuffer.append(string2 + "\n");
                continue;
            }
            FeatureStructureImpl featureStructureImpl = (FeatureStructureImpl)this.getFeatureValue(feature);
            if (featureStructureImpl == null) {
                stringBuffer.append("<null>\n");
                continue;
            }
            featureStructureImpl.prettyPrint(n, n2, stringBuffer, bl, null, printReferences);
        }
    }

    public Object clone() throws CASRuntimeException {
        Object object;
        if (this.getType().getName().equals("uima.cas.Sofa")) {
            object = new CASRuntimeException(2);
            ((CASRuntimeException)object).addArgument("SofaFS may not be cloned");
        }
        object = this.getCASImpl();
        FeatureStructure featureStructure = this.getCAS().createFS(this.getType());
        ((CASImpl)object).copyFeatures(((FeatureStructureImpl)featureStructure).getAddress(), this.getAddress());
        return featureStructure;
    }

    private static class PrintReferences {
        static final int NO_LABEL = 0;
        static final int WITH_LABEL = 1;
        static final int JUST_LABEL = 2;
        private static final String refNamePrefix = "#";
        private RedBlackTree tree = new RedBlackTree();
        private IntSet seen = new IntSet();
        private int count = 0;

        private PrintReferences() {
        }

        boolean addReference(int n) {
            if (this.tree.containsKey(n)) {
                String string = (String)this.tree.get(n);
                if (string == null) {
                    string = refNamePrefix + Integer.toString(this.count);
                    ++this.count;
                    this.tree.put(n, string);
                }
                return true;
            }
            this.tree.put(n, null);
            return false;
        }

        String getLabel(int n) {
            return (String)this.tree.get(n);
        }

        int printInfo(int n) {
            if (this.tree.get(n) == null) {
                return 0;
            }
            if (this.seen.contains(n)) {
                return 2;
            }
            this.seen.add(n);
            return 1;
        }

        int size() {
            return this.count;
        }
    }
}

