/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FSLeafIndexImpl;
import com.ibm.uima.cas.impl.FeatureStructureImpl;
import com.ibm.uima.cas.impl.LowLevelIndex;
import com.ibm.uima.cas.impl.LowLevelIterator;
import com.ibm.uima.util.ComparableIntPointerIterator;
import com.ibm.uima.util.IntComparator;
import com.ibm.uima.util.IntPointerIterator;
import com.ibm.uima.util.IntVector;
import java.util.NoSuchElementException;

public class FSVectorIndex
extends FSLeafIndexImpl {
    private IntVector index;
    private int initialSize;

    FSVectorIndex(CASImpl cASImpl, Type type, int n, int n2) {
        super(cASImpl, type, n2);
        this.initialSize = n;
        this.index = new IntVector(n);
    }

    IntVector getVector() {
        return this.index;
    }

    public void flush() {
        this.index = new IntVector(this.initialSize);
    }

    public final boolean insert(int n) {
        int[] nArray = this.index.getArray();
        int n2 = this.index.size();
        if (n2 == 0) {
            this.index.add(n);
            return true;
        }
        int n3 = nArray[n2 - 1];
        if (this.compare(n3, n) < 0) {
            this.index.add(n);
            return true;
        }
        int n4 = this.binarySearch(nArray, n, 0, n2);
        if (n4 >= 0) {
            return false;
        }
        this.index.add(-(n4 + 1), n);
        return true;
    }

    private final int find(int n) {
        return this.binarySearch(this.index.getArray(), n, 0, this.index.size());
    }

    private final int binarySearch(int[] nArray, int n, int n2, int n3) {
        --n3;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = this.compare(n, nArray[n4]);
            if (n5 == 0) {
                return n4;
            }
            if (n2 == n3) {
                if (n5 < 0) {
                    return -n4 - 1;
                }
                return -n4 - 2;
            }
            if (n5 < 0) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        return -n2 - 1;
    }

    public ComparableIntPointerIterator pointerIterator(IntComparator intComparator) {
        return new IntVectorIterator(intComparator);
    }

    protected IntPointerIterator refIterator() {
        return new IntVectorIterator();
    }

    protected IntPointerIterator refIterator(int n) {
        IntVectorIterator intVectorIterator = new IntVectorIterator();
        int n2 = this.find(n);
        if (n2 >= 0) {
            intVectorIterator.itPos = n2;
        } else {
            intVectorIterator.itPos = -(n2 + 1);
        }
        return intVectorIterator;
    }

    public boolean contains(FeatureStructure featureStructure) {
        return this.find(((FeatureStructureImpl)featureStructure).getAddress()) >= 0;
    }

    public FeatureStructure find(FeatureStructure featureStructure) {
        FeatureStructureImpl featureStructureImpl = (FeatureStructureImpl)featureStructure;
        int n = this.find(featureStructureImpl.getAddress());
        if (n > 0) {
            return featureStructureImpl.getCASImpl().createFS(n);
        }
        return null;
    }

    public int size() {
        return this.index.size();
    }

    public void deleteFS(FeatureStructure featureStructure) {
        int n = ((FeatureStructureImpl)featureStructure).getAddress();
        int n2 = this.index.indexOf(n);
        if (n2 >= 0) {
            this.index.remove(n2);
        }
    }

    public LowLevelIterator ll_iterator() {
        return new IntVectorIterator();
    }

    void remove(int n) {
        int n2 = this.index.indexOf(n);
        if (n2 >= 0) {
            this.index.remove(n2);
        }
    }

    private class IntVectorIterator
    implements ComparableIntPointerIterator,
    LowLevelIterator {
        private int itPos = 0;
        private IntComparator comp;

        private IntVectorIterator() {
        }

        private IntVectorIterator(IntComparator intComparator) {
            this();
            this.comp = intComparator;
        }

        public boolean isValid() {
            return this.itPos >= 0 && this.itPos < FSVectorIndex.this.index.size();
        }

        public void moveToFirst() {
            this.itPos = 0;
        }

        public void moveToLast() {
            this.itPos = FSVectorIndex.this.index.size() - 1;
        }

        public void moveToNext() {
            ++this.itPos;
        }

        public void moveToPrevious() {
            --this.itPos;
        }

        public int ll_get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return FSVectorIndex.this.index.get(this.itPos);
        }

        public Object copy() {
            IntVectorIterator intVectorIterator = new IntVectorIterator(this.comp);
            intVectorIterator.itPos = this.itPos;
            return intVectorIterator;
        }

        public int compareTo(Object object) throws NoSuchElementException {
            return this.comp.compare(this.get(), ((IntVectorIterator)object).get());
        }

        public void moveTo(int n) {
            int n2 = FSVectorIndex.this.find(n);
            this.itPos = n2 >= 0 ? n2 : -(n2 + 1);
        }

        public int get() throws NoSuchElementException {
            return this.ll_get();
        }

        public void inc() {
            this.moveToNext();
        }

        public void dec() {
            this.moveToPrevious();
        }

        public int ll_indexSize() {
            return FSVectorIndex.this.size();
        }

        public LowLevelIndex ll_getIndex() {
            return FSVectorIndex.this;
        }
    }
}

