/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.FSIndex;
import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.admin.FSIndexComparator;
import com.ibm.uima.cas.admin.LinearTypeOrder;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FSIndexComparatorImpl;
import com.ibm.uima.cas.impl.FSIndexImpl;
import com.ibm.uima.cas.impl.FSIteratorWrapper;
import com.ibm.uima.cas.impl.FeatureImpl;
import com.ibm.uima.cas.impl.FeatureStructureImpl;
import com.ibm.uima.cas.impl.LowLevelIterator;
import com.ibm.uima.util.ComparableIntPointerIterator;
import com.ibm.uima.util.IntComparator;
import com.ibm.uima.util.IntPointerIterator;

public abstract class FSLeafIndexImpl
implements IntComparator,
FSIndex,
FSIndexImpl {
    private final int indexType;
    protected CASImpl lowLevelCAS;
    private static final int STRING_CODE = 0;
    private static final int FLOAT_CODE = 1;
    private static final int INT_CODE = 2;
    private static final int TYPE_ORDER_CODE = 3;
    private FSIndexComparatorImpl comparator;
    private boolean isInitialized = false;
    private int[] keyType;
    private int[] keyOffset;
    private LinearTypeOrder[] typeOrder;
    private int[] keyComp;
    private int numKeys;
    private Type type;

    private FSLeafIndexImpl() {
        this.indexType = 0;
    }

    protected FSLeafIndexImpl(CASImpl cASImpl, Type type, int n) {
        this.indexType = n;
        this.lowLevelCAS = cASImpl;
        this.type = type;
    }

    abstract boolean insert(int var1);

    abstract void remove(int var1);

    public abstract ComparableIntPointerIterator pointerIterator(IntComparator var1);

    public FSIndexComparator getComparator() {
        return this.comparator;
    }

    IntComparator getIntComparator() {
        return this;
    }

    public int getIndexingStrategy() {
        return this.indexType;
    }

    boolean init(FSIndexComparator fSIndexComparator) {
        if (this.isInitialized) {
            return false;
        }
        FSIndexComparatorImpl fSIndexComparatorImpl = (FSIndexComparatorImpl)fSIndexComparator;
        this.comparator = fSIndexComparatorImpl.copy();
        if (!this.comparator.isValid()) {
            return false;
        }
        int n = this.comparator.getNumberOfKeys();
        this.keyType = new int[n];
        this.keyOffset = new int[n];
        this.keyComp = new int[n];
        this.typeOrder = new LinearTypeOrder[n];
        block4: for (int i = 0; i < n; ++i) {
            switch (fSIndexComparator.getKeyType(i)) {
                case 0: {
                    Feature feature = this.comparator.getKeyFeature(i);
                    this.keyType[i] = FSLeafIndexImpl.getKeyCode(feature);
                    this.keyOffset[i] = this.getFeatureOffset(feature);
                    this.keyComp[i] = this.comparator.getKeyComparator(i);
                    continue block4;
                }
                case 1: {
                    this.keyType[i] = 3;
                    this.keyComp[i] = this.comparator.getKeyComparator(i);
                    this.typeOrder[i] = this.comparator.getKeyTypeOrder(i);
                    this.keyOffset[i] = 0;
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Assertion failed.");
                }
            }
        }
        this.numKeys = n;
        this.isInitialized = true;
        return true;
    }

    private static final int getKeyCode(Feature feature) {
        String string = feature.getRange().getName();
        if (string.equals("uima.cas.String")) {
            return 0;
        }
        if (string.equals("uima.cas.Float")) {
            return 1;
        }
        return 2;
    }

    private final int getFeatureOffset(Feature feature) {
        return this.comparator.getLowLevelCAS().getFeatureOffset(((FeatureImpl)feature).getCode());
    }

    public int ll_compare(int n, int n2) {
        return this.compare(n, n2);
    }

    public int compare(int n, int n2) {
        int[] nArray = this.lowLevelCAS.getHeap().heap;
        block5: for (int i = 0; i < this.numKeys; ++i) {
            int n3 = nArray[n + this.keyOffset[i]];
            int n4 = nArray[n2 + this.keyOffset[i]];
            switch (this.keyType[i]) {
                case 0: {
                    String string = this.lowLevelCAS.getStringForCode(n3);
                    String string2 = this.lowLevelCAS.getStringForCode(n4);
                    int n5 = string == null ? (string2 == null ? 0 : -1) : (string2 == null ? 1 : string.compareTo(string2));
                    if (n5 == 0) continue block5;
                    if (this.keyComp[i] == 0) {
                        return n5;
                    }
                    return -n5;
                }
                case 1: {
                    float f = CASImpl.int2float(n3);
                    float f2 = CASImpl.int2float(n4);
                    if (f < f2) {
                        if (this.keyComp[i] == 0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (!(f > f2)) continue block5;
                    if (this.keyComp[i] == 0) {
                        return 1;
                    }
                    return -1;
                }
                case 3: {
                    if (n3 == n4) continue block5;
                    if (this.typeOrder[i].lessThan(n3, n4)) {
                        if (this.keyComp[i] == 0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (this.keyComp[i] == 0) {
                        return 1;
                    }
                    return -1;
                }
                default: {
                    if (n3 < n4) {
                        if (this.keyComp[i] == 0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (n3 <= n4) continue block5;
                    if (this.keyComp[i] == 0) {
                        return 1;
                    }
                    return -1;
                }
            }
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return this.comparator.equals(object);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public int compare(FeatureStructure featureStructure, FeatureStructure featureStructure2) {
        return this.compare(((FeatureStructureImpl)featureStructure).getAddress(), ((FeatureStructureImpl)featureStructure2).getAddress());
    }

    public Type getType() {
        return this.type;
    }

    protected abstract IntPointerIterator refIterator();

    public IntPointerIterator getIntIterator() {
        return this.refIterator();
    }

    protected abstract IntPointerIterator refIterator(int var1);

    public FSIterator iterator() {
        System.out.println(this.getClass().getName());
        return new FSIteratorWrapper(this.refIterator(), this.lowLevelCAS);
    }

    public FSIterator iterator(FeatureStructure featureStructure) {
        return new FSIteratorWrapper(this.refIterator(((FeatureStructureImpl)featureStructure).getAddress()), this.lowLevelCAS);
    }

    public abstract void deleteFS(FeatureStructure var1);

    public LowLevelIterator ll_iterator(boolean bl) {
        if (bl) {
            return this.ll_iterator();
        }
        return null;
    }
}

