/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.CASException;
import com.ibm.uima.cas.FSIndex;
import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.admin.CASAdminException;
import com.ibm.uima.cas.admin.FSIndexComparator;
import com.ibm.uima.cas.admin.FSIndexRepositoryMgr;
import com.ibm.uima.cas.admin.LinearTypeOrder;
import com.ibm.uima.cas.admin.LinearTypeOrderBuilder;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FSBagIndex;
import com.ibm.uima.cas.impl.FSIndexComparatorImpl;
import com.ibm.uima.cas.impl.FSIndexImpl;
import com.ibm.uima.cas.impl.FSIntArrayIndex;
import com.ibm.uima.cas.impl.FSIteratorWrapper;
import com.ibm.uima.cas.impl.FSLeafIndexImpl;
import com.ibm.uima.cas.impl.FSRBTSetIndex;
import com.ibm.uima.cas.impl.FeatureStructureImpl;
import com.ibm.uima.cas.impl.LLUnambiguousIteratorImpl;
import com.ibm.uima.cas.impl.LinearTypeOrderBuilderImpl;
import com.ibm.uima.cas.impl.LowLevelException;
import com.ibm.uima.cas.impl.LowLevelIndex;
import com.ibm.uima.cas.impl.LowLevelIndexRepository;
import com.ibm.uima.cas.impl.LowLevelIterator;
import com.ibm.uima.cas.impl.TypeImpl;
import com.ibm.uima.cas.impl.TypeSystemImpl;
import com.ibm.uima.util.ComparableIntPointerIterator;
import com.ibm.uima.util.IntComparator;
import com.ibm.uima.util.IntPointerIterator;
import com.ibm.uima.util.IntVector;
import com.ibm.uima.util.SortedIntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public class FSIndexRepositoryImpl
implements FSIndexRepositoryMgr,
LowLevelIndexRepository {
    public static final int DEFAULT_INDEX_SIZE = 100;
    private CASImpl cas;
    private TypeSystemImpl typeSystem;
    private boolean locked = false;
    private ArrayList[] indexArray;
    private HashMap name2indexMap;
    private LinearTypeOrderBuilder defaultOrderBuilder = null;
    private LinearTypeOrder defaultTypeOrder = null;
    private IntVector undefinedIndex;

    private FSIndexRepositoryImpl() {
    }

    FSIndexRepositoryImpl(CASImpl cASImpl) {
        this.cas = cASImpl;
        this.typeSystem = cASImpl.getTypeSystemImpl();
        this.name2indexMap = new HashMap();
        this.undefinedIndex = new IntVector();
        this.init();
    }

    FSIndexRepositoryImpl(CASImpl cASImpl, FSIndexRepositoryImpl fSIndexRepositoryImpl) {
        this.cas = cASImpl;
        this.typeSystem = cASImpl.getTypeSystemImpl();
        this.name2indexMap = new HashMap();
        this.undefinedIndex = new IntVector();
        this.init();
        Set set = fSIndexRepositoryImpl.name2indexMap.keySet();
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                IndexIteratorCachePair indexIteratorCachePair = (IndexIteratorCachePair)fSIndexRepositoryImpl.name2indexMap.get(string);
                this.createIndexNoQuestionsAsked(indexIteratorCachePair.index.getComparator(), string, indexIteratorCachePair.index.getIndexingStrategy());
            }
        }
        this.defaultOrderBuilder = fSIndexRepositoryImpl.defaultOrderBuilder;
        this.defaultTypeOrder = fSIndexRepositoryImpl.defaultTypeOrder;
    }

    private void init() {
        TypeSystemImpl typeSystemImpl = this.typeSystem;
        int n = typeSystemImpl.getNumberOfTypes() + 1;
        this.indexArray = new ArrayList[n];
        for (int i = 1; i < n; ++i) {
            this.indexArray[i] = new ArrayList();
        }
    }

    public void flush() {
        if (!this.locked) {
            return;
        }
        this.undefinedIndex.removeAllElements();
        for (int i = 1; i < this.indexArray.length; ++i) {
            ArrayList arrayList = this.indexArray[i];
            int n = arrayList.size();
            for (int j = 0; j < n; ++j) {
                ((IndexIteratorCachePair)arrayList.get(j)).index.flush();
            }
        }
    }

    public void addFS(int n) {
        this.ll_addFS(n);
    }

    private IndexIteratorCachePair addNewIndex(FSIndexComparator fSIndexComparator, int n) {
        return this.addNewIndex(fSIndexComparator, 100, n);
    }

    private IndexIteratorCachePair addNewIndex(FSIndexComparator fSIndexComparator, int n, int n2) {
        FSLeafIndexImpl fSLeafIndexImpl;
        Type type = fSIndexComparator.getType();
        int n3 = ((TypeImpl)type).getCode();
        if (n3 >= this.indexArray.length) {
            // empty if block
        }
        ArrayList arrayList = this.indexArray[n3];
        switch (n2) {
            case 1: {
                fSLeafIndexImpl = new FSRBTSetIndex(this.cas, type, n2);
                break;
            }
            case 2: {
                fSLeafIndexImpl = new FSBagIndex(this.cas, type, n, n2);
                break;
            }
            default: {
                fSLeafIndexImpl = new FSIntArrayIndex(this.cas, type, n, 0);
            }
        }
        fSLeafIndexImpl.init(fSIndexComparator);
        IndexIteratorCachePair indexIteratorCachePair = new IndexIteratorCachePair();
        indexIteratorCachePair.index = fSLeafIndexImpl;
        arrayList.add(indexIteratorCachePair);
        return indexIteratorCachePair;
    }

    private IndexIteratorCachePair addNewIndexRecursive(FSIndexComparator fSIndexComparator, int n) {
        FSIndexComparatorImpl fSIndexComparatorImpl = ((FSIndexComparatorImpl)fSIndexComparator).copy();
        return this.addNewIndexRec(fSIndexComparatorImpl, n);
    }

    private static final int findIndex(ArrayList arrayList, FSIndexComparator fSIndexComparator) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            FSIndexComparator fSIndexComparator2 = ((IndexIteratorCachePair)arrayList.get(i)).index.getComparator();
            if (!((Object)fSIndexComparator).equals(fSIndexComparator2)) continue;
            return i;
        }
        return -1;
    }

    private IndexIteratorCachePair addNewIndexRec(FSIndexComparator fSIndexComparator, int n) {
        IndexIteratorCachePair indexIteratorCachePair = this.addNewIndex(fSIndexComparator, n);
        Type type = fSIndexComparator.getType();
        Vector vector = this.typeSystem.getDirectlySubsumedTypes(type);
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            FSIndexComparatorImpl fSIndexComparatorImpl = ((FSIndexComparatorImpl)fSIndexComparator).copy();
            fSIndexComparatorImpl.setType((Type)vector.get(i));
            this.addNewIndexRec(fSIndexComparatorImpl, n);
        }
        return indexIteratorCachePair;
    }

    private static final ArrayList getAllSubsumedTypes(Type type, TypeSystem typeSystem) {
        ArrayList arrayList = new ArrayList();
        FSIndexRepositoryImpl.addAllSubsumedTypes(type, typeSystem, arrayList);
        return arrayList;
    }

    private static final void addAllSubsumedTypes(Type type, TypeSystem typeSystem, ArrayList arrayList) {
        arrayList.add(type);
        List list = typeSystem.getDirectSubtypes(type);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            FSIndexRepositoryImpl.addAllSubsumedTypes((Type)list.get(i), typeSystem, arrayList);
        }
    }

    public void commit() {
        this.getDefaultTypeOrder();
        this.locked = true;
    }

    public LinearTypeOrder getDefaultTypeOrder() {
        if (this.defaultTypeOrder == null) {
            if (this.defaultOrderBuilder == null) {
                this.defaultOrderBuilder = new LinearTypeOrderBuilderImpl(this.typeSystem);
            }
            try {
                this.defaultTypeOrder = this.defaultOrderBuilder.getOrder();
            }
            catch (CASException cASException) {
                // empty catch block
            }
        }
        return this.defaultTypeOrder;
    }

    public LinearTypeOrderBuilder getDefaultOrderBuilder() {
        if (this.defaultOrderBuilder == null) {
            this.defaultOrderBuilder = new LinearTypeOrderBuilderImpl(this.typeSystem);
        }
        return this.defaultOrderBuilder;
    }

    void setDefaultTypeOrder(LinearTypeOrder linearTypeOrder) {
        this.defaultTypeOrder = linearTypeOrder;
    }

    public boolean createIndex(FSIndexComparator fSIndexComparator, String string, int n) throws CASAdminException {
        if (this.locked) {
            throw new CASAdminException(0);
        }
        return this.createIndexNoQuestionsAsked(fSIndexComparator, string, n);
    }

    public boolean createIndexNoQuestionsAsked(FSIndexComparator fSIndexComparator, String string, int n) {
        IndexIteratorCachePair indexIteratorCachePair = (IndexIteratorCachePair)this.name2indexMap.get(string);
        if (indexIteratorCachePair == null) {
            indexIteratorCachePair = this.addNewIndexRecursive(fSIndexComparator, n);
            this.name2indexMap.put(string, indexIteratorCachePair);
            return true;
        }
        return false;
    }

    public Iterator getIndexes() {
        ArrayList<FSIndex> arrayList = new ArrayList<FSIndex>();
        Iterator iterator = this.getLabels();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            arrayList.add(this.getIndex(string));
        }
        return arrayList.iterator();
    }

    public Iterator getLabels() {
        return this.name2indexMap.keySet().iterator();
    }

    public Iterator getLabels(FSIndexComparator fSIndexComparator) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getLabels();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!((Object)((IndexIteratorCachePair)this.name2indexMap.get(string)).index.getComparator()).equals(fSIndexComparator)) continue;
            arrayList.add(string);
        }
        return arrayList.iterator();
    }

    public FSIndex getIndex(String string, Type type) {
        Type type2;
        IndexIteratorCachePair indexIteratorCachePair = (IndexIteratorCachePair)this.name2indexMap.get(string);
        if (indexIteratorCachePair == null) {
            return null;
        }
        if (type.isArray() && (type2 = type.getComponentType()) != null && !type2.isPrimitive() && !type2.getName().equals("uima.cas.TOP")) {
            return null;
        }
        type2 = indexIteratorCachePair.index.getType();
        if (!this.typeSystem.subsumes(type2, type)) {
            return null;
        }
        int n = ((TypeImpl)type).getCode();
        ArrayList arrayList = this.indexArray[n];
        int n2 = FSIndexRepositoryImpl.findIndex(arrayList, indexIteratorCachePair.index.getComparator());
        return new IndexImpl((IndexIteratorCachePair)arrayList.get(n2));
    }

    public FSIndex getIndex(String string) {
        IndexIteratorCachePair indexIteratorCachePair = (IndexIteratorCachePair)this.name2indexMap.get(string);
        if (indexIteratorCachePair == null) {
            return null;
        }
        return new IndexImpl(indexIteratorCachePair);
    }

    public IntPointerIterator getIntIteratorForIndex(String string) {
        IndexImpl indexImpl = (IndexImpl)this.getIndex(string);
        if (indexImpl == null) {
            return null;
        }
        return new PointerIterator(indexImpl.iicp);
    }

    public IntPointerIterator getIntIteratorForIndex(String string, Type type) {
        IndexImpl indexImpl = (IndexImpl)this.getIndex(string, type);
        if (indexImpl == null) {
            return null;
        }
        return new PointerIterator(indexImpl.iicp);
    }

    public int getIndexSize(Type type) {
        int n = ((TypeImpl)type).getCode();
        ArrayList arrayList = this.indexArray[n];
        if (arrayList.size() == 0) {
            return 0;
        }
        int n2 = ((IndexIteratorCachePair)arrayList.get(0)).index.size();
        Vector vector = this.typeSystem.getDirectlySubsumedTypes(type);
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            n2 += this.getIndexSize((Type)vector.get(i));
        }
        return n2;
    }

    public FSIndexComparator createComparator() {
        return new FSIndexComparatorImpl(this.cas);
    }

    public boolean isCommitted() {
        return this.locked;
    }

    public boolean createIndex(FSIndexComparator fSIndexComparator, String string) throws CASAdminException {
        return this.createIndex(fSIndexComparator, string, 0);
    }

    public int[] getIndexedFSs() {
        int n;
        IntVector intVector = new IntVector();
        for (int i = 0; i < this.indexArray.length; ++i) {
            ArrayList arrayList = this.indexArray[i];
            if (arrayList == null) continue;
            int n2 = arrayList.size();
            ArrayList<IndexIteratorCachePair> arrayList2 = new ArrayList<IndexIteratorCachePair>();
            for (n = 0; n < n2; ++n) {
                IndexIteratorCachePair indexIteratorCachePair = (IndexIteratorCachePair)arrayList.get(n);
                int n3 = indexIteratorCachePair.index.getIndexingStrategy();
                if (n3 != 1) {
                    if (arrayList2.size() > 0) {
                        arrayList2 = new ArrayList();
                    }
                    arrayList2.add(indexIteratorCachePair);
                    break;
                }
                arrayList2.add(indexIteratorCachePair);
            }
            if (arrayList2.size() <= 0) continue;
            SortedIntSet sortedIntSet = new SortedIntSet();
            for (n = 0; n < arrayList2.size(); ++n) {
                IntPointerIterator intPointerIterator = ((IndexIteratorCachePair)arrayList2.get(n)).index.refIterator();
                while (intPointerIterator.isValid()) {
                    sortedIntSet.add(intPointerIterator.get());
                    intPointerIterator.inc();
                }
            }
            for (n = 0; n < sortedIntSet.size(); ++n) {
                intVector.add(sortedIntSet.get(n));
            }
        }
        if (this.undefinedIndex.size() > 0) {
            int[] nArray = this.undefinedIndex.toArray();
            for (n = 0; n < nArray.length; ++n) {
                intVector.add(nArray[n]);
            }
        }
        return intVector.toArray();
    }

    public void addFS(FeatureStructure featureStructure) {
        this.addFS(((FeatureStructureImpl)featureStructure).getAddress());
    }

    public void removeFS(FeatureStructure featureStructure) {
        int n = this.cas.ll_getFSRefType(this.cas.ll_getFSRef(featureStructure));
        ArrayList arrayList = this.indexArray[n];
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            ((IndexIteratorCachePair)arrayList.get(i)).index.deleteFS(featureStructure);
        }
    }

    public LinearTypeOrderBuilder createTypeSortOrder() {
        LinearTypeOrderBuilderImpl linearTypeOrderBuilderImpl = new LinearTypeOrderBuilderImpl(this.typeSystem);
        if (this.defaultOrderBuilder == null) {
            this.defaultOrderBuilder = linearTypeOrderBuilderImpl;
        }
        return linearTypeOrderBuilderImpl;
    }

    public LowLevelIndex ll_getIndex(String string) {
        return (LowLevelIndex)((Object)this.getIndex(string));
    }

    public LowLevelIndex ll_getIndex(String string, int n) {
        if (!this.typeSystem.isType(n) || !this.cas.isFSRefType(n)) {
            LowLevelException lowLevelException = new LowLevelException(9);
            lowLevelException.addArgument(Integer.toString(n));
            throw lowLevelException;
        }
        return (LowLevelIndex)((Object)this.getIndex(string, this.typeSystem.ll_getTypeForCode(n)));
    }

    public final void ll_addFS(int n, boolean bl) {
        if (bl) {
            this.cas.checkFsRef(n);
            this.cas.isFSRefType(this.cas.ll_getFSRefType(n));
        }
        this.ll_addFS(n);
    }

    public void ll_addFS(int n) {
        int n2 = this.cas.getHeapValue(n);
        ArrayList arrayList = this.indexArray[n2];
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            ((IndexIteratorCachePair)arrayList.get(i)).index.insert(n);
        }
        if (n3 == 0) {
            this.undefinedIndex.add(n);
        }
    }

    public void ll_removeFS(int n) {
        int n2 = this.cas.ll_getFSRefType(n);
        ArrayList arrayList = this.indexArray[n2];
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            ((IndexIteratorCachePair)arrayList.get(i)).index.remove(n);
        }
    }

    private class IndexImpl
    implements FSIndex,
    FSIndexImpl {
        private IndexIteratorCachePair iicp;

        private IndexImpl(IndexIteratorCachePair indexIteratorCachePair) {
            this.iicp = indexIteratorCachePair;
        }

        public int ll_compare(int n, int n2) {
            return this.iicp.index.ll_compare(n, n2);
        }

        public int getIndexingStrategy() {
            return this.iicp.index.getIndexingStrategy();
        }

        public FSIndexComparator getComparator() {
            return this.iicp.index.getComparator();
        }

        protected IntComparator getIntComparator() {
            return this.iicp.index.getIntComparator();
        }

        public void flush() {
            this.iicp.index.flush();
        }

        public int compare(FeatureStructure featureStructure, FeatureStructure featureStructure2) {
            return this.iicp.index.compare(featureStructure, featureStructure2);
        }

        public boolean contains(FeatureStructure featureStructure) {
            return this.iicp.index.contains(featureStructure);
        }

        public FeatureStructure find(FeatureStructure featureStructure) {
            return this.iicp.index.find(featureStructure);
        }

        public Type getType() {
            return this.iicp.index.getType();
        }

        public FSIterator iterator() {
            return new FSIteratorWrapper(new PointerIterator(this.iicp), FSIndexRepositoryImpl.this.cas);
        }

        public FSIterator iterator(FeatureStructure featureStructure) {
            return new FSIteratorWrapper(new PointerIterator(this.iicp, ((FeatureStructureImpl)featureStructure).getAddress()), FSIndexRepositoryImpl.this.cas);
        }

        public IntPointerIterator getIntIterator() {
            return new PointerIterator(this.iicp);
        }

        public int size() {
            this.iicp.createIndexIteratorCache();
            int n = 0;
            ArrayList arrayList = this.iicp.iteratorCache;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                n += ((FSIndex)arrayList.get(i)).size();
            }
            return n;
        }

        public LowLevelIterator ll_iterator() {
            return new PointerIterator(this.iicp);
        }

        public LowLevelIterator ll_iterator(boolean bl) {
            if (bl) {
                return this.ll_iterator();
            }
            return new LLUnambiguousIteratorImpl(this.ll_iterator(), ((IndexIteratorCachePair)this.iicp).index.lowLevelCAS);
        }
    }

    private class PointerIterator
    implements IntPointerIterator,
    LowLevelIterator {
        private IndexIteratorCachePair iicp;
        private ComparableIntPointerIterator[] indexes;
        private int indexesSize;
        private int numIndexes;
        private int currentIndex;
        private boolean wentForward;
        private IntComparator iteratorComparator;

        private PointerIterator() {
        }

        private PointerIterator(IndexIteratorCachePair indexIteratorCachePair) {
            this.iicp = indexIteratorCachePair;
            indexIteratorCachePair.createIndexIteratorCache();
            ArrayList arrayList = indexIteratorCachePair.iteratorCache;
            this.indexesSize = arrayList.size();
            this.indexes = new ComparableIntPointerIterator[this.indexesSize];
            this.numIndexes = this.indexesSize;
            this.iteratorComparator = new IteratorComparator((FSLeafIndexImpl)arrayList.get(0));
            for (int i = 0; i < this.indexesSize; ++i) {
                ComparableIntPointerIterator comparableIntPointerIterator;
                this.indexes[i] = comparableIntPointerIterator = ((FSLeafIndexImpl)arrayList.get(i)).pointerIterator(this.iteratorComparator);
            }
            this.moveToFirst();
        }

        private PointerIterator(IndexIteratorCachePair indexIteratorCachePair, int n) {
            indexIteratorCachePair.createIndexIteratorCache();
            ArrayList arrayList = indexIteratorCachePair.iteratorCache;
            this.indexesSize = arrayList.size();
            this.indexes = new ComparableIntPointerIterator[this.indexesSize];
            this.numIndexes = this.indexesSize;
            this.iteratorComparator = new IteratorComparator((FSLeafIndexImpl)arrayList.get(0));
            for (int i = 0; i < this.indexesSize; ++i) {
                ComparableIntPointerIterator comparableIntPointerIterator;
                this.indexes[i] = comparableIntPointerIterator = ((FSLeafIndexImpl)arrayList.get(i)).pointerIterator(this.iteratorComparator);
            }
            this.moveTo(n);
        }

        public boolean isValid() {
            return this.numIndexes > 0;
        }

        public void moveToFirst() {
            for (int i = 0; i < this.indexes.length; ++i) {
                this.indexes[i].moveToFirst();
            }
            this.numIndexes = this.indexes.length;
            this.checkIndexesTo(this.numIndexes);
            Arrays.sort(this.indexes, 0, this.numIndexes);
            this.wentForward = true;
        }

        public void moveToLast() {
            for (int i = 0; i < this.indexes.length; ++i) {
                this.indexes[i].moveToLast();
            }
            this.numIndexes = this.indexes.length;
            this.checkIndexesTo(this.numIndexes);
            Arrays.sort(this.indexes, 0, this.numIndexes);
            this.currentIndex = this.numIndexes - 1;
            this.wentForward = false;
        }

        public void moveToNext() {
            if (!this.isValid()) {
                return;
            }
            boolean bl = this.wentForward;
            this.incrementIterators();
            if (!this.isValid()) {
                return;
            }
            if (bl) {
                this.insert(0, this.indexes, this.numIndexes);
            } else {
                Arrays.sort(this.indexes, 0, this.numIndexes);
            }
            this.currentIndex = 0;
        }

        private final void insert(int n, Comparable[] comparableArray, int n2) {
            int n3 = n2 - 1;
            while (n < n3) {
                int n4 = n + 1;
                int n5 = comparableArray[n].compareTo(comparableArray[n4]);
                if (n5 <= 0) {
                    return;
                }
                Comparable comparable = comparableArray[n];
                comparableArray[n] = comparableArray[n4];
                comparableArray[n4] = comparable;
                ++n;
            }
        }

        private void ensureIndexValidity(int n) {
            if (!this.indexes[n].isValid()) {
                if (n + 1 == this.numIndexes) {
                    --this.numIndexes;
                } else {
                    --this.numIndexes;
                    ComparableIntPointerIterator comparableIntPointerIterator = this.indexes[n];
                    this.indexes[n] = this.indexes[this.numIndexes];
                    this.indexes[this.numIndexes] = comparableIntPointerIterator;
                }
            }
        }

        private void checkIndexesTo(int n) {
            for (int i = n - 1; i >= 0; --i) {
                this.ensureIndexValidity(i);
            }
        }

        private void incrementIterators() {
            if (this.wentForward) {
                this.indexes[this.currentIndex].inc();
                this.ensureIndexValidity(this.currentIndex);
            } else {
                for (int i = 0; i < this.indexesSize; ++i) {
                    if (i == this.currentIndex) continue;
                    ComparableIntPointerIterator comparableIntPointerIterator = this.indexes[i];
                    if (!comparableIntPointerIterator.isValid()) {
                        comparableIntPointerIterator.moveToFirst();
                    }
                    while (comparableIntPointerIterator.isValid() && this.iteratorComparator.compare(comparableIntPointerIterator.get(), this.indexes[this.currentIndex].get()) < 0) {
                        comparableIntPointerIterator.inc();
                    }
                }
                this.indexes[this.currentIndex].inc();
                this.numIndexes = this.indexesSize;
                this.checkIndexesTo(this.numIndexes);
            }
            this.wentForward = true;
        }

        public void moveToPrevious() {
            if (!this.isValid()) {
                return;
            }
            this.decrementIterators();
            if (!this.isValid()) {
                return;
            }
            Arrays.sort(this.indexes, 0, this.numIndexes);
            this.currentIndex = this.numIndexes - 1;
        }

        private void decrementIterators() {
            if (!this.wentForward) {
                this.indexes[this.currentIndex].dec();
                this.ensureIndexValidity(this.currentIndex);
            } else {
                for (int i = 0; i < this.indexesSize; ++i) {
                    if (i == this.currentIndex) continue;
                    ComparableIntPointerIterator comparableIntPointerIterator = this.indexes[i];
                    if (!comparableIntPointerIterator.isValid()) {
                        comparableIntPointerIterator.moveToLast();
                    }
                    while (comparableIntPointerIterator.isValid() && this.iteratorComparator.compare(comparableIntPointerIterator.get(), this.indexes[this.currentIndex].get()) > 0) {
                        comparableIntPointerIterator.dec();
                    }
                }
                this.indexes[this.currentIndex].dec();
                this.numIndexes = this.indexesSize;
                this.checkIndexesTo(this.numIndexes);
            }
            this.wentForward = false;
        }

        public int get() throws NoSuchElementException {
            return this.ll_get();
        }

        public int ll_get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return this.indexes[this.currentIndex].get();
        }

        public Object copy() {
            return new PointerIterator(this.iicp, this.get());
        }

        public void moveTo(int n) {
            this.numIndexes = this.indexes.length;
            for (int i = 0; i < this.numIndexes; ++i) {
                this.indexes[i].moveTo(n);
            }
            this.checkIndexesTo(this.numIndexes);
            if (this.numIndexes > 1) {
                Arrays.sort(this.indexes, 0, this.numIndexes);
            }
            this.wentForward = true;
            this.currentIndex = 0;
        }

        public void inc() {
            this.moveToNext();
        }

        public void dec() {
            this.moveToPrevious();
        }

        public int ll_indexSize() {
            return this.iicp.size();
        }

        public LowLevelIndex ll_getIndex() {
            return this.iicp.index;
        }
    }

    private static class IteratorComparator
    implements IntComparator {
        private final IntComparator comp;

        private IteratorComparator(IntComparator intComparator) {
            this.comp = intComparator;
        }

        public int compare(int n, int n2) {
            int n3 = this.comp.compare(n, n2);
            if (n3 == 0) {
                if (n < n2) {
                    return -1;
                }
                if (n > n2) {
                    return 1;
                }
            }
            return n3;
        }
    }

    private class IndexIteratorCachePair
    implements Comparable {
        private FSLeafIndexImpl index = null;
        private ArrayList iteratorCache = null;

        private IndexIteratorCachePair() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof IndexIteratorCachePair)) {
                return false;
            }
            IndexIteratorCachePair indexIteratorCachePair = (IndexIteratorCachePair)object;
            return ((Object)this.index.getComparator()).equals(indexIteratorCachePair.index.getComparator()) && this.index.getIndexingStrategy() == indexIteratorCachePair.index.getIndexingStrategy();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        private void createIndexIteratorCache() {
            if (this.iteratorCache != null) {
                return;
            }
            this.iteratorCache = new ArrayList();
            Type type = this.index.getComparator().getType();
            ArrayList arrayList = FSIndexRepositoryImpl.getAllSubsumedTypes(type, FSIndexRepositoryImpl.this.typeSystem);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                int n2 = ((TypeImpl)arrayList.get(i)).getCode();
                ArrayList arrayList2 = FSIndexRepositoryImpl.this.indexArray[n2];
                int n3 = arrayList2.indexOf(this);
                if (n3 < 0) continue;
                this.iteratorCache.add(((IndexIteratorCachePair)arrayList2.get((int)n3)).index);
            }
        }

        public int compareTo(Object object) {
            int n;
            IndexIteratorCachePair indexIteratorCachePair = (IndexIteratorCachePair)object;
            int n2 = ((TypeImpl)this.index.getType()).getCode();
            if (n2 < (n = ((TypeImpl)indexIteratorCachePair.index.getType()).getCode())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return this.index.getComparator().compareTo(indexIteratorCachePair.index.getComparator());
        }

        int size() {
            int n = 0;
            for (int i = 0; i < this.iteratorCache.size(); ++i) {
                n += ((LowLevelIndex)this.iteratorCache.get(i)).size();
            }
            return n;
        }
    }
}

