/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.admin.FSIndexComparator;
import com.ibm.uima.cas.admin.LinearTypeOrder;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FeatureImpl;
import com.ibm.uima.util.IntVector;
import java.util.Vector;

public class FSIndexComparatorImpl
implements FSIndexComparator {
    private Type type;
    private Vector keyVector;
    private IntVector compVector;
    private IntVector keyTypeVector;
    private TypeSystem ts;
    private CASImpl cas;

    private FSIndexComparatorImpl() {
    }

    public FSIndexComparatorImpl(CASImpl cASImpl) {
        this.keyVector = new Vector();
        this.compVector = new IntVector();
        this.keyTypeVector = new IntVector();
        this.type = null;
        this.ts = cASImpl.getTypeSystem();
        this.cas = cASImpl;
    }

    private boolean checkType(Type type) {
        return this.cas.isIntType(type) || this.cas.isFloatType(type) || this.cas.isStringType(type);
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public int addKey(Feature feature, int n) {
        if (!this.checkType(feature.getRange())) {
            return -1;
        }
        int n2 = this.keyVector.size();
        this.keyVector.add(feature);
        this.compVector.add(n);
        this.keyTypeVector.add(0);
        return n2;
    }

    public int addKey(LinearTypeOrder linearTypeOrder, int n) {
        int n2 = this.keyVector.size();
        this.compVector.add(n);
        this.keyVector.add(linearTypeOrder);
        this.keyTypeVector.add(1);
        return n2;
    }

    public int getKeyType(int n) {
        return this.keyTypeVector.get(n);
    }

    public int getNumberOfKeys() {
        return this.keyVector.size();
    }

    public Feature getKeyFeature(int n) {
        if (this.keyTypeVector.get(n) == 0) {
            return (Feature)this.keyVector.get(n);
        }
        return null;
    }

    public LinearTypeOrder getKeyTypeOrder(int n) {
        if (this.keyTypeVector.get(n) == 1) {
            return (LinearTypeOrder)this.keyVector.get(n);
        }
        return null;
    }

    public int getKeyComparator(int n) {
        return this.compVector.get(n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FSIndexComparator)) {
            return false;
        }
        FSIndexComparator fSIndexComparator = (FSIndexComparator)object;
        int n = this.getNumberOfKeys();
        if (n != fSIndexComparator.getNumberOfKeys()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.getKeyFeature(i) == fSIndexComparator.getKeyFeature(i) && this.getKeyComparator(i) == fSIndexComparator.getKeyComparator(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    CASImpl getLowLevelCAS() {
        return this.cas;
    }

    public boolean isValid() {
        if (this.type == null) {
            return false;
        }
        int n = this.getNumberOfKeys();
        for (int i = 0; i < n; ++i) {
            Feature feature;
            if (this.keyTypeVector.get(i) != 0 || this.ts.subsumes((feature = (Feature)this.keyVector.get(i)).getDomain(), this.type)) continue;
            return false;
        }
        return true;
    }

    synchronized FSIndexComparatorImpl copy() {
        FSIndexComparatorImpl fSIndexComparatorImpl = new FSIndexComparatorImpl(this.cas);
        fSIndexComparatorImpl.type = this.type;
        int n = this.getNumberOfKeys();
        for (int i = 0; i < n; ++i) {
            fSIndexComparatorImpl.keyVector.add(this.keyVector.get(i));
            fSIndexComparatorImpl.compVector.add(this.compVector.get(i));
            fSIndexComparatorImpl.keyTypeVector.add(this.keyTypeVector.get(i));
        }
        return fSIndexComparatorImpl;
    }

    public int compareTo(Object object) {
        FSIndexComparator fSIndexComparator = (FSIndexComparator)object;
        int n = this.getNumberOfKeys();
        int n2 = fSIndexComparator.getNumberOfKeys();
        int n3 = 0;
        while (n3 < n && n3 < n2) {
            int n4;
            int n5 = ((FeatureImpl)this.getKeyFeature(n3)).getCode();
            if (n5 < (n4 = ((FeatureImpl)fSIndexComparator.getKeyFeature(n3)).getCode())) {
                return -1;
            }
            if (n5 > n4) {
                return 1;
            }
            if (this.getKeyComparator(n3) < fSIndexComparator.getKeyComparator(n3)) {
                return -1;
            }
            if (this.getKeyComparator(n3) <= fSIndexComparator.getKeyComparator(n3)) continue;
            return 1;
        }
        if (n3 < n) {
            return 1;
        }
        if (n3 < n2) {
            return -1;
        }
        return 0;
    }
}

