/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.FSFloatConstraint;
import com.ibm.uima.util.IntVector;
import java.util.Vector;

class FSFloatConstraintImpl
implements FSFloatConstraint {
    private static final int LT = 0;
    private static final int LEQ = 1;
    private static final int EQ = 2;
    private static final int GEQ = 3;
    private static final int GT = 4;
    private IntVector codes = new IntVector();
    private Vector values = new Vector();

    FSFloatConstraintImpl() {
    }

    public boolean match(float f) {
        int n = this.codes.size();
        block7: for (int i = 0; i < n; ++i) {
            switch (this.codes.get(i)) {
                case 0: {
                    if (!(f >= ((Float)this.values.get(i)).floatValue())) continue block7;
                    return false;
                }
                case 1: {
                    if (!(f > ((Float)this.values.get(i)).floatValue())) continue block7;
                    return false;
                }
                case 2: {
                    if (f == ((Float)this.values.get(i)).floatValue()) continue block7;
                    return false;
                }
                case 3: {
                    if (!(f < ((Float)this.values.get(i)).floatValue())) continue block7;
                    return false;
                }
                case 4: {
                    if (!(f <= ((Float)this.values.get(i)).floatValue())) continue block7;
                    return false;
                }
                default: {
                    throw new Error("Internal error.");
                }
            }
        }
        return true;
    }

    public void eq(float f) {
        this.codes.add(2);
        this.values.add(new Float(f));
    }

    public void lt(float f) {
        this.codes.add(0);
        this.values.add(new Float(f));
    }

    public void leq(float f) {
        this.codes.add(1);
        this.values.add(new Float(f));
    }

    public void gt(float f) {
        this.codes.add(4);
        this.values.add(new Float(f));
    }

    public void geq(float f) {
        this.codes.add(3);
        this.values.add(new Float(f));
    }

    public String toString() {
        if (this.codes.size() == 1) {
            return FSFloatConstraintImpl.toString(this.codes.get(0)) + " " + ((Float)this.values.get(0)).toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("( ");
        for (int i = 0; i < this.codes.size(); ++i) {
            stringBuffer.append(FSFloatConstraintImpl.toString(this.codes.get(i)));
            stringBuffer.append(" ");
            stringBuffer.append(((Float)this.values.get(i)).toString());
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static final String toString(int n) {
        switch (n) {
            case 1: {
                return "<=";
            }
            case 0: {
                return "<";
            }
            case 2: {
                return "=";
            }
            case 3: {
                return ">=";
            }
            case 4: {
                return ">";
            }
        }
        return "";
    }
}

