/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FSGenerator;
import com.ibm.uima.cas.impl.FeatureStructureImplC;
import com.ibm.uima.cas.impl.TypeImpl;
import com.ibm.uima.cas.impl.TypeSystemImpl;
import java.util.Arrays;
import java.util.Iterator;

public class FSClassRegistry {
    private final boolean useFSCache;
    private TypeSystemImpl ts;
    private final FSGenerator[] generators;
    private FeatureStructure[] fsArray;
    private static final int initialArraySize = 1000;

    FSClassRegistry(TypeSystemImpl typeSystemImpl, boolean bl) {
        this.useFSCache = bl;
        this.ts = typeSystemImpl;
        this.generators = new FSGenerator[typeSystemImpl.getTypeArraySize()];
        DefaultFSGenerator defaultFSGenerator = new DefaultFSGenerator();
        for (int i = typeSystemImpl.getSmallestType(); i < this.generators.length; ++i) {
            this.generators[i] = defaultFSGenerator;
        }
        if (bl) {
            this.fsArray = new FeatureStructure[1000];
        }
    }

    void addClassForType(Type type, FSGenerator fSGenerator) {
        Iterator iterator = this.ts.getTypeIterator();
        while (iterator.hasNext()) {
            TypeImpl typeImpl = (TypeImpl)iterator.next();
            if (!this.ts.subsumes(type, typeImpl)) continue;
            this.generators[typeImpl.getCode()] = fSGenerator;
        }
    }

    public void addGeneratorForType(TypeImpl typeImpl, FSGenerator fSGenerator) {
        this.generators[typeImpl.getCode()] = fSGenerator;
    }

    public void copyGeneratorForType(TypeImpl typeImpl, TypeImpl typeImpl2) {
        this.generators[typeImpl.getCode()] = this.generators[typeImpl2.getCode()];
    }

    void flush() {
        if (this.fsArray != null) {
            Arrays.fill(this.fsArray, null);
        }
    }

    FeatureStructure createFS(int n, CASImpl cASImpl) {
        if (n == 0) {
            return null;
        }
        FeatureStructure featureStructure = null;
        if (this.useFSCache) {
            try {
                featureStructure = this.fsArray[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (featureStructure == null) {
                featureStructure = this.generators[cASImpl.heap.heap[n]].createFS(n, cASImpl);
                if (n >= this.fsArray.length) {
                    int n2;
                    for (n2 = this.fsArray.length * 2; n2 <= n; n2 *= 2) {
                    }
                    FeatureStructure[] featureStructureArray = new FeatureStructure[n2];
                    System.arraycopy(this.fsArray, 0, featureStructureArray, 0, this.fsArray.length);
                    this.fsArray = featureStructureArray;
                }
                this.fsArray[n] = featureStructure;
            }
        } else {
            featureStructure = this.generators[cASImpl.heap.heap[n]].createFS(n, cASImpl);
        }
        return featureStructure;
    }

    private static class DefaultFSGenerator
    implements FSGenerator {
        private DefaultFSGenerator() {
        }

        public FeatureStructure createFS(int n, CASImpl cASImpl) {
            return new FeatureStructureImplC(cASImpl, n);
        }
    }
}

