/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.admin.FSIndexComparator;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FSIndexComparatorImpl;
import com.ibm.uima.cas.impl.FSLeafIndexImpl;
import com.ibm.uima.cas.impl.FeatureStructureImpl;
import com.ibm.uima.cas.impl.LowLevelIndex;
import com.ibm.uima.cas.impl.LowLevelIterator;
import com.ibm.uima.util.ComparableIntPointerIterator;
import com.ibm.uima.util.IntComparator;
import com.ibm.uima.util.IntPointerIterator;
import com.ibm.uima.util.IntVector;
import java.util.NoSuchElementException;

public class FSBagIndex
extends FSLeafIndexImpl {
    private IntVector index;
    private int initialSize;

    FSBagIndex(CASImpl cASImpl, Type type, int n, int n2) {
        super(cASImpl, type, n2);
        this.initialSize = n;
        this.index = new IntVector(n);
    }

    boolean init(FSIndexComparator fSIndexComparator) {
        FSIndexComparator fSIndexComparator2;
        if (fSIndexComparator.getNumberOfKeys() > 0) {
            fSIndexComparator2 = new FSIndexComparatorImpl(this.lowLevelCAS);
            fSIndexComparator2.setType(fSIndexComparator.getType());
        } else {
            fSIndexComparator2 = fSIndexComparator;
        }
        return super.init(fSIndexComparator2);
    }

    IntVector getVector() {
        return this.index;
    }

    public void flush() {
        this.index = new IntVector(this.initialSize);
    }

    public final boolean insert(int n) {
        this.index.add(n);
        return true;
    }

    private final int find(int n) {
        int[] nArray = this.index.getArray();
        int n2 = this.index.size();
        for (int i = 0; i < n2; ++i) {
            if (this.compare(n, nArray[i]) != 0) continue;
            return i;
        }
        return -1;
    }

    public int compare(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    public ComparableIntPointerIterator pointerIterator(IntComparator intComparator) {
        return new IntVectorIterator(intComparator);
    }

    protected IntPointerIterator refIterator() {
        return new IntVectorIterator();
    }

    public LowLevelIterator ll_iterator() {
        return new IntVectorIterator();
    }

    protected IntPointerIterator refIterator(int n) {
        IntVectorIterator intVectorIterator = new IntVectorIterator();
        int n2 = this.find(n);
        if (n2 >= 0) {
            intVectorIterator.itPos = n2;
        } else {
            intVectorIterator.itPos = -(n2 + 1);
        }
        return intVectorIterator;
    }

    public boolean contains(FeatureStructure featureStructure) {
        return this.find(((FeatureStructureImpl)featureStructure).getAddress()) >= 0;
    }

    public FeatureStructure find(FeatureStructure featureStructure) {
        FeatureStructureImpl featureStructureImpl = (FeatureStructureImpl)featureStructure;
        int n = this.find(featureStructureImpl.getAddress());
        if (n > 0) {
            return featureStructureImpl.getCASImpl().createFS(this.index.get(n));
        }
        return null;
    }

    public int size() {
        return this.index.size();
    }

    public void deleteFS(FeatureStructure featureStructure) {
        int n = ((FeatureStructureImpl)featureStructure).getAddress();
        int n2 = this.index.indexOf(n);
        if (n2 >= 0) {
            this.index.remove(n2);
        }
    }

    public void remove(int n) {
        int n2 = this.index.indexOf(n);
        if (n2 >= 0) {
            this.index.remove(n2);
        }
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    private class IntVectorIterator
    implements ComparableIntPointerIterator,
    LowLevelIterator {
        private int itPos = 0;
        private IntComparator comp;

        private IntVectorIterator() {
        }

        private IntVectorIterator(IntComparator intComparator) {
            this();
            this.comp = intComparator;
        }

        public boolean isValid() {
            return this.itPos >= 0 && this.itPos < FSBagIndex.this.index.size();
        }

        public void moveToFirst() {
            this.itPos = 0;
        }

        public void moveToLast() {
            this.itPos = FSBagIndex.this.index.size() - 1;
        }

        public void moveToNext() {
            ++this.itPos;
        }

        public void moveToPrevious() {
            --this.itPos;
        }

        public int ll_get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return FSBagIndex.this.index.get(this.itPos);
        }

        public Object copy() {
            IntVectorIterator intVectorIterator = new IntVectorIterator(this.comp);
            intVectorIterator.itPos = this.itPos;
            return intVectorIterator;
        }

        public int compareTo(Object object) throws NoSuchElementException {
            return this.comp.compare(this.get(), ((IntVectorIterator)object).get());
        }

        public void moveTo(int n) {
            int n2 = FSBagIndex.this.find(n);
            this.itPos = n2 >= 0 ? n2 : -(n2 + 1);
        }

        public int get() throws NoSuchElementException {
            return this.ll_get();
        }

        public void inc() {
            this.moveToNext();
        }

        public void dec() {
            this.moveToPrevious();
        }

        public int ll_indexSize() {
            return FSBagIndex.this.size();
        }

        public LowLevelIndex ll_getIndex() {
            return FSBagIndex.this;
        }
    }
}

