/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.ArrayFS;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.FloatArrayFS;
import com.ibm.uima.cas.IntArrayFS;
import com.ibm.uima.cas.StringArrayFS;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.impl.DebugNameValuePair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DebugFSLogicalStructure {
    public static Object getDebugLogicalStructure_FeatureStructure(FeatureStructure featureStructure) {
        DebugNameValuePair[] debugNameValuePairArray;
        if (featureStructure instanceof StringArrayFS) {
            return ((StringArrayFS)featureStructure).toArray();
        }
        if (featureStructure instanceof FloatArrayFS) {
            return ((FloatArrayFS)featureStructure).toArray();
        }
        if (featureStructure instanceof IntArrayFS) {
            return ((IntArrayFS)featureStructure).toArray();
        }
        if (featureStructure instanceof ArrayFS) {
            return ((ArrayFS)featureStructure).toArray();
        }
        TypeSystem typeSystem = featureStructure.getCAS().getTypeSystem();
        Type type = featureStructure.getType();
        if (typeSystem.subsumes(typeSystem.getType("uima.cas.FloatList"), type)) {
            return DebugFSLogicalStructure.floatListToArray(featureStructure);
        }
        if (typeSystem.subsumes(typeSystem.getType("uima.cas.IntegerList"), type)) {
            return DebugFSLogicalStructure.integerListToArray(featureStructure);
        }
        if (typeSystem.subsumes(typeSystem.getType("uima.cas.StringList"), type)) {
            return DebugFSLogicalStructure.stringListToArray(featureStructure);
        }
        if (typeSystem.subsumes(typeSystem.getType("uima.cas.FSList"), type)) {
            return DebugFSLogicalStructure.fsListToArray(featureStructure);
        }
        int n = 0;
        String string = type.getName();
        List list = type.getFeatures();
        int n2 = list.size();
        if (featureStructure.getClass().getName().equals(string)) {
            debugNameValuePairArray = new DebugNameValuePair[n2];
        } else {
            debugNameValuePairArray = new DebugNameValuePair[n2 + 1];
            debugNameValuePairArray[0] = new DebugNameValuePair("CasType", string);
            n = 1;
        }
        for (int i = 0; i < n2; ++i) {
            Feature feature = (Feature)list.get(i);
            DebugNameValuePair debugNameValuePair = new DebugNameValuePair(feature.getShortName(), null);
            String string2 = feature.getRange().getName();
            if ("uima.cas.Integer".equals(string2)) {
                debugNameValuePair.setValue(new Integer(featureStructure.getIntValue(feature)));
            } else if ("uima.cas.Float".equals(string2)) {
                debugNameValuePair.setValue(new Float(featureStructure.getFloatValue(feature)));
            } else if ("uima.cas.String".equals(string2)) {
                debugNameValuePair.setValue(featureStructure.getStringValue(feature));
            } else {
                debugNameValuePair.setValue(featureStructure.getFeatureValue(feature));
            }
            debugNameValuePairArray[n++] = debugNameValuePair;
        }
        return debugNameValuePairArray;
    }

    public static Object floatListToArray(FeatureStructure featureStructure) {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        TypeSystem typeSystem = featureStructure.getCAS().getTypeSystem();
        Type type = typeSystem.getType("uima.cas.EmptyFloatList");
        Feature feature = typeSystem.getFeatureByFullName("uima.cas.NonEmptyFloatList:head");
        Feature feature2 = typeSystem.getFeatureByFullName("uima.cas.NonEmptyFloatList:tail");
        HashSet<FeatureStructure> hashSet = new HashSet<FeatureStructure>();
        Object object = featureStructure;
        while (object.getType() != type) {
            arrayList.add(new Float(object.getFloatValue(feature)));
            FeatureStructure featureStructure2 = object.getFeatureValue(feature2);
            if (hashSet.contains(featureStructure2)) {
                return DebugFSLogicalStructure.loopInList(arrayList);
            }
            hashSet.add(featureStructure2);
            object = featureStructure2;
        }
        object = new float[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = ((Float)arrayList.get(i)).floatValue();
        }
        return object;
    }

    public static Object integerListToArray(FeatureStructure featureStructure) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        TypeSystem typeSystem = featureStructure.getCAS().getTypeSystem();
        Type type = typeSystem.getType("uima.cas.EmptyIntegerList");
        Feature feature = typeSystem.getFeatureByFullName("uima.cas.NonEmptyIntegerList:head");
        Feature feature2 = typeSystem.getFeatureByFullName("uima.cas.NonEmptyIntegerList:tail");
        HashSet<FeatureStructure> hashSet = new HashSet<FeatureStructure>();
        Object object = featureStructure;
        while (object.getType() != type) {
            arrayList.add(new Integer(object.getIntValue(feature)));
            FeatureStructure featureStructure2 = object.getFeatureValue(feature2);
            if (hashSet.contains(featureStructure2)) {
                return DebugFSLogicalStructure.loopInList(arrayList);
            }
            hashSet.add(featureStructure2);
            object = featureStructure2;
        }
        object = new int[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        return object;
    }

    public static Object stringListToArray(FeatureStructure featureStructure) {
        ArrayList<String> arrayList = new ArrayList<String>();
        TypeSystem typeSystem = featureStructure.getCAS().getTypeSystem();
        Type type = typeSystem.getType("uima.cas.EmptyStringList");
        Feature feature = typeSystem.getFeatureByFullName("uima.cas.NonEmptyStringList:head");
        Feature feature2 = typeSystem.getFeatureByFullName("uima.cas.NonEmptyStringList:tail");
        HashSet<FeatureStructure> hashSet = new HashSet<FeatureStructure>();
        FeatureStructure featureStructure2 = featureStructure;
        while (featureStructure2.getType() != type) {
            arrayList.add(featureStructure2.getStringValue(feature));
            FeatureStructure featureStructure3 = featureStructure2.getFeatureValue(feature2);
            if (hashSet.contains(featureStructure3)) {
                return DebugFSLogicalStructure.loopInList(arrayList);
            }
            hashSet.add(featureStructure3);
            featureStructure2 = featureStructure3;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Object fsListToArray(FeatureStructure featureStructure) {
        ArrayList<FeatureStructure> arrayList = new ArrayList<FeatureStructure>();
        TypeSystem typeSystem = featureStructure.getCAS().getTypeSystem();
        Type type = typeSystem.getType("uima.cas.EmptyFSList");
        Feature feature = typeSystem.getFeatureByFullName("uima.cas.NonEmptyFSList:head");
        Feature feature2 = typeSystem.getFeatureByFullName("uima.cas.NonEmptyFSList:tail");
        HashSet<FeatureStructure> hashSet = new HashSet<FeatureStructure>();
        FeatureStructure featureStructure2 = featureStructure;
        while (featureStructure2.getType() != type) {
            arrayList.add(featureStructure2.getFeatureValue(feature));
            FeatureStructure featureStructure3 = featureStructure2.getFeatureValue(feature2);
            if (hashSet.contains(featureStructure3)) {
                return DebugFSLogicalStructure.loopInList(arrayList);
            }
            hashSet.add(featureStructure3);
            featureStructure2 = featureStructure3;
        }
        return arrayList.toArray(new FeatureStructure[arrayList.size()]);
    }

    private static Object loopInList(List list) {
        Object[] objectArray = new Object[list.size() + 1];
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            objectArray[i] = e instanceof Integer ? ((Integer)e).toString() : (e instanceof Float ? ((Float)e).toString() : list.get(i));
        }
        objectArray[list.size()] = "... loop in list";
        return objectArray;
    }
}

