/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.CASRuntimeException;
import com.ibm.uima.cas.impl.CASImpl;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class CASSerializer
implements Serializable {
    static final long serialVersionUID = -7972011651957420295L;
    public int[] heapArray = null;
    public int[] heapMetaData = null;
    public String[] stringTable;
    public int[] fsIndex;

    public void addNoMetaData(CASImpl cASImpl) {
        this.addCAS(cASImpl, false);
    }

    public void addCAS(CASImpl cASImpl) {
        this.addCAS(cASImpl, true);
    }

    public void addCAS(CASImpl cASImpl, boolean bl) {
        this.fsIndex = cASImpl.getIndexedFSs();
        int n = cASImpl.heap.getCurrentTempSize();
        this.heapArray = new int[n];
        System.arraycopy(cASImpl.heap.heap, 0, this.heapArray, 0, n);
        if (bl) {
            this.heapMetaData = cASImpl.heap.getMetaData();
        }
        this.stringTable = this.stringArrayListToArray(cASImpl.getStringTable());
    }

    public void addCAS(CASImpl cASImpl, OutputStream outputStream) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            this.fsIndex = cASImpl.getIndexedFSs();
            byte[] byArray = new byte[4];
            byArray[3] = 85;
            byArray[2] = 73;
            byArray[1] = 77;
            byArray[0] = 65;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            int n5 = byteBuffer.asIntBuffer().get();
            int n6 = 1;
            dataOutputStream.writeInt(n5);
            dataOutputStream.writeInt(n6);
            int n7 = cASImpl.heap.getCurrentTempSize();
            dataOutputStream.writeInt(n7);
            for (int i = 0; i < n7; ++i) {
                dataOutputStream.writeInt(cASImpl.heap.heap[i]);
            }
            int[] nArray = new int[cASImpl.stringHeap.refHeapPos];
            for (n4 = 0; n4 < nArray.length; ++n4) {
                nArray[n4] = cASImpl.stringHeap.refHeap[n4];
            }
            n4 = cASImpl.stringHeap.charHeapPos + 1;
            for (n3 = 0; n3 < nArray.length; n3 += 3) {
                n2 = nArray[n3 + 2];
                if (n2 == 0) continue;
                n4 += 1 + ((String)cASImpl.stringHeap.stringList.get(n2)).length();
            }
            if (n4 % 2 != 0) {
                dataOutputStream.writeInt(n4 + 1);
            } else {
                dataOutputStream.writeInt(n4);
            }
            dataOutputStream.writeChar(0);
            if (cASImpl.stringHeap.charHeapPos > 0) {
                dataOutputStream.writeChars(String.valueOf(cASImpl.stringHeap.stringHeap));
            }
            n3 = cASImpl.stringHeap.charHeapPos + 1;
            for (n2 = 0; n2 < nArray.length; n2 += 3) {
                n = nArray[n2 + 2];
                if (n == 0) continue;
                nArray[n2 + 0] = n3;
                dataOutputStream.writeChars((String)cASImpl.stringHeap.stringList.get(n));
                dataOutputStream.writeChar(0);
                n3 += 1 + ((String)cASImpl.stringHeap.stringList.get(n)).length();
            }
            if (n4 % 2 != 0) {
                dataOutputStream.writeChar(0);
            }
            n2 = (nArray.length - 3) / 3 * 2;
            dataOutputStream.writeInt(++n2);
            dataOutputStream.writeInt(0);
            for (n = 3; n < nArray.length; n += 3) {
                dataOutputStream.writeInt(nArray[n + 0]);
                dataOutputStream.writeInt(nArray[n + 1]);
            }
            dataOutputStream.writeInt(this.fsIndex.length);
            for (n = 0; n < this.fsIndex.length; ++n) {
                dataOutputStream.writeInt(this.fsIndex[n]);
            }
        }
        catch (IOException iOException) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(27);
            cASRuntimeException.addArgument(iOException.getMessage());
            throw cASRuntimeException;
        }
    }

    private String[] stringArrayListToArray(ArrayList arrayList) {
        int n = arrayList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    int[] getHeapMetadata() {
        return this.heapMetaData;
    }

    int[] getHeapArray() {
        return this.heapArray;
    }

    String[] getStringTable() {
        return this.stringTable;
    }

    int[] getFSIndex() {
        return this.fsIndex;
    }
}

