/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.FSIndex;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.admin.FSIndexComparator;
import com.ibm.uima.cas.admin.LinearTypeOrder;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FSIndexImpl;
import com.ibm.uima.cas.impl.FSIndexRepositoryImpl;
import com.ibm.uima.cas.impl.FeatureImpl;
import com.ibm.uima.cas.impl.LinearTypeOrderBuilderImpl;
import com.ibm.uima.cas.impl.StringTypeImpl;
import com.ibm.uima.cas.impl.TypeImpl;
import com.ibm.uima.cas.impl.TypeSystemImpl;
import com.ibm.uima.util.IntVector;
import com.ibm.uima.util.SymbolTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class CASMgrSerializer
implements Serializable {
    public static final int SOURCE_JEDI = 0;
    public static final int SOURCE_TAF = 1;
    static final long serialVersionUID = 5549299679614131956L;
    public int[] typeOrder;
    public String[] indexNames;
    public int[] nameToIndexMap;
    public int[] indexingStrategy;
    public int[] comparatorIndex;
    public int[] comparators;
    public String[] typeNames = null;
    public String[] featureNames = null;
    public int[] typeInheritance;
    public int[] featDecls;
    public int topTypeCode;
    public int[] featureOffsets;
    public int[] stringSubtypes;
    public String[] stringSubtypeValues;
    public int[] stringSubtypeValuePos;
    public int source = 0;

    public void addIndexRepository(FSIndexRepositoryImpl fSIndexRepositoryImpl) {
        int n;
        this.typeOrder = fSIndexRepositoryImpl.getDefaultTypeOrder().getOrder();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = fSIndexRepositoryImpl.getLabels();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        int n2 = arrayList.size();
        this.indexNames = new String[n2];
        for (int i = 0; i < n2; ++i) {
            String string;
            this.indexNames[i] = string = (String)arrayList.get(i);
        }
        this.nameToIndexMap = new int[n2];
        Vector<FSIndex> vector = new Vector<FSIndex>();
        for (n = 0; n < n2; ++n) {
            FSIndex fSIndex = fSIndexRepositoryImpl.getIndex(this.indexNames[n]);
            int n3 = vector.indexOf(fSIndex);
            if (n3 < 0) {
                vector.add(fSIndex);
                n3 = vector.size() - 1;
            }
            this.nameToIndexMap[n] = n3;
        }
        n = vector.size();
        this.indexingStrategy = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indexingStrategy[i] = ((FSIndex)vector.get(i)).getIndexingStrategy();
        }
        this.comparatorIndex = new int[n];
        IntVector intVector = new IntVector();
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            this.comparatorIndex[i] = n4;
            FSIndexComparator fSIndexComparator = ((FSIndexImpl)vector.get(i)).getComparator();
            intVector.add(((TypeImpl)fSIndexComparator.getType()).getCode());
            int n5 = fSIndexComparator.getNumberOfKeys();
            for (int j = 0; j < n5; ++j) {
                switch (fSIndexComparator.getKeyType(j)) {
                    case 0: {
                        intVector.add(((FeatureImpl)fSIndexComparator.getKeyFeature(j)).getCode());
                        break;
                    }
                    case 1: {
                        intVector.add(0);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Internal serialization error.");
                    }
                }
                intVector.add(fSIndexComparator.getKeyComparator(j));
            }
            n4 += 1 + 2 * n5;
        }
        this.comparators = intVector.toArray();
    }

    public void addTypeSystem(TypeSystemImpl typeSystemImpl) {
        this.typeNames = CASMgrSerializer.symbolTable2StringArray(typeSystemImpl.getTypeNameST());
        this.encodeTypeInheritance(typeSystemImpl);
        this.encodeFeatureDecls(typeSystemImpl);
        this.encodeStringSubtypes(typeSystemImpl);
    }

    private void encodeStringSubtypes(TypeSystemImpl typeSystemImpl) {
        int n;
        Vector vector = this.getStringSubtypes(typeSystemImpl);
        int n2 = vector.size();
        this.stringSubtypes = new int[n2];
        this.stringSubtypeValuePos = new int[n2];
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            int n4;
            StringTypeImpl stringTypeImpl = (StringTypeImpl)vector.get(n);
            this.stringSubtypes[n] = n4 = stringTypeImpl.getCode();
            this.stringSubtypeValuePos[n] = n3;
            String[] stringArray = typeSystemImpl.getStringSet(stringTypeImpl.getStringSet());
            n3 += stringArray.length;
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        this.stringSubtypeValues = new String[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this.stringSubtypeValues[n] = (String)arrayList.get(n);
        }
    }

    private Vector getStringSubtypes(TypeSystemImpl typeSystemImpl) {
        return typeSystemImpl.getDirectlySubsumedTypes(typeSystemImpl.getType("uima.cas.String"));
    }

    static String[] symbolTable2StringArray(SymbolTable symbolTable) {
        int n = symbolTable.size();
        int n2 = symbolTable.getStart();
        Object[] objectArray = new String[n + n2];
        Arrays.fill(objectArray, 0, n2, null);
        int n3 = n2;
        for (int i = 0; i < n; ++i) {
            objectArray[n3] = symbolTable.getSymbol(n3);
            ++n3;
        }
        return objectArray;
    }

    private void encodeFeatureDecls(TypeSystemImpl typeSystemImpl) {
        int n = typeSystemImpl.getSmallestFeature() + typeSystemImpl.getNumberOfFeatures();
        this.featureNames = new String[n];
        this.featDecls = new int[n * 2];
        for (int i = typeSystemImpl.getSmallestFeature(); i < n; ++i) {
            Feature feature = typeSystemImpl.getFeature(i);
            this.featureNames[i] = feature.getShortName();
            this.featDecls[i * 2] = ((TypeImpl)feature.getDomain()).getCode();
            this.featDecls[i * 2 + 1] = ((TypeImpl)feature.getRange()).getCode();
        }
    }

    private void encodeTypeInheritance(TypeSystemImpl typeSystemImpl) {
        int n = typeSystemImpl.getSmallestType() + typeSystemImpl.getNumberOfTypes();
        this.typeInheritance = new int[n];
        for (int i = typeSystemImpl.getSmallestType() + 1; i < n; ++i) {
            TypeImpl typeImpl = (TypeImpl)typeSystemImpl.getParent(typeSystemImpl.getType(i));
            this.typeInheritance[i] = typeImpl.getCode();
        }
    }

    private int isStringSubtype(int n) {
        for (int i = 0; i < this.stringSubtypes.length; ++i) {
            if (this.stringSubtypes[i] != n) continue;
            return i;
        }
        return -1;
    }

    private String[] getSubarray(String[] stringArray, int n, int n2) {
        String[] stringArray2 = new String[n2 - n];
        for (int i = n; i < n2; ++i) {
            stringArray2[i - n] = stringArray[i];
        }
        return stringArray2;
    }

    private String[] getStringArray(int n) {
        int n2 = n == this.stringSubtypes.length - 1 ? this.stringSubtypeValues.length : this.stringSubtypeValuePos[n + 1];
        return this.getSubarray(this.stringSubtypeValues, this.stringSubtypeValuePos[n], n2);
    }

    public TypeSystemImpl getTypeSystem() {
        int n;
        String string;
        int n2;
        TypeSystemImpl typeSystemImpl = new TypeSystemImpl();
        typeSystemImpl.addTopType("uima.cas.TOP");
        HashMap hashMap = new HashMap();
        if (this.source == 1) {
            for (n2 = 2; n2 < this.typeNames.length; ++n2) {
                int n3 = this.typeInheritance[n2];
                string = CASImpl.mapName(this.typeNames[n2], hashMap);
                n = this.isStringSubtype(n2);
                if (n >= 0) {
                    typeSystemImpl.addStringSubtype(string, this.getStringArray(n));
                    continue;
                }
                typeSystemImpl.addType(string, n3);
            }
        } else {
            for (n2 = 2; n2 < this.typeNames.length; ++n2) {
                string = this.typeNames[n2];
                n = this.isStringSubtype(n2);
                if (n >= 0) {
                    typeSystemImpl.addStringSubtype(string, this.getStringArray(n));
                    continue;
                }
                typeSystemImpl.addType(string, this.typeInheritance[n2]);
            }
        }
        n2 = this.featureNames.length;
        for (n = 1; n < n2; ++n) {
            string = this.source == 1 ? CASImpl.mapName(this.featureNames[n], hashMap) : this.featureNames[n];
            typeSystemImpl.addFeature(string, this.featDecls[n * 2], this.featDecls[n * 2 + 1]);
        }
        return typeSystemImpl;
    }

    public FSIndexRepositoryImpl getIndexRepository(CASImpl cASImpl) {
        int n;
        FSIndexRepositoryImpl fSIndexRepositoryImpl = new FSIndexRepositoryImpl(cASImpl);
        fSIndexRepositoryImpl.setDefaultTypeOrder(LinearTypeOrderBuilderImpl.createTypeOrder(this.typeOrder, cASImpl.getTypeSystem()));
        int n2 = this.indexNames.length;
        int n3 = 0;
        if (this.nameToIndexMap == null) {
            this.nameToIndexMap = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.nameToIndexMap[n] = n;
            }
        }
        for (n = 0; n < n2; ++n) {
            FSIndexComparator fSIndexComparator = fSIndexRepositoryImpl.createComparator();
            n3 = this.comparatorIndex[this.nameToIndexMap[n]];
            Type type = cASImpl.getTypeSystemImpl().getType(this.comparators[n3]);
            fSIndexComparator.setType(type);
            ++n3;
            int n4 = this.nameToIndexMap[n] + 1;
            int n5 = n4 < n2 ? this.comparatorIndex[n4] : this.comparators.length;
            TypeSystemImpl typeSystemImpl = (TypeSystemImpl)cASImpl.getTypeSystem();
            while (n3 < n5) {
                if (this.comparators[n3] > 0) {
                    Feature feature = typeSystemImpl.getFeature(this.comparators[n3]);
                    fSIndexComparator.addKey(feature, this.comparators[++n3]);
                } else {
                    LinearTypeOrder linearTypeOrder = fSIndexRepositoryImpl.getDefaultTypeOrder();
                    fSIndexComparator.addKey(linearTypeOrder, this.comparators[++n3]);
                }
                ++n3;
            }
            fSIndexRepositoryImpl.createIndex(fSIndexComparator, this.indexNames[n], this.indexingStrategy[this.nameToIndexMap[n]]);
        }
        fSIndexRepositoryImpl.commit();
        return fSIndexRepositoryImpl;
    }
}

