/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.ArrayFS;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.CASException;
import com.ibm.uima.cas.CASRuntimeException;
import com.ibm.uima.cas.ConstraintFactory;
import com.ibm.uima.cas.FSIndex;
import com.ibm.uima.cas.FSIndexRepository;
import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.FSMatchConstraint;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.FeaturePath;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.FeatureValuePath;
import com.ibm.uima.cas.FloatArrayFS;
import com.ibm.uima.cas.IntArrayFS;
import com.ibm.uima.cas.SofaFS;
import com.ibm.uima.cas.SofaID;
import com.ibm.uima.cas.StringArrayFS;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.admin.CASAdminException;
import com.ibm.uima.cas.admin.CASMgr;
import com.ibm.uima.cas.admin.FSIndexComparator;
import com.ibm.uima.cas.admin.FSIndexRepositoryMgr;
import com.ibm.uima.cas.admin.TypeSystemMgr;
import com.ibm.uima.cas.impl.AnnotationImpl;
import com.ibm.uima.cas.impl.ArrayFSGenerator;
import com.ibm.uima.cas.impl.CASCompleteSerializer;
import com.ibm.uima.cas.impl.CASMgrSerializer;
import com.ibm.uima.cas.impl.CASSerializer;
import com.ibm.uima.cas.impl.DebugFSLogicalStructure;
import com.ibm.uima.cas.impl.DebugNameValuePair;
import com.ibm.uima.cas.impl.FSClassRegistry;
import com.ibm.uima.cas.impl.FSIndexRepositoryImpl;
import com.ibm.uima.cas.impl.FSListIteratorImpl;
import com.ibm.uima.cas.impl.FeatureImpl;
import com.ibm.uima.cas.impl.FeaturePathImpl;
import com.ibm.uima.cas.impl.FeatureStructureImpl;
import com.ibm.uima.cas.impl.FeatureValuePathImpl;
import com.ibm.uima.cas.impl.FilteredIterator;
import com.ibm.uima.cas.impl.FloatArrayFSImpl;
import com.ibm.uima.cas.impl.Heap;
import com.ibm.uima.cas.impl.IntArrayFSImpl;
import com.ibm.uima.cas.impl.LowLevelCAS;
import com.ibm.uima.cas.impl.LowLevelException;
import com.ibm.uima.cas.impl.LowLevelIndexRepository;
import com.ibm.uima.cas.impl.LowLevelTypeSystem;
import com.ibm.uima.cas.impl.SofaFSImpl;
import com.ibm.uima.cas.impl.StringArrayFSImpl;
import com.ibm.uima.cas.impl.StringHeap;
import com.ibm.uima.cas.impl.TCASImpl;
import com.ibm.uima.cas.impl.TypeImpl;
import com.ibm.uima.cas.impl.TypeSystemImpl;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.jcas.impl.JCas;
import com.ibm.uima.util.IntVector;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class CASImpl
implements CAS,
CASMgr,
LowLevelCAS {
    public static final int NULL = 0;
    public static final int DEFAULT_INITIAL_HEAP_SIZE = 500000;
    public static final int DEFAULT_RESET_HEAP_SIZE = 5000000;
    private static final int resetHeapSize = 5000000;
    protected TypeSystemImpl ts;
    private static final int arrayLengthFeatOffset = 1;
    private static final int arrayContentOffset = 2;
    protected Heap heap;
    protected StringHeap stringHeap;
    protected FSIndexRepositoryImpl indexRepository;
    private HashMap sofa2indexMap;
    private HashMap sofa2tcasMap;
    private HashMap sofa2jcasMap;
    private HashSet sofaNameSet;
    private int sofaCount;
    private CASImpl baseCAS;
    private TCASImpl defaultTCas;
    protected int mySofaRef = 0;
    protected FSClassRegistry fsClassReg = null;
    private final boolean useFSCache;
    private static final boolean DEFAULT_USE_FS_CACHE = false;
    private ClassLoader jcasClassLoader = this.getClass().getClassLoader();
    private int[] featureOffset;
    private int[] fsSpaceReq;
    private boolean[] creatableType;
    private static String[] nonCreatableTypes;
    private TypeImpl topType;
    private TypeImpl intType;
    private TypeImpl stringType;
    private TypeImpl floatType;
    private TypeImpl arrayBaseType;
    private TypeImpl intArrayType;
    private TypeImpl floatArrayType;
    private TypeImpl stringArrayType;
    private TypeImpl fsArrayType;
    private TypeImpl sofaType;
    private TypeImpl annotType;
    private int intTypeCode;
    private int stringTypeCode;
    private int floatTypeCode;
    private int intArrayTypeCode;
    private int floatArrayTypeCode;
    private int stringArrayTypeCode;
    private int fsArrayTypeCode;
    private int sofaTypeCode;
    private int annotTypeCode;
    private int sofaNumFeatCode;
    private int sofaIdFeatCode;
    private int sofaMimeFeatCode;
    private int sofaUriFeatCode;
    private int sofaArrayFeatCode;
    private int annotSofaFeatCode;
    private boolean flushEnabled = true;
    private boolean annotIndexInitialized = false;
    protected JCas jcas = null;

    private final ArrayList getStringList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(null);
        int n = this.stringHeap.getLargestStringCode();
        for (int i = this.stringHeap.getLeastStringCode(); i <= n; ++i) {
            arrayList.add(this.stringHeap.getStringForCode(i));
        }
        return arrayList;
    }

    public void setCAS(CAS cAS) {
        CASImpl cASImpl;
        this.baseCAS = cASImpl = (CASImpl)cAS;
        this.ts = cASImpl.ts;
        this.heap = cASImpl.heap;
        this.stringHeap = cASImpl.stringHeap;
        this.indexRepository = cASImpl.indexRepository;
        this.sofa2indexMap = cASImpl.sofa2indexMap;
        this.sofa2tcasMap = cASImpl.sofa2tcasMap;
        this.sofa2jcasMap = cASImpl.sofa2jcasMap;
        this.sofaNameSet = cASImpl.sofaNameSet;
        this.fsClassReg = cASImpl.fsClassReg;
        this.featureOffset = cASImpl.featureOffset;
        this.fsSpaceReq = cASImpl.fsSpaceReq;
        this.creatableType = cASImpl.creatableType;
        this.topType = cASImpl.topType;
        this.intType = cASImpl.intType;
        this.stringType = cASImpl.stringType;
        this.floatType = cASImpl.floatType;
        this.arrayBaseType = cASImpl.arrayBaseType;
        this.intArrayType = cASImpl.intArrayType;
        this.floatArrayType = cASImpl.floatArrayType;
        this.stringArrayType = cASImpl.stringArrayType;
        this.fsArrayType = cASImpl.fsArrayType;
        this.annotType = cASImpl.annotType;
        this.sofaType = cASImpl.sofaType;
        this.flushEnabled = cASImpl.flushEnabled;
        this.initTypeCodeVars();
        this.jcas = cASImpl.jcas;
    }

    CASImpl(CAS cAS) {
        this.setCAS(cAS);
        this.useFSCache = false;
    }

    public CASImpl(TypeSystemImpl typeSystemImpl, int n) {
        this(typeSystemImpl, n, false);
    }

    CASImpl(TypeSystemImpl typeSystemImpl, int n, boolean bl) {
        boolean bl2;
        this.useFSCache = bl;
        boolean bl3 = bl2 = typeSystemImpl != null;
        if (bl2) {
            this.ts = typeSystemImpl;
            this.redoTypeSystemSetup();
            this.ts.setCommitted(true);
        } else {
            this.ts = new TypeSystemImpl(this);
            this.setupTSDefault();
        }
        this.initTypeVariables();
        this.heap = new Heap(n);
        this.initStringTable();
        if (bl2) {
            this.commitTypeSystem();
        }
        this.sofa2indexMap = new HashMap();
        this.sofa2tcasMap = new HashMap();
        this.sofa2jcasMap = new HashMap();
        this.sofaNameSet = new HashSet();
        this.sofaCount = 0;
        this.baseCAS = this;
    }

    public CASImpl() {
        this(500000);
    }

    public CASImpl(int n) {
        this(null, n);
    }

    public CASImpl(CASMgrSerializer cASMgrSerializer) {
        this();
        this.ts = cASMgrSerializer.getTypeSystem();
        this.ts.commit();
        this.initTypeVariables();
        this.redoTypeSystemSetup();
        this.checkInternalCodes(cASMgrSerializer);
        this.setIndexRepository(cASMgrSerializer.getIndexRepository(this));
    }

    private final void initTypeVariables() {
        this.topType = (TypeImpl)this.ts.getTopType();
        this.intType = (TypeImpl)this.ts.getType("uima.cas.Integer");
        this.stringType = (TypeImpl)this.ts.getType("uima.cas.String");
        this.floatType = (TypeImpl)this.ts.getType("uima.cas.Float");
        this.arrayBaseType = (TypeImpl)this.ts.getType("uima.cas.ArrayBase");
        this.intArrayType = (TypeImpl)this.ts.getType("uima.cas.IntegerArray");
        this.floatArrayType = (TypeImpl)this.ts.getType("uima.cas.FloatArray");
        this.stringArrayType = (TypeImpl)this.ts.getType("uima.cas.StringArray");
        this.fsArrayType = (TypeImpl)this.ts.getType("uima.cas.FSArray");
        this.sofaType = (TypeImpl)this.ts.getType("uima.cas.Sofa");
        this.annotType = (TypeImpl)this.ts.getType("uima.tcas.Annotation");
        this.initTypeCodeVars();
    }

    private final void initTypeCodeVars() {
        this.intTypeCode = this.intType.getCode();
        this.stringTypeCode = this.stringType.getCode();
        this.floatTypeCode = this.floatType.getCode();
        this.intArrayTypeCode = this.intArrayType.getCode();
        this.floatArrayTypeCode = this.floatArrayType.getCode();
        this.stringArrayTypeCode = this.stringArrayType.getCode();
        this.fsArrayTypeCode = this.fsArrayType.getCode();
        this.sofaTypeCode = this.sofaType.getCode();
        this.annotTypeCode = this.annotType.getCode();
        this.sofaNumFeatCode = this.ll_getTypeSystem().ll_getCodeForFeature(this.sofaType.getFeatureByBaseName("sofaNum"));
        this.sofaIdFeatCode = this.ll_getTypeSystem().ll_getCodeForFeature(this.sofaType.getFeatureByBaseName("sofaID"));
        this.sofaMimeFeatCode = this.ll_getTypeSystem().ll_getCodeForFeature(this.sofaType.getFeatureByBaseName("mimeType"));
        this.sofaUriFeatCode = this.ll_getTypeSystem().ll_getCodeForFeature(this.sofaType.getFeatureByBaseName("sofaURI"));
        this.sofaArrayFeatCode = this.ll_getTypeSystem().ll_getCodeForFeature(this.sofaType.getFeatureByBaseName("sofaArray"));
        this.annotSofaFeatCode = this.ll_getTypeSystem().ll_getCodeForFeature(this.annotType.getFeatureByBaseName("sofa"));
    }

    private void checkInternalCodes(CASMgrSerializer cASMgrSerializer) throws CASAdminException {
        if (cASMgrSerializer.topTypeCode > 0 && cASMgrSerializer.topTypeCode != ((TypeImpl)this.ts.getTopType()).getCode()) {
            throw new CASAdminException(8);
        }
        if (cASMgrSerializer.featureOffsets == null) {
            return;
        }
        if (cASMgrSerializer.featureOffsets.length != this.featureOffset.length) {
            throw new CASAdminException(8);
        }
        for (int i = 1; i < cASMgrSerializer.featureOffsets.length; ++i) {
            if (cASMgrSerializer.featureOffsets[i] == this.featureOffset[i]) continue;
            throw new CASAdminException(8);
        }
    }

    public void enableReset(boolean bl) {
        this.flushEnabled = bl;
    }

    public TypeSystem getTypeSystem() {
        if (this.ts.isCommitted()) {
            return this.ts;
        }
        throw new CASRuntimeException(6);
    }

    public ConstraintFactory getConstraintFactory() {
        return ConstraintFactory.instance();
    }

    public FeatureStructure createFS(Type type) {
        int n = ((TypeImpl)type).getCode();
        if (!this.isCreatableType(n)) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(0);
            cASRuntimeException.addArgument(type.getName());
            cASRuntimeException.addArgument("CAS.createFS()");
            throw cASRuntimeException;
        }
        int n2 = this.createTempFS(n);
        boolean bl = this.ts.subsumes(this.annotTypeCode, n);
        if (bl && !(this instanceof TCAS)) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(0);
            cASRuntimeException.addArgument(type.getName());
            cASRuntimeException.addArgument("CAS.createFS()");
            throw cASRuntimeException;
        }
        FeatureStructure featureStructure = this.fsClassReg.createFS(n2, this);
        if (bl) {
            int n3 = this.getLowLevelCAS().ll_getFSRef(featureStructure);
            this.getLowLevelCAS().ll_setIntValue(n3, this.annotSofaFeatCode, ((TCASImpl)this).getSofaRef());
        }
        return featureStructure;
    }

    public FeatureStructure createPermFS(Type type) {
        int n = this.createPermFS(((TypeImpl)type).getCode());
        return this.getFSClassRegistry().createFS(n, this);
    }

    public ArrayFS createArrayFS(int n) {
        this.checkArrayPreconditions(n);
        int n2 = this.createTempArray(this.fsArrayType.getCode(), n);
        return (ArrayFS)this.createFS(n2);
    }

    public IntArrayFS createIntArrayFS(int n) {
        this.checkArrayPreconditions(n);
        int n2 = this.createTempArray(this.intArrayType.getCode(), n);
        return (IntArrayFS)this.createFS(n2);
    }

    public FloatArrayFS createFloatArrayFS(int n) {
        this.checkArrayPreconditions(n);
        int n2 = this.createTempArray(this.floatArrayType.getCode(), n);
        return (FloatArrayFS)this.createFS(n2);
    }

    public StringArrayFS createStringArrayFS(int n) {
        this.checkArrayPreconditions(n);
        int n2 = this.createTempArray(this.stringArrayType.getCode(), n);
        return (StringArrayFS)this.createFS(n2);
    }

    public final void checkArrayPreconditions(int n) throws CASRuntimeException {
        if (n < 0) {
            throw new CASRuntimeException(1);
        }
    }

    public boolean isBackwardCompatibleCas() {
        if (this.sofaCount != 1) {
            return false;
        }
        int n = this.getLowLevelCAS().ll_getFSRef(this.getSofa(1));
        String string = this.getLowLevelCAS().ll_getStringValue(n, this.sofaMimeFeatCode);
        if (!"text".equals(string)) {
            return false;
        }
        String string2 = this.getLowLevelCAS().ll_getStringValue(n, this.sofaUriFeatCode);
        if (string2 != null) {
            return false;
        }
        int n2 = this.getLowLevelCAS().ll_getRefValue(n, this.sofaArrayFeatCode);
        if (n2 != 0) {
            return false;
        }
        String string3 = this.getLowLevelCAS().ll_getStringValue(n, this.sofaIdFeatCode);
        return "_DefaultTextSofaName".equals(string3);
    }

    protected FSIndexRepository getSofaIndexRepository(SofaFS sofaFS) {
        return (FSIndexRepositoryImpl)this.sofa2indexMap.get(new Integer(sofaFS.getSofaRef()));
    }

    void setSofaIndexRepository(SofaFS sofaFS, FSIndexRepository fSIndexRepository) {
        this.sofa2indexMap.put(new Integer(sofaFS.getSofaRef()), fSIndexRepository);
    }

    public SofaFS createLocalSofa(SofaID sofaID, String string) {
        return this.createSofa(sofaID.getSofaID(), string);
    }

    public SofaFS createRemoteSofa(SofaID sofaID, String string) {
        return this.createSofa(sofaID.getSofaID(), string);
    }

    public SofaFS createSofa(SofaID sofaID, String string) {
        return this.createSofa(sofaID.getSofaID(), string);
    }

    void createDefaultSofa() {
        int n = this.createTempFS(this.sofaTypeCode);
        FeatureStructure featureStructure = this.fsClassReg.createFS(n, this);
        this.addSofa(featureStructure, "_DefaultTextSofaName", "text");
    }

    private SofaFS createSofa(String string, String string2) {
        int n = this.createTempFS(this.sofaTypeCode);
        FeatureStructure featureStructure = this.fsClassReg.createFS(n, this);
        this.addSofa(featureStructure, string, string2);
        return (SofaFS)featureStructure;
    }

    public void addSofa(FeatureStructure featureStructure, String string, String string2) {
        if (this.baseCAS.sofaNameSet.contains(string)) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(19);
            cASRuntimeException.addArgument(string);
            throw cASRuntimeException;
        }
        int n = this.getLowLevelCAS().ll_getFSRef(featureStructure);
        this.getLowLevelCAS().ll_setIntValue(n, this.sofaNumFeatCode, ++this.baseCAS.sofaCount);
        this.getLowLevelCAS().ll_setStringValue(n, this.sofaIdFeatCode, string);
        this.getLowLevelCAS().ll_setStringValue(n, this.sofaMimeFeatCode, string2);
        this.baseCAS.getIndexRepository().addFS(featureStructure);
        this.baseCAS.sofaNameSet.add(string);
    }

    public SofaFS getSofa(SofaID sofaID) {
        return this.getSofa(sofaID.getSofaID());
    }

    private SofaFS getSofa(String string) {
        Object object;
        FSIterator fSIterator = this.baseCAS.getSofaIterator();
        while (fSIterator.isValid()) {
            object = (SofaFS)fSIterator.get();
            if (string.equals(this.getStringValue(object.hashCode(), this.sofaIdFeatCode))) {
                return object;
            }
            fSIterator.moveToNext();
        }
        object = new CASRuntimeException(21);
        ((CASRuntimeException)object).addArgument(string);
        throw object;
    }

    protected SofaFS getSofa(int n) {
        Object object;
        FSIterator fSIterator = this.baseCAS.getSofaIterator();
        while (fSIterator.isValid()) {
            object = (SofaFS)fSIterator.get();
            if (n == this.ll_getIntValue(object.hashCode(), this.sofaNumFeatCode)) {
                return object;
            }
            fSIterator.moveToNext();
        }
        object = new CASRuntimeException(22);
        throw object;
    }

    public CASImpl getBaseCAS() {
        return this.baseCAS;
    }

    public FSIterator getSofaIterator() {
        FSIndex fSIndex = this.baseCAS.indexRepository.getIndex("SofaIndex");
        return fSIndex.iterator();
    }

    public void setSofaFeat(int n, int n2) {
        this.setFeatureValue(n, this.annotSofaFeatCode, n2);
    }

    public int getSofaFeat(int n) {
        return this.getFeatureValue(n, this.annotSofaFeatCode);
    }

    public int getSofaRef() {
        return this.mySofaRef;
    }

    public InputStream getSofaDataStream(SofaFS sofaFS) {
        block11: {
            try {
                if (null != sofaFS.getLocalStringData()) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(sofaFS.getLocalStringData().getBytes("UTF-8"));
                    return byteArrayInputStream;
                }
                if (null != sofaFS.getLocalFSData()) {
                    FeatureStructure featureStructure = sofaFS.getLocalFSData();
                    Type type = featureStructure.getType();
                    if (type.getName().equals("uima.cas.FloatArray")) {
                        FloatArrayFS floatArrayFS = (FloatArrayFS)featureStructure;
                        ByteBuffer byteBuffer = ByteBuffer.allocate(floatArrayFS.size() * 4);
                        for (int i = 0; i < floatArrayFS.size(); ++i) {
                            byteBuffer.putFloat(floatArrayFS.get(i));
                        }
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer.array());
                        return byteArrayInputStream;
                    }
                    if (type.getName().equals("uima.cas.IntegerArray")) {
                        IntArrayFS intArrayFS = (IntArrayFS)featureStructure;
                        ByteBuffer byteBuffer = ByteBuffer.allocate(intArrayFS.size() * 4);
                        for (int i = 0; i < intArrayFS.size(); ++i) {
                            byteBuffer.putInt(intArrayFS.get(i));
                        }
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer.array());
                        return byteArrayInputStream;
                    }
                    break block11;
                }
                if (null != sofaFS.getSofaURI()) {
                    URL uRL = new URL(sofaFS.getSofaURI());
                    return uRL.openStream();
                }
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                CASRuntimeException cASRuntimeException = new CASRuntimeException(29);
                cASRuntimeException.addArgument(malformedURLException.getMessage());
                throw cASRuntimeException;
            }
            catch (CASRuntimeException cASRuntimeException) {
                CASRuntimeException cASRuntimeException2 = new CASRuntimeException(29);
                cASRuntimeException2.addArgument(cASRuntimeException.getMessage());
                throw cASRuntimeException2;
            }
            catch (IOException iOException) {
                CASRuntimeException cASRuntimeException = new CASRuntimeException(29);
                cASRuntimeException.addArgument(iOException.getMessage());
                throw cASRuntimeException;
            }
        }
        return null;
    }

    public FSIterator createFilteredIterator(FSIterator fSIterator, FSMatchConstraint fSMatchConstraint) {
        return new FilteredIterator(fSIterator, fSMatchConstraint);
    }

    public void commitTypeSystem() {
        this.redoTypeSystemSetup();
        this.initFSClassRegistry();
        this.createIndexRepository();
    }

    private void createIndexRepository() {
        if (!this.getTypeSystemMgr().isCommitted()) {
            throw new CASAdminException(2);
        }
        if (this.indexRepository == null) {
            this.indexRepository = new FSIndexRepositoryImpl(this);
        }
    }

    public FSIndexRepositoryMgr getIndexRepositoryMgr() {
        return this.indexRepository;
    }

    public void commitFS(FeatureStructure featureStructure) {
        this.getIndexRepository().addFS(featureStructure);
    }

    public FeaturePath createFeaturePath() {
        return new FeaturePathImpl();
    }

    public TypeSystemMgr getTypeSystemMgr() {
        return this.ts;
    }

    public void reset() {
        if (!this.flushEnabled) {
            throw new CASAdminException(9);
        }
        if (this == this.baseCAS) {
            this.resetNoQuestions();
            return;
        }
        this.baseCAS.resetNoQuestions();
    }

    public void resetNoQuestions() {
        Object object;
        FSIterator fSIterator = this.baseCAS.getSofaIterator();
        while (fSIterator.isValid()) {
            SofaFS sofaFS = (SofaFS)fSIterator.get();
            fSIterator.moveToNext();
            object = this.getTCAS(sofaFS);
            ((TCASImpl)object).resetNoQuestions();
        }
        if (this.heap.getCurrentTempSize() > 5000000) {
            this.heap.resetTempHeap(true);
            this.resetStringTable(true);
        } else {
            this.heap.resetTempHeap(false);
            this.resetStringTable(false);
        }
        this.indexRepository.flush();
        this.baseCAS.sofaNameSet.clear();
        this.sofaCount = 0;
        this.defaultTCas = null;
        if (null != this.fsClassReg) {
            this.fsClassReg.flush();
        }
        if (this.jcas != null) {
            try {
                JCas.clearData(this);
            }
            catch (CASException cASException) {
                object = new CASAdminException(10);
                ((CASAdminException)object).addArgument(cASException.getMessage());
                throw object;
            }
        }
    }

    public void flush() {
        this.reset();
    }

    public FSIndexRepository getIndexRepository() {
        if (this.indexRepository.isCommitted()) {
            return this.indexRepository;
        }
        return null;
    }

    public void reinit(CASSerializer cASSerializer) {
        if (this != this.baseCAS) {
            this.baseCAS.reinit(cASSerializer);
            return;
        }
        this.resetNoQuestions();
        this.reinit(cASSerializer.getHeapMetadata(), cASSerializer.getHeapArray(), cASSerializer.getStringTable(), cASSerializer.getFSIndex());
    }

    public ListIterator fs2listIterator(FSIterator fSIterator) {
        return new FSListIteratorImpl(fSIterator);
    }

    public CAS getCAS() {
        if (this.indexRepository.isCommitted()) {
            return this;
        }
        throw new CASAdminException(3);
    }

    void resetStringTable() {
        this.resetStringTable(false);
    }

    void resetStringTable(boolean bl) {
        this.stringHeap.reset(bl);
    }

    private void initStringTable() {
        this.stringHeap = new StringHeap();
    }

    public void setFSClassRegistry(FSClassRegistry fSClassRegistry) {
        this.fsClassReg = fSClassRegistry;
    }

    void initFSClassRegistry() {
        FSClassRegistry fSClassRegistry = new FSClassRegistry(this.ts, this.useFSCache);
        this.setFSClassRegistry(fSClassRegistry);
        fSClassRegistry.addClassForType(this.fsArrayType, new ArrayFSGenerator());
        fSClassRegistry.addClassForType(this.intArrayType, IntArrayFSImpl.generator());
        fSClassRegistry.addClassForType(this.floatArrayType, FloatArrayFSImpl.generator());
        fSClassRegistry.addClassForType(this.stringArrayType, StringArrayFSImpl.generator());
        fSClassRegistry.addClassForType(this.sofaType, SofaFSImpl.getSofaFSGenerator());
        fSClassRegistry.addClassForType(this.annotType, AnnotationImpl.getAnnotationGenerator());
    }

    public FSClassRegistry getFSClassRegistry() {
        return this.fsClassReg;
    }

    private void initCreatableTypeTable() {
        this.creatableType = new boolean[this.ts.getTypeArraySize()];
        Arrays.fill(this.creatableType, true);
        for (int i = 0; i < nonCreatableTypes.length; ++i) {
            int n = ((TypeImpl)this.ts.getType(nonCreatableTypes[i])).getCode();
            for (int j = this.ts.getSmallestType(); j < this.creatableType.length; ++j) {
                if (!this.ts.subsumes(n, j)) continue;
                this.creatableType[j] = false;
            }
        }
    }

    void setIndexRepository(FSIndexRepositoryImpl fSIndexRepositoryImpl) {
        this.indexRepository = fSIndexRepositoryImpl;
    }

    public void reinit(CASCompleteSerializer cASCompleteSerializer) {
        if (this != this.baseCAS) {
            this.baseCAS.reinit(cASCompleteSerializer);
            return;
        }
        this.ts = cASCompleteSerializer.getCASMgrSerializer().getTypeSystem();
        this.ts.commit();
        this.initTypeVariables();
        this.redoTypeSystemSetup();
        this.sofa2indexMap.clear();
        this.sofa2tcasMap.clear();
        this.defaultTCas = null;
        this.indexRepository = cASCompleteSerializer.getCASMgrSerializer().getIndexRepository(this);
        this.indexRepository.commit();
        CASSerializer cASSerializer = cASCompleteSerializer.getCASSerializer();
        this.reinit(cASSerializer.getHeapMetadata(), cASSerializer.getHeapArray(), cASSerializer.getStringTable(), cASSerializer.getFSIndex());
        this.jcas = null;
        this.sofa2jcasMap.clear();
    }

    void reinit(int[] nArray, int[] nArray2, String[] stringArray, int[] nArray3) {
        this.createStringTableFromArray(stringArray);
        this.heap.reinit(nArray, nArray2);
        this.reinitIndexedFSs(nArray3);
    }

    int[] getIndexedFSs() {
        IntVector intVector = new IntVector();
        int[] nArray = this.baseCAS.indexRepository.getIndexedFSs();
        intVector.add(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            intVector.add(nArray[i]);
        }
        FSIterator fSIterator = this.baseCAS.getSofaIterator();
        while (fSIterator.isValid()) {
            SofaFS sofaFS = (SofaFS)fSIterator.get();
            fSIterator.moveToNext();
            FSIndexRepositoryImpl fSIndexRepositoryImpl = (FSIndexRepositoryImpl)this.baseCAS.getSofaIndexRepository(sofaFS);
            nArray = fSIndexRepositoryImpl != null ? fSIndexRepositoryImpl.getIndexedFSs() : new IntVector().toArray();
            intVector.add(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                intVector.add(nArray[i]);
            }
        }
        return intVector.toArray();
    }

    public void reinit(InputStream inputStream) throws CASRuntimeException {
        if (this != this.baseCAS) {
            this.baseCAS.reinit(inputStream);
            return;
        }
        this.resetNoQuestions();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            int n;
            int n2;
            int n3;
            byte[] byArray = new byte[]{dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte()};
            boolean bl = false;
            if (byArray[0] != 65) {
                bl = true;
            }
            int n4 = bl ? this.swap4(dataInputStream, byArray) : dataInputStream.readInt();
            int n5 = 0;
            n5 = bl ? this.swap4(dataInputStream, byArray) : dataInputStream.readInt();
            this.heap.reinitSizeOnly(n5);
            for (n3 = 0; n3 < n5; ++n3) {
                this.heap.heap[n3] = bl ? this.swap4(dataInputStream, byArray) : dataInputStream.readInt();
            }
            n3 = 0;
            n3 = bl ? this.swap4(dataInputStream, byArray) : dataInputStream.readInt();
            this.stringHeap.stringHeap = new char[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.stringHeap.stringHeap[n2] = bl ? this.swap2(dataInputStream, byArray) : dataInputStream.readChar();
            }
            this.stringHeap.charHeapPos = n3;
            if (n3 % 2 != 0) {
                dataInputStream.readChar();
            }
            n2 = 0;
            n2 = bl ? this.swap4(dataInputStream, byArray) : dataInputStream.readInt();
            --n2;
            n2 /= 2;
            this.stringHeap.refHeap = new int[3 + (n2 *= 3)];
            dataInputStream.readInt();
            for (n = this.stringHeap.refHeapPos; n < this.stringHeap.refHeap.length; n += 3) {
                if (bl) {
                    this.stringHeap.refHeap[n + 0] = this.swap4(dataInputStream, byArray);
                    this.stringHeap.refHeap[n + 1] = this.swap4(dataInputStream, byArray);
                } else {
                    this.stringHeap.refHeap[n + 0] = dataInputStream.readInt();
                    this.stringHeap.refHeap[n + 1] = dataInputStream.readInt();
                }
                this.stringHeap.refHeap[n + 2] = 0;
            }
            this.stringHeap.refHeapPos = n2;
            n = 0;
            n = bl ? this.swap4(dataInputStream, byArray) : dataInputStream.readInt();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = bl ? this.swap4(dataInputStream, byArray) : dataInputStream.readInt();
            }
            this.reinitIndexedFSs(nArray);
        }
        catch (IOException iOException) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(28);
            cASRuntimeException.addArgument(iOException.getMessage());
            throw cASRuntimeException;
        }
    }

    private int swap4(DataInputStream dataInputStream, byte[] byArray) throws IOException {
        byArray[3] = dataInputStream.readByte();
        byArray[2] = dataInputStream.readByte();
        byArray[1] = dataInputStream.readByte();
        byArray[0] = dataInputStream.readByte();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        return byteBuffer.getInt();
    }

    private char swap2(DataInputStream dataInputStream, byte[] byArray) throws IOException {
        byArray[1] = dataInputStream.readByte();
        byArray[0] = dataInputStream.readByte();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, 2);
        return byteBuffer.getChar();
    }

    private void reinitIndexedFSs(int[] nArray) {
        int n;
        int n2 = nArray[0];
        for (n = 1; n < n2 + 1; ++n) {
            this.indexRepository.addFS(nArray[n]);
        }
        n = n2 + 1;
        FSIterator fSIterator = this.baseCAS.getSofaIterator();
        Feature feature = this.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaID");
        while (fSIterator.isValid()) {
            SofaFS sofaFS = (SofaFS)fSIterator.get();
            ++this.baseCAS.sofaCount;
            String string = this.getLowLevelCAS().ll_getStringValue(sofaFS.hashCode(), ((FeatureImpl)feature).getCode());
            this.sofaNameSet.add(string);
            fSIterator.moveToNext();
            TCAS tCAS = this.getTCAS(sofaFS);
            FSIndexRepositoryImpl fSIndexRepositoryImpl = (FSIndexRepositoryImpl)this.getSofaIndexRepository(sofaFS);
            n2 = nArray[n];
            for (int i = n + 1; i < n + 1 + n2; ++i) {
                fSIndexRepositoryImpl.addFS(nArray[i]);
            }
            n += n2 + 1;
            ((TCASImpl)tCAS).updateDocumentAnnotation();
        }
    }

    void createStringTableFromArray(String[] stringArray) {
        this.stringHeap.reset();
        for (int i = 1; i < stringArray.length; ++i) {
            this.stringHeap.addString(stringArray[i]);
        }
    }

    static String mapName(String string, HashMap hashMap) {
        String string2 = (String)hashMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public FeatureStructure createFS(int n) {
        return this.fsClassReg.createFS(n, this);
    }

    public int createTempStringArray(int n, int n2) {
        int n3 = this.heap.addToTempHeap(2 + n2, n);
        this.heap.heap[n3 + 1] = n2;
        return n3;
    }

    public int createPermFS(int n) {
        return this.heap.addToHeap(this.fsSpaceReq[n], n);
    }

    public int getArraySize(int n) {
        return this.ll_getArraySize(n);
    }

    public int ll_getArraySize(int n) {
        return this.heap.heap[n + 1];
    }

    public final int getArrayStartAddress(int n) {
        return n + 2;
    }

    public int getArrayValue(int n, int n2) throws ArrayIndexOutOfBoundsException {
        int n3 = this.heap.heap[n + 1];
        if (n2 < 0 || n2 >= n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.heap.heap[n + 2 + n2];
    }

    void setArrayValue(int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        int n4 = this.heap.heap[n + 1];
        if (n2 < 0 || n2 >= n4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.heap.heap[n + 2 + n2] = n3;
    }

    void copyToArray(int n, int n2, int[] nArray, int n3, int n4) {
        int n5 = this.heap.heap[n + 1];
        if (n2 < 0 || n4 + n2 > n5) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n6 = n + 2;
        System.arraycopy(this.heap.heap, n6 + n2, nArray, n3, n4);
    }

    void copyFromArray(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = this.heap.heap[n2 + 1];
        if (n3 < 0 || n4 + n3 > n5) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n6 = n2 + 2;
        System.arraycopy(nArray, n, this.heap.heap, n6 + n3, n4);
    }

    void copyFeatures(int n, int n2) throws CASRuntimeException {
        int n3 = this.getHeapValue(n);
        if (n3 != this.getHeapValue(n2)) {
            CASRuntimeException cASRuntimeException = new CASRuntimeException(2);
            cASRuntimeException.addArgument("Type of source and target feature structures do not match");
            throw cASRuntimeException;
        }
        int[] nArray = this.getTypeSystem().getLowLevelTypeSystem().ll_getAppropriateFeatures(n3);
        for (int i = 0; i < nArray.length; ++i) {
            int n4;
            Feature feature = this.getTypeSystem().getLowLevelTypeSystem().ll_getFeatureForCode(nArray[i]);
            Type type = feature.getRange();
            int n5 = ((FeatureImpl)feature).getCode();
            int n6 = this.getHeapValue(n2 + this.featureOffset[n5]);
            this.heap.heap[n + this.featureOffset[n5]] = this.isStringType(type) ? (n4 = this.stringHeap.cloneStringReference(n6)) : this.getHeapValue(n2 + this.featureOffset[n5]);
        }
    }

    public int createPermArray(int n, int n2) {
        int n3 = this.heap.addToHeap(this.fsSpaceReq[n] + n2, n);
        this.heap.heap[n3 + 1] = n2;
        return n3;
    }

    public int getHeapValue(int n) {
        return this.heap.heap[n];
    }

    public void setFeatureValue(int n, int n2, int n3) {
        this.heap.heap[n + this.featureOffset[n2]] = n3;
    }

    public void setStringValue(int n, int n2, String string) {
        int n3 = string == null ? 0 : this.stringHeap.addString(string);
        this.setFeatureValue(n, n2, n3);
    }

    public void setFloatValue(int n, int n2, float f) {
        int n3 = Float.floatToIntBits(f);
        this.setFeatureValue(n, n2, n3);
    }

    public void setFloatValue(int n, float f) {
        int n2;
        this.heap.heap[n] = n2 = Float.floatToIntBits(f);
    }

    public int getFeatureValue(int n, int n2) {
        return this.heap.heap[n + this.featureOffset[n2]];
    }

    public String getStringValue(int n, int n2) {
        return this.stringHeap.getStringForCode(this.heap.heap[n + this.featureOffset[n2]]);
    }

    public float getFloatValue(int n, int n2) {
        return Float.intBitsToFloat(this.getFeatureValue(n, n2));
    }

    public float getFloatValue(int n) {
        return Float.intBitsToFloat(this.heap.heap[n]);
    }

    public static final float int2float(int n) {
        return Float.intBitsToFloat(n);
    }

    public static final int float2int(float f) {
        return Float.floatToIntBits(f);
    }

    public TypeSystemImpl getTypeSystemImpl() {
        return this.ts;
    }

    public String getStringForCode(int n) {
        return this.stringHeap.getStringForCode(n);
    }

    final boolean isCreatableType(int n) {
        return this.creatableType[n];
    }

    boolean isBuiltinType(Type type) {
        return type.getName().startsWith("uima");
    }

    int addString(String string) {
        return this.stringHeap.addString(string);
    }

    public boolean isStringType(Type type) {
        return this.ts.subsumes(this.stringType, type);
    }

    public boolean isAbstractArrayType(Type type) {
        return this.ts.subsumes(this.arrayBaseType, type);
    }

    public boolean isArrayType(Type type) {
        return type == this.fsArrayType || type == this.intArrayType || type == this.floatArrayType || type == this.stringArrayType;
    }

    public boolean isIntArrayType(Type type) {
        return type == this.intArrayType;
    }

    public boolean isFloatArrayType(Type type) {
        return type == this.floatArrayType;
    }

    public boolean isStringArrayType(Type type) {
        return type == this.stringArrayType;
    }

    public boolean isFSArrayType(Type type) {
        return type == this.fsArrayType;
    }

    public boolean isIntType(Type type) {
        return type == this.intType;
    }

    public boolean isFloatType(Type type) {
        return type == this.floatType;
    }

    public boolean isStringType(int n) {
        return this.ts.subsumes(this.stringType.getCode(), n);
    }

    public boolean isAbstractArrayType(int n) {
        return this.ts.subsumes(this.arrayBaseType.getCode(), n);
    }

    public boolean isArrayType(int n) {
        return n == this.fsArrayType.getCode() || n == this.intArrayType.getCode() || n == this.floatArrayType.getCode() || n == this.stringArrayType.getCode();
    }

    public boolean isIntArrayType(int n) {
        return n == this.intArrayType.getCode();
    }

    public boolean isFloatArrayType(int n) {
        return n == this.floatArrayType.getCode();
    }

    public boolean isStringArrayType(int n) {
        return n == this.stringArrayType.getCode();
    }

    public boolean isFSArrayType(int n) {
        return n == this.fsArrayType.getCode();
    }

    public boolean isIntType(int n) {
        return n == this.intType.getCode();
    }

    public boolean isFloatType(int n) {
        return n == this.floatType.getCode();
    }

    public Heap getHeap() {
        return this.heap;
    }

    public int getFeatureOffset(int n) {
        if (n < 1 || n >= this.featureOffset.length) {
            return -1;
        }
        return this.featureOffset[n];
    }

    public void redoTypeSystemSetup() {
        this.computeFeatureOffsets();
        int n = this.ts.getNumberOfTypes();
        this.fsSpaceReq = new int[n + 1];
        for (int i = 1; i <= n; ++i) {
            this.fsSpaceReq[i] = this.ts.getAppropriateFeatures(i).length + 1;
        }
        this.initCreatableTypeTable();
    }

    private final void computeFeatureOffsets() {
        int n = this.ts.getNumberOfFeatures();
        this.featureOffset = new int[n + 1];
        Type type = this.ts.getTopType();
        this.computeFeatureOffsets(type, 0);
    }

    private final void computeFeatureOffsets(Type type, int n) {
        int n2;
        List list = type.getFeatures();
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        int n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Feature feature = (Feature)list.get(n2);
            if (feature.getDomain() != type) continue;
            arrayList.add(feature);
        }
        int n4 = arrayList.size();
        for (int i = 0; i < n4; ++i) {
            n2 = ((FeatureImpl)arrayList.get(i)).getCode();
            this.featureOffset[n2] = n + 1 + i;
        }
        Vector vector = this.ts.getDirectlySubsumedTypes(type);
        int n5 = vector.size();
        for (int i = 0; i < n5; ++i) {
            this.computeFeatureOffsets((Type)vector.get(i), n + n4);
        }
    }

    private void setupTSDefault() {
        CASImpl.setupTSDefault(this.ts);
        this.redoTypeSystemSetup();
    }

    public static void setupTSDefault(TypeSystemImpl typeSystemImpl) {
        Type type = typeSystemImpl.addTopType("uima.cas.TOP");
        Type type2 = typeSystemImpl.addType("uima.cas.Integer", type);
        Type type3 = typeSystemImpl.addType("uima.cas.Float", type);
        Type type4 = typeSystemImpl.addType("uima.cas.String", type);
        Type type5 = typeSystemImpl.addType("uima.cas.ArrayBase", type);
        TypeImpl typeImpl = (TypeImpl)typeSystemImpl.addType("uima.cas.FSArray", type5);
        TypeImpl typeImpl2 = (TypeImpl)typeSystemImpl.addType("uima.cas.FloatArray", type5);
        TypeImpl typeImpl3 = (TypeImpl)typeSystemImpl.addType("uima.cas.IntegerArray", type5);
        TypeImpl typeImpl4 = (TypeImpl)typeSystemImpl.addType("uima.cas.StringArray", type5);
        Type type6 = typeSystemImpl.addType("uima.cas.ListBase", type);
        Type type7 = typeSystemImpl.addType("uima.cas.FSList", type6);
        Type type8 = typeSystemImpl.addType("uima.cas.EmptyFSList", type7);
        Type type9 = typeSystemImpl.addType("uima.cas.NonEmptyFSList", type7);
        typeSystemImpl.addFeature("head", type9, type);
        typeSystemImpl.addFeature("tail", type9, type7);
        Type type10 = typeSystemImpl.addType("uima.cas.FloatList", type6);
        Type type11 = typeSystemImpl.addType("uima.cas.EmptyFloatList", type10);
        Type type12 = typeSystemImpl.addType("uima.cas.NonEmptyFloatList", type10);
        typeSystemImpl.addFeature("head", type12, type3);
        typeSystemImpl.addFeature("tail", type12, type10);
        Type type13 = typeSystemImpl.addType("uima.cas.IntegerList", type6);
        Type type14 = typeSystemImpl.addType("uima.cas.EmptyIntegerList", type13);
        Type type15 = typeSystemImpl.addType("uima.cas.NonEmptyIntegerList", type13);
        typeSystemImpl.addFeature("head", type15, type2);
        typeSystemImpl.addFeature("tail", type15, type13);
        Type type16 = typeSystemImpl.addType("uima.cas.StringList", type6);
        Type type17 = typeSystemImpl.addType("uima.cas.EmptyStringList", type16);
        Type type18 = typeSystemImpl.addType("uima.cas.NonEmptyStringList", type16);
        typeSystemImpl.addFeature("head", type18, type4);
        typeSystemImpl.addFeature("tail", type18, type16);
        Type type19 = typeSystemImpl.addType("uima.cas.Sofa", type);
        typeSystemImpl.addFeature("sofaNum", type19, type2);
        typeSystemImpl.addFeature("sofaID", type19, type4);
        typeSystemImpl.addFeature("mimeType", type19, type4);
        typeSystemImpl.addFeature("sofaArray", type19, type);
        typeSystemImpl.addFeature("sofaString", type19, type4);
        typeSystemImpl.addFeature("sofaURI", type19, type4);
        Type type20 = typeSystemImpl.addType("uima.tcas.Annotation", type);
        typeSystemImpl.addFeature("sofa", type20, type2);
        typeSystemImpl.addFeature("begin", type20, type2);
        typeSystemImpl.addFeature("end", type20, type2);
        Type type21 = typeSystemImpl.addType("uima.tcas.DocumentAnnotation", type20);
        typeSystemImpl.addFeature("language", type21, type4);
        CASImpl.setTypeFinal(type2);
        CASImpl.setTypeFinal(type3);
        CASImpl.setTypeFinal(type4);
        ((TypeImpl)type).setFeatureFinal();
        CASImpl.setTypeFinal(type5);
        CASImpl.setTypeFinal(typeImpl);
        CASImpl.setTypeFinal(typeImpl3);
        CASImpl.setTypeFinal(typeImpl2);
        CASImpl.setTypeFinal(typeImpl4);
        CASImpl.setTypeFinal(type19);
        ((TypeImpl)type6).setFeatureFinal();
        ((TypeImpl)type7).setFeatureFinal();
        ((TypeImpl)type8).setFeatureFinal();
        ((TypeImpl)type9).setFeatureFinal();
        ((TypeImpl)type10).setFeatureFinal();
        ((TypeImpl)type11).setFeatureFinal();
        ((TypeImpl)type12).setFeatureFinal();
        ((TypeImpl)type13).setFeatureFinal();
        ((TypeImpl)type14).setFeatureFinal();
        ((TypeImpl)type15).setFeatureFinal();
        ((TypeImpl)type16).setFeatureFinal();
        ((TypeImpl)type17).setFeatureFinal();
        ((TypeImpl)type18).setFeatureFinal();
        ((TypeImpl)type20).setFeatureFinal();
    }

    private static void setTypeFinal(Type type) {
        TypeImpl typeImpl = (TypeImpl)type;
        typeImpl.setFeatureFinal();
        typeImpl.setInheritanceFinal();
    }

    public void initCASIndexes() throws CASException {
        if (null == this.ts.getType("uima.cas.Sofa")) {
            throw new CASException(10);
        }
        if (this.annotIndexInitialized) {
            return;
        }
        FSIndexComparator fSIndexComparator = this.indexRepository.createComparator();
        fSIndexComparator.setType(this.ts.getType("uima.cas.Sofa"));
        fSIndexComparator.addKey(this.ts.getFeatureByFullName("uima.cas.Sofa:sofaNum"), 0);
        this.indexRepository.createIndex(fSIndexComparator, "SofaIndex", 1);
        fSIndexComparator = this.indexRepository.createComparator();
        fSIndexComparator.setType(this.ts.getType("uima.tcas.Annotation"));
        fSIndexComparator.addKey(this.ts.getFeatureByFullName("uima.tcas.Annotation:begin"), 0);
        fSIndexComparator.addKey(this.ts.getFeatureByFullName("uima.tcas.Annotation:end"), 1);
        fSIndexComparator.addKey(this.indexRepository.getDefaultTypeOrder(), 0);
        this.indexRepository.createIndex(fSIndexComparator, "AnnotationIndex");
    }

    ArrayList getStringTable() {
        return this.baseCAS.getStringList();
    }

    public TCAS getTCAS(SofaFS sofaFS) {
        String string;
        Feature feature;
        TCASImpl tCASImpl = (TCASImpl)this.sofa2tcasMap.get(new Integer(sofaFS.getSofaRef()));
        if (null == tCASImpl) {
            tCASImpl = new TCASImpl(this.baseCAS, sofaFS);
            this.sofa2tcasMap.put(new Integer(sofaFS.getSofaRef()), tCASImpl);
            if (this.baseCAS.sofaCount < sofaFS.getSofaRef()) {
                this.baseCAS.sofaCount = sofaFS.getSofaRef();
                feature = this.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaID");
                string = this.getLowLevelCAS().ll_getStringValue(sofaFS.hashCode(), ((FeatureImpl)feature).getCode());
                if (this.baseCAS.sofaNameSet.contains(string)) {
                    CASRuntimeException cASRuntimeException = new CASRuntimeException(19);
                    cASRuntimeException.addArgument(string);
                    throw cASRuntimeException;
                }
                this.baseCAS.sofaNameSet.add(string);
            }
        }
        if (this.baseCAS.sofaCount < sofaFS.getSofaRef()) {
            this.baseCAS.sofaCount = sofaFS.getSofaRef();
            feature = this.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaID");
            string = this.getLowLevelCAS().ll_getStringValue(sofaFS.hashCode(), ((FeatureImpl)feature).getCode());
            if (this.baseCAS.sofaNameSet.contains(string)) {
                CASRuntimeException cASRuntimeException = new CASRuntimeException(19);
                cASRuntimeException.addArgument(string);
                throw cASRuntimeException;
            }
            this.baseCAS.sofaNameSet.add(string);
        }
        return tCASImpl;
    }

    public TCAS getTCAS(int n) {
        SofaFS sofaFS = this.getSofa(n);
        return this.getTCAS(sofaFS);
    }

    public TCAS getTCAS() {
        if (this.defaultTCas == null) {
            this.defaultTCas = this.baseCAS.sofaNameSet.contains("_DefaultTextSofaName") ? (TCASImpl)this.getTCAS(this.getSofa("_DefaultTextSofaName")) : (TCASImpl)this.getTCAS(this.createSofa("_DefaultTextSofaName", "text"));
        }
        return this.defaultTCas;
    }

    public JCas getJCas() throws CASException {
        if (this.jcas == null) {
            this.jcas = JCas.getJCas(this);
        }
        return this.jcas;
    }

    public JCas getJCas(SofaFS sofaFS) throws CASException {
        JCas jCas;
        if (this.baseCAS.jcas == null) {
            this.baseCAS.jcas = JCas.getJCas(this.baseCAS);
        }
        if (null != (jCas = (JCas)this.baseCAS.sofa2jcasMap.get(new Integer(sofaFS.getSofaRef())))) {
            return jCas;
        }
        TCASImpl tCASImpl = (TCASImpl)this.getTCAS(sofaFS);
        jCas = tCASImpl.getJCas(this.jcas);
        this.sofa2jcasMap.put(new Integer(sofaFS.getSofaRef()), jCas);
        return jCas;
    }

    public LowLevelTypeSystem ll_getTypeSystem() {
        return this.ts.getLowLevelTypeSystem();
    }

    public LowLevelIndexRepository ll_getIndexRepository() {
        return this.indexRepository;
    }

    private final void checkLowLevelParams(int n, int n2, int n3, int n4) {
        this.checkTypeAt(n2, n);
        this.checkFeature(n4);
        this.checkTypingConditions(n2, n3, n4);
    }

    private final void checkLowLevelParams(int n, int n2, int n3) {
        this.checkTypeAt(n2, n);
        this.checkFeature(n3);
        this.checkDomTypeConditions(n2, n3);
    }

    private final void checkDomTypeConditions(int n, int n2) {
        if (!this.ts.isApprop(n, n2)) {
            LowLevelException lowLevelException = new LowLevelException(3);
            lowLevelException.addArgument(Integer.toString(n));
            lowLevelException.addArgument(this.ts.ll_getTypeForCode(n).getName());
            lowLevelException.addArgument(Integer.toString(n2));
            lowLevelException.addArgument(this.ts.ll_getFeatureForCode(n2).getName());
            throw lowLevelException;
        }
    }

    public final void checkTypingConditions(Type type, Type type2, Feature feature) {
        this.checkTypingConditions(((TypeImpl)type).getCode(), ((TypeImpl)type2).getCode(), ((FeatureImpl)feature).getCode());
    }

    private final void checkTypingConditions(int n, int n2, int n3) {
        this.checkDomTypeConditions(n, n3);
        if (!this.ts.subsumes(this.ts.range(n3), n2)) {
            LowLevelException lowLevelException = new LowLevelException(4);
            lowLevelException.addArgument(Integer.toString(n3));
            lowLevelException.addArgument(this.ts.ll_getFeatureForCode(n3).getName());
            lowLevelException.addArgument(Integer.toString(n2));
            lowLevelException.addArgument(this.ts.ll_getTypeForCode(n2).getName());
            throw lowLevelException;
        }
    }

    private final void checkFsRan(int n) throws LowLevelException {
        int n2 = this.ts.range(n);
        if (!this.ll_isRefType(n2)) {
            LowLevelException lowLevelException = new LowLevelException(5);
            lowLevelException.addArgument(Integer.toString(n));
            lowLevelException.addArgument(this.ts.ll_getFeatureForCode(n).getName());
            lowLevelException.addArgument(this.ts.ll_getTypeForCode(n2).getName());
            throw lowLevelException;
        }
    }

    private final void checkFeature(int n) {
        if (!this.ts.isFeature(n)) {
            LowLevelException lowLevelException = new LowLevelException(2);
            lowLevelException.addArgument(Integer.toString(n));
            throw lowLevelException;
        }
    }

    private final void checkTypeAt(int n, int n2) {
        if (!this.ts.isType(n)) {
            LowLevelException lowLevelException = new LowLevelException(1);
            lowLevelException.addArgument(Integer.toString(n));
            lowLevelException.addArgument(Integer.toString(n2));
            throw lowLevelException;
        }
    }

    final void checkFsRef(int n) {
        if (n <= 0 || n >= this.heap.heap.length) {
            LowLevelException lowLevelException = new LowLevelException(0);
            lowLevelException.addArgument(Integer.toString(n));
            throw lowLevelException;
        }
    }

    final boolean isFSRefType(int n) {
        return this.ll_isRefType(n);
    }

    public final boolean ll_isRefType(int n) {
        if (n == this.intTypeCode || n == this.floatTypeCode || n == this.stringTypeCode) {
            return false;
        }
        return !this.ll_getTypeSystem().ll_isStringSubtype(n);
    }

    public final int ll_getTypeClass(int n) {
        if (n == this.intTypeCode) {
            return 1;
        }
        if (n == this.floatTypeCode) {
            return 2;
        }
        if (this.ts.subsumes(this.stringTypeCode, n)) {
            return 3;
        }
        if (n == this.intArrayTypeCode) {
            return 4;
        }
        if (n == this.floatArrayTypeCode) {
            return 5;
        }
        if (n == this.stringArrayTypeCode) {
            return 6;
        }
        if (n == this.fsArrayTypeCode) {
            return 7;
        }
        return 8;
    }

    public int createTempFS(int n) {
        return this.ll_createFS(n);
    }

    public final int ll_createFS(int n) {
        return this.heap.addToTempHeap(this.fsSpaceReq[n], n);
    }

    public final int ll_createFS(int n, boolean bl) {
        if (!(!bl || this.ts.isType(n) && this.isCreatableType(n))) {
            LowLevelException lowLevelException = new LowLevelException(8);
            lowLevelException.addArgument(Integer.toString(n));
            throw lowLevelException;
        }
        return this.ll_createFS(n);
    }

    public int createTempArray(int n, int n2) {
        int n3 = this.heap.addToTempHeap(2 + n2, n);
        this.heap.heap[n3 + 1] = n2;
        return n3;
    }

    public int ll_createArray(int n, int n2) {
        int n3 = this.heap.addToTempHeap(2 + n2, n);
        this.heap.heap[n3 + 1] = n2;
        return n3;
    }

    public int ll_createArray(int n, int n2, boolean bl) {
        if (bl) {
            if (!this.ts.isType(n)) {
                LowLevelException lowLevelException = new LowLevelException(12);
                lowLevelException.addArgument(Integer.toString(n));
                throw lowLevelException;
            }
            if (!this.isCreatableArrayType(n)) {
                LowLevelException lowLevelException = new LowLevelException(10);
                lowLevelException.addArgument(Integer.toString(n));
                lowLevelException.addArgument(this.ts.ll_getTypeForCode(n).getName());
                throw lowLevelException;
            }
            if (n2 < 0) {
                LowLevelException lowLevelException = new LowLevelException(11);
                lowLevelException.addArgument(Integer.toString(n2));
                throw lowLevelException;
            }
        }
        return this.ll_createArray(n, n2);
    }

    private final boolean isCreatableArrayType(int n) {
        int n2 = this.ll_getTypeClass(n);
        return n2 == 4 || n2 == 5 || n2 == 6 || n2 == 7;
    }

    public final int ll_getFSRef(FeatureStructure featureStructure) {
        if (null == featureStructure) {
            return 0;
        }
        return ((FeatureStructureImpl)featureStructure).getAddress();
    }

    public FeatureStructure ll_getFSForRef(int n) {
        return this.fsClassReg.createFS(n, this);
    }

    public final int ll_getIntValue(int n, int n2) {
        return this.heap.heap[n + this.featureOffset[n2]];
    }

    public final float ll_getFloatValue(int n, int n2) {
        return CASImpl.int2float(this.ll_getIntValue(n, n2));
    }

    public final String ll_getStringValue(int n, int n2) {
        return this.stringHeap.getStringForCode(this.ll_getIntValue(n, n2));
    }

    public final int ll_getRefValue(int n, int n2) {
        return this.ll_getIntValue(n, n2);
    }

    public final int ll_getIntValue(int n, int n2, boolean bl) {
        if (bl) {
            this.checkFsRef(n);
            int n3 = this.heap.heap[n];
            this.checkLowLevelParams(n, n3, this.intTypeCode, n2);
            this.checkFsRef(n + this.featureOffset[n2]);
        }
        return this.ll_getIntValue(n, n2);
    }

    public final float ll_getFloatValue(int n, int n2, boolean bl) {
        if (bl) {
            this.checkFsRef(n);
            int n3 = this.heap.heap[n];
            this.checkLowLevelParams(n, n3, this.floatTypeCode, n2);
            this.checkFsRef(n + this.featureOffset[n2]);
        }
        return this.ll_getFloatValue(n, n2);
    }

    public final String ll_getStringValue(int n, int n2, boolean bl) {
        if (bl) {
            this.checkFsRef(n);
            int n3 = this.heap.heap[n];
            this.checkLowLevelParams(n, n3, this.stringTypeCode, n2);
            this.checkFsRef(n + this.featureOffset[n2]);
        }
        return this.ll_getStringValue(n, n2);
    }

    public final int ll_getRefValue(int n, int n2, boolean bl) {
        if (bl) {
            this.checkFsRef(n);
            int n3 = this.heap.heap[n];
            this.checkLowLevelParams(n, n3, n2);
            this.checkFsRan(n2);
            this.checkFsRef(n + this.featureOffset[n2]);
        }
        return this.ll_getIntValue(n, n2);
    }

    public final void ll_setIntValue(int n, int n2, int n3) {
        this.heap.heap[n + this.featureOffset[n2]] = n3;
    }

    public final void ll_setFloatValue(int n, int n2, float f) {
        this.heap.heap[n + this.featureOffset[n2]] = CASImpl.float2int(f);
    }

    public final void ll_setStringValue(int n, int n2, String string) {
        int n3;
        this.heap.heap[n + this.featureOffset[n2]] = n3 = string == null ? 0 : this.stringHeap.addString(string);
    }

    public final void ll_setRefValue(int n, int n2, int n3) {
        this.heap.heap[n + this.featureOffset[n2]] = n3;
    }

    public final void ll_setIntValue(int n, int n2, int n3, boolean bl) {
        if (bl) {
            this.checkFsRef(n);
            int n4 = this.heap.heap[n];
            this.checkLowLevelParams(n, n4, this.intTypeCode, n2);
            this.checkFsRef(n + this.featureOffset[n2]);
        }
        this.ll_setIntValue(n, n2, n3);
    }

    public final void ll_setFloatValue(int n, int n2, float f, boolean bl) {
        if (bl) {
            this.checkFsRef(n);
            int n3 = this.heap.heap[n];
            this.checkLowLevelParams(n, n3, this.floatTypeCode, n2);
            this.checkFsRef(n + this.featureOffset[n2]);
        }
        this.ll_setFloatValue(n, n2, f);
    }

    public final void ll_setStringValue(int n, int n2, String string, boolean bl) {
        if (bl) {
            this.checkFsRef(n);
            int n3 = this.heap.heap[n];
            this.checkLowLevelParams(n, n3, this.stringTypeCode, n2);
            this.checkFsRef(n + this.featureOffset[n2]);
        }
        this.ll_setStringValue(n, n2, string);
    }

    public final void ll_setCharBufferValue(int n, int n2, char[] cArray, int n3, int n4, boolean bl) {
        if (bl) {
            this.checkFsRef(n);
            int n5 = this.heap.heap[n];
            this.checkLowLevelParams(n, n5, this.stringTypeCode, n2);
            this.checkFsRef(n + this.featureOffset[n2]);
        }
        this.ll_setCharBufferValue(n, n2, cArray, n3, n4);
    }

    public final void ll_setCharBufferValue(int n, int n2, char[] cArray, int n3, int n4) {
        int n5 = this.stringHeap.addCharBuffer(cArray, n3, n4);
        this.ll_setIntValue(n, n2, n5);
    }

    public int ll_copyCharBufferValue(int n, int n2, char[] cArray, int n3) {
        int n4 = this.ll_getIntValue(n, n2);
        if (n4 == 0) {
            return -1;
        }
        return this.stringHeap.copyCharsToBuffer(n4, cArray, n3);
    }

    public int ll_getCharBufferValueSize(int n, int n2) {
        int n3 = this.ll_getIntValue(n, n2);
        if (n3 == 0) {
            return -1;
        }
        return this.stringHeap.getCharArrayLength(n3);
    }

    public final void ll_setRefValue(int n, int n2, int n3, boolean bl) {
        if (bl) {
            this.checkFsRef(n);
            int n4 = this.heap.heap[n];
            this.checkLowLevelParams(n, n4, n2);
            this.checkFsRan(n2);
            this.checkFsRef(n + this.featureOffset[n2]);
            this.checkFsRef(n3);
        }
        this.ll_setRefValue(n, n2, n3);
    }

    public final int ll_getIntArrayValue(int n, int n2) {
        int n3 = this.getArrayStartAddress(n) + n2;
        return this.heap.heap[n3];
    }

    public final float ll_getFloatArrayValue(int n, int n2) {
        int n3 = this.getArrayStartAddress(n) + n2;
        return CASImpl.int2float(this.heap.heap[n3]);
    }

    public final String ll_getStringArrayValue(int n, int n2) {
        int n3 = this.getArrayStartAddress(n) + n2;
        return this.getStringForCode(this.heap.heap[n3]);
    }

    public final int ll_getRefArrayValue(int n, int n2) {
        int n3 = this.getArrayStartAddress(n) + n2;
        return this.heap.heap[n3];
    }

    private final void checkTypeSubsumptionAt(int n, int n2) {
        if (!this.ts.subsumes(n2, this.ll_getFSRefType(n))) {
            LowLevelException lowLevelException = new LowLevelException(6);
            lowLevelException.addArgument(Integer.toString(n));
            lowLevelException.addArgument(Integer.toString(n2));
            lowLevelException.addArgument(this.ts.ll_getTypeForCode(n2).getName());
            lowLevelException.addArgument(this.ts.ll_getTypeForCode(this.ll_getFSRefType(n)).getName());
            throw lowLevelException;
        }
    }

    public final void checkArrayBounds(int n, int n2) {
        int n3 = this.getArraySize(n);
        if (n2 < 0 || n2 >= n3) {
            LowLevelException lowLevelException = new LowLevelException(7);
            lowLevelException.addArgument(Integer.toString(n2));
            throw lowLevelException;
        }
    }

    private final void checkArrayConditions(int n, int n2, int n3) {
        this.checkTypeSubsumptionAt(n, n2);
        this.checkFsRef(this.getArrayStartAddress(n) + n3);
        this.checkArrayBounds(n, n3);
    }

    public final int ll_getIntArrayValue(int n, int n2, boolean bl) {
        if (bl) {
            this.checkArrayConditions(n, this.intArrayTypeCode, n2);
        }
        return this.ll_getIntArrayValue(n, n2);
    }

    public float ll_getFloatArrayValue(int n, int n2, boolean bl) {
        if (bl) {
            this.checkArrayConditions(n, this.floatArrayTypeCode, n2);
        }
        return this.ll_getFloatArrayValue(n, n2);
    }

    public String ll_getStringArrayValue(int n, int n2, boolean bl) {
        if (bl) {
            this.checkArrayConditions(n, this.stringArrayTypeCode, n2);
        }
        return this.ll_getStringArrayValue(n, n2);
    }

    public int ll_getRefArrayValue(int n, int n2, boolean bl) {
        if (bl) {
            this.checkArrayConditions(n, this.fsArrayTypeCode, n2);
        }
        return this.ll_getRefArrayValue(n, n2);
    }

    public void ll_setIntArrayValue(int n, int n2, int n3, boolean bl) {
        if (bl) {
            this.checkArrayConditions(n, this.intArrayTypeCode, n2);
        }
        this.ll_setIntArrayValue(n, n2, n3);
    }

    public void ll_setFloatArrayValue(int n, int n2, float f, boolean bl) {
        if (bl) {
            this.checkArrayConditions(n, this.floatArrayTypeCode, n2);
        }
        this.ll_setFloatArrayValue(n, n2, f);
    }

    public void ll_setStringArrayValue(int n, int n2, String string, boolean bl) {
        if (bl) {
            this.checkArrayConditions(n, this.stringArrayTypeCode, n2);
        }
        this.ll_setStringArrayValue(n, n2, string);
    }

    public void ll_setRefArrayValue(int n, int n2, int n3, boolean bl) {
        if (bl) {
            this.checkArrayConditions(n, this.fsArrayTypeCode, n2);
            this.checkFsRef(n3);
        }
        this.ll_setRefArrayValue(n, n2, n3);
    }

    public void ll_setIntArrayValue(int n, int n2, int n3) {
        int n4 = this.getArrayStartAddress(n) + n2;
        this.heap.heap[n4] = n3;
    }

    public void ll_setFloatArrayValue(int n, int n2, float f) {
        int n3 = this.getArrayStartAddress(n) + n2;
        this.heap.heap[n3] = CASImpl.float2int(f);
    }

    public void ll_setStringArrayValue(int n, int n2, String string) {
        int n3;
        int n4 = this.getArrayStartAddress(n) + n2;
        this.heap.heap[n4] = n3 = string == null ? 0 : this.addString(string);
    }

    public void ll_setRefArrayValue(int n, int n2, int n3) {
        int n4 = this.getArrayStartAddress(n) + n2;
        this.heap.heap[n4] = n3;
    }

    public int ll_getFSRefType(int n) {
        return this.heap.heap[n];
    }

    public int ll_getFSRefType(int n, boolean bl) {
        if (bl) {
            this.checkFsRef(n);
            this.checkTypeAt(this.ll_getFSRefType(n), n);
        }
        return this.ll_getFSRefType(n);
    }

    public LowLevelCAS getLowLevelCAS() {
        return this;
    }

    public int size() {
        return this.heap.heap.length * 6;
    }

    public ClassLoader getJCasClassLoader() {
        if (this != this.baseCAS) {
            return this.baseCAS.getJCasClassLoader();
        }
        return this.jcasClassLoader;
    }

    public void setJCasClassLoader(ClassLoader classLoader) {
        this.jcasClassLoader = classLoader;
    }

    public FeatureValuePath createFeatureValuePath(String string) throws CASRuntimeException {
        return FeatureValuePathImpl.getFeaturePath(string);
    }

    static {
        new DebugNameValuePair(null, null);
        new DebugFSLogicalStructure();
        nonCreatableTypes = new String[]{"uima.cas.Integer", "uima.cas.Float", "uima.cas.String", "uima.cas.ArrayBase", "uima.cas.FSArray", "uima.cas.IntegerArray", "uima.cas.FloatArray", "uima.cas.StringArray", "uima.cas.Sofa"};
    }
}

