/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.cas.ArrayFS;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FeatureStructureImplC;

public class ArrayFSImpl
extends FeatureStructureImplC
implements ArrayFS {
    private ArrayFSImpl() {
    }

    public ArrayFSImpl(int n, CASImpl cASImpl) {
        super(cASImpl, n);
    }

    public int size() {
        return this.getCASImpl().getArraySize(this.getAddress());
    }

    public FeatureStructure get(int n) {
        if (n < 0 || n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.casImpl.createFS(this.casImpl.getArrayValue(this.addr, n));
    }

    public void set(int n, FeatureStructure featureStructure) throws ArrayIndexOutOfBoundsException {
        this.casImpl.setArrayValue(this.addr, n, this.getCASImpl().ll_getFSRef(featureStructure));
    }

    public void copyFromArray(FeatureStructure[] featureStructureArray, int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n2 + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n2 += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < n3; ++i) {
            this.casImpl.heap.heap[n2] = this.getCASImpl().ll_getFSRef(featureStructureArray[n]);
            ++n2;
            ++n;
        }
    }

    public void copyToArray(int n, FeatureStructure[] featureStructureArray, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < n3; ++i) {
            featureStructureArray[n2] = this.casImpl.createFS(this.casImpl.heap.heap[n]);
            ++n2;
            ++n;
        }
    }

    public FeatureStructure[] toArray() {
        int n = this.size();
        FeatureStructure[] featureStructureArray = new FeatureStructure[n];
        this.copyToArray(0, featureStructureArray, 0, n);
        return featureStructureArray;
    }
}

