/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CASRuntimeException
extends RuntimeException {
    private static final String resource_file = "com.ibm.uima.cas.cas_runtime_exception";
    private static final String missing_resource_error = "Could not load message catalog: com.ibm.uima.cas.cas_runtime_exception";
    private static final int MESSAGES_NOT_FOUND = -1;
    public static final int NON_CREATABLE_TYPE = 0;
    public static final int ILLEGAL_ARRAY_SIZE = 1;
    public static final int INAPPROP_TYPE = 2;
    public static final int INAPPROP_FEAT = 3;
    public static final int INAPPROP_RANGE = 4;
    public static final int PRIMITIVE_VAL_FEAT = 5;
    public static final int TYPESYSTEM_NOT_LOCKED = 6;
    public static final int ILLEGAL_STRING_VALUE = 7;
    public static final int UNKNOWN_CONSTRAINT_TYPE = 8;
    public static final int UNKNOWN_CONSTRAINT_FEAT = 9;
    public static final int CHILD_INDEX_OOB = 10;
    public static final int JCAS_CAS_MISMATCH = 11;
    public static final int JCAS_TYPE_NOT_IN_CAS = 12;
    public static final int JCAS_UNKNOWN_TYPE_NOT_IN_CAS = 13;
    public static final int JCAS_GET_NTH_ON_EMPTY_LIST = 14;
    public static final int JCAS_GET_NTH_NEGATIVE_INDEX = 15;
    public static final int JCAS_GET_NTH_PAST_END = 16;
    public static final int JCAS_OLDSTYLE_REF_TO_NONJCAS_TYPE = 17;
    public static final int JCAS_MAKING_ABSTRACT_INSTANCE = 18;
    public static final int SOFANAME_ALREADY_EXISTS = 19;
    public static final int SOFADATA_ALREADY_SET = 20;
    public static final int SOFANAME_NOT_FOUND = 21;
    public static final int SOFAREF_NOT_FOUND = 22;
    public static final int PROTECTED_SOFA_FEATURE = 23;
    public static final int JCAS_MISSING_COVERCLASS = 24;
    public static final int INVALID_FEATURE_PATH = 25;
    public static final int NO_PRIMITIVE_TAIL = 26;
    public static final int BLOB_SERIALIZATION = 27;
    public static final int BLOB_DESERIALIZATION = 28;
    public static final int SOFADATASTREAM_ERROR = 29;
    public static final int JCAS_UNSUPPORTED_OP_NOT_TCAS = 30;
    private static final String[] identifiers = new String[]{"NON_CREATABLE_TYPE", "ILLEGAL_ARRAY_SIZE", "INAPPROP_TYPE", "INAPPROP_FEAT", "INAPPROP_RANGE", "PRIMITIVE_VAL_FEAT", "TYPESYSTEM_NOT_LOCKED", "ILLEGAL_STRING_VALUE", "UNKNOWN_CONSTRAINT_TYPE", "UNKNOWN_CONSTRAINT_FEAT", "CHILD_INDEX_OOB", "JCAS_CAS_MISMATCH", "JCAS_TYPE_NOT_IN_CAS", "JCAS_UNKNOWN_TYPE_NOT_IN_CAS", "JCAS_GET_NTH_ON_EMPTY_LIST", "JCAS_GET_NTH_NEGATIVE_INDEX", "JCAS_GET_NTH_PAST_END", "JCAS_OLDSTYLE_REF_TO_NONJCAS_TYPE", "JCAS_MAKING_ABSTRACT_INSTANCE", "SOFANAME_ALREADY_EXISTS", "SOFADATA_ALREADY_SET", "SOFANAME_NOT_FOUND", "SOFAREF_NOT_FOUND", "PROTECTED_SOFA_FEATURE", "JCAS_MISSING_COVERCLASS", "INVALID_FEATURE_PATH", "NO_PRIMITIVE_TAIL", "BLOB_SERIALIZATION", "BLOB_DESERIALIZATION", "SOFADATASTREAM_ERROR", "JCAS_UNSUPPORTED_OP_NOT_TCAS"};
    private int error;
    private ResourceBundle resource = null;
    private String[] arguments = new String[9];

    public CASRuntimeException(int n) {
        this.error = n;
    }

    public int getError() {
        return this.error;
    }

    public String getMessage() {
        if (this.resource == null) {
            try {
                this.resource = ResourceBundle.getBundle(resource_file);
            }
            catch (MissingResourceException missingResourceException) {
                this.error = -1;
                return missing_resource_error;
            }
        }
        return new MessageFormat(this.resource.getString(identifiers[this.error])).format(this.arguments);
    }

    public String toString() {
        return "CASRuntimeException: " + this.getMessage();
    }

    public boolean addArgument(String string) {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] != null) continue;
            this.arguments[i] = string;
            return true;
        }
        return false;
    }

    public String getMessageCode() {
        return identifiers[this.error];
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getBundleShortName() {
        if (resource_file.indexOf(46) >= 0) {
            return resource_file.substring(resource_file.lastIndexOf(46) + 1);
        }
        return resource_file;
    }

    public String getResourceBundleName() {
        return resource_file;
    }

    public String getMessageKey() {
        if (this.error >= 0 && this.error < identifiers.length) {
            return identifiers[this.error];
        }
        return null;
    }
}

