/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CASException
extends Exception {
    private static final String resource_file = "com.ibm.uima.cas.cas_exception";
    private static final String missing_resource_error = "Could not load message catalog: com.ibm.uima.cas.cas_exception";
    private static final int MESSAGES_NOT_FOUND = -1;
    public static final int INAPPROP_TYPE_EXCEPTION = 0;
    public static final int UNDEFINED_FEATURE = 1;
    public static final int CANT_CREATE_BUILTIN_FS = 2;
    public static final int NOT_A_STRING = 3;
    public static final int CYCLE_IN_TYPE_ORDER = 4;
    public static final int JCAS_INIT_ERROR = 5;
    public static final int JCAS_TYPENOTFOUND_ERROR = 6;
    public static final int JCAS_FEATURENOTFOUND_ERROR = 7;
    public static final int JCAS_FEATURE_WRONG_TYPE = 8;
    public static final int TYPEORDER_UNKNOWN_TYPE = 9;
    public static final int MUST_COMMIT_TYPE_SYSTEM = 10;
    private static final String[] identifiers = new String[]{"INAPPROP_TYPE_EXCEPTION", "UNDEFINED_FEATURE", "CANT_CREATE_BUILTIN_FS", "NOT_A_STRING", "CYCLE_IN_TYPE_ORDER", "JCAS_INIT_ERROR", "JCAS_TYPENOTFOUND_ERROR", "JCAS_FEATURENOTFOUND_ERROR", "JCAS_FEATURE_WRONG_TYPE", "TYPEORDER_UNKNOWN_TYPE", "MUST_COMMIT_TYPE_SYSTEM"};
    private int error;
    private ResourceBundle resource = null;
    private String[] arguments = new String[9];

    public CASException(int n) {
        this.error = n;
    }

    public int getError() {
        return this.error;
    }

    public String getMessage() {
        if (this.resource == null) {
            try {
                this.resource = ResourceBundle.getBundle(resource_file);
            }
            catch (MissingResourceException missingResourceException) {
                this.error = -1;
                return missing_resource_error;
            }
        }
        return new MessageFormat(this.resource.getString(identifiers[this.error])).format(this.arguments);
    }

    public String toString() {
        return "CASException: " + this.getMessage();
    }

    public boolean addArgument(String string) {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] != null) continue;
            this.arguments[i] = string;
            return true;
        }
        return false;
    }

    public String getMessageCode() {
        return identifiers[this.error];
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getBundleShortName() {
        if (resource_file.indexOf(46) >= 0) {
            return resource_file.substring(resource_file.lastIndexOf(46) + 1);
        }
        return resource_file;
    }

    public String getResourceBundleName() {
        return resource_file;
    }

    public String getMessageKey() {
        if (this.error >= 0 && this.error < identifiers.length) {
            return identifiers[this.error];
        }
        return null;
    }
}

