/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima;

import com.ibm.uima.InternationalizedException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class InternationalizedRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 6387360855459370559L;
    private String mResourceBundleName;
    private String mMessageKey;
    private Object[] mArguments;
    private Throwable mCause;

    public InternationalizedRuntimeException() {
        this(null, null, null, null);
    }

    public InternationalizedRuntimeException(Throwable throwable) {
        this(null, null, null, throwable);
    }

    public InternationalizedRuntimeException(String string, String string2, Object[] objectArray) {
        this(string, string2, objectArray, null);
    }

    public InternationalizedRuntimeException(String string, String string2, Object[] objectArray, Throwable throwable) {
        this.mCause = throwable;
        this.mResourceBundleName = string;
        this.mMessageKey = string2;
        this.mArguments = objectArray;
        if (this.mResourceBundleName == null && this.mMessageKey == null) {
            if (this.mCause instanceof InternationalizedException) {
                this.mResourceBundleName = ((InternationalizedException)this.mCause).getResourceBundleName();
                this.mMessageKey = ((InternationalizedException)this.mCause).getMessageKey();
                this.mArguments = ((InternationalizedException)this.mCause).getArguments();
            } else if (this.mCause instanceof InternationalizedRuntimeException) {
                this.mResourceBundleName = ((InternationalizedRuntimeException)this.mCause).getResourceBundleName();
                this.mMessageKey = ((InternationalizedRuntimeException)this.mCause).getMessageKey();
                this.mArguments = ((InternationalizedRuntimeException)this.mCause).getArguments();
            }
        }
    }

    public String getResourceBundleName() {
        return this.mResourceBundleName;
    }

    public String getMessageKey() {
        return this.mMessageKey;
    }

    public Object[] getArguments() {
        if (this.mArguments == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[this.mArguments.length];
        System.arraycopy(this.mArguments, 0, objectArray, 0, this.mArguments.length);
        return objectArray;
    }

    public String getMessage() {
        return this.getLocalizedMessage(Locale.ENGLISH);
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String getLocalizedMessage(Locale locale) {
        if (this.getMessageKey() == null) {
            return null;
        }
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this.getResourceBundleName(), locale);
            String string = resourceBundle.getString(this.getMessageKey());
            if (this.getArguments().length > 0) {
                MessageFormat messageFormat = new MessageFormat(string);
                messageFormat.setLocale(locale);
                return messageFormat.format(this.getArguments());
            }
            return string;
        }
        catch (Exception exception) {
            return "EXCEPTION MESSAGE LOCALIZATION FAILED: " + exception.toString();
        }
    }

    public Throwable getCause() {
        return this.mCause;
    }
}

