/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.supa.server.internal.client;

import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamz.supa.server.client.ISUPAServerClientLibrary;
import com.ibm.teamz.supa.server.common.v1.dto.IConfiguration;
import com.ibm.teamz.supa.server.common.v1.dto.ISearchResult;
import com.ibm.teamz.supa.server.messageClient.internal.SUPAServiceMessageClientLibrary;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUPAServerClientLibrary
extends SUPAServiceMessageClientLibrary
implements ISUPAServerClientLibrary {
    private ExecutorService asyncExecService;

    public SUPAServerClientLibrary(IClientLibraryContext context) {
        super(context);
    }

    public void login(int maxVersionSupported, String identifier) throws TeamRepositoryException {
        if (this.asyncExecService != null && !this.asyncExecService.isShutdown()) {
            this.asyncExecService.shutdown();
        }
        this.asyncExecService = Executors.newSingleThreadExecutor();
        super.login(maxVersionSupported, identifier);
    }

    public void logout() throws TeamRepositoryException {
        this.asyncExecService.shutdown();
        super.logout();
    }

    public void reportResults(Collection<ISearchResult> results, long queryId, boolean moreResultsPending) throws TeamRepositoryException {
        this.getService().reportResults(results, queryId, moreResultsPending);
    }

    @Override
    public boolean submitRunnable(Runnable command) {
        if (this.asyncExecService == null || this.asyncExecService.isShutdown()) {
            return false;
        }
        this.asyncExecService.execute(command);
        return true;
    }

    public void setConfigurations(Collection<IConfiguration> configurations) throws TeamRepositoryException {
        this.getService().setConfigurations(configurations);
    }

    public void removeConfiguration(String componentUUIDValue) throws TeamRepositoryException {
        this.getService().removeConfiguration(componentUUIDValue);
    }

    public void updateConfiguration(IConfiguration config) throws TeamRepositoryException {
        this.getService().updateConfiguration(config);
    }

    public void reportTermScores(String[] terms, double[] tfs, double[] idfs, long requestId) throws TeamRepositoryException {
        this.getService().reportTermScores(terms, tfs, idfs, requestId);
    }
}

