/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.jFrostAnnotator;

import com.ibm.dltj.CapMatrix;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.LangIDSession;
import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContext;
import com.ibm.uima.analysis_engine.annotator.AnnotatorInitializationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorProcessException;
import com.ibm.uima.analysis_engine.annotator.Annotator_ImplBase;
import com.ibm.uima.analysis_engine.annotator.TextAnnotator;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.jFrostAnnotator.Config;
import com.ibm.uima.jFrostAnnotator.LangIDAnalyzer;
import com.ibm.uima.jFrostAnnotator.LexicalAnalyzer;
import com.ibm.uima.jFrostAnnotator.Messages;
import com.ibm.uima.jFrostAnnotator.ResultHandler;
import com.ibm.uima.jFrostAnnotator.TypeSystemMgr;
import com.ibm.uima.util.Level;
import java.io.File;

public class jFrostAnnotator
extends Annotator_ImplBase
implements TextAnnotator {
    Config mConfig = new Config();
    TypeSystemMgr mTSMgr = new TypeSystemMgr();
    private LangIDSession mLIDSession = null;
    ResultHandler handler = null;
    private Dictionary langidDict = null;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public void initialize(AnnotatorContext annotatorContext) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        super.initialize(annotatorContext);
        this.mConfig.mContext = annotatorContext;
        this.mConfig.getConfigValues();
        this.mConfig.logDataPath();
        try {
            this.initFrost();
        }
        catch (Exception exception) {
            this.mConfig.mLogger.logrb(Level.SEVERE, ((Object)((Object)this)).getClass().getName(), "initFrost", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Error_during_Frost_initialization__SEVERE", (Throwable)exception);
            this.destroy();
            throw new AnnotatorInitializationException("com.ibm.uima.jFrostAnnotator.messages", "FROST_EXCEPTION_ENCOUNTERED__SEVERE", new Object[0], (Throwable)exception);
        }
    }

    public void reconfigure() throws AnnotatorConfigurationException, AnnotatorInitializationException {
        this.mConfig.getConfigValues();
        this.mConfig.mLastLanguage = "";
        this.initFrost();
    }

    public void destroy() {
    }

    private final void initFrost() throws AnnotatorInitializationException {
        try {
            if (!this.mConfig.mIsLangIDSession) {
                if (this.mConfig.mPreloadLanguageArray != null && this.mConfig.mPreloadLanguageArray.length > 0) {
                    this.mConfig.mLogger.logrb(Level.CONFIG, ((Object)((Object)this)).getClass().getName(), "initFrost", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Preloading_language_resources__CONFIG");
                    this.mConfig.doPreload();
                }
                this.handler = new LexicalAnalyzer(this.mConfig);
            } else {
                this.mLIDSession = new LangIDSession();
                this.langidDict = new Dictionary(this.getLangIDDictionaryFile());
                if (this.langidDict == null) {
                    throw new DLTException(Messages.getString("jFrostAnnotator.Cannot_Open_LangID_dict__SEVERE") + this.mConfig.mLangIDDict);
                }
                this.mLIDSession.unknownProcessing(this.mConfig.mUnknownProcessing);
                this.mLIDSession.setTieDelta(this.mConfig.mTieDelta);
                this.handler = new LangIDAnalyzer(this.mLIDSession);
            }
        }
        catch (Exception exception) {
            throw new AnnotatorInitializationException("com.ibm.uima.jFrostAnnotator.messages", "FROST_EXCEPTION_ENCOUNTERED__SEVERE", new Object[0], (Throwable)exception);
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        this.mTSMgr.typeSystemInit(typeSystem, this.mConfig.mIsLangIDSession);
    }

    public void process(TCAS tCAS, ResultSpecification resultSpecification) throws AnnotatorProcessException {
        this.handler.mDocumentTextString = tCAS.getDocumentText();
        if (this.handler.mDocumentTextString.length() == 0) {
            return;
        }
        if (this.mConfig.mIsLangIDSession) {
            if (!resultSpecification.containsFeature("uima.tcas.DocumentAnnotation:language")) {
                return;
            }
            ((LangIDAnalyzer)this.handler).init(this.mTSMgr, this.mConfig);
            ((LangIDAnalyzer)this.handler).process(tCAS);
        } else {
            boolean bl;
            String string = tCAS.getDocumentAnnotation().getStringValue(this.mTSMgr.mLanguageFeat);
            if (string.length() == 0) {
                return;
            }
            this.mConfig.normalizeLangName(string);
            boolean bl2 = bl = string.compareToIgnoreCase(this.mConfig.mLastLanguage) != 0;
            if (bl) {
                ((LexicalAnalyzer)this.handler).init(this.mTSMgr, this.mConfig, resultSpecification);
            }
            ((LexicalAnalyzer)this.handler).process(tCAS, bl);
        }
    }

    private File getLangIDDictionaryFile() {
        File file = null;
        try {
            CapMatrix.Entry entry = Config.cm.getEntryByFilename(this.mConfig.mLangIDDict);
            file = entry.getFile();
        }
        catch (DLTException dLTException) {
            // empty catch block
        }
        return file;
    }
}

