/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.jFrostAnnotator;

import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorInitializationException;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.impl.LowLevelTypeSystem;

public class TypeSystemMgr {
    private static boolean MANDATORY = true;
    private static boolean OPTIONAL = false;
    LowLevelTypeSystem mLLTypeSystem;
    int mSentenceTypeCode;
    int mParaTypeCode;
    int mCompoundPartTypeCode;
    int mTokenTypeCode;
    int mTokenPropsFeatCode;
    int mTokenNumFeatCode;
    int mSentenceNumFeatCode;
    int mParaNumFeatCode;
    int mStartFeatCode;
    int mEndFeatCode;
    int mLemmaListFeatCode;
    int mLemmaAtTokenFeatCode;
    int mSynonymListFeatCode;
    int mFrostTokenTypeFeatCode;
    int mTokenStopwordFeatCode;
    int mLemmaTypeCode;
    int mKeyFeatCode;
    int mPosFeatCode;
    int mIsLemmaStopwordCode;
    int mIsDeterminerCode;
    int mFrostConstraintsCode;
    int mFrostMorphBitMasksCode;
    int mFrostExtPosCode;
    int mFrostJPStartCode;
    int mFrostJKomCode;
    int mIntArrayTypeCode;
    int mDecompFeatCode;
    int mDecompAnalTypeCode;
    int mMWUTypeCode;
    int mDecompAnRouteFeatCode;
    int mDecompAnRouteAddr;
    int mDecompRouteAddr;
    int mCompoundTypeCode;
    int mStopwordTypeCode;
    int mBoostTypeCode;
    int mBoostValueFeatCode;
    int mQuerySynTypeCode;
    int mQuerySynSynArrayFeatCode;
    int mSpellCorrectionTypeCode;
    int mSpellSuggestionsFeatCode;
    int mFilePathTypeCode;
    int mEmailTypeCode;
    int mNumberTypeCode;
    int mURLTypeCode;
    int mDateTypeCode;
    int mTimeTypeCode;
    int mTelTypeCode;
    int mCurrencyTypeCode;
    int mAcronymTypeCode;
    int mHeadFeatCode;
    int mTailFeatCode;
    int mNeFsListTypeCode;
    int mEFsListTypeCode;
    int mStringArrayTypeCode;
    int mLanguageCandidatesFeatureCode;
    int mLanguageConfidencePairTypeCode;
    int mLanguageConfidencePairConfidenceFeatureCode;
    int mLanguageConfidencePairLanguageFeatureCode;
    int mSynonymTypeCode;
    Feature mLanguageFeat;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    protected int initTypeCode(String string, boolean bl) throws AnnotatorInitializationException {
        int n = this.mLLTypeSystem.ll_getCodeForTypeName(string);
        if (bl && n == 0) {
            throw new AnnotatorInitializationException("annotator_ex_type_not_found", new Object[]{this.getClass().getName(), string});
        }
        return n;
    }

    protected int initFeatureCode(String string, boolean bl) throws AnnotatorInitializationException {
        int n = this.mLLTypeSystem.ll_getCodeForFeatureName(string);
        if (bl && n == 0) {
            throw new AnnotatorInitializationException("annotator_ex_feature_not_found", new Object[]{this.getClass().getName(), string});
        }
        return n;
    }

    public void typeSystemInit(TypeSystem typeSystem, boolean bl) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        this.mLLTypeSystem = (LowLevelTypeSystem)typeSystem;
        if (!bl) {
            this.mCompoundTypeCode = this.initTypeCode("uima.tt.CompoundAnnotation", OPTIONAL);
            this.mStopwordTypeCode = this.initTypeCode("uima.tt.StopwordAnnotation", OPTIONAL);
            this.mQuerySynTypeCode = this.initTypeCode("uima.tt.SynonymAnnotation", OPTIONAL);
            this.mQuerySynSynArrayFeatCode = this.initFeatureCode("uima.tt.SynonymAnnotation:synonyms", this.mQuerySynTypeCode != 0);
            this.mBoostTypeCode = this.initTypeCode("com.ibm.es.tt.BoostTermAnnotation", OPTIONAL);
            this.mBoostValueFeatCode = this.initFeatureCode("com.ibm.es.tt.BoostTermAnnotation:value", this.mBoostTypeCode != 0);
            this.mSpellCorrectionTypeCode = this.initTypeCode("uima.tt.SpellCorrectionAnnotation", OPTIONAL);
            this.mSpellSuggestionsFeatCode = this.initFeatureCode("uima.tt.SpellCorrectionAnnotation:correctionTerms", this.mSpellCorrectionTypeCode != 0);
            this.mMWUTypeCode = this.initTypeCode("com.ibm.dlt.uimatypes.MWU", OPTIONAL);
            this.mSentenceTypeCode = this.initTypeCode("uima.tt.SentenceAnnotation", MANDATORY);
            this.mParaTypeCode = this.initTypeCode("uima.tt.ParagraphAnnotation", MANDATORY);
            this.mCompoundPartTypeCode = this.initTypeCode("uima.tt.CompPartAnnotation", MANDATORY);
            this.mTokenTypeCode = this.initTypeCode("uima.tt.TokenAnnotation", MANDATORY);
            this.mTokenPropsFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:tokenProperties", OPTIONAL);
            this.mTokenNumFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:tokenNumber", OPTIONAL);
            this.mTokenStopwordFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:stopwordToken", OPTIONAL);
            this.mSynonymListFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:synonymEntries", OPTIONAL);
            this.mSynonymTypeCode = this.initTypeCode("uima.tt.Synonym", this.mSynonymListFeatCode != 0);
            this.mLemmaListFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:lemmaEntries", OPTIONAL);
            this.mLemmaAtTokenFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:lemma", MANDATORY);
            this.mLemmaTypeCode = this.initTypeCode("uima.tt.Lemma", MANDATORY);
            this.mKeyFeatCode = this.initFeatureCode("uima.tt.KeyStringEntry:key", MANDATORY);
            this.mPosFeatCode = this.initFeatureCode("uima.tt.Lemma:partOfSpeech", OPTIONAL);
            this.mFrostTokenTypeFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:frost_TokenType", OPTIONAL);
            this.mIsDeterminerCode = this.initFeatureCode("uima.tt.Lemma:isDeterminer", OPTIONAL);
            this.mIsLemmaStopwordCode = this.initFeatureCode("uima.tt.Lemma:isStopword", OPTIONAL);
            this.mFrostConstraintsCode = this.initFeatureCode("uima.tt.Lemma:frost_Constraints", OPTIONAL);
            this.mFrostMorphBitMasksCode = this.initFeatureCode("uima.tt.Lemma:frost_MorphBitMasks", OPTIONAL);
            this.mFrostExtPosCode = this.initFeatureCode("uima.tt.Lemma:frost_ExtendedPOS", OPTIONAL);
            this.mFrostJKomCode = this.initFeatureCode("uima.tt.Lemma:frost_JKom", OPTIONAL);
            this.mFrostJPStartCode = this.initFeatureCode("uima.tt.Lemma:frost_JPStart", OPTIONAL);
            this.mIntArrayTypeCode = this.initTypeCode("uima.cas.IntegerArray", MANDATORY);
            this.mSentenceNumFeatCode = this.initFeatureCode("uima.tt.SentenceAnnotation:sentenceNumber", OPTIONAL);
            this.mParaNumFeatCode = this.initFeatureCode("uima.tt.ParagraphAnnotation:paragraphNumber", OPTIONAL);
            this.mStartFeatCode = this.initFeatureCode("uima.tcas.Annotation:begin", MANDATORY);
            this.mEndFeatCode = this.initFeatureCode("uima.tcas.Annotation:end", MANDATORY);
            this.mDecompFeatCode = this.initFeatureCode("uima.tt.TokenAnnotation:decomposition", OPTIONAL);
            this.mDecompAnalTypeCode = this.initTypeCode("com.ibm.dlt.uimatypes.Decomp_Analysis", this.mDecompFeatCode != 0);
            this.mDecompAnRouteFeatCode = this.initFeatureCode("com.ibm.dlt.uimatypes.Decomp_Analysis:route", this.mDecompAnalTypeCode != 0);
            this.mFilePathTypeCode = this.initTypeCode("com.ibm.dlt.uimatypes.FilePath", OPTIONAL);
            this.mEmailTypeCode = this.initTypeCode("com.ibm.dlt.uimatypes.Email", OPTIONAL);
            this.mURLTypeCode = this.initTypeCode("com.ibm.dlt.uimatypes.URL", OPTIONAL);
            this.mNumberTypeCode = this.initTypeCode("com.ibm.dlt.uimatypes.Number", OPTIONAL);
            this.mDateTypeCode = this.initTypeCode("com.ibm.dlt.uimatypes.Date", OPTIONAL);
            this.mTimeTypeCode = this.initTypeCode("com.ibm.dlt.uimatypes.Time", OPTIONAL);
            this.mTelTypeCode = this.initTypeCode("com.ibm.dlt.uimatypes.Tel", OPTIONAL);
            this.mCurrencyTypeCode = this.initTypeCode("com.ibm.dlt.uimatypes.Currency", OPTIONAL);
            this.mAcronymTypeCode = this.initTypeCode("com.ibm.dlt.uimatypes.Acronym", OPTIONAL);
        } else {
            this.mLanguageCandidatesFeatureCode = this.initFeatureCode("uima.tcas.DocumentAnnotation:languageCandidates", MANDATORY);
            this.mLanguageConfidencePairTypeCode = this.initTypeCode("uima.tt.LanguageConfidencePair", MANDATORY);
            this.mLanguageConfidencePairConfidenceFeatureCode = this.initFeatureCode("uima.tt.LanguageConfidencePair:languageConfidence", MANDATORY);
            this.mLanguageConfidencePairLanguageFeatureCode = this.initFeatureCode("uima.tt.LanguageConfidencePair:language", MANDATORY);
        }
        this.mHeadFeatCode = this.initFeatureCode("uima.cas.NonEmptyFSList:head", MANDATORY);
        this.mTailFeatCode = this.initFeatureCode("uima.cas.NonEmptyFSList:tail", MANDATORY);
        this.mNeFsListTypeCode = this.initTypeCode("uima.cas.NonEmptyFSList", MANDATORY);
        this.mEFsListTypeCode = this.initTypeCode("uima.cas.EmptyFSList", MANDATORY);
        this.mStringArrayTypeCode = this.initTypeCode("uima.cas.StringArray", MANDATORY);
        this.mLanguageFeat = typeSystem.getFeatureByFullName("uima.tcas.DocumentAnnotation:language");
    }
}

