/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.jFrostAnnotator;

import com.ibm.dltj.CapMatrix;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.nondeterm.AdvancedLookupDriver;
import com.ibm.icu.text.Normalizer;
import com.ibm.uima.jFrostAnnotator.Config;
import java.io.File;
import java.util.ArrayList;

public class SpellSuggestionsCreator {
    private AdvancedLookupDriver mAdvancedLookupDriver = null;
    private String mQueryLanguage = "";
    private Dictionary[] mSpellMatchDicts = null;
    private Dictionary[] mTCRDicts = null;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public SpellSuggestionsCreator() {
    }

    public SpellSuggestionsCreator(String string, String[] stringArray, String[] stringArray2) throws Exception {
        this.setLanguageResources(string, stringArray, stringArray2);
    }

    public synchronized void setLanguageResources(String string, String[] stringArray, String[] stringArray2) throws Exception {
        this.mQueryLanguage = string;
        this.mSpellMatchDicts = this.getDictsFromAnnotatorCM(stringArray);
        this.mTCRDicts = this.getDictsFromAnnotatorCM(stringArray2);
        this.mAdvancedLookupDriver = new AdvancedLookupDriver(this.mSpellMatchDicts);
        this.mAdvancedLookupDriver.allowExactMatch = false;
        this.mAdvancedLookupDriver.extraRanking = true;
        this.mAdvancedLookupDriver.strictMWU = true;
        this.mAdvancedLookupDriver.doWhiteSpaces = true;
        this.mAdvancedLookupDriver.whiteSpaceTokenization = true;
        if (this.mQueryLanguage.equalsIgnoreCase("ja")) {
            this.mAdvancedLookupDriver.doKatakanaMiddleDot = true;
        }
    }

    public Suggestion[] getSuggestions(String string, int n) {
        Suggestion[] suggestionArray;
        if (this.mQueryLanguage.equalsIgnoreCase("ja")) {
            return new Suggestion[0];
        }
        if (this.mSpellMatchDicts == null || this.mSpellMatchDicts.length == 0 || this.mAdvancedLookupDriver == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return new Suggestion[0];
        }
        Suggestion suggestion = this.getSuggestionsForQuery(string, n);
        if (suggestion != null) {
            Suggestion[] suggestionArray2 = new Suggestion[1];
            suggestionArray = suggestionArray2;
            suggestionArray2[0] = suggestion;
        } else {
            suggestionArray = new Suggestion[]{};
        }
        return suggestionArray;
    }

    private synchronized Suggestion getSuggestionsForQuery(String string, int n) {
        String[] stringArray = this.getSuggestionsForString(string, n);
        return stringArray.length > 0 ? new Suggestion(stringArray, 0, 1) : null;
    }

    /*
     * Unable to fully structure code
     */
    private String[] getSuggestionsForString(String var1_1, int var2_2) {
        var3_3 = new ArrayList<String>();
        if (var1_1 == null || var1_1.equals("")) {
            return new String[0];
        }
        if (this.mTCRDicts == null || this.mTCRDicts.length == 0) {
            try {
                this.mAdvancedLookupDriver.obeyRules = false;
                var4_4 = this.mAdvancedLookupDriver.match(var1_1, 3, var2_2);
                if (var4_4 == null) ** GOTO lbl41
                for (var5_8 = 0; var5_8 < var4_4.length; ++var5_8) {
                    if (this.mQueryLanguage.equalsIgnoreCase("ja")) {
                        var6_11 = Normalizer.normalize((String)var4_4[var5_8], (Normalizer.Mode)Normalizer.NFKC);
                        var3_3.add(var6_11);
                        continue;
                    }
                    var3_3.add(var4_4[var5_8]);
                }
            }
            catch (DLTException var4_5) {}
        } else {
            for (var4_6 = 0; var4_6 < this.mTCRDicts.length; ++var4_6) {
                try {
                    this.mAdvancedLookupDriver.setRules(this.mTCRDicts[var4_6]);
                    var5_9 = this.mAdvancedLookupDriver.match(var1_1, 3, var2_2);
                    if (var5_9 == null) continue;
                    for (var6_12 = 0; var6_12 < var5_9.length; ++var6_12) {
                        if (this.mQueryLanguage.equalsIgnoreCase("ja")) {
                            var7_13 = Normalizer.normalize((String)var5_9[var6_12], (Normalizer.Mode)Normalizer.NFKC);
                            if (var4_6 != 0 && var3_3.indexOf(var7_13) >= 0) continue;
                            var3_3.add(var7_13);
                            continue;
                        }
                        if (var4_6 != 0 && var3_3.indexOf(var5_9[var6_12]) >= 0) continue;
                        var3_3.add(var5_9[var6_12]);
                    }
                    continue;
                }
                catch (DLTException var5_10) {
                    // empty catch block
                }
            }
        }
lbl41:
        // 4 sources

        var4_7 = new String[var3_3.size()];
        return var3_3.toArray(var4_7);
    }

    private Dictionary[] getDictsFromAnnotatorCM(String[] stringArray) throws Exception {
        if (Config.cm == null) {
            throw new Exception("Cannot retrieve required dictionaries. CapMatrix instance may be not ready!");
        }
        ArrayList<Dictionary> arrayList = new ArrayList<Dictionary>();
        CapMatrix.Entry entry = null;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                block6: {
                    File file = new File(stringArray[i]);
                    if (file.isFile()) {
                        try {
                            entry = Config.cm.getEntryByFile(file);
                            break block6;
                        }
                        catch (DLTException dLTException) {
                            continue;
                        }
                    }
                    entry = Config.cm.getEntryByFilename(stringArray[i]);
                }
                if (entry == null) continue;
                arrayList.add(entry.activate());
            }
        }
        Dictionary[] dictionaryArray = new Dictionary[arrayList.size()];
        return arrayList.toArray(dictionaryArray);
    }

    public class Suggestion {
        private String[] suggestions;
        private int fromTokenNumber;
        private int toTokenNumber;

        public Suggestion(String[] stringArray, int n, int n2) {
            this.suggestions = stringArray;
            this.fromTokenNumber = n;
            this.toTokenNumber = n2;
        }

        public String[] getSuggestions() {
            return this.suggestions;
        }

        public int getFromTokenNumber() {
            return this.fromTokenNumber;
        }

        public int getToTokenNumber() {
            return this.toTokenNumber;
        }
    }
}

