/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.jFrostAnnotator;

import com.ibm.dltj.DLT;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class SingleWordDictionary {
    public static final int STW_GLOSS_ID = 128;
    private static final String DEFAULT_ENCODING = "UTF-16";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public static synchronized ArrayList readDictionary(Reader reader) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() <= 0) continue;
            arrayList.add(string);
        }
        bufferedReader.close();
        return arrayList;
    }

    public static ArrayList readDictionary(InputStream inputStream, String string) throws UnsupportedEncodingException, IOException {
        return SingleWordDictionary.readDictionary(new InputStreamReader(inputStream, string));
    }

    public static ArrayList readDictionary(InputStream inputStream) throws IOException {
        try {
            return SingleWordDictionary.readDictionary(inputStream, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static void frostDictCreateAndSave(String string, String string2, ArrayList arrayList) throws Exception {
        boolean bl;
        File file = new File(string);
        if (file.exists() && !(bl = file.delete())) {
            System.err.println("Could not delete old dictionary file: " + file.getAbsolutePath());
            System.exit(1);
        }
        DLT.init();
        Dictionary dictionary = new Dictionary(file, string2, 84083200, 1);
        dictionary.registerType(128, string2);
        Gloss gloss = dictionary.addUserGloss(128, new byte[1], 0);
        for (int i = 0; i < arrayList.size(); ++i) {
            dictionary.addWord((String)arrayList.get(i), gloss);
        }
        dictionary.contract();
        dictionary.save();
        dictionary.dispose();
    }

    private static Dictionary loadFrostDictionary(File file) throws DLTException {
        Dictionary dictionary = new Dictionary(file);
        return dictionary;
    }

    public static void addStopWord(ArrayList arrayList, String string) {
        arrayList.add(string);
    }

    private static final boolean isStopword(String string, Dictionary dictionary) throws DLTException {
        return dictionary.lookupWord(string).valid();
    }

    private static final void showStopwordInfo(String string, Dictionary dictionary) throws DLTException {
        System.out.print("\"" + string + "\"");
        if (SingleWordDictionary.isStopword(string, dictionary)) {
            System.out.println(" is in stopword dictionary.");
        } else {
            System.out.println(" is NOT in stopword dictionary.");
        }
    }

    private static void createNewDictFromFile(String string, String string2, String string3, String string4) throws Exception {
        System.out.println("Using input file           : " + string);
        System.out.println("Using output file          : " + string2);
        System.out.println("Using ISO language         : " + string3);
        System.out.println("Using encoding             : " + string4);
        System.out.println("Reading input word list    : " + string + " ...");
        ArrayList arrayList = SingleWordDictionary.readDictionary(new FileInputStream(string), string4);
        System.out.println("Done reading input word list.");
        System.out.println("Read " + arrayList.size() + " stopwords.");
        System.out.println("Compiling output dictionary: " + string2 + " ...");
        SingleWordDictionary.frostDictCreateAndSave(string2, string3, arrayList);
        System.out.println("Done compiling output dictionary.");
    }

    private static void testDict(String string, String[] stringArray, int n) throws Exception {
        System.out.println("Testing " + string + " against test words...");
        DLT.init();
        Dictionary dictionary = SingleWordDictionary.loadFrostDictionary(new File(string));
        for (int i = n; i < stringArray.length; ++i) {
            SingleWordDictionary.showStopwordInfo(stringArray[i], dictionary);
        }
        System.out.println("Done testing " + string + " against test words.");
    }

    private static void printUsageAndExit() {
        System.out.println("Usage: -create <inputTextfilename> <outputDictfilename> <language> [<encoding>]");
        System.out.println("       -test   <inputDictfilename> <testword>*");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            System.out.println("Frost wordlist dictionary compiler tool");
            if (stringArray.length == 0) {
                SingleWordDictionary.printUsageAndExit();
            }
            if ((string = stringArray[0]).compareToIgnoreCase("-create") == 0) {
                String string2;
                if (stringArray.length > 5) {
                    SingleWordDictionary.printUsageAndExit();
                }
                String string3 = DEFAULT_ENCODING;
                if (stringArray.length >= 5) {
                    string3 = stringArray[4];
                }
                if ((string2 = stringArray[3]).endsWith("stw")) {
                    string2 = string2.substring(0, string2.length() - 4);
                }
                SingleWordDictionary.createNewDictFromFile(stringArray[1], stringArray[2], string2, string3);
            } else if (string.compareToIgnoreCase("-test") == 0) {
                if (stringArray.length < 2) {
                    SingleWordDictionary.printUsageAndExit();
                }
                SingleWordDictionary.testDict(stringArray[1], stringArray, 2);
            }
            System.out.println("Sucessfully finished dictionary maintenance.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

