/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.jFrostAnnotator;

import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.jFrostAnnotator.Config;
import com.ibm.uima.jFrostAnnotator.TypeSystemMgr;

public class ResultSpec {
    protected boolean mIsTokenReq = true;
    protected boolean mIsSentenceReq = true;
    protected boolean mIsParagraphReq = true;
    protected boolean mIsLemmaReq = true;
    protected boolean mIsLemmaAtTokenReq = true;
    protected boolean mIsLemmaEntriesAtTokenReq = true;
    protected boolean mIsDecompostionReq = true;
    protected boolean mIsSynonymsReq = true;
    protected boolean mIsParagraphNbrReq = true;
    protected boolean mIsSentenceNbrReq = true;
    protected boolean mIsTokenNbrReq = true;
    protected boolean mIsTokenPropsReq = true;
    protected boolean mIsFrostTokentypeReq = true;
    protected boolean mIsLemmaStopwordReq = true;
    protected boolean mIsDeterminerReq = true;
    protected boolean mIsFrostConstraintsReq = true;
    protected boolean mIsFrostMorphbitmaksReq = true;
    protected boolean mIsFrostExtendedPosReq = true;
    protected boolean mIsFrostJPStartReq = true;
    protected boolean mIsFrostJKomReq = true;
    protected boolean mIsMWURequired = false;
    protected boolean mIsCompoundAnnoReq = false;
    protected boolean mIsStopwordAnnoReq = false;
    protected boolean mIsBoostTermAnnoReq = false;
    protected boolean mIsSynonymAnnoReq = false;
    protected boolean mIsSpellCorrectAnnoReq = false;
    protected boolean mIsFilePathTypeReq = true;
    protected boolean mIsEmailTypeReq = true;
    protected boolean mIsNumberTypeReq = true;
    protected boolean mIsURLTypeReq = true;
    protected boolean mIsDateTypeReq = true;
    protected boolean mIsTimeTypeReq = true;
    protected boolean mIsTelTypeReq = true;
    protected boolean mIsCurrencyTypeReq = true;
    protected boolean mIsAcronymTypeReq = true;
    protected boolean mIsPosAtLemmaReq = true;
    protected boolean mIsDecompositionFeatReq = true;
    private String mISOLangName;
    private String mISOLangNameNoTerritory;
    private ResultSpecification _rsltSpec;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public void readSpec(ResultSpecification resultSpecification, TypeSystemMgr typeSystemMgr, Config config) {
        this.mISOLangName = config.mNormalizedISOLang;
        this.mISOLangNameNoTerritory = config.mISOLangNoTerritory;
        this._rsltSpec = resultSpecification;
        this.mIsParagraphReq = this.rsltSpec_containsType("uima.tt.ParagraphAnnotation");
        this.mIsSentenceReq = this.rsltSpec_containsType("uima.tt.SentenceAnnotation");
        this.mIsTokenReq = this.rsltSpec_containsType("uima.tt.TokenAnnotation");
        this.mIsLemmaAtTokenReq = this.rsltSpec_containsFeature("uima.tt.TokenAnnotation:lemma");
        this.mIsLemmaEntriesAtTokenReq = typeSystemMgr.mLemmaListFeatCode != 0 && (this.rsltSpec_containsType("uima.tt.Lemma") || this.rsltSpec_containsFeature("uima.tt.TokenAnnotation:lemmaEntries"));
        this.mIsLemmaReq = this.mIsLemmaAtTokenReq || this.mIsLemmaEntriesAtTokenReq;
        boolean bl = this.rsltSpec_containsType("uima.tt.Decomp_Analysis");
        boolean bl2 = this.rsltSpec_containsType("uima.tt.CompPartAnnotation");
        this.mIsDecompostionReq = bl || bl2;
        this.mIsMWURequired = typeSystemMgr.mMWUTypeCode != 0 && this.rsltSpec_containsType("com.ibm.dlt.uimatypes.MWU");
        this.mIsSynonymsReq = typeSystemMgr.mSynonymListFeatCode != 0 && this.rsltSpec_containsType("uima.tt.Synonym");
        this.mIsParagraphNbrReq = typeSystemMgr.mParaNumFeatCode != 0 && this.rsltSpec_containsFeature("uima.tt.ParagraphAnnotation:paragraphNumber");
        this.mIsSentenceNbrReq = typeSystemMgr.mSentenceNumFeatCode != 0 && this.rsltSpec_containsFeature("uima.tt.SentenceAnnotation:sentenceNumber");
        this.mIsTokenNbrReq = typeSystemMgr.mTokenNumFeatCode != 0 && this.rsltSpec_containsFeature("uima.tt.TokenAnnotation:tokenNumber");
        this.mIsTokenPropsReq = typeSystemMgr.mTokenPropsFeatCode != 0 && this.rsltSpec_containsFeature("uima.tt.TokenAnnotation:tokenProperties");
        this.mIsFrostTokentypeReq = typeSystemMgr.mFrostTokenTypeFeatCode != 0 && this.rsltSpec_containsFeature("uima.tt.TokenAnnotation:frost_TokenType");
        this.mIsDeterminerReq = typeSystemMgr.mIsDeterminerCode != 0 && this.rsltSpec_containsFeature("uima.tt.Lemma:isDeterminer");
        this.mIsLemmaStopwordReq = typeSystemMgr.mIsLemmaStopwordCode != 0 && this.rsltSpec_containsFeature("uima.tt.Lemma:isStopword");
        this.mIsFrostConstraintsReq = typeSystemMgr.mFrostConstraintsCode != 0 && this.rsltSpec_containsFeature("uima.tt.Lemma:frost_Constraints");
        this.mIsFrostMorphbitmaksReq = typeSystemMgr.mFrostMorphBitMasksCode != 0 && this.rsltSpec_containsFeature("uima.tt.Lemma:frost_MorphBitMasks");
        this.mIsFrostJPStartReq = typeSystemMgr.mFrostJPStartCode != 0 && this.rsltSpec_containsFeature("uima.tt.Lemma:frost_JPStart");
        this.mIsFrostJKomReq = typeSystemMgr.mFrostJKomCode != 0 && this.rsltSpec_containsFeature("uima.tt.Lemma:frost_JKom");
        this.mIsFrostExtendedPosReq = typeSystemMgr.mFrostExtPosCode != 0 && this.rsltSpec_containsFeature("uima.tt.Lemma:frost_ExtendedPOS");
        this.mIsCompoundAnnoReq = typeSystemMgr.mCompoundTypeCode != 0 && this.rsltSpec_containsType("uima.tt.CompoundAnnotation");
        this.mIsStopwordAnnoReq = typeSystemMgr.mStopwordTypeCode != 0 && this.rsltSpec_containsType("uima.tt.StopwordAnnotation");
        this.mIsBoostTermAnnoReq = typeSystemMgr.mBoostTypeCode != 0 && this.rsltSpec_containsType("com.ibm.es.tt.BoostTermAnnotation");
        this.mIsSpellCorrectAnnoReq = typeSystemMgr.mSpellCorrectionTypeCode != 0 && this.rsltSpec_containsType("uima.tt.SpellCorrectionAnnotation");
        this.mIsSynonymAnnoReq = typeSystemMgr.mQuerySynTypeCode != 0 && this.rsltSpec_containsType("uima.tt.SynonymAnnotation");
        this.mIsFilePathTypeReq = typeSystemMgr.mFilePathTypeCode != 0 && this.rsltSpec_containsType("com.ibm.dlt.uimatypes.FilePath");
        this.mIsEmailTypeReq = typeSystemMgr.mEmailTypeCode != 0 && this.rsltSpec_containsType("com.ibm.dlt.uimatypes.Email");
        this.mIsNumberTypeReq = typeSystemMgr.mNumberTypeCode != 0 && this.rsltSpec_containsType("com.ibm.dlt.uimatypes.Number");
        this.mIsURLTypeReq = typeSystemMgr.mURLTypeCode != 0 && this.rsltSpec_containsType("com.ibm.dlt.uimatypes.URL");
        this.mIsDateTypeReq = typeSystemMgr.mDateTypeCode != 0 && this.rsltSpec_containsType("com.ibm.dlt.uimatypes.Date");
        this.mIsTimeTypeReq = typeSystemMgr.mTimeTypeCode != 0 && this.rsltSpec_containsType("com.ibm.dlt.uimatypes.Time");
        this.mIsTelTypeReq = typeSystemMgr.mTelTypeCode != 0 && this.rsltSpec_containsType("com.ibm.dlt.uimatypes.Tel");
        this.mIsCurrencyTypeReq = typeSystemMgr.mCurrencyTypeCode != 0 && this.rsltSpec_containsType("com.ibm.dlt.uimatypes.Currency");
        this.mIsAcronymTypeReq = typeSystemMgr.mAcronymTypeCode != 0 && this.rsltSpec_containsType("com.ibm.dlt.uimatypes.Acronym");
        this.mIsPosAtLemmaReq = typeSystemMgr.mPosFeatCode != 0;
        this.mIsDecompositionFeatReq = typeSystemMgr.mDecompFeatCode != 0;
    }

    protected final boolean rsltSpec_containsType(String string) {
        return this._rsltSpec.containsType(string, this.mISOLangName) || this._rsltSpec.containsType(string, this.mISOLangNameNoTerritory);
    }

    protected final boolean rsltSpec_containsFeature(String string) {
        return this._rsltSpec.containsFeature(string, this.mISOLangName) || this._rsltSpec.containsFeature(string, this.mISOLangNameNoTerritory);
    }
}

