/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.jFrostAnnotator;

import com.ibm.dltj.CharacterBuffer;
import com.ibm.dltj.CharacterBufferPool;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Entry;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossListElement;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.GrammarGloss;
import com.ibm.dltj.gloss.IntegerGloss;
import com.ibm.dltj.gloss.JaMorphGloss;
import com.ibm.dltj.gloss.JkomCollectionGloss;
import com.ibm.dltj.gloss.LemmaGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.PhoneticSpellingGloss;
import com.ibm.dltj.gloss.TCRGloss;
import com.ibm.dltj.gloss.ZhCposGloss;
import com.ibm.dltj.nondeterm.AdvancedLookupDriver;
import com.ibm.dltj.nondeterm.RuleBasedNormalizer;
import com.ibm.dltj.parser.MWUParsingStream;
import com.ibm.icu.text.Normalizer;
import com.ibm.uima.analysis_engine.annotator.AnnotatorProcessException;
import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.impl.LowLevelCAS;
import com.ibm.uima.cas.impl.LowLevelIndexRepository;
import com.ibm.uima.cas.impl.LowLevelIterator;
import com.ibm.uima.cas.impl.LowLevelTypeSystem;
import com.ibm.uima.cas.text.AnnotationFS;
import com.ibm.uima.cas.text.AnnotationIndex;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.jFrostAnnotator.Config;
import com.ibm.uima.jFrostAnnotator.Messages;
import com.ibm.uima.jFrostAnnotator.ResultSpec;
import com.ibm.uima.jFrostAnnotator.TokenProperties;
import com.ibm.uima.jFrostAnnotator.TypeSystemMgr;
import com.ibm.uima.util.Level;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

abstract class ResultHandler
implements MWUParsingStream {
    ResultSpec mSpec = null;
    protected Config mConfig = null;
    protected TypeSystemMgr mTSMgr = null;
    protected TCAS mCas = null;
    protected LowLevelCAS mLLCas;
    protected LowLevelTypeSystem mLLTypeSystem;
    protected LowLevelIndexRepository mLLIndexRep;
    protected int tokenAddr = 0;
    protected boolean mIsCompoundPart = false;
    protected boolean mIsGroupToken = false;
    protected boolean mHasLemmaIndex = false;
    protected boolean mSentenceBreakEncountered;
    protected int mBeginOfNextSentence;
    protected boolean mParagraphBreakEncountered;
    protected int mBeginOfNextParagraph;
    protected int mTokenNbr;
    protected int mSentenceNbr;
    protected int mParagraphNbr;
    protected final int mCOUNTER_START = 1;
    protected int mListAppendAddr;
    protected int mLastDecompAnal;
    protected boolean mFirstComponent;
    protected boolean mInSecondLevelOfDecomp = false;
    protected TokenProperties mTokProps;
    final int MAX_LEMMASTRING = 256;
    final int MAX_MORPH_BITMAKS = 64;
    protected long[] mMorphBitMaskArray;
    int mEmptyFsList;
    protected StringCharacterIterator mDocumentTextItr;
    protected String mDocumentTextString;
    protected StringCharacterIterator mSecondaryLookupItr;
    protected static final int LANG_TYPE_IS_EU = 0;
    protected static final int LANG_TYPE_IS_JA = 1;
    protected static final int LANG_TYPE_IS_ZH = 2;
    protected int mLangType;
    protected char[] mDocumentTextCharArray = null;
    StringBuffer lemma = new StringBuffer();
    static final int PASSTYPE_DEFAULT = 0;
    static final int PASSTYPE_SYN = 1;
    static final int PASSTYPE_STOP = 2;
    static final int PASSTYPE_BOOST = 3;
    protected int mPassType = 0;
    protected GlossCollection mGlossCollection = new GlossCollection();
    private int mTokenAnnotationAddress = 0;
    private AdvancedLookupDriver mAdvancedLookupDriver;
    private RuleBasedNormalizer mRuleBasedNormalizer;
    protected boolean mDoLookupVariant = false;
    protected boolean mDoRuleBasedNormalizer4All = false;
    protected boolean mDoRuleBasedNormalizer4Katakana = false;
    protected boolean mReturnOnlyFirstLevelOfCompoundBreakdown = true;
    private boolean mInURISegmentation;
    protected Comparator mGlossComparator;
    static /* synthetic */ Class class$com$ibm$dltj$gloss$JaMorphGloss;
    static /* synthetic */ Class class$com$ibm$dltj$gloss$ZhCposGloss;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    ResultHandler() {
    }

    protected void dispose() {
        this.mDocumentTextString = null;
        this.mDocumentTextItr.setText("");
        this.mSecondaryLookupItr.setText("");
        this.mRuleBasedNormalizer = null;
        if (this.mAdvancedLookupDriver != null) {
            this.mAdvancedLookupDriver.dispose();
        }
    }

    protected void createNewParagraphAnnotation(int n, int n2) {
        if (!this.mSpec.mIsParagraphReq) {
            return;
        }
        if (n == n2) {
            return;
        }
        int n3 = this.mLLCas.ll_createFS(this.mTSMgr.mParaTypeCode);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mStartFeatCode, n);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mEndFeatCode, n2);
        if (this.mSpec.mIsParagraphNbrReq) {
            this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mParaNumFeatCode, this.mParagraphNbr);
        }
        this.mLLIndexRep.ll_addFS(n3);
        ++this.mParagraphNbr;
        if (this.mConfig.mUseRelativeTokenAndSentenceNumbers) {
            this.mSentenceNbr = 1;
        }
    }

    protected void createNewSentenceAnnotation(int n, int n2) {
        if (!this.mSpec.mIsSentenceReq) {
            return;
        }
        if (n == n2) {
            return;
        }
        int n3 = this.mLLCas.ll_createFS(this.mTSMgr.mSentenceTypeCode);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mStartFeatCode, n);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mEndFeatCode, n2);
        if (this.mSpec.mIsSentenceNbrReq) {
            this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mSentenceNumFeatCode, this.mSentenceNbr);
        }
        this.mLLIndexRep.ll_addFS(n3);
        ++this.mSentenceNbr;
        if (this.mConfig.mUseRelativeTokenAndSentenceNumbers) {
            this.mTokenNbr = 1;
        }
    }

    private int createNewTokenAnnotation(int n, int n2, TokenProperties tokenProperties, int n3) {
        int n4 = 0;
        if (!this.mSpec.mIsTokenReq) {
            if (this.mTokenAnnotationAddress == 0) {
                return n4;
            }
            n4 = this.mTokenAnnotationAddress;
            this.mTokenAnnotationAddress = 0;
        }
        if (!this.mConfig.mIgnorePunctuationTokens || n2 - n != 1 || !tokenProperties.hasSpecial()) {
            int n5;
            if (n4 == 0) {
                n4 = this.mLLCas.ll_createFS(this.mIsCompoundPart && !this.mConfig.mCreateCompoundPartsInsteadOfToken && !this.mConfig.mCreateDecompStructure ? this.mTSMgr.mCompoundPartTypeCode : this.mTSMgr.mTokenTypeCode);
            }
            this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mStartFeatCode, n);
            this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mEndFeatCode, n2);
            String string = null;
            if (this.mSpec.mIsTokenNbrReq) {
                this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mTokenNumFeatCode, this.mTokenNbr);
            }
            if (this.mSpec.mIsTokenPropsReq) {
                n5 = tokenProperties.getInt();
                this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mTokenPropsFeatCode, n5);
            }
            if (this.mSpec.mIsFrostTokentypeReq) {
                this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mFrostTokenTypeFeatCode, n3);
            }
            if (this.mSpec.mIsLemmaEntriesAtTokenReq) {
                this.mLLCas.ll_setRefValue(n4, this.mTSMgr.mLemmaListFeatCode, this.mEmptyFsList);
            }
            if (this.mSpec.mIsSynonymsReq) {
                if (string == null) {
                    string = new String(this.mDocumentTextCharArray, n, n2 - n);
                }
                this.mLLCas.ll_setRefValue(n4, this.mTSMgr.mSynonymListFeatCode, this.mEmptyFsList);
                for (n5 = 0; n5 < this.mConfig.mActiveDicts.synonymDictObjectsArray.length; ++n5) {
                    try {
                        Entry entry = this.mConfig.mActiveDicts.synonymDictObjectsArray[n5].lookupWord(string);
                        int n6 = 0;
                        if (entry != null && entry.valid()) {
                            n6 = entry.getType() == 22 || entry.getType() == 2 ? entry.getSynCount() : 1;
                        }
                        for (int i = 0; i < n6; ++i) {
                            try {
                                String string2 = entry.getSynonym(i);
                                if (this.mConfig.mVerbose) {
                                    this.mConfig.mLogger.logrb(Level.FINEST, this.getClass().getName(), "createNewTokenAnnotation", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Creating_synonym_for_token__FINEST", new Object[]{string2, string});
                                }
                                this.createNewSynonymFS(n4, string2);
                                continue;
                            }
                            catch (DLTException dLTException) {
                                this.mConfig.mLogger.logrb(Level.WARNING, this.getClass().getName(), "createNewTokenAnnotation", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Error_retrieving_synonym_x_of_y_for_token_ignoring_error__WARNING", new Object[]{new Integer(i + 1), new Integer(n6), string});
                                continue;
                            }
                            catch (AnnotatorProcessException annotatorProcessException) {
                                this.mConfig.mLogger.logrb(Level.WARNING, this.getClass().getName(), "createNewTokenAnnotation", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Error_creating_synonym_x_of_y_for_token_ignoring_error__WARNING", new Object[]{new Integer(i + 1), new Integer(n6), string});
                            }
                        }
                        continue;
                    }
                    catch (DLTException dLTException) {
                        this.mConfig.mLogger.logrb(Level.WARNING, this.getClass().getName(), "createNewTokenAnnotation", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Error_looking_up_synonyms_for_token_ignoring_error__WARNING", new Object[]{string});
                    }
                }
            }
            if (!(this.mIsCompoundPart && this.mConfig.mCreateDecompStructure || !this.mSpec.mIsTokenReq)) {
                this.mLLIndexRep.ll_addFS(n4);
            }
            ++this.mTokenNbr;
            if (this.mSentenceBreakEncountered) {
                this.mBeginOfNextSentence = n;
                this.mSentenceBreakEncountered = false;
            }
            if (this.mParagraphBreakEncountered) {
                this.mBeginOfNextParagraph = n;
                this.mParagraphBreakEncountered = false;
            }
            tokenProperties.reset();
        }
        return n4;
    }

    private void createNewCompoundAnnotationFS(int n, int n2) throws AnnotatorProcessException {
        int n3 = this.mLLCas.ll_createFS(this.mTSMgr.mCompoundTypeCode);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mStartFeatCode, n);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mEndFeatCode, n2);
        this.mLLIndexRep.ll_addFS(n3);
    }

    private void createNewStopwordAnnotationFS(int n, int n2) throws AnnotatorProcessException {
        int n3 = this.mLLCas.ll_createFS(this.mTSMgr.mStopwordTypeCode);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mStartFeatCode, n);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mEndFeatCode, n2);
        this.mLLIndexRep.ll_addFS(n3);
    }

    private void createNewBoostAnnotationFS(int n, int n2, int n3) throws AnnotatorProcessException {
        int n4 = this.mLLCas.ll_createFS(this.mTSMgr.mBoostTypeCode);
        this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mStartFeatCode, n);
        this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mEndFeatCode, n2);
        this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mBoostValueFeatCode, n3, false);
        this.mLLIndexRep.ll_addFS(n4);
    }

    private void createNewSynonymAnnotationFS(int n, int n2, GlossCollection glossCollection) throws AnnotatorProcessException {
        int n3 = this.mLLCas.ll_createFS(this.mTSMgr.mQuerySynTypeCode);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mStartFeatCode, n);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mEndFeatCode, n2);
        HashSet hashSet = new HashSet();
        hashSet.addAll(glossCollection);
        Iterator iterator = hashSet.iterator();
        int n4 = hashSet.size();
        int n5 = this.mLLCas.ll_createArray(this.mTSMgr.mStringArrayTypeCode, n4, true);
        for (int i = 0; i < n4; ++i) {
            TCRGloss tCRGloss = (TCRGloss)iterator.next();
            this.mLLCas.ll_setStringArrayValue(n5, i, tCRGloss.value, true);
        }
        this.mLLCas.ll_setRefValue(n3, this.mTSMgr.mQuerySynSynArrayFeatCode, n5);
        this.mLLIndexRep.ll_addFS(n3);
    }

    private void createNewSpellingCorrectionAnnotationFS(int n, int n2, String[] stringArray) {
        int n3 = this.mLLCas.ll_createFS(this.mTSMgr.mSpellCorrectionTypeCode);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mStartFeatCode, n);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mEndFeatCode, n2);
        int n4 = stringArray.length;
        int n5 = this.mLLCas.ll_createArray(this.mTSMgr.mStringArrayTypeCode, n4, true);
        for (int i = 0; i < n4; ++i) {
            this.mLLCas.ll_setStringArrayValue(n5, i, stringArray[i], true);
        }
        this.mLLCas.ll_setRefValue(n3, this.mTSMgr.mSpellSuggestionsFeatCode, n5);
        this.mLLIndexRep.ll_addFS(n3);
    }

    private void createNewSynonymFS(int n, String string) throws AnnotatorProcessException {
        if (!this.mSpec.mIsSynonymsReq) {
            return;
        }
        if (n == 0) {
            throw new AnnotatorProcessException("com.ibm.uima.jFrostAnnotator.messages", "INVALID_FS_ADRESS__SEVERE", new Object[]{new Integer(n)});
        }
        int n2 = this.mLLCas.ll_createFS(this.mTSMgr.mSynonymTypeCode);
        this.mLLCas.ll_setStringValue(n2, this.mTSMgr.mKeyFeatCode, string, false);
        int n3 = this.mLLCas.ll_createFS(this.mTSMgr.mNeFsListTypeCode);
        this.mLLCas.ll_setRefValue(n3, this.mTSMgr.mHeadFeatCode, n2);
        int n4 = this.mLLCas.ll_getRefValue(n, this.mTSMgr.mSynonymListFeatCode);
        this.mLLCas.ll_setRefValue(n3, this.mTSMgr.mTailFeatCode, n4);
        this.mLLCas.ll_setRefValue(n, this.mTSMgr.mSynonymListFeatCode, n3);
    }

    private void createNewLemmaFS(int n, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8, long[] lArray, int n9, int n10, int n11, boolean bl) throws AnnotatorProcessException {
        int n12;
        String string2;
        if (!this.mSpec.mIsLemmaReq) {
            return;
        }
        if (n == 0) {
            throw new AnnotatorProcessException("com.ibm.uima.jFrostAnnotator.messages", "INVALID_FS_ADRESS__SEVERE", new Object[]{new Integer(n)});
        }
        int n13 = this.mLLCas.ll_createFS(this.mTSMgr.mLemmaTypeCode);
        String string3 = null;
        if (this.mConfig.mActiveDicts.variantDictObjectsArray.length > 0 && (string3 = this.lookupVariantInVariantDict(string2 = new String(this.mDocumentTextCharArray, n2, n3 - n2))) != null) {
            if (this.mConfig.mVerbose) {
                this.mConfig.mLogger.logrb(Level.FINEST, this.getClass().getName(), "createNewLemmaFS", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Using_variant_as_lemma_string_for_token__FINEST", new Object[]{string3, string2});
            }
            this.mLLCas.ll_setStringValue(n13, this.mTSMgr.mKeyFeatCode, string3);
        }
        if (string3 == null) {
            if (this.lemma.length() == 0) {
                if (this.mConfig.mVerbose && this.mLangType != 1) {
                    this.mConfig.mLogger.logrb(Level.FINEST, this.getClass().getName(), "createNewLemmaFS", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Missing_lemma_string_but_language_is_not_Japanese__FINEST");
                }
                this.mLLCas.ll_setCharBufferValue(n13, this.mTSMgr.mKeyFeatCode, this.mDocumentTextCharArray, n2, n3 - n2, false);
            } else {
                if (this.mConfig.mVerbose && this.mLangType == 1) {
                    this.mConfig.mLogger.logrb(Level.FINEST, this.getClass().getName(), "createNewLemmaFS", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Found_a_lemma_string_but_language_is_Japanese__FINEST");
                }
                this.mLLCas.ll_setStringValue(n13, this.mTSMgr.mKeyFeatCode, string);
            }
        }
        if (this.mSpec.mIsPosAtLemmaReq) {
            this.mLLCas.ll_setIntValue(n13, this.mTSMgr.mPosFeatCode, n4);
        }
        if (this.mSpec.mIsDeterminerReq) {
            this.mLLCas.ll_setIntValue(n13, this.mTSMgr.mIsDeterminerCode, n6);
        }
        if (this.mSpec.mIsLemmaStopwordReq) {
            this.mLLCas.ll_setIntValue(n13, this.mTSMgr.mIsLemmaStopwordCode, n5);
        }
        if (this.mSpec.mIsFrostConstraintsReq) {
            this.mLLCas.ll_setIntValue(n13, this.mTSMgr.mFrostConstraintsCode, n7);
        }
        if (this.mSpec.mIsFrostMorphbitmaksReq && n8 > 0) {
            int n14 = this.mLLCas.ll_createArray(this.mTSMgr.mIntArrayTypeCode, n8);
            for (n12 = 0; n12 < n8; ++n12) {
                this.mLLCas.ll_setIntArrayValue(n14, n12, (int)lArray[n12]);
            }
            this.mLLCas.ll_setRefValue(n13, this.mTSMgr.mFrostMorphBitMasksCode, n14);
        }
        if (this.mSpec.mIsFrostExtendedPosReq) {
            this.mLLCas.ll_setIntValue(n13, this.mTSMgr.mFrostExtPosCode, n9);
        }
        if (this.mSpec.mIsFrostJPStartReq) {
            this.mLLCas.ll_setIntValue(n13, this.mTSMgr.mFrostJPStartCode, n10);
        }
        if (this.mSpec.mIsFrostJKomReq) {
            this.mLLCas.ll_setIntValue(n13, this.mTSMgr.mFrostJKomCode, n11);
        }
        if (this.mHasLemmaIndex && !this.mIsCompoundPart) {
            this.mLLIndexRep.ll_addFS(n13);
        }
        if (bl && this.mSpec.mIsLemmaAtTokenReq) {
            this.mLLCas.ll_setRefValue(n, this.mTSMgr.mLemmaAtTokenFeatCode, n13);
        }
        if (this.mSpec.mIsLemmaEntriesAtTokenReq) {
            int n15 = this.mLLCas.ll_createFS(this.mTSMgr.mNeFsListTypeCode);
            this.mLLCas.ll_setRefValue(n15, this.mTSMgr.mHeadFeatCode, n13);
            n12 = this.mLLCas.ll_getRefValue(n, this.mTSMgr.mLemmaListFeatCode);
            this.mLLCas.ll_setRefValue(n15, this.mTSMgr.mTailFeatCode, n12);
            this.mLLCas.ll_setRefValue(n, this.mTSMgr.mLemmaListFeatCode, n15);
        }
    }

    private String lookupVariantInVariantDict(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        for (int i = 0; i < this.mConfig.mActiveDicts.variantDictObjectsArray.length; ++i) {
            try {
                GlossListElement glossListElement;
                GlossCollection glossCollection = this.mConfig.mActiveDicts.variantDictObjectsArray[i].get((CharacterIterator)stringCharacterIterator, string.length());
                GlossListElement glossListElement2 = glossListElement = glossCollection != null ? glossCollection.getFirst() : null;
                while (glossListElement != null) {
                    if (glossListElement.gloss instanceof JkomCollectionGloss) {
                        for (int j = 0; j < ((JkomCollectionGloss)glossListElement.gloss).element.length; ++j) {
                            if (!(((JkomCollectionGloss)glossListElement.gloss).element[j] instanceof PhoneticSpellingGloss)) continue;
                            return ((PhoneticSpellingGloss)((JkomCollectionGloss)glossListElement.gloss).element[j]).value;
                        }
                    }
                    glossListElement = glossListElement.next;
                }
                continue;
            }
            catch (DLTException dLTException) {
                this.mConfig.mLogger.logrb(Level.WARNING, this.getClass().getName(), "findVariantForLemmaString", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Error_looking_up_variants_for_token_ignoring_error__WARNING", new Object[]{string});
            }
        }
        return null;
    }

    private String lookupRuleBasedVariant(String string) {
        if (string == null || string.equals("") || this.mRuleBasedNormalizer == null || this.mConfig.mActiveDicts.lexDictObjectsArray == null || this.mConfig.mActiveDicts.lexDictObjectsArray.length == 0 || this.mConfig.mActiveDicts.ruleDictObjectsArray == null || this.mConfig.mActiveDicts.ruleDictObjectsArray.length == 0) {
            return null;
        }
        for (int i = 0; i < this.mConfig.mActiveDicts.ruleDictObjectsArray.length; ++i) {
            try {
                String[] stringArray = this.mRuleBasedNormalizer.gather(string, this.mConfig.mActiveDicts.lexDictObjectsArray, this.mConfig.mActiveDicts.ruleDictObjectsArray[i], 2, true);
                if (stringArray == null) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    if (stringArray[j].length() == 0) continue;
                    return stringArray[j];
                }
                continue;
            }
            catch (DLTException dLTException) {
                this.mConfig.mLogger.logrb(Level.WARNING, this.getClass().getName(), "findRuleBasedVariant", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Error_look_up_rulebasedVariants_for_token_ignoring_error__WARNING", new Object[]{string});
            }
        }
        return null;
    }

    protected static int determineLanguageType(String string) throws AnnotatorProcessException {
        if (string.length() > 3) {
            throw new AnnotatorProcessException("com.ibm.uima.jFrostAnnotator.messages", "LANGUAGE_NAME_WITHTOUT_TERRITORY_EXPECTED__SEVERE", new Object[]{string});
        }
        if (string.compareToIgnoreCase("ja") == 0) {
            return 1;
        }
        if (string.compareToIgnoreCase("zh") == 0) {
            return 2;
        }
        return 0;
    }

    public void close() {
        this.mConfig.mLogger.log(Level.FINEST, Messages.getString("ResultHandler.Lexical_Analyzer_Callback_Close__FINEST"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        String string;
        GlossListElement glossListElement;
        if (this.mReturnOnlyFirstLevelOfCompoundBreakdown && this.mInSecondLevelOfDecomp) {
            return;
        }
        if (this.mLangType != 0 && this.mIsCompoundPart && this.mFirstComponent) {
            this.mFirstComponent = false;
            return;
        }
        if (this.mConfig.mQueryProcessingMode && this.mPassType != 0) {
            try {
                switch (this.mPassType) {
                    case 1: {
                        this.createNewSynonymAnnotationFS(n2, n3, glossCollection);
                        return;
                    }
                    case 2: {
                        this.createNewStopwordAnnotationFS(n2, n3);
                        return;
                    }
                    case 3: {
                        Iterator iterator = glossCollection.iterator();
                        while (iterator.hasNext()) {
                            IntegerGloss integerGloss = (IntegerGloss)iterator.next();
                            this.createNewBoostAnnotationFS(n2, n3, integerGloss.weight);
                        }
                        return;
                    }
                }
                return;
            }
            catch (AnnotatorProcessException annotatorProcessException) {
                annotatorProcessException.printStackTrace();
            }
            return;
        }
        if (this.mConfig.mQueryProcessingMode && this.mSpec.mIsSpellCorrectAnnoReq && (glossListElement = this.getSuggestionsForString(string = new String(this.mDocumentTextCharArray, n2, n3 - n2), true)) != null && ((String[])glossListElement).length > 0) {
            this.createNewSpellingCorrectionAnnotationFS(n2, n3, (String[])glossListElement);
        }
        try {
            if (n2 != n3) {
                if (this.mSpec.mIsTokenPropsReq) {
                    this.mTokProps.initFromCharArray(this.mDocumentTextCharArray, n2, n3 - n2);
                }
                this.tokenAddr = this.createNewTokenAnnotation(n2, n3, this.mTokProps, 0);
            }
            if (this.mSpec.mIsLemmaReq) {
                if (this.mGlossComparator != null) {
                    try {
                        glossCollection.sort(this.mGlossComparator);
                    }
                    catch (Exception exception) {
                        this.mConfig.mLogger.log(Level.FINEST, Messages.getString("ResultHandler.GC_Sorting_Failed__FINEST"), (Throwable)exception);
                    }
                }
                boolean bl = true;
                glossListElement = glossCollection.getFirst();
                while (glossListElement != null) {
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    int n11 = 0;
                    if (glossListElement.gloss instanceof MidGloss) {
                        ZhCposGloss zhCposGloss;
                        MidGloss midGloss = (MidGloss)glossListElement.gloss;
                        FeatureSetGloss featureSetGloss = midGloss.getFeatureGloss();
                        if (featureSetGloss != null) {
                            n4 = featureSetGloss.getPOS();
                            if (this.mSpec.mIsLemmaStopwordReq) {
                                n8 = featureSetGloss.getStop();
                            }
                            if (this.mSpec.mIsDeterminerReq) {
                                n9 = featureSetGloss.getDet();
                            }
                            if (this.mSpec.mIsFrostConstraintsReq) {
                                n10 = featureSetGloss.getBOFA();
                            }
                            if (this.mLangType == 0) {
                                if (this.mSpec.mIsFrostMorphbitmaksReq && (zhCposGloss = midGloss.getGrammarGloss()) != null) {
                                    n11 = zhCposGloss.getMaskN();
                                    if (n11 > 64) {
                                        throw new ArrayIndexOutOfBoundsException();
                                    }
                                    for (int i = 0; i < n11; ++i) {
                                        this.mMorphBitMaskArray[i] = zhCposGloss.getMask(i);
                                    }
                                }
                            } else {
                                if (this.mLangType != 1) throw new AnnotatorProcessException("com.ibm.uima.jFrostAnnotator.messages", "UNKNOWN_LANGUAGE_TYPE__SEVERE", new Object[]{new Integer(this.mLangType)});
                                zhCposGloss = (JaMorphGloss)midGloss.getGloss(class$com$ibm$dltj$gloss$JaMorphGloss == null ? ResultHandler.class$("com.ibm.dltj.gloss.JaMorphGloss") : class$com$ibm$dltj$gloss$JaMorphGloss);
                                if (zhCposGloss != null) {
                                    if (this.mSpec.mIsFrostExtendedPosReq) {
                                        n5 = zhCposGloss.getJPOS();
                                    }
                                    if (this.mSpec.mIsFrostJPStartReq) {
                                        n6 = zhCposGloss.getPhraseStart();
                                    }
                                    if (this.mSpec.mIsFrostJKomReq) {
                                        n7 = zhCposGloss.getJKOM();
                                    }
                                }
                            }
                        } else if (this.mLangType == 2 && (zhCposGloss = (ZhCposGloss)midGloss.getGloss(class$com$ibm$dltj$gloss$ZhCposGloss == null ? ResultHandler.class$("com.ibm.dltj.gloss.ZhCposGloss") : class$com$ibm$dltj$gloss$ZhCposGloss)) != null) {
                            n5 = zhCposGloss.value[0];
                            n4 = ZhCposGloss.getPOSbyCPOS((int)n5);
                        }
                        this.lemma.delete(0, this.lemma.length());
                        zhCposGloss = midGloss.getLemmaGloss();
                        if (zhCposGloss != null) {
                            zhCposGloss.getLemma((CharacterIterator)this.mDocumentTextItr, n2, n3, this.lemma);
                        }
                        this.createNewLemmaFS(this.tokenAddr, n2, n3, this.lemma.toString(), n4, n8, n9, n10, n11, this.mMorphBitMaskArray, n5, n6, n7, bl);
                        bl = false;
                        if (!this.mSpec.mIsLemmaEntriesAtTokenReq) break;
                    }
                    glossListElement = glossListElement.next;
                }
            }
            if (!this.mIsCompoundPart || !this.mConfig.mCreateDecompStructure || !this.mSpec.mIsDecompositionFeatReq) return;
            int n12 = this.mLLCas.ll_createFS(this.mTSMgr.mNeFsListTypeCode);
            this.mLLCas.ll_setRefValue(n12, this.mTSMgr.mHeadFeatCode, this.tokenAddr);
            this.mLLCas.ll_setRefValue(n12, this.mTSMgr.mTailFeatCode, this.mEmptyFsList);
            if (this.mFirstComponent) {
                this.mLLCas.ll_setRefValue(this.mTSMgr.mDecompAnRouteAddr, this.mTSMgr.mDecompAnRouteFeatCode, n12);
                this.mListAppendAddr = n12;
                this.mFirstComponent = false;
                return;
            } else {
                this.mLLCas.ll_setRefValue(this.mListAppendAddr, this.mTSMgr.mTailFeatCode, n12);
                this.mListAppendAddr = n12;
            }
            return;
        }
        catch (DLTException dLTException) {
            this.mConfig.mLogger.log(Level.FINEST, Messages.getString("ResultHandler.DLTException_In_CreateStd__FINEST"), (Throwable)dLTException);
            return;
        }
        catch (AnnotatorProcessException annotatorProcessException) {
            this.mConfig.mLogger.log(Level.FINEST, Messages.getString("ResultHandler.AnnoProcessException_In_CreateStd__FINEST"), (Throwable)annotatorProcessException);
        }
    }

    private void createQueryAnnotations(int n, int n2) {
        Dictionary[] dictionaryArray;
        Iterator iterator = null;
        if (this.mSpec.mIsStopwordAnnoReq) {
            dictionaryArray = this.mConfig.mActiveDicts.getStopwordDictArray();
            iterator = this.mGlossCollection.iterator();
            this.mSecondaryLookupItr.setIndex(n);
            for (int i = 0; i < dictionaryArray.length; ++i) {
                try {
                    if (dictionaryArray[i].get((CharacterIterator)this.mSecondaryLookupItr, n2 - n) == null) continue;
                    try {
                        this.createNewStopwordAnnotationFS(n, n2);
                    }
                    catch (AnnotatorProcessException annotatorProcessException) {
                        annotatorProcessException.printStackTrace();
                    }
                    continue;
                }
                catch (DLTException dLTException) {
                    this.mConfig.mLogger.logrb(Level.WARNING, this.getClass().getName(), "lookup", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Error_looking_up_dictionaries_for_token_ignoring_error__WARNING", new Object[]{new String(this.mDocumentTextCharArray, n, n2 - n)});
                }
            }
        }
        if (this.mSpec.mIsBoostTermAnnoReq) {
            dictionaryArray = this.mConfig.mActiveDicts.getBoostDictArray();
            this.lookup(dictionaryArray, n, n2, false);
            iterator = this.mGlossCollection.iterator();
            while (iterator.hasNext()) {
                Gloss gloss = (Gloss)iterator.next();
                if (!gloss.getClass().getName().equals("com.ibm.dltj.gloss.user.BoostGloss")) continue;
                try {
                    Method method = gloss.getClass().getMethod("getBoostTerm_value", null);
                    Object object = method.invoke((Object)gloss, null);
                    List list = (List)object;
                    int n3 = (Integer)list.get(0);
                    try {
                        this.createNewBoostAnnotationFS(n, n2, n3);
                    }
                    catch (AnnotatorProcessException annotatorProcessException) {
                        annotatorProcessException.printStackTrace();
                    }
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }
        }
        if (this.mSpec.mIsSynonymAnnoReq) {
            dictionaryArray = this.mConfig.mActiveDicts.getQuerySynDictArray();
            this.lookup(dictionaryArray, n, n2, true);
            if (!this.mGlossCollection.isEmpty()) {
                try {
                    this.createNewSynonymAnnotationFS(n, n2, this.mGlossCollection);
                }
                catch (AnnotatorProcessException annotatorProcessException) {
                    annotatorProcessException.printStackTrace();
                }
            }
        }
    }

    private void lookup(Dictionary[] dictionaryArray, int n, int n2, boolean bl) {
        this.mSecondaryLookupItr.setIndex(n);
        this.mGlossCollection.clear();
        for (int i = 0; i < dictionaryArray.length; ++i) {
            try {
                GlossCollection glossCollection = dictionaryArray[i].get((CharacterIterator)this.mSecondaryLookupItr, n2 - n);
                if (glossCollection == null) continue;
                if (!bl) {
                    this.mGlossCollection.addAll(glossCollection);
                    return;
                }
                this.mGlossCollection.addAll(glossCollection);
                continue;
            }
            catch (DLTException dLTException) {
                this.mConfig.mLogger.logrb(Level.WARNING, this.getClass().getName(), "lookup", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Error_looking_up_dictionaries_for_token_ignoring_error__WARNING", new Object[]{new String(this.mDocumentTextCharArray, n, n2 - n)});
            }
        }
    }

    public void createUnknown(int n, int n2, int n3, int n4) {
        if (this.mReturnOnlyFirstLevelOfCompoundBreakdown && this.mInSecondLevelOfDecomp) {
            return;
        }
        if (this.mLangType != 0 && this.mIsCompoundPart && this.mFirstComponent) {
            this.mFirstComponent = false;
            return;
        }
        if (!this.mSpec.mIsTokenReq && this.mTokenAnnotationAddress == 0) {
            return;
        }
        if (this.mConfig.mQueryProcessingMode && this.mPassType != 0) {
            return;
        }
        int n5 = 0;
        if (!(!this.mConfig.mDoTypes4Regex || this.mConfig.mDoURISegmentation && this.mInURISegmentation)) {
            switch (n4) {
                case 101: {
                    if (!this.mSpec.mIsFilePathTypeReq) break;
                    n5 = this.mLLCas.ll_createFS(this.mTSMgr.mFilePathTypeCode);
                    break;
                }
                case 102: {
                    if (!this.mSpec.mIsEmailTypeReq) break;
                    n5 = this.mLLCas.ll_createFS(this.mTSMgr.mEmailTypeCode);
                    break;
                }
                case 103: {
                    if (!this.mSpec.mIsNumberTypeReq) break;
                    n5 = this.mLLCas.ll_createFS(this.mTSMgr.mNumberTypeCode);
                    break;
                }
                case 104: {
                    if (!this.mSpec.mIsURLTypeReq) break;
                    n5 = this.mLLCas.ll_createFS(this.mTSMgr.mURLTypeCode);
                    break;
                }
                case 105: {
                    if (!this.mSpec.mIsDateTypeReq) break;
                    n5 = this.mLLCas.ll_createFS(this.mTSMgr.mDateTypeCode);
                    break;
                }
                case 106: {
                    if (!this.mSpec.mIsTimeTypeReq) break;
                    n5 = this.mLLCas.ll_createFS(this.mTSMgr.mTimeTypeCode);
                    break;
                }
                case 108: {
                    if (!this.mSpec.mIsTelTypeReq) break;
                    n5 = this.mLLCas.ll_createFS(this.mTSMgr.mTelTypeCode);
                    break;
                }
                case 109: {
                    if (!this.mSpec.mIsCurrencyTypeReq) break;
                    n5 = this.mLLCas.ll_createFS(this.mTSMgr.mCurrencyTypeCode);
                    break;
                }
                case 205: {
                    if (!this.mSpec.mIsAcronymTypeReq) break;
                    n5 = this.mLLCas.ll_createFS(this.mTSMgr.mAcronymTypeCode);
                    break;
                }
            }
            if (n5 != 0) {
                this.mLLCas.ll_setIntValue(n5, this.mTSMgr.mStartFeatCode, n2);
                this.mLLCas.ll_setIntValue(n5, this.mTSMgr.mEndFeatCode, n3);
                this.mLLIndexRep.ll_addFS(n5);
                if (!this.mSpec.mIsTokenReq) {
                    this.mLLIndexRep.ll_removeFS(this.mTokenAnnotationAddress);
                    this.mTokenAnnotationAddress = 0;
                }
                if (this.mConfig.mDoURISegmentation && this.doURISegmentation(n2, n3, n4)) {
                    return;
                }
                if (this.mSentenceBreakEncountered) {
                    this.mBeginOfNextSentence = n2;
                    this.mSentenceBreakEncountered = false;
                }
                if (this.mParagraphBreakEncountered) {
                    this.mBeginOfNextParagraph = n2;
                    this.mParagraphBreakEncountered = false;
                }
                return;
            }
        }
        if (this.mConfig.mDoURISegmentation && !this.mInURISegmentation && this.doURISegmentation(n2, n3, n4)) {
            return;
        }
        if (n2 != n3) {
            String[] stringArray;
            if (this.mSpec.mIsTokenPropsReq) {
                this.mTokProps.initFromCharArray(this.mDocumentTextCharArray, n2, n3 - n2);
            }
            this.tokenAddr = this.createNewTokenAnnotation(n2, n3, this.mTokProps, n4);
            String string = new String(this.mDocumentTextCharArray, n2, n3 - n2);
            String string2 = null;
            if (this.mDoLookupVariant) {
                string2 = this.lookupVariantInVariantDict(string);
            }
            if ((this.mDoRuleBasedNormalizer4All || this.mDoRuleBasedNormalizer4Katakana && n4 == 304) && string2 == null && this.mLangType == 1 && string != null && (string2 = this.lookupRuleBasedVariant((String)(stringArray = Normalizer.normalize((String)string, (Normalizer.Mode)Normalizer.NFKD)))) != null) {
                string2 = Normalizer.normalize((String)string2, (Normalizer.Mode)Normalizer.NFKC);
            }
            if (string2 != null) {
                try {
                    this.createNewLemmaFS(this.tokenAddr, n2, n3, string2, 0, 0, 0, 0, 0, null, 0, 0, 0, true);
                }
                catch (AnnotatorProcessException annotatorProcessException) {
                    this.mConfig.mLogger.log(Level.FINEST, Messages.getString("ResultHandler.AnnoProcessException_In_CreateUnknown__FINEST"), (Throwable)annotatorProcessException);
                }
            }
            if (this.mSpec.mIsSpellCorrectAnnoReq && this.mConfig.mQueryProcessingMode && (stringArray = this.getSuggestionsForString(string, true)) != null && stringArray.length > 0) {
                this.createNewSpellingCorrectionAnnotationFS(n2, n3, stringArray);
            }
        }
    }

    public void createBreakpoint(int n, int n2, int n3) {
        if (this.mConfig.mQueryProcessingMode && this.mPassType != 0) {
            return;
        }
        if (n3 == 1) {
            if (!this.mSentenceBreakEncountered) {
                this.mSentenceBreakEncountered = true;
                if (this.mConfig.mVerbose) {
                    this.mConfig.mLogger.log(Level.FINEST, Messages.getString("ResultHandler.Focre_Sentence_Break__FINEST"));
                }
                this.createNewSentenceAnnotation(this.mBeginOfNextSentence, n2);
            }
            if (!this.mParagraphBreakEncountered) {
                this.mParagraphBreakEncountered = true;
                this.createNewParagraphAnnotation(this.mBeginOfNextParagraph, n2);
            }
        }
        if (n3 == 2 && !this.mSentenceBreakEncountered) {
            this.mSentenceBreakEncountered = true;
            this.createNewSentenceAnnotation(this.mBeginOfNextSentence, n2);
        }
    }

    public void createPunctuation(int n, int n2, int n3, int n4) {
        if (this.mConfig.mQueryProcessingMode && this.mPassType != 0) {
            return;
        }
        if (n2 != n3 && n >= 32768) {
            if (this.mSpec.mIsTokenPropsReq) {
                this.mTokProps.initFromCharArray(this.mDocumentTextCharArray, n2, n3 - n2);
            }
            this.createNewTokenAnnotation(n2, n3, this.mTokProps, 1);
        }
    }

    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.mConfig.mLogger.log(Level.FINEST, Messages.getString("ResultHandler.Lexical_Analyzer_Callback_Reset__FINEST"));
        if (this.mSpec.mIsSpellCorrectAnnoReq) {
            if (this.mConfig.mQueryProcessingMode) {
                this.mAdvancedLookupDriver = new AdvancedLookupDriver(this.mConfig.mActiveDicts.spellMatchDictObjectArray);
                this.mAdvancedLookupDriver.extraRanking = true;
                this.mAdvancedLookupDriver.whiteSpaceTokenization = false;
            } else {
                this.mAdvancedLookupDriver = new AdvancedLookupDriver(this.mConfig.mActiveDicts.lexDictObjectsArray);
            }
        }
        if (this.mDoRuleBasedNormalizer4All || this.mDoRuleBasedNormalizer4Katakana) {
            CharacterBufferPool characterBufferPool = new CharacterBufferPool();
            characterBufferPool.init(CharacterBuffer.class, 256);
            this.mRuleBasedNormalizer = new RuleBasedNormalizer(characterBufferPool);
            this.mRuleBasedNormalizer.extraRanking = true;
            this.mRuleBasedNormalizer.doExtraSuffix = false;
            this.mRuleBasedNormalizer.doWhiteSpaces = false;
        }
    }

    public int startGroup(int n, int n2, int n3) {
        if (this.mConfig.mQueryProcessingMode) {
            if (this.mSpec.mIsCompoundAnnoReq) {
                try {
                    this.createNewCompoundAnnotationFS(n, n2);
                }
                catch (AnnotatorProcessException annotatorProcessException) {
                    annotatorProcessException.printStackTrace();
                }
                this.createQueryAnnotations(n, n2);
            }
            this.mIsCompoundPart = true;
            return 0;
        }
        this.mIsGroupToken = true;
        if (n != n2) {
            if (this.mSpec.mIsTokenPropsReq) {
                this.mTokProps.initFromCharArray(this.mDocumentTextCharArray, n, n2 - n);
            }
            if (!this.mConfig.mCreateCompoundPartsInsteadOfToken) {
                this.tokenAddr = this.createNewTokenAnnotation(n, n2, this.mTokProps, 0);
            }
        }
        if (this.mConfig.mCreateDecompStructure && this.mSpec.mIsDecompositionFeatReq) {
            this.mLLCas.ll_setRefValue(this.tokenAddr, this.mTSMgr.mDecompFeatCode, this.mEmptyFsList);
        }
        this.mIsCompoundPart = true;
        return 0;
    }

    public void closeGroup(int n) {
        this.mIsCompoundPart = false;
    }

    public void fork() {
        if (this.mConfig.mCreateDecompStructure && this.mSpec.mIsDecompositionFeatReq) {
            this.mTSMgr.mDecompAnRouteAddr = this.mLLCas.ll_createFS(this.mTSMgr.mDecompAnalTypeCode);
            int n = this.mLLCas.ll_createFS(this.mTSMgr.mNeFsListTypeCode);
            this.mLLCas.ll_setRefValue(n, this.mTSMgr.mHeadFeatCode, this.mTSMgr.mDecompAnRouteAddr);
            int n2 = this.mLLCas.ll_getRefValue(this.tokenAddr, this.mTSMgr.mDecompFeatCode);
            this.mLLCas.ll_setRefValue(n, this.mTSMgr.mTailFeatCode, n2);
            this.mLLCas.ll_setRefValue(this.tokenAddr, this.mTSMgr.mDecompFeatCode, n);
            this.mLastDecompAnal = n;
            this.mLLCas.ll_setRefValue(this.mTSMgr.mDecompAnRouteAddr, this.mTSMgr.mDecompAnRouteFeatCode, this.mEmptyFsList);
        }
        this.mFirstComponent = true;
    }

    public void addToFork() {
        this.mInSecondLevelOfDecomp = true;
        if (this.mConfig.mCreateDecompStructure && this.mSpec.mIsDecompositionFeatReq && !this.mReturnOnlyFirstLevelOfCompoundBreakdown) {
            this.mTSMgr.mDecompAnRouteAddr = this.mLLCas.ll_createFS(this.mTSMgr.mDecompAnalTypeCode);
            int n = this.mLLCas.ll_createFS(this.mTSMgr.mNeFsListTypeCode);
            this.mLLCas.ll_setRefValue(n, this.mTSMgr.mHeadFeatCode, this.mTSMgr.mDecompAnRouteAddr);
            this.mLLCas.ll_setRefValue(n, this.mTSMgr.mHeadFeatCode, this.mEmptyFsList);
            this.mLLCas.ll_setRefValue(this.mLastDecompAnal, this.mTSMgr.mTailFeatCode, n);
        }
    }

    public void mergeRoutes(int n) {
        this.mInSecondLevelOfDecomp = false;
    }

    public void createMWU(int n, int n2, int n3, Gloss gloss) {
        if (!this.mSpec.mIsMWURequired) {
            return;
        }
        int n4 = 0;
        if (n2 != n3 && this.mSpec.mIsTokenPropsReq) {
            this.mTokProps.initFromCharArray(this.mDocumentTextCharArray, n2, n3 - n2);
        }
        n4 = this.mLLCas.ll_createFS(this.mTSMgr.mMWUTypeCode);
        this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mStartFeatCode, n2);
        this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mEndFeatCode, n3);
        Object var6_6 = null;
        if (this.mSpec.mIsTokenPropsReq) {
            int n5 = this.mTokProps.getInt();
            this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mTokenPropsFeatCode, n5);
        }
        if (this.mSpec.mIsFrostTokentypeReq) {
            this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mFrostTokenTypeFeatCode, 99);
        }
        if (this.mSpec.mIsLemmaEntriesAtTokenReq) {
            this.mLLCas.ll_setRefValue(n4, this.mTSMgr.mLemmaListFeatCode, this.mEmptyFsList);
        }
        this.mLLIndexRep.ll_addFS(n4);
        this.mTokProps.reset();
        if (this.mSpec.mIsLemmaReq) {
            Object object;
            LemmaGloss lemmaGloss = null;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            if (gloss instanceof LemmaGloss) {
                lemmaGloss = (LemmaGloss)gloss;
            } else if (gloss instanceof MidGloss) {
                object = (MidGloss)gloss;
                lemmaGloss = object.getLemmaGloss();
                FeatureSetGloss featureSetGloss = object.getFeatureGloss();
                if (featureSetGloss != null) {
                    n6 = featureSetGloss.getPOS();
                    if (this.mSpec.mIsLemmaStopwordReq) {
                        int n14 = n10 = featureSetGloss.is(200) ? 1 : 0;
                    }
                    if (this.mSpec.mIsDeterminerReq) {
                        int n15 = n11 = featureSetGloss.is(201) ? 1 : 0;
                    }
                    if (this.mSpec.mIsFrostConstraintsReq) {
                        n12 = featureSetGloss.getBOFA();
                    }
                }
                if (this.mLangType == 0) {
                    GrammarGloss grammarGloss;
                    if (this.mSpec.mIsFrostMorphbitmaksReq && null != (grammarGloss = object.getGrammarGloss())) {
                        n13 = grammarGloss.mask.length;
                        if (n13 > 64) {
                            throw new ArrayIndexOutOfBoundsException();
                        }
                        for (int i = 0; i < n13; ++i) {
                            this.mMorphBitMaskArray[i] = grammarGloss.mask[i];
                        }
                    }
                } else if (this.mLangType == 1) {
                    // empty if block
                }
            }
            if (lemmaGloss != null) {
                try {
                    object = lemmaGloss.getLemma((CharacterIterator)this.mDocumentTextItr, n2, n3);
                    this.createNewLemmaFS(n4, n2, n3, (String)object, n6, n10, n11, n12, n13, this.mMorphBitMaskArray, n7, n8, n9, true);
                }
                catch (AnnotatorProcessException annotatorProcessException) {
                    annotatorProcessException.printStackTrace();
                }
                catch (DLTException dLTException) {
                    dLTException.printStackTrace();
                }
            }
        }
    }

    protected final void createLemmasForTokens() throws AnnotatorProcessException {
        this.reset(null);
        LowLevelIterator lowLevelIterator = this.mLLIndexRep.ll_getIndex("AnnotationIndex", this.mTSMgr.mTokenTypeCode).ll_iterator();
        lowLevelIterator.moveToFirst();
        while (lowLevelIterator.isValid()) {
            String string;
            String[] stringArray;
            int n = lowLevelIterator.ll_get();
            int n2 = this.mLLCas.ll_getIntValue(n, this.mTSMgr.mStartFeatCode);
            int n3 = this.mLLCas.ll_getIntValue(n, this.mTSMgr.mEndFeatCode);
            if (this.mSpec.mIsLemmaReq) {
                this.mDocumentTextItr.setIndex(n2);
                boolean bl = false;
                for (int i = 0; i < this.mConfig.mActiveDicts.lexDictObjectsArray.length; ++i) {
                    try {
                        GlossCollection glossCollection = this.mConfig.mActiveDicts.lexDictObjectsArray[i].lookupWord((CharacterIterator)this.mDocumentTextItr, n3 - n2);
                        if (glossCollection == null) continue;
                        bl = true;
                        this.mTokenAnnotationAddress = n;
                        this.createStd(0, n2, n3, glossCollection);
                        if (!this.mConfig.mUseFirstMatchPolicy) continue;
                        break;
                    }
                    catch (DLTException dLTException) {
                        dLTException.printStackTrace();
                    }
                }
                if (!bl) {
                    this.mTokenAnnotationAddress = n;
                    this.createUnknown(0, n2, n3, 0);
                }
            } else if (this.mConfig.mQueryProcessingMode && this.mSpec.mIsSpellCorrectAnnoReq && (stringArray = this.getSuggestionsForString(string = new String(this.mDocumentTextCharArray, n2, n3 - n2), true)) != null && stringArray.length > 0) {
                this.createNewSpellingCorrectionAnnotationFS(n2, n3, stringArray);
            }
            lowLevelIterator.moveToNext();
        }
    }

    protected void processPreTokenizedText(Dictionary[] dictionaryArray) throws AnnotatorProcessException {
        MatchBuffer matchBuffer = new MatchBuffer();
        LowLevelIterator lowLevelIterator = this.mLLIndexRep.ll_getIndex("AnnotationIndex", this.mTSMgr.mTokenTypeCode).ll_iterator();
        LowLevelIterator lowLevelIterator2 = this.mLLIndexRep.ll_getIndex("AnnotationIndex", this.mTSMgr.mTokenTypeCode).ll_iterator();
        for (int i = 0; i < dictionaryArray.length; ++i) {
            lowLevelIterator.moveToFirst();
            while (lowLevelIterator.isValid()) {
                int n = lowLevelIterator.ll_get();
                this.mDocumentTextItr.setIndex(this.mLLCas.ll_getIntValue(n, this.mTSMgr.mStartFeatCode));
                matchBuffer.clear();
                dictionaryArray[i].traverse((CharacterIterator)this.mDocumentTextItr, matchBuffer);
                int n2 = matchBuffer.mpos;
                lowLevelIterator2.moveToLast();
                while (n2 > 0) {
                    int n3;
                    int n4;
                    int n5 = matchBuffer.index[--n2];
                    do {
                        n3 = lowLevelIterator2.ll_get();
                        n4 = this.mLLCas.ll_getIntValue(n3, this.mTSMgr.mEndFeatCode);
                        lowLevelIterator2.moveToPrevious();
                    } while (lowLevelIterator2.isValid() && n5 < n4);
                    if (n5 == n4) {
                        int n6 = this.mLLCas.ll_getIntValue(n, this.mTSMgr.mStartFeatCode);
                        int n7 = matchBuffer.index[n2];
                        GlossCollection glossCollection = (GlossCollection)matchBuffer.gloss[n2];
                        this.createStd(0, n6, n7, glossCollection);
                        while (n != n3 && lowLevelIterator.isValid()) {
                            lowLevelIterator.moveToNext();
                            n = lowLevelIterator.ll_get();
                        }
                        break;
                    }
                    if (lowLevelIterator2.isValid()) {
                        lowLevelIterator2.moveToNext();
                        continue;
                    }
                    lowLevelIterator2.moveToFirst();
                }
                lowLevelIterator.moveToNext();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String[] getSuggestionsForString(String var1_1, boolean var2_2) {
        if (this.mLangType != 0) {
            return null;
        }
        if (var1_1 == null || var1_1.equals("") || this.mAdvancedLookupDriver == null) {
            return null;
        }
        if (this.mConfig.mQueryProcessingMode && (this.mConfig.mActiveDicts.spellMatchDictObjectArray == null || this.mConfig.mActiveDicts.spellMatchDictObjectArray.length == 0)) {
            return null;
        }
        var3_3 = new ArrayList<String>();
        if (this.mConfig.mActiveDicts.ruleDictObjectsArray.length == 0) {
            try {
                this.mAdvancedLookupDriver.obeyRules = false;
                var4_4 = this.mAdvancedLookupDriver.match(var1_1, 3, this.mConfig.mSpellSuggestionsMaxCount);
                if (var4_4 == null) ** GOTO lbl46
                for (var5_8 = 0; var5_8 < var4_4.length; ++var5_8) {
                    if (this.mLangType == 1) {
                        var6_11 = Normalizer.normalize((String)var4_4[var5_8], (Normalizer.Mode)Normalizer.NFKC);
                        var3_3.add(var6_11);
                        continue;
                    }
                    var3_3.add(var4_4[var5_8]);
                }
            }
            catch (DLTException var4_5) {
                this.mConfig.mLogger.logrb(Level.WARNING, this.getClass().getName(), "findRuleBasedVariant", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Error_look_up_suggestions_ignoring_error__WARNING", new Object[]{var1_1});
            }
        } else {
            for (var4_6 = 0; var4_6 < this.mConfig.mActiveDicts.ruleDictObjectsArray.length; ++var4_6) {
                try {
                    this.mAdvancedLookupDriver.setRules(this.mConfig.mActiveDicts.ruleDictObjectsArray[var4_6]);
                    var5_9 = this.mAdvancedLookupDriver.match(var1_1, 3, this.mConfig.mSpellSuggestionsMaxCount);
                    if (var5_9 == null) continue;
                    for (var6_12 = 0; var6_12 < var5_9.length; ++var6_12) {
                        if (this.mLangType == 1) {
                            var7_13 = Normalizer.normalize((String)var5_9[var6_12], (Normalizer.Mode)Normalizer.NFKC);
                            if (var4_6 != 0 && var3_3.indexOf(var7_13) >= 0) continue;
                            var3_3.add(var7_13);
                            continue;
                        }
                        if (var4_6 != 0 && var3_3.indexOf(var5_9[var6_12]) >= 0) continue;
                        var3_3.add(var5_9[var6_12]);
                    }
                    continue;
                }
                catch (DLTException var5_10) {
                    this.mConfig.mLogger.logrb(Level.WARNING, this.getClass().getName(), "findRuleBasedVariant", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Error_look_up_suggestions_ignoring_error__WARNING", new Object[]{var1_1});
                }
            }
        }
lbl46:
        // 4 sources

        if (var2_2) {
            var3_3.remove(var1_1);
        }
        var4_7 = new String[var3_3.size()];
        return var3_3.toArray(var4_7);
    }

    protected void processTokensInCompounds(Dictionary[] dictionaryArray) {
        Type type = this.mCas.getTypeSystem().getType("uima.tt.CompoundAnnotation");
        Type type2 = this.mCas.getTypeSystem().getType("uima.tt.TokenAnnotation");
        FSIterator fSIterator = this.mCas.getAnnotationIndex(type).iterator();
        fSIterator.moveToFirst();
        while (fSIterator.isValid()) {
            AnnotationFS annotationFS = (AnnotationFS)fSIterator.get();
            AnnotationIndex annotationIndex = (AnnotationIndex)this.mCas.getAnnotationIndex(type2);
            FSIterator fSIterator2 = annotationIndex.subiterator(annotationFS);
            fSIterator2.moveToFirst();
            while (fSIterator2.isValid()) {
                AnnotationFS annotationFS2 = (AnnotationFS)fSIterator2.get();
                int n = annotationFS2.getBegin();
                int n2 = annotationFS2.getEnd();
                for (int i = 0; i < dictionaryArray.length; ++i) {
                    this.mDocumentTextItr.setIndex(n);
                    try {
                        GlossCollection glossCollection = dictionaryArray[i].lookupWord((CharacterIterator)this.mDocumentTextItr, n2 - n);
                        if (glossCollection == null) continue;
                        this.createStd(0, n, n2, glossCollection);
                        continue;
                    }
                    catch (DLTException dLTException) {
                        dLTException.printStackTrace();
                    }
                }
                fSIterator2.moveToNext();
            }
            fSIterator.moveToNext();
        }
    }

    private boolean doURISegmentation(int n, int n2, int n3) {
        int n4;
        String string;
        switch (n3) {
            case 102: {
                string = this.mConfig.mBreakOnHyphens ? ".@-" : ".@";
                break;
            }
            case 104: {
                string = this.mConfig.mBreakOnHyphens ? ".:/-" : ".:/";
                break;
            }
            case 101: {
                string = this.mConfig.mBreakOnHyphens ? "\\.:/-" : "\\.:/";
                break;
            }
            case 100: {
                string = this.mConfig.mBreakOnHyphens ? "\"'&$*%@?!:.-" : "\"'&$*%@?!:.";
                string = string + "\u05f4\u2019\u0589\uff0e\u30fb\u3002\uff61\uff01\uff1f";
                break;
            }
            case 103: {
                string = "-+/%^,.: \u00ad\u2212";
                break;
            }
            case 108: {
                string = "-+()/ \u00ad\u2212";
                break;
            }
            case 105: {
                string = ".-/ \uff0d\uff0f'\u2019\u02bc";
                break;
            }
            case 106: {
                string = ": \uff1a";
                break;
            }
            case 109: {
                string = ".-\u00ad\u2212$\u00a2\u00a3\u20ac\u00a5\u00a4\ufdfc\ufe69\uff04\uffe0\uffe1\uffe5\uffe6\u20a0\u20a1\u20a2\u20a3\u20a4\u20a5\u20a6\u20a7\u20a8\u20a9\u20aa\u20ab\u20ad\u20ae\u20af\u20b0\u20b1\u20b2\u20b3\u20b4\u20b5\u060b\u09f2\u09f3\u0af1\u0bf9\u0e3f\u17db\u5143\u5186\u92ad\uc6d0";
                break;
            }
            default: {
                return false;
            }
        }
        this.mInURISegmentation = true;
        int n5 = n;
        for (n4 = n; n4 < n2; ++n4) {
            if (string.indexOf(this.mDocumentTextCharArray[n4]) < 0) continue;
            switch (n3) {
                case 100: 
                case 101: 
                case 102: 
                case 104: {
                    if (n4 == n5) break;
                    this.lookup(this.mConfig.mActiveDicts.lexDictObjectsArray, n5, n4, false);
                    if (!this.mGlossCollection.isEmpty()) {
                        this.createStd(0, n5, n4, this.mGlossCollection);
                        break;
                    }
                    this.createUnknown(0, n5, n4, 100);
                    break;
                }
                default: {
                    if (n4 == n5) break;
                    if (this.mSpec.mIsTokenPropsReq) {
                        this.mTokProps.initFromCharArray(this.mDocumentTextCharArray, n5, n4 - n5);
                    }
                    this.createNewTokenAnnotation(n5, n4, this.mTokProps, 100);
                }
            }
            if (this.mDocumentTextCharArray[n4] != ' ') {
                if (this.mSpec.mIsTokenPropsReq) {
                    this.mTokProps.initFromCharArray(this.mDocumentTextCharArray, n4, 1);
                }
                this.createNewTokenAnnotation(n4, n4 + 1, this.mTokProps, 1);
            }
            n5 = n4 + 1;
        }
        switch (n3) {
            case 100: 
            case 101: 
            case 102: 
            case 104: {
                if (n4 == n5) break;
                this.lookup(this.mConfig.mActiveDicts.lexDictObjectsArray, n5, n4, false);
                if (!this.mGlossCollection.isEmpty()) {
                    this.createStd(0, n5, n4, this.mGlossCollection);
                    break;
                }
                this.createUnknown(0, n5, n4, n5 == n ? n3 : 100);
                break;
            }
            default: {
                if (n4 == n5) break;
                if (this.mSpec.mIsTokenPropsReq) {
                    this.mTokProps.initFromCharArray(this.mDocumentTextCharArray, n5, n4 - n5);
                }
                this.createNewTokenAnnotation(n5, n4, this.mTokProps, n5 == n ? n3 : 100);
            }
        }
        this.mInURISegmentation = false;
        return true;
    }
}

