/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.jFrostAnnotator;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Session;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.analysis_engine.annotator.AnnotatorProcessException;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.jFrostAnnotator.Config;
import com.ibm.uima.jFrostAnnotator.LanguageDictionaries;
import com.ibm.uima.jFrostAnnotator.Messages;
import com.ibm.uima.jFrostAnnotator.ResultHandler;
import com.ibm.uima.jFrostAnnotator.ResultSpec;
import com.ibm.uima.jFrostAnnotator.TokenProperties;
import com.ibm.uima.jFrostAnnotator.TypeSystemMgr;
import com.ibm.uima.util.Level;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Comparator;

public class LexicalAnalyzer
extends ResultHandler {
    private Session mSession = null;
    private Session mSecondarySession = null;
    private final String mSecondarySessionLocale = "eu";
    private boolean mIsFirstCallToProcess = true;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    LexicalAnalyzer(Config config) {
        this.mConfig = config;
        this.initMemberVars();
        this.mSpec = new ResultSpec();
    }

    void init(TypeSystemMgr typeSystemMgr, Config config, ResultSpecification resultSpecification) {
        this.mTSMgr = typeSystemMgr;
        this.mConfig = config;
        this.mSpec.readSpec(resultSpecification, typeSystemMgr, config);
    }

    private final void initMemberVars() {
        this.resetMemberVars();
        this.mTokProps = new TokenProperties();
        this.mMorphBitMaskArray = new long[64];
        this.mDocumentTextItr = new StringCharacterIterator("");
        if (this.mConfig.mGlossComparatorClassname != null && this.mConfig.mGlossComparatorClassname.length() != 0) {
            try {
                Class<?> clazz = Class.forName(this.mConfig.mGlossComparatorClassname);
                this.mGlossComparator = (Comparator)clazz.newInstance();
            }
            catch (Exception exception) {
                this.mConfig.mLogger.logrb(Level.FINEST, this.getClass().getName(), "initMemberVars", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Cannot_Init_GC_Comparator__CONFIG", (Object)this.mConfig.mGlossComparatorClassname);
            }
        }
    }

    private final void resetMemberVars() {
        this.mTokenNbr = 1;
        this.mSentenceNbr = 1;
        this.mParagraphNbr = 1;
        this.mSentenceBreakEncountered = false;
        this.mParagraphBreakEncountered = false;
        this.mBeginOfNextSentence = 0;
        this.mBeginOfNextParagraph = 0;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(TCAS var1_1, boolean var2_2) throws AnnotatorProcessException {
        block40: {
            block38: {
                block39: {
                    this.mCas = var1_1;
                    this.mLLCas = var1_1.getLowLevelCAS();
                    this.mLLIndexRep = this.mLLCas.ll_getIndexRepository();
                    this.mEmptyFsList = this.mLLCas.ll_createFS(this.mTSMgr.mEFsListTypeCode);
                    this.resetMemberVars();
                    v0 = this.mHasLemmaIndex = this.mLLIndexRep.ll_getIndex("Lemma Index") != null;
                    if (var2_2) {
                        this.mSession = null;
                        this.mConfig.mLastLanguage = this.mConfig.mNormalizedISOLang;
                        this.mLangType = LexicalAnalyzer.determineLanguageType(this.mConfig.mISOLangNoTerritory);
                        if (this.mLangType == 1) {
                            this.mSpec.mIsDecompostionReq = this.mConfig.mJaDecomposition;
                            this.mDoLookupVariant = this.mConfig.mDoLookupVariant;
                            this.mDoRuleBasedNormalizer4All = this.mConfig.mDoRuleBasedNormalization4All;
                            this.mDoRuleBasedNormalizer4Katakana = this.mConfig.mDoRuleBasedNormalization4Katakana;
                        } else {
                            this.mDoLookupVariant = false;
                            this.mDoRuleBasedNormalizer4All = false;
                            this.mDoRuleBasedNormalizer4Katakana = false;
                        }
                        this.mReturnOnlyFirstLevelOfCompoundBreakdown = this.mLangType == 0 ? this.mConfig.mReturnOnlyFirstLevelOfCompoundBreakdown : false;
                        this.mConfig.loadFrostDictsIfNecessary(this.mSpec.mIsMWURequired, this.mConfig.mConfigRequiresOOV);
                    }
                    try {
                        try {
                            this.mDocumentTextCharArray = this.mDocumentTextString.toCharArray();
                            this.mDocumentTextItr.setText(this.mDocumentTextString);
                            this.mSecondaryLookupItr = (StringCharacterIterator)this.mDocumentTextItr.clone();
                            if (!this.mSpec.mIsTokenReq) {
                                if (this.mConfig.mQueryProcessingMode) {
                                    this.mPassType = 3;
                                    while (this.mPassType >= 1) {
                                        switch (this.mPassType) {
                                            case 1: {
                                                if (!this.mSpec.mIsSynonymAnnoReq) break;
                                                if (this.mConfig.mActiveDicts.querySynDictObjectsArray == null || this.mConfig.mActiveDicts.querySynDictObjectsArray.length == 0) {
                                                    this.mConfig.mLogger.log(Level.CONFIG, Messages.getString("LexicalAnalyzer.No_QuerySynonum_dictionaries_found__CONFIG"));
                                                    break;
                                                }
                                                this.processPreTokenizedText(this.mConfig.mActiveDicts.querySynDictObjectsArray);
                                                break;
                                            }
                                            case 2: {
                                                if (!this.mSpec.mIsStopwordAnnoReq) break;
                                                if (this.mConfig.mActiveDicts.stopwordDictObjectsArray == null || this.mConfig.mActiveDicts.stopwordDictObjectsArray.length == 0) {
                                                    this.mConfig.mLogger.log(Level.CONFIG, Messages.getString("LexicalAnalyzer.No_Stopword_dictionaries_found__CONFIG"));
                                                    break;
                                                }
                                                this.processPreTokenizedText(this.mConfig.mActiveDicts.stopwordDictObjectsArray);
                                                break;
                                            }
                                            case 3: {
                                                if (!this.mSpec.mIsBoostTermAnnoReq) break;
                                                if (this.mConfig.mActiveDicts.boostDictObjectsArray == null || this.mConfig.mActiveDicts.boostDictObjectsArray.length == 0) {
                                                    this.mConfig.mLogger.log(Level.CONFIG, Messages.getString("LexicalAnalyzer.No_BoostTerm_dictionaries_found__CONFIG"));
                                                    break;
                                                }
                                                this.processPreTokenizedText(this.mConfig.mActiveDicts.boostDictObjectsArray);
                                                break;
                                            }
                                        }
                                        --this.mPassType;
                                    }
                                }
                                this.createLemmasForTokens();
                                if (!this.mSpec.mIsParagraphReq && !this.mSpec.mIsSentenceReq) {
                                    this.mIsFirstCallToProcess = false;
                                    var5_3 = null;
                                    if (this.mSession == null) break block38;
                                    break block39;
                                }
                            }
                            this.mSession = LexicalAnalyzer.openSession(this.mSession, this.mConfig.mActiveDicts, this.mConfig.mBreakIteratorSpec, this.mConfig.mNormalizedISOLang, this.mConfig.mQueryProcessingMode, this.mPassType, this.mConfig.mUseFirstMatchPolicy, this.mSpec.mIsDecompostionReq, this.mConfig.mBreakOnHyphens, this.mConfig.mJaDeepWordBreak);
                            if (this.mSpec.mIsMWURequired) {
                                this.mSession.processTextMW((CharacterIterator)this.mDocumentTextItr, (ParsingStream)this);
                            } else {
                                this.mSession.processText((CharacterIterator)this.mDocumentTextItr, (ParsingStream)this);
                            }
                            var3_6 = var1_1.getDocumentText().length();
                            if (!this.mSentenceBreakEncountered && this.mSpec.mIsSentenceReq) {
                                this.createNewSentenceAnnotation(this.mBeginOfNextSentence, var3_6);
                            }
                            if (!this.mParagraphBreakEncountered && this.mSpec.mIsParagraphReq) {
                                this.createNewParagraphAnnotation(this.mBeginOfNextParagraph, var3_6);
                            }
                            if (!this.mSpec.mIsTokenReq || !this.mConfig.mQueryProcessingMode) break block40;
                            this.mPassType = 1;
                            while (this.mPassType <= 3) {
                                block41: {
                                    switch (this.mPassType) {
                                        case 1: {
                                            if (this.mSpec.mIsSynonymAnnoReq) {
                                                if (this.mConfig.mActiveDicts.querySynDictObjectsArray != null && this.mConfig.mActiveDicts.querySynDictObjectsArray.length != 0) break;
                                                this.mConfig.mLogger.log(Level.CONFIG, Messages.getString("LexicalAnalyzer.No_QuerySynonum_dictionaries_found__CONFIG"));
                                            }
                                            break block41;
                                        }
                                        case 2: {
                                            if (this.mSpec.mIsStopwordAnnoReq) {
                                                if (this.mConfig.mActiveDicts.stopwordDictObjectsArray != null && this.mConfig.mActiveDicts.stopwordDictObjectsArray.length != 0) break;
                                                this.mConfig.mLogger.log(Level.CONFIG, Messages.getString("LexicalAnalyzer.No_Stopword_dictionaries_found__CONFIG"));
                                            }
                                            break block41;
                                        }
                                        case 3: {
                                            if (!this.mSpec.mIsBoostTermAnnoReq) break block41;
                                            if (this.mConfig.mActiveDicts.boostDictObjectsArray != null && this.mConfig.mActiveDicts.boostDictObjectsArray.length != 0) ** GOTO lbl91
                                            this.mConfig.mLogger.log(Level.CONFIG, Messages.getString("LexicalAnalyzer.No_BoostTerm_dictionaries_found__CONFIG"));
                                            break block41;
lbl91:
                                            // 1 sources

                                            this.processTokensInCompounds(this.mConfig.mActiveDicts.boostDictObjectsArray);
                                        }
                                    }
                                    this.mDocumentTextItr.setIndex(this.mDocumentTextItr.getBeginIndex());
                                    if (this.mLangType == 0) {
                                        this.mSession.close();
                                        this.mSession = LexicalAnalyzer.openSession(this.mSession, this.mConfig.mActiveDicts, this.mConfig.mBreakIteratorSpec, this.mConfig.mNormalizedISOLang, this.mConfig.mQueryProcessingMode, this.mPassType, this.mConfig.mUseFirstMatchPolicy, this.mSpec.mIsDecompostionReq, this.mConfig.mBreakOnHyphens, this.mConfig.mJaDeepWordBreak);
                                        this.mSession.processText((CharacterIterator)this.mDocumentTextItr, (ParsingStream)this);
                                    } else {
                                        this.mSecondarySession = LexicalAnalyzer.openSession(this.mSecondarySession, this.mConfig.mActiveDicts, this.mConfig.mBreakIteratorSpec, "eu", this.mConfig.mQueryProcessingMode, this.mPassType, this.mConfig.mUseFirstMatchPolicy, this.mSpec.mIsDecompostionReq, this.mConfig.mBreakOnHyphens, this.mConfig.mJaDeepWordBreak);
                                        this.mSecondarySession.processText((CharacterIterator)this.mDocumentTextItr, (ParsingStream)this);
                                        this.mSecondarySession.close();
                                    }
                                }
                                ++this.mPassType;
                            }
                            this.mPassType = 0;
                            break block40;
                        }
                        catch (DLTException var3_7) {
                            throw new AnnotatorProcessException("com.ibm.uima.jFrostAnnotator.messages", "FROST_EXCEPTION_ENCOUNTERED__SEVERE", new Object[0], (Throwable)var3_7);
                        }
                    }
                    catch (Throwable var4_8) {
                        var5_5 = null;
                        if (this.mSession != null) {
                            this.mSession.close();
                        }
                        if (this.mSecondarySession != null) {
                            this.mSecondarySession.close();
                        }
                        this.dispose();
                        throw var4_8;
                    }
                }
                this.mSession.close();
            }
            if (this.mSecondarySession != null) {
                this.mSecondarySession.close();
            }
            this.dispose();
            return;
        }
        var5_4 = null;
        if (this.mSession != null) {
            this.mSession.close();
        }
        if (this.mSecondarySession != null) {
            this.mSecondarySession.close();
        }
        this.dispose();
        this.mIsFirstCallToProcess = false;
    }

    private static Session closeSession(Session session) throws AnnotatorProcessException {
        if (session == null) {
            return session;
        }
        session.close();
        session = null;
        return session;
    }

    private static Session openSession(Session session, LanguageDictionaries languageDictionaries, String string, String string2, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws AnnotatorProcessException {
        try {
            if (session == null) {
                session = new Session(string2);
                if (string != null) {
                    session.setBreakIteratorByFilename(string);
                }
            }
            try {
                switch (n) {
                    case 1: {
                        session.setDictionaries(languageDictionaries.getQuerySynDictArray(), null, null);
                        break;
                    }
                    case 2: {
                        session.setDictionaries(languageDictionaries.getStopwordDictArray(), null, null);
                        break;
                    }
                    case 3: {
                        session.setDictionaries(languageDictionaries.getBoostDictArray(), null, null);
                        break;
                    }
                    default: {
                        session.setDictionaries(languageDictionaries.getLexDictArray(), languageDictionaries.getOOVDictArray(), languageDictionaries.getMWUDictArray());
                        break;
                    }
                }
            }
            catch (DLTException dLTException) {
                dLTException.printStackTrace();
            }
            session.open(bl2 ? 1 : 0, bl3 ? (bl4 ? 1 : 3) : 0, bl5 ? 1 : 0);
        }
        catch (DLTException dLTException) {
            throw new AnnotatorProcessException("com.ibm.uima.jFrostAnnotator.messages", "FROST_EXCEPTION_ENCOUNTERED__SEVERE", new Object[0], (Throwable)dLTException);
        }
        return session;
    }
}

