/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.jFrostAnnotator;

import com.ibm.dltj.CapMatrix;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.uima.analysis_engine.annotator.AnnotatorProcessException;
import com.ibm.uima.jFrostAnnotator.Config;
import com.ibm.uima.jFrostAnnotator.Messages;
import com.ibm.uima.util.Level;
import com.ibm.uima.util.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class LanguageDictionaries
implements Comparable {
    static final String DICT_TYPE_LEX = "LexicalDicts";
    static final String DICT_TYPE_SYN = "SynonymDicts";
    static final String DICT_TYPE_NE = "NamedEntityDicts";
    static final String DICT_TYPE_OOV = "OOVDicts";
    static final String DICT_TYPE_VAR = "VariantDicts";
    static final String DICT_TYPE_RULE = "SpellCorrectionDicts";
    static final String DICT_TYPE_SPELLMATCH = "SpellMatchDicts";
    static final String DICT_TYPE_QSYN = "QuerySynDicts";
    static final String DICT_TYPE_BOOST = "BoostTermDicts";
    static final String DICT_TYPE_STOP = "StopwordDicts";
    Dictionary[] lexDictObjectsArray;
    ArrayList lexDictEntriesList;
    Dictionary[] synonymDictObjectsArray;
    ArrayList synonymDictEntriesList;
    Dictionary[] variantDictObjectsArray;
    ArrayList variantDictEntriesList;
    Dictionary[] stopwordDictObjectsArray;
    ArrayList stopwordDictEntriesList;
    Dictionary[] oovDictObjectsArray;
    ArrayList oovDictEntriesList;
    Dictionary[] mwuDictObjectsArray;
    ArrayList mwuDictEntriesList;
    Dictionary[] boostDictObjectsArray;
    ArrayList boostDictEntriesList;
    Dictionary[] querySynDictObjectsArray;
    ArrayList querySynDictEntriesList;
    Dictionary[] ruleDictObjectsArray;
    ArrayList ruleDictEntriesList;
    Dictionary[] spellMatchDictObjectArray;
    ArrayList spellMatchDictEntriesList;
    String isoLangName;
    String isoLangNoTerritory;
    boolean useExplicitDicts = false;
    boolean queryProcessing = false;
    Logger logger;
    private CapMatrix capMatrix;
    static final int[] synonymDictGlossTypes = new int[]{22, 2};
    static final String[] synonymDictGlossTypeNames = new String[]{"Synonym", "PosCollection"};
    static final int[] variantDictGlossTypes = new int[]{4};
    static final String[] variantDictGlossTypeNames = new String[]{"JKOMCOL"};
    static final int[] stopwordDictGlossTypes = new int[]{128};
    static final String[] stopwordDictGlossTypeNames = new String[]{"External Stopwords"};
    static final int[] ruleDictGlossTypes = new int[]{17};
    static final String[] ruleDictGlossTypeNames = new String[]{"TCR"};
    private int usageCount = 0;
    private int recency = 50;
    static EntryComparator entryComparator = new EntryComparator();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    void incRecency() {
        if (this.recency < 100) {
            ++this.recency;
        }
    }

    void decRecency() {
        if (this.recency > 0) {
            --this.recency;
        }
    }

    int getUsageCount() {
        return this.usageCount;
    }

    void incUsageCount() {
        ++this.usageCount;
    }

    void decUsageCount() {
        if (this.usageCount > 0) {
            --this.usageCount;
        }
    }

    public LanguageDictionaries(CapMatrix capMatrix) {
        this.capMatrix = capMatrix;
    }

    void setLogger(Logger logger) {
        this.logger = logger;
    }

    Dictionary[] getLexDictArray() {
        return this.lexDictObjectsArray;
    }

    Dictionary[] getSynonymDictArray() {
        return this.synonymDictObjectsArray;
    }

    Dictionary[] getVariantDictArray() {
        return this.variantDictObjectsArray;
    }

    Dictionary[] getStopwordDictArray() {
        return this.stopwordDictObjectsArray;
    }

    Dictionary[] getOOVDictArray() {
        return this.oovDictObjectsArray;
    }

    Dictionary[] getMWUDictArray() {
        return this.mwuDictObjectsArray;
    }

    Dictionary[] getBoostDictArray() {
        return this.boostDictObjectsArray;
    }

    Dictionary[] getQuerySynDictArray() {
        return this.querySynDictObjectsArray;
    }

    Dictionary[] getruleDictArray() {
        return this.ruleDictObjectsArray;
    }

    boolean matches(String string) {
        return this.isoLangName.compareToIgnoreCase(string) == 0;
    }

    void load(Config config, String string, String string2, boolean bl, boolean bl2) throws AnnotatorProcessException {
        this.useExplicitDicts = config.mUseExplicitDicts;
        this.queryProcessing = config.mQueryProcessingMode;
        this.isoLangName = string;
        this.isoLangNoTerritory = string2;
        if (this.useExplicitDicts) {
            this.logger.logrb(Level.CONFIG, "LanguageDictionaries", "load", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Using_Explicit_Dictionaries__CONFIG");
            this.lexDictEntriesList = config.getDictsForLang(string, string2, DICT_TYPE_LEX);
            this.synonymDictEntriesList = config.getDictsForLang(string, string2, DICT_TYPE_SYN);
            if (bl) {
                this.mwuDictEntriesList = config.getDictsForLang(string, string2, DICT_TYPE_NE);
            }
            if (bl2) {
                this.oovDictEntriesList = config.getDictsForLang(string, string2, DICT_TYPE_OOV);
            }
            this.variantDictEntriesList = config.getDictsForLang(string, string2, DICT_TYPE_VAR);
            this.stopwordDictEntriesList = config.getDictsForLang(string, string2, DICT_TYPE_STOP);
            this.boostDictEntriesList = config.getDictsForLang(string, string2, DICT_TYPE_BOOST);
            this.querySynDictEntriesList = config.getDictsForLang(string, string2, DICT_TYPE_QSYN);
            this.ruleDictEntriesList = config.getDictsForLang(string, string2, DICT_TYPE_RULE);
            this.spellMatchDictEntriesList = config.getDictsForLang(string, string2, DICT_TYPE_SPELLMATCH);
        } else {
            this.find(string, string2, bl, bl2);
        }
        if (config.mDefaultLang != null && config.mDefaultLang.length() > 0 && string.startsWith(config.mDefaultLang)) {
            this.disableDeactivate(this.lexDictEntriesList);
            this.disableDeactivate(this.synonymDictEntriesList);
            this.disableDeactivate(this.mwuDictEntriesList);
            this.disableDeactivate(this.oovDictEntriesList);
            this.disableDeactivate(this.variantDictEntriesList);
            this.disableDeactivate(this.stopwordDictEntriesList);
            this.disableDeactivate(this.boostDictEntriesList);
            this.disableDeactivate(this.querySynDictEntriesList);
            this.disableDeactivate(this.ruleDictEntriesList);
            this.disableDeactivate(this.spellMatchDictEntriesList);
        }
        this.load();
    }

    private void disableDeactivate(ArrayList arrayList) {
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                CapMatrix.Entry entry = (CapMatrix.Entry)arrayList.get(i);
                entry.setNoDeactivateFuzzy(true);
            }
        }
    }

    private void load() throws AnnotatorProcessException {
        this.lexDictObjectsArray = LanguageDictionaries.load(this.lexDictEntriesList, this.logger, Messages.getString("LanguageDictionaries.lexical__CONFIG"));
        this.boostDictObjectsArray = LanguageDictionaries.load(this.boostDictEntriesList, this.logger, Messages.getString("LanguageDictionaries.boost__CONFIG"));
        this.querySynDictObjectsArray = LanguageDictionaries.load(this.querySynDictEntriesList, this.logger, Messages.getString("LanguageDictionaries.querysyn__CONFIG"));
        this.ruleDictObjectsArray = LanguageDictionaries.load(this.ruleDictEntriesList, this.logger, Messages.getString("LanguageDictionaries.rule__CONFIG"));
        this.spellMatchDictObjectArray = LanguageDictionaries.load(this.spellMatchDictEntriesList, this.logger, Messages.getString("LanguageDictionaries.spellMatch__CONFIG"));
        this.stopwordDictObjectsArray = LanguageDictionaries.load(this.stopwordDictEntriesList, this.logger, Messages.getString("LanguageDictionaries.stopword__CONFIG"));
        this.oovDictObjectsArray = LanguageDictionaries.load(this.oovDictEntriesList, this.logger, Messages.getString("LanguageDictionaries.oov__CONFIG"));
        this.mwuDictObjectsArray = LanguageDictionaries.load(this.mwuDictEntriesList, this.logger, Messages.getString("LanguageDictionaries.mwu__CONFIG"));
        this.synonymDictObjectsArray = LanguageDictionaries.load(this.synonymDictEntriesList, this.logger, Messages.getString("LanguageDictionaries.synonym__CONFIG"));
        this.variantDictObjectsArray = LanguageDictionaries.load(this.variantDictEntriesList, this.logger, Messages.getString("LanguageDictionaries.variant__CONFIG"));
    }

    private static Dictionary[] load(ArrayList arrayList, Logger logger, String string) throws AnnotatorProcessException {
        if (arrayList == null || arrayList.size() == 0) {
            return new Dictionary[0];
        }
        try {
            logger.logrb(Level.CONFIG, "LanguageDictionaries", "load", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Loading_Frost_x_dictionaries__CONFIG", (Object)string);
            Dictionary[] dictionaryArray = new Dictionary[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                dictionaryArray[i] = ((CapMatrix.Entry)arrayList.get(i)).activate();
            }
            return dictionaryArray;
        }
        catch (DLTException dLTException) {
            throw new AnnotatorProcessException("com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.could_not_activate_required_dictionaries__SEVERE", new Object[0], (Throwable)dLTException);
        }
    }

    private void findGlossDictionariesForLanguage(ArrayList arrayList, String string, String string2, int[] nArray) throws AnnotatorProcessException {
        try {
            CapMatrix.Entry[] entryArray = this.capMatrix.getAvailableEntries(string + "*", nArray);
            if (entryArray.length == 0 && string2 != null) {
                entryArray = this.capMatrix.getAvailableEntries(string2 + "*", nArray);
            }
            for (int i = 0; i < entryArray.length; ++i) {
                arrayList.add(entryArray[i]);
            }
            Collections.sort(arrayList, entryComparator);
        }
        catch (DLTException dLTException) {
            throw new AnnotatorProcessException("com.ibm.uima.jFrostAnnotator.messages", "FROST_EXCEPTION_ENCOUNTERED__SEVERE", new Object[0], (Throwable)dLTException);
        }
    }

    private void find(String string, String string2, boolean bl, boolean bl2) throws AnnotatorProcessException {
        int n;
        this.logger.logrb(Level.CONFIG, this.getClass().getName(), "find", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Finding_Frost_morphological_dictionaries__CONFIG");
        this.lexDictEntriesList = new ArrayList();
        if (string2.compareToIgnoreCase("zh") == 0) {
            this.findGlossDictionariesForLanguage(this.lexDictEntriesList, string, string2, new int[]{1, 80, -56, -17, -22, -26});
        } else {
            this.findGlossDictionariesForLanguage(this.lexDictEntriesList, string, string2, new int[]{15, -56, -17, -22, -26});
        }
        int n2 = this.lexDictEntriesList.size();
        for (n = 0; n < n2; ++n) {
            this.logger.logrb(Level.CONFIG, this.getClass().getName(), "find", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Using_Frost_morphological_dictionary__CONFIG", this.lexDictEntriesList.get(n));
        }
        this.logger.logrb(Level.CONFIG, this.getClass().getName(), "find", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Finding_Frost_synonym_dictionaries__CONFIG");
        this.synonymDictEntriesList = new ArrayList();
        this.findGlossDictionariesForLanguage(this.synonymDictEntriesList, string, string2, synonymDictGlossTypes);
        n2 = this.synonymDictEntriesList.size();
        for (n = 0; n < n2; ++n) {
            this.logger.logrb(Level.CONFIG, this.getClass().getName(), "find", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Using_Frost_synonym_dictionary__CONFIG", this.synonymDictEntriesList.get(n));
        }
        this.logger.logrb(Level.CONFIG, this.getClass().getName(), "find", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Finding_Frost_variants_dictionaries__CONFIG");
        this.variantDictEntriesList = new ArrayList();
        this.findGlossDictionariesForLanguage(this.variantDictEntriesList, string, string2, variantDictGlossTypes);
        n2 = this.variantDictEntriesList.size();
        for (n = 0; n < n2; ++n) {
            this.logger.logrb(Level.CONFIG, this.getClass().getName(), "find", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Using_Frost_variant_dictionary__CONFIG", this.variantDictEntriesList.get(n));
        }
        this.logger.logrb(Level.CONFIG, this.getClass().getName(), "find", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Finding_Frost_stopword_dictionaries__CONFIG");
        this.stopwordDictEntriesList = new ArrayList();
        this.findGlossDictionariesForLanguage(this.stopwordDictEntriesList, string, string2, stopwordDictGlossTypes);
        n2 = this.stopwordDictEntriesList.size();
        for (n = 0; n < n2; ++n) {
            this.logger.logrb(Level.CONFIG, this.getClass().getName(), "find", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Using_Frost_stopword_dictionary__CONFIG", this.stopwordDictEntriesList.get(n));
        }
        this.logger.logrb(Level.CONFIG, this.getClass().getName(), "find", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Finding_Frost_rule_dictionaries__CONFIG");
        this.ruleDictEntriesList = new ArrayList();
        this.findGlossDictionariesForLanguage(this.ruleDictEntriesList, string, string2, ruleDictGlossTypes);
        n2 = this.ruleDictEntriesList.size();
        for (n = 0; n < n2; ++n) {
            this.logger.logrb(Level.CONFIG, this.getClass().getName(), "find", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Using_Frost_rule_dictionary__CONFIG", this.ruleDictEntriesList.get(n));
        }
        if (bl) {
            this.logger.logrb(Level.CONFIG, this.getClass().getName(), "find", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Finding_Frost_morphological_dictionaries__CONFIG");
            this.mwuDictEntriesList = new ArrayList();
            this.findGlossDictionariesForLanguage(this.mwuDictEntriesList, string, string2, new int[]{56});
            n2 = this.mwuDictEntriesList.size();
            for (n = 0; n < n2; ++n) {
                this.logger.logrb(Level.CONFIG, this.getClass().getName(), "find", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Using_Frost_mwu_dictionary__CONFIG", this.mwuDictEntriesList.get(n));
            }
        }
        if (bl2) {
            this.logger.logrb(Level.CONFIG, this.getClass().getName(), "find", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Finding_Frost_morphological_dictionaries__CONFIG");
            this.oovDictEntriesList = new ArrayList();
            this.findGlossDictionariesForLanguage(this.oovDictEntriesList, string, string2, new int[]{26});
            n2 = this.oovDictEntriesList.size();
            for (n = 0; n < n2; ++n) {
                this.logger.logrb(Level.CONFIG, this.getClass().getName(), "find", "com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Using_Frost_oov_dictionary__CONFIG", this.oovDictEntriesList.get(n));
            }
        }
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        if (object instanceof LanguageDictionaries) {
            LanguageDictionaries languageDictionaries = (LanguageDictionaries)object;
            if (this.recency < languageDictionaries.recency) {
                return -1;
            }
            if (this.recency > languageDictionaries.recency) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    private static final class EntryComparator
    implements Comparator {
        private EntryComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object instanceof CapMatrix.Entry && object2 instanceof CapMatrix.Entry) {
                CapMatrix.Entry entry = (CapMatrix.Entry)object;
                CapMatrix.Entry entry2 = (CapMatrix.Entry)object2;
                return entry.getFile().getAbsolutePath().compareTo(entry2.getFile().getAbsolutePath());
            }
            return -1;
        }
    }
}

