/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.jFrostAnnotator;

import com.ibm.dltj.CapMatrix;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.LangIDSession;
import com.ibm.dltj.LanguageGuess;
import com.ibm.uima.analysis_engine.annotator.AnnotatorProcessException;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.jFrostAnnotator.Config;
import com.ibm.uima.jFrostAnnotator.Messages;
import com.ibm.uima.jFrostAnnotator.ResultHandler;
import com.ibm.uima.jFrostAnnotator.TypeSystemMgr;
import com.ibm.uima.util.Level;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public class LangIDAnalyzer
extends ResultHandler {
    private static final String UNSPECIFIED_LANGUAGE = "x-unspecified";
    private LangIDSession mLIDSession = null;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public LangIDAnalyzer(LangIDSession langIDSession) {
        this.mLIDSession = langIDSession;
    }

    public void init(TypeSystemMgr typeSystemMgr, Config config) {
        this.mTSMgr = typeSystemMgr;
        this.mConfig = config;
    }

    public void process(TCAS tCAS) throws AnnotatorProcessException {
        this.mCas = tCAS;
        this.mLLCas = tCAS.getLowLevelCAS();
        this.mLLIndexRep = this.mLLCas.ll_getIndexRepository();
        this.mEmptyFsList = this.mLLCas.ll_createFS(this.mTSMgr.mEFsListTypeCode);
        try {
            CapMatrix.Entry entry = this.mConfig.getLangIDDict();
            if (entry == null) {
                throw new AnnotatorProcessException("com.ibm.uima.jFrostAnnotator.messages", "LanguageDictionaries.Finding_Frost_language_id_dictionaries__SEVERE", new Object[]{this.mConfig.mLangIDDict, this.mConfig.mFrostDataSpec});
            }
            Dictionary[] dictionaryArray = new Dictionary[]{entry.activate()};
            this.mLIDSession.open(dictionaryArray);
        }
        catch (DLTException dLTException) {
            this.mConfig.mLogger.log(Level.SEVERE, Messages.getString("LANGWARE_LANGID_EXCEPTION_ENCOUNTERED__SEVERE"), (Throwable)dLTException);
            throw new AnnotatorProcessException("com.ibm.uima.jFrostAnnotator.messages", "LANGWARE_LANGID_EXCEPTION_ENCOUNTERED__SEVERE", new Object[0], (Throwable)dLTException);
        }
        try {
            String string = this.detectLanguage(this.mDocumentTextString);
            if (this.mConfig.mVerbose) {
                this.mConfig.mLogger.log(Level.FINER, Messages.getString("LangIDAnalyzer.Setting_Language_To__FINER"), (Object)string);
                if (string.compareToIgnoreCase(UNSPECIFIED_LANGUAGE) == 0) {
                    this.mConfig.mLogger.log(Level.FINER, Messages.getString("LangIDAnalyzer.Unknown_Language_Encountered__FINER"));
                    this.mConfig.mLogger.log(Level.FINER, "\n---------\n" + (this.mDocumentTextString.length() > 80 ? this.mDocumentTextString.substring(80) : this.mDocumentTextString) + "\n---------\n");
                }
            }
            tCAS.getDocumentAnnotation().setStringValue(this.mTSMgr.mLanguageFeat, string);
        }
        catch (Exception exception) {
            this.mConfig.mLogger.log(Level.WARNING, "Log Exception: " + exception.getLocalizedMessage());
            throw new AnnotatorProcessException("com.ibm.uima.jFrostAnnotator.messages", "LANGWARE_LANGID_EXCEPTION_ENCOUNTERED__SEVERE", new Object[0], (Throwable)exception);
        }
        finally {
            this.mLIDSession.close();
        }
    }

    private String detectLanguage(String string) throws AnnotatorProcessException {
        int n;
        LanguageGuess[] languageGuessArray;
        int n2 = string.length();
        if (n2 == 0) {
            this.mConfig.mLogger.log(Level.FINER, Messages.getString("LangIDAnalyzer.Empty_Document_Encountered__FINER"));
            return "";
        }
        if (this.mConfig.mMaxCharsToExamine > 0 && this.mConfig.mMaxCharsToExamine < n2) {
            n2 = this.mConfig.mMaxCharsToExamine;
            if (this.mConfig.mVerbose) {
                this.mConfig.mLogger.log(Level.FINER, Messages.getString("LangIDAnalyzer.Chars_To_Examine__FINER"), (Object)new Integer(n2));
            }
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string, 0, n2, 0);
        try {
            languageGuessArray = this.mLIDSession.identifyLanguage((CharacterIterator)stringCharacterIterator);
        }
        catch (DLTException dLTException) {
            throw new AnnotatorProcessException("com.ibm.uima.jFrostAnnotator.messages", "LANGWARE_LANGID_EXCEPTION_ENCOUNTERED__SEVERE", new Object[0], (Throwable)dLTException);
        }
        int n3 = this.mLLCas.ll_getFSRef((FeatureStructure)this.mCas.getDocumentAnnotation());
        if (languageGuessArray.length > 0 && this.mTSMgr.mLanguageConfidencePairTypeCode != 0) {
            n = 0;
            int n4 = 0;
            int n5 = 0;
            n = this.mLLCas.ll_createFS(this.mTSMgr.mNeFsListTypeCode);
            this.mLLCas.ll_setRefValue(n3, this.mTSMgr.mLanguageCandidatesFeatureCode, n);
            n5 = this.mLLCas.ll_createFS(this.mTSMgr.mLanguageConfidencePairTypeCode);
            this.mLLCas.ll_setStringValue(n5, this.mTSMgr.mLanguageConfidencePairLanguageFeatureCode, languageGuessArray[0].getLanguage());
            this.mLLCas.ll_setFloatValue(n5, this.mTSMgr.mLanguageConfidencePairConfidenceFeatureCode, (float)languageGuessArray[0].getConfidence());
            this.mLLCas.ll_setRefValue(n, this.mTSMgr.mHeadFeatCode, n5);
            int n6 = languageGuessArray.length;
            if (this.mConfig.mMaxNumTopLanguages > 0 && this.mConfig.mMaxNumTopLanguages < n6) {
                n6 = this.mConfig.mMaxNumTopLanguages;
            }
            for (int i = 1; i < n6; ++i) {
                n4 = this.mLLCas.ll_createFS(this.mTSMgr.mNeFsListTypeCode);
                n5 = this.mLLCas.ll_createFS(this.mTSMgr.mLanguageConfidencePairTypeCode);
                this.mLLCas.ll_setStringValue(n5, this.mTSMgr.mLanguageConfidencePairLanguageFeatureCode, LangIDAnalyzer.adjustLanguageNames(languageGuessArray[i].getLanguage()));
                this.mLLCas.ll_setFloatValue(n5, this.mTSMgr.mLanguageConfidencePairConfidenceFeatureCode, (float)languageGuessArray[i].getConfidence());
                this.mLLCas.ll_setRefValue(n4, this.mTSMgr.mHeadFeatCode, n5);
                this.mLLCas.ll_setRefValue(n, this.mTSMgr.mTailFeatCode, n4);
                n = n4;
            }
            this.mLLCas.ll_setRefValue(n, this.mTSMgr.mTailFeatCode, this.mEmptyFsList);
        }
        if (this.mConfig.mVerbose) {
            for (n = 0; n < languageGuessArray.length; ++n) {
                this.mConfig.mLogger.log(Level.FINER, languageGuessArray[n].getLanguage() + "(" + languageGuessArray[n].getConfidence() + "),");
            }
        }
        this.mLIDSession.reset();
        if (languageGuessArray.length == 0) {
            return UNSPECIFIED_LANGUAGE;
        }
        return LangIDAnalyzer.adjustLanguageNames(languageGuessArray[0].getLanguage());
    }

    private static String adjustLanguageNames(String string) {
        if (string.compareToIgnoreCase("STL") == 0) {
            return UNSPECIFIED_LANGUAGE;
        }
        if (string.compareToIgnoreCase("x-STL") == 0) {
            return UNSPECIFIED_LANGUAGE;
        }
        if (string.compareToIgnoreCase("CTL") == 0) {
            return UNSPECIFIED_LANGUAGE;
        }
        if (string.compareToIgnoreCase("x-CTL") == 0) {
            return UNSPECIFIED_LANGUAGE;
        }
        return string;
    }
}

