/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.jFrostAnnotator;

import com.ibm.dltj.CapMatrix;
import com.ibm.dltj.DLT;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.DictionaryInfo;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContext;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContextException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorInitializationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorProcessException;
import com.ibm.uima.jFrostAnnotator.LanguageDictionaries;
import com.ibm.uima.util.Level;
import com.ibm.uima.util.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class Config {
    static CapMatrix cm;
    LanguageDictionaries mActiveDicts;
    String mBreakIteratorSpec;
    private static final int DEFAULT_DICTS_CACHE_SIZE = 5;
    private int mDictsCacheSize = 5;
    String mDefaultLang;
    String mNormalizedISOLang = null;
    String mISOLangNoTerritory = null;
    private String mISOTerritory = null;
    Logger mLogger;
    boolean mIsLangIDSession = false;
    String mLangIDDict = null;
    boolean mUseRelativeTokenAndSentenceNumbers = false;
    boolean mIgnorePunctuationTokens = false;
    boolean mVerbose = false;
    boolean mJaDeepWordBreak = false;
    boolean mJaDecomposition = false;
    boolean mProcessLanguagesWithNoDictionaries = false;
    boolean mUseFirstMatchPolicy = true;
    boolean mCreateCompoundPartsInsteadOfToken = false;
    boolean mReturnOnlyFirstLevelOfCompoundBreakdown = true;
    boolean mCreateDecompStructure = false;
    String[] mPreloadLanguageArray;
    int mMaxCharsToExamine = 0;
    int mMaxNumTopLanguages = 1;
    boolean mUnknownProcessing = true;
    int mTieDelta = 1;
    String mFrostDataSubdir = "";
    String mFrostDataPath;
    String mFrostDataSpec;
    boolean mConfigRequiresMWU;
    boolean mConfigRequiresOOV;
    public boolean mDoTypes4Regex = false;
    public boolean mUseExplicitDicts;
    protected String mLastLanguage = "";
    public AnnotatorContext mContext = null;
    public boolean mQueryProcessingMode = false;
    public int mSpellSuggestionsMaxCount = 10;
    public boolean mDoLookupVariant = false;
    public boolean mDoRuleBasedNormalization4All = false;
    public boolean mDoRuleBasedNormalization4Katakana = false;
    public boolean mDoURISegmentation = false;
    public boolean mBreakOnHyphens = true;
    public String mGlossComparatorClassname;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public final void getConfigValues() throws AnnotatorConfigurationException, AnnotatorInitializationException {
        try {
            this.mLogger = this.mContext.getLogger();
            this.mIsLangIDSession = Config.secureGetConfigParameterValue(this.mContext, "SessionTypeIsLangID", false);
            this.mVerbose = this.mLogger.isLoggable(Level.FINEST);
            this.mFrostDataSubdir = Config.secureGetConfigParameterValue(this.mContext, "LWDataSubdir", this.mFrostDataSubdir);
            this.mFrostDataPath = this.mContext.getDataPath();
            String[] stringArray = this.mFrostDataPath.split(File.pathSeparator);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(File.separatorChar);
                stringBuffer.append(this.mFrostDataSubdir);
                stringBuffer.append(File.pathSeparatorChar);
                if (i != 0) continue;
                this.mFrostDataPath = stringBuffer.substring(0, stringBuffer.length() - 1);
            }
            this.mFrostDataSpec = stringBuffer.substring(0, stringBuffer.length() - 1);
            try {
                if (cm == null) {
                    cm = new CapMatrix(this.mFrostDataSpec);
                } else {
                    cm.setDataSpec(this.mFrostDataSpec);
                }
            }
            catch (DLTException dLTException) {
                throw new AnnotatorContextException("com.ibm.uima.jFrostAnnotator.messages", "FROST_EXCEPTION_ENCOUNTERED__SEVERE", new Object[0], (Throwable)dLTException);
            }
            this.logAvailableDicts();
            if (!this.mIsLangIDSession) {
                this.mBreakIteratorSpec = Config.secureGetConfigParameterValue(this.mContext, "BreakIteratorSpec", this.mBreakIteratorSpec);
                if (this.mBreakIteratorSpec != null && this.mBreakIteratorSpec.length() != 0) {
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(stringArray[0]);
                    stringBuffer.append(File.separatorChar);
                    stringBuffer.append(this.mFrostDataSubdir);
                    if (this.mFrostDataSubdir.length() > 0) {
                        stringBuffer.append(File.separatorChar);
                    }
                    stringBuffer.append(this.mBreakIteratorSpec);
                    this.mBreakIteratorSpec = stringBuffer.toString();
                }
                this.mUseExplicitDicts = Config.secureGetConfigParameterValue(this.mContext, "UseExplicitDicts", this.mUseExplicitDicts);
                this.mQueryProcessingMode = Config.secureGetConfigParameterValue(this.mContext, "QueryProcessingMode", this.mQueryProcessingMode);
                this.mDoTypes4Regex = Config.secureGetConfigParameterValue(this.mContext, "DoTypes4Regex", this.mDoTypes4Regex);
                this.mDoURISegmentation = Config.secureGetConfigParameterValue(this.mContext, "DoURISegmentation", this.mDoURISegmentation);
                this.mBreakOnHyphens = Config.secureGetConfigParameterValue(this.mContext, "BreakOnHyphens", this.mBreakOnHyphens);
                this.mConfigRequiresMWU = Config.secureGetConfigParameterValue(this.mContext, "DoMWUProcessing", this.mConfigRequiresMWU);
                this.mConfigRequiresOOV = Config.secureGetConfigParameterValue(this.mContext, "DoOOVProcessing", this.mConfigRequiresOOV);
                this.mDoLookupVariant = Config.secureGetConfigParameterValue(this.mContext, "DoLookupVariant", this.mDoLookupVariant);
                this.mDoRuleBasedNormalization4All = Config.secureGetConfigParameterValue(this.mContext, "DoRuleBasedNormalization4All", this.mDoRuleBasedNormalization4All);
                this.mDoRuleBasedNormalization4Katakana = Config.secureGetConfigParameterValue(this.mContext, "DoRuleBasedNormalization4Katakana", this.mDoRuleBasedNormalization4Katakana);
                this.mIgnorePunctuationTokens = Config.secureGetConfigParameterValue(this.mContext, "IgnorePunctuationTokens", this.mIgnorePunctuationTokens);
                this.mUseRelativeTokenAndSentenceNumbers = Config.secureGetConfigParameterValue(this.mContext, "UseRelativeTokenAndSentenceNumbers", this.mUseRelativeTokenAndSentenceNumbers);
                this.mJaDeepWordBreak = Config.secureGetConfigParameterValue(this.mContext, "JapaneseDeepWordBreak", this.mJaDeepWordBreak);
                this.mJaDecomposition = Config.secureGetConfigParameterValue(this.mContext, "JapaneseDecomposition", this.mJaDecomposition);
                this.mPreloadLanguageArray = (String[])this.mContext.getConfigParameterValue("PreloadLanguages");
                this.mProcessLanguagesWithNoDictionaries = Config.secureGetConfigParameterValue(this.mContext, "ProcessLanguagesWithNoDictionaries", this.mProcessLanguagesWithNoDictionaries);
                this.mUseFirstMatchPolicy = Config.secureGetConfigParameterValue(this.mContext, "UseFirstMatchPolicy", this.mUseFirstMatchPolicy);
                this.mCreateCompoundPartsInsteadOfToken = Config.secureGetConfigParameterValue(this.mContext, "CreateCompoundPartsInsteadOfToken", this.mCreateCompoundPartsInsteadOfToken);
                this.mReturnOnlyFirstLevelOfCompoundBreakdown = Config.secureGetConfigParameterValue(this.mContext, "ReturnOnlyFirstLevelOfCompoundBreakdown", this.mReturnOnlyFirstLevelOfCompoundBreakdown);
                this.mCreateDecompStructure = Config.secureGetConfigParameterValue(this.mContext, "CreateDecompStructure", this.mCreateDecompStructure);
                this.mSpellSuggestionsMaxCount = Config.secureGetConfigParameterValue(this.mContext, "SpellSuggestionsMaxCount", this.mSpellSuggestionsMaxCount);
                this.mDictsCacheSize = Config.secureGetConfigParameterValue(this.mContext, "DictionaryCacheSize", this.mDictsCacheSize);
                this.mDefaultLang = Config.secureGetConfigParameterValue(this.mContext, "DefaultLanguage", this.mDefaultLang);
                this.mGlossComparatorClassname = Config.secureGetConfigParameterValue(this.mContext, "GlossComparatorClassname", this.mGlossComparatorClassname);
            } else {
                this.mMaxCharsToExamine = Config.secureGetConfigParameterValue(this.mContext, "MaxCharsToExamine", this.mMaxCharsToExamine);
                this.mMaxNumTopLanguages = Config.secureGetConfigParameterValue(this.mContext, "MaxTopLanguages", this.mMaxNumTopLanguages);
                this.mLangIDDict = Config.secureGetConfigParameterValue(this.mContext, "LangIDDictName", this.mLangIDDict);
                this.mUnknownProcessing = Config.secureGetConfigParameterValue(this.mContext, "UnknownProcessing", this.mUnknownProcessing);
                this.mTieDelta = Config.secureGetConfigParameterValue(this.mContext, "TieDelta", this.mTieDelta);
            }
        }
        catch (AnnotatorContextException annotatorContextException) {
            throw new AnnotatorConfigurationException((Throwable)annotatorContextException);
        }
    }

    public CapMatrix.Entry getLangIDDict() throws DLTException {
        CapMatrix.Entry entry = cm.getEntryByFilename(this.mLangIDDict);
        return entry;
    }

    static int secureGetConfigParameterValue(AnnotatorContext annotatorContext, String string, int n) throws AnnotatorContextException {
        try {
            Integer n2 = (Integer)annotatorContext.getConfigParameterValue(string);
            if (n2 != null) {
                return n2;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return n;
    }

    static boolean secureGetConfigParameterValue(AnnotatorContext annotatorContext, String string, boolean bl) throws AnnotatorContextException {
        Boolean bl2 = (Boolean)annotatorContext.getConfigParameterValue(string);
        if (bl2 != null) {
            return bl2;
        }
        return bl;
    }

    static String secureGetConfigParameterValue(AnnotatorContext annotatorContext, String string, String string2) throws AnnotatorContextException {
        String string3 = (String)annotatorContext.getConfigParameterValue(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    final void logAvailableDicts() throws AnnotatorInitializationException {
        this.mLogger.log(Level.CONFIG, "");
        this.logAvailableDicts(22, "Synonym");
        this.logAvailableDicts(15, "Featureset");
        this.logAvailableDicts(13, "Grammar");
        this.logAvailableDicts(32, "JA-Morph");
        this.logAvailableDicts(4, "JKomCol");
        this.logAvailableDicts(23, "Phonetic Spelling");
        this.logAvailableDicts(40, "ZH-Morph");
    }

    private final void logAvailableDicts(int n, String string) throws AnnotatorInitializationException {
        try {
            this.mLogger.logrb(Level.CONFIG, this.getClass().getName(), "logAvailableDicts", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Looking_for_Frost_dictionaries_of_type__CONFIG", new Object[]{string, new Integer(n)});
            if (cm == null) {
                this.mLogger.logrb(Level.CONFIG, this.getClass().getName(), "logAvailableDicts", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.No_CapMatrix__CONFIG");
                this.mLogger.log(Level.CONFIG, "");
                return;
            }
            CapMatrix.Entry[] entryArray = cm.getAvailableEntries("*", n);
            if (entryArray.length == 0) {
                this.mLogger.logrb(Level.CONFIG, this.getClass().getName(), "logAvailableDicts", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.No_Frost_dictionaries_of_type_X_found__CONFIG", (Object)string);
                this.mLogger.log(Level.CONFIG, "");
                return;
            }
            DictionaryInfo dictionaryInfo = new DictionaryInfo();
            for (int i = 0; i < entryArray.length; ++i) {
                this.mLogger.log(Level.CONFIG, entryArray[i].getFile().getCanonicalPath() + " v" + DLT.buildVersionString((int)((int)dictionaryInfo.getVersion())));
            }
        }
        catch (DLTException dLTException) {
            throw new AnnotatorInitializationException("com.ibm.uima.jFrostAnnotator.messages", "FROST_EXCEPTION_ENCOUNTERED__SEVERE", new Object[0], (Throwable)dLTException);
        }
        catch (IOException iOException) {
            throw new AnnotatorInitializationException((Throwable)iOException);
        }
        this.mLogger.log(Level.CONFIG, "");
    }

    private String getFrostDictionarySearchExpression() {
        return this.mFrostDataSpec;
    }

    synchronized void loadFrostDictsIfNecessary(boolean bl, boolean bl2) throws AnnotatorProcessException {
        this.mActiveDicts = null;
        this.mActiveDicts = new LanguageDictionaries(cm);
        this.mActiveDicts.setLogger(this.mLogger);
        this.mActiveDicts.load(this, this.mNormalizedISOLang, this.mISOLangNoTerritory, bl, bl2);
        if (this.mDictsCacheSize > 0) {
            try {
                cm.deactivateFuzzy(this.mDictsCacheSize);
            }
            catch (DLTException dLTException) {
                // empty catch block
            }
        }
        if (this.mActiveDicts == null) {
            System.out.println("active dict = null");
        }
        if (this.mActiveDicts.getLexDictArray().length == 0) {
            AnnotatorProcessException annotatorProcessException = new AnnotatorProcessException("com.ibm.uima.jFrostAnnotator.messages", "NO_DICTS_AVAIL_FOR_LANG__SEVERE", new Object[]{this.mNormalizedISOLang, this.mISOLangNoTerritory, this.getFrostDictionarySearchExpression()});
            if (this.mProcessLanguagesWithNoDictionaries) {
                this.mLogger.log(Level.WARNING, annotatorProcessException.getLocalizedMessage());
            } else {
                throw annotatorProcessException;
            }
        }
    }

    void doPreload() throws AnnotatorProcessException {
        for (int i = this.mPreloadLanguageArray.length - 1; i >= 0; --i) {
            this.normalizeLangName(this.mPreloadLanguageArray[i]);
            this.loadFrostDictsIfNecessary(true, true);
        }
    }

    void normalizeLangName(String string) {
        string = string.toLowerCase();
        this.mISOLangNoTerritory = string = string.replace('_', '-');
        this.mISOTerritory = "";
        int n = string.indexOf(45);
        if (n != -1) {
            this.mISOLangNoTerritory = string.substring(0, n);
            this.mISOTerritory = string.substring(n + 1, string.length()).toUpperCase();
            string = this.mISOLangNoTerritory + "-" + this.mISOTerritory;
        }
        this.mNormalizedISOLang = string;
    }

    public void logDataPath() {
        this.mLogger.logrb(Level.CONFIG, this.getClass().getName(), "initFrost", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Using_frost_data_path__CONFIG", (Object)this.getFrostDictionarySearchExpression());
        this.mLogger.logrb(Level.CONFIG, this.getClass().getName(), "initFrost", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Using_frost_break_iterator_directory__CONFIG", (Object)this.mFrostDataPath);
    }

    public ArrayList getDictsForLang(String string, String string2, String string3) {
        ArrayList<CapMatrix.Entry> arrayList;
        block20: {
            arrayList = new ArrayList<CapMatrix.Entry>();
            CapMatrix.Entry entry = null;
            String[] stringArray = null;
            try {
                File file;
                try {
                    stringArray = (String[])this.mContext.getConfigParameterValue(string, string3);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (stringArray == null && string2 != null) {
                    try {
                        stringArray = (String[])this.mContext.getConfigParameterValue(string2, string3);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        block19: {
                            file = new File(stringArray[i]);
                            if (file.isFile()) {
                                try {
                                    entry = cm.getEntryByFile(file);
                                    break block19;
                                }
                                catch (DLTException dLTException) {
                                    this.mLogger.logrb(Level.SEVERE, this.getClass().getName(), "getDictsForLang", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Invalid_dictionary__SEVERE", (Throwable)dLTException);
                                    continue;
                                }
                            }
                            entry = cm.getEntryByFilename(stringArray[i]);
                        }
                        if (entry == null) continue;
                        arrayList.add(entry);
                    }
                }
                try {
                    stringArray = (String[])this.mContext.getConfigParameterValue("default", string3);
                }
                catch (ClassCastException classCastException) {
                    stringArray = null;
                }
                if (stringArray == null) break block20;
                for (int i = 0; i < stringArray.length; ++i) {
                    block21: {
                        file = new File(stringArray[i]);
                        if (file.isFile()) {
                            try {
                                entry = cm.getEntryByFile(file);
                                break block21;
                            }
                            catch (DLTException dLTException) {
                                this.mLogger.logrb(Level.SEVERE, this.getClass().getName(), "getDictsForLang", "com.ibm.uima.jFrostAnnotator.messages", "jFrostAnnotator.Invalid_dictionary__SEVERE", (Throwable)dLTException);
                                continue;
                            }
                        }
                        entry = cm.getEntryByFilename(stringArray[i]);
                    }
                    if (entry == null) continue;
                    arrayList.add(entry);
                }
            }
            catch (AnnotatorContextException annotatorContextException) {
                annotatorContextException.printStackTrace();
            }
            catch (DLTException dLTException) {
                dLTException.printStackTrace();
            }
        }
        return arrayList;
    }
}

