/**
 * <copyright>
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2006-2007. All Rights Reserved. 
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 * </copyright>
 *
 * $Id$
 */
package com.ibm.team.foundation.rcp.core.internal.favorites.util;

import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.foundation.rcp.core.internal.favorites.*;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import com.ibm.team.foundation.rcp.core.internal.favorites.Favorite;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage;
import com.ibm.team.foundation.rcp.core.internal.favorites.ModelAccessor;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 *
 * @since 0.5
 * <!-- end-user-doc -->
 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage
 * @generated
 */
public class FavoritesAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static FavoritesPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FavoritesAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = FavoritesPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject) object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FavoritesSwitch modelSwitch = new FavoritesSwitch() {
		public Object caseFavoritesNode(FavoritesNode object) {
			return createFavoritesNodeAdapter();
		}

		public Object caseURIFavorite(URIFavorite object) {
			return createURIFavoriteAdapter();
		}

		public Object caseFavoritesFolder(FavoritesFolder object) {
			return createFavoritesFolderAdapter();
		}

		public Object caseFavorite(Favorite object) {
			return createFavoriteAdapter();
		}

		public Object caseModelAccessor(ModelAccessor object) {
			return createModelAccessorAdapter();
		}

		public Object caseModelAccessorFacade(IModelAccessor object) {
			return createModelAccessorFacadeAdapter();
		}

		public Object defaultCase(EObject object) {
			return createEObjectAdapter();
		}
	};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	public Adapter createAdapter(Notifier target) {
		return (Adapter) modelSwitch.doSwitch((EObject) target);
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode <em>Node</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode
	 * @generated
	 */
	public Adapter createFavoritesNodeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite <em>URI Favorite</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite
	 * @generated
	 */
	public Adapter createURIFavoriteAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder <em>Folder</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder
	 * @generated
	 */
	public Adapter createFavoritesFolderAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.ibm.team.foundation.rcp.core.internal.favorites.Favorite <em>Favorite</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.Favorite
	 * @generated
	 */
	public Adapter createFavoriteAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.ibm.team.foundation.rcp.core.internal.favorites.ModelAccessor <em>Model Accessor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.ModelAccessor
	 * @generated
	 */
	public Adapter createModelAccessorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.ibm.team.foundation.rcp.core.IModelAccessor <em>Model Accessor Facade</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.ibm.team.foundation.rcp.core.IModelAccessor
	 * @generated
	 */
	public Adapter createModelAccessorFacadeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //FavoritesAdapterFactory
