/**
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2007. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *
 * $Id$
 */
package com.ibm.team.foundation.rcp.core.internal.favorites;

import java.net.URI;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>URI Favorite</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getDetails <em>Details</em>}</li>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getFavoriteType <em>Favorite Type</em>}</li>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getUri <em>Uri</em>}</li>
 * </ul>
 * </p>
 *
 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage#getURIFavorite()
 * @model annotation="teamClass dbPersistable='false'"
 * @generated
 */
public interface URIFavorite extends FavoritesNode, ModelAccessor {
	/**
	 * Returns the value of the '<em><b>Details</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Details</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Details</em>' attribute.
	 * @see #isSetDetails()
	 * @see #unsetDetails()
	 * @see #setDetails(String)
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage#getURIFavorite_Details()
	 * @model unsettable="true"
	 * @generated
	 */
	String getDetails();

	/**
	 * Sets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getDetails <em>Details</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Details</em>' attribute.
	 * @see #isSetDetails()
	 * @see #unsetDetails()
	 * @see #getDetails()
	 * @generated
	 */
	void setDetails(String value);

	/**
	 * Unsets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getDetails <em>Details</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetDetails()
	 * @see #getDetails()
	 * @see #setDetails(String)
	 * @generated
	 */
	void unsetDetails();

	/**
	 * Returns whether the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getDetails <em>Details</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Details</em>' attribute is set.
	 * @see #unsetDetails()
	 * @see #getDetails()
	 * @see #setDetails(String)
	 * @generated
	 */
	boolean isSetDetails();

	/**
	 * Returns the value of the '<em><b>Favorite Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Favorite Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Favorite Type</em>' attribute.
	 * @see #isSetFavoriteType()
	 * @see #unsetFavoriteType()
	 * @see #setFavoriteType(String)
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage#getURIFavorite_FavoriteType()
	 * @model unsettable="true"
	 * @generated
	 */
	String getFavoriteType();

	/**
	 * Sets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getFavoriteType <em>Favorite Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Favorite Type</em>' attribute.
	 * @see #isSetFavoriteType()
	 * @see #unsetFavoriteType()
	 * @see #getFavoriteType()
	 * @generated
	 */
	void setFavoriteType(String value);

	/**
	 * Unsets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getFavoriteType <em>Favorite Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetFavoriteType()
	 * @see #getFavoriteType()
	 * @see #setFavoriteType(String)
	 * @generated
	 */
	void unsetFavoriteType();

	/**
	 * Returns whether the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getFavoriteType <em>Favorite Type</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Favorite Type</em>' attribute is set.
	 * @see #unsetFavoriteType()
	 * @see #getFavoriteType()
	 * @see #setFavoriteType(String)
	 * @generated
	 */
	boolean isSetFavoriteType();

	/**
	 * Returns the value of the '<em><b>Uri</b></em>' attribute.
	 * The default value is <code>""</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Uri</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Uri</em>' attribute.
	 * @see #isSetUri()
	 * @see #unsetUri()
	 * @see #setUri(String)
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage#getURIFavorite_Uri()
	 * @model default="" unsettable="true"
	 * @generated
	 */
	String getUri();

	/**
	 * Sets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getUri <em>Uri</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Uri</em>' attribute.
	 * @see #isSetUri()
	 * @see #unsetUri()
	 * @see #getUri()
	 * @generated
	 */
	void setUri(String value);

	/**
	 * Unsets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getUri <em>Uri</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetUri()
	 * @see #getUri()
	 * @see #setUri(String)
	 * @generated
	 */
	void unsetUri();

	/**
	 * Returns whether the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite#getUri <em>Uri</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Uri</em>' attribute is set.
	 * @see #unsetUri()
	 * @see #getUri()
	 * @see #setUri(String)
	 * @generated
	 */
	boolean isSetUri();

	URI uri();

	void setResolvedObject(Object resolved);
} // URIFavorite
