/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsAttributeType
extends AttributeType {
    public TagsAttributeType(String identifier) {
        super(identifier, String.class, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS, AttributeOperation.CONTAINS, AttributeOperation.NOT_CONTAINS}, new String[0], "_tags");
    }

    @Override
    public Object[] getValueSet(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        if (attribute == null) {
            return workItemCommon.findTags(workItem.getProjectArea(), monitor).toArray();
        }
        return workItemCommon.findTags2(attribute, monitor).toArray();
    }

    @Override
    public Object getNullValue(IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return "";
    }

    public static List<String> parseTags(String value) {
        ArrayList<String> result = new ArrayList<String>();
        TagsAttributeType.parseTags(result, value);
        return result;
    }

    private static void parseTags(Collection<String> result, String value) {
        if (value.length() > 0) {
            String[] tags = value.split(",");
            int j = 0;
            while (j < tags.length) {
                String part = tags[j].toLowerCase().trim();
                if (part.length() > 0 && !result.contains(part)) {
                    result.add(part);
                }
                ++j;
            }
        }
    }

    public static String normalizeTags(String tags) {
        String result = "";
        if (tags.length() > 0) {
            tags = tags.replaceAll(" ", ",");
            List<String> parsed = TagsAttributeType.parseTags(tags);
            return SeparatedStringList.toCommaSeparatedValue(parsed);
        }
        return result;
    }

    @Override
    public Object valueOf(String stringValue, Object origin) {
        String nospaces = stringValue.replaceAll(" ", "");
        return nospaces.toLowerCase();
    }
}

