/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Identifier<T> {
    public static final String SEPARATOR = ":";
    private String fStringIdentifier;
    private String fScope;
    private Class<T> fType;

    public static <T> Identifier<T> create(Class<T> type, String stringIdentifier) {
        return new Identifier<T>(stringIdentifier, type);
    }

    public static <T> Identifier<T> create(Class<T> type, String scope, String stringIdentifier) {
        return new Identifier<T>(scope, stringIdentifier, type);
    }

    private Identifier(String scope, String stringIdentifier, Class<T> type) {
        Assert.isNotNull((Object)stringIdentifier);
        Assert.isTrue((!"".equals(stringIdentifier) ? 1 : 0) != 0);
        Assert.isNotNull(type);
        this.fScope = scope;
        this.fStringIdentifier = stringIdentifier;
        this.fType = type;
    }

    private Identifier(String stringIdentifier, Class<T> type) {
        this(null, stringIdentifier, type);
    }

    public String getScope() {
        return this.fScope;
    }

    public String getStringIdentifier() {
        return this.fStringIdentifier;
    }

    public String getScopedIdentifier() {
        if (this.fScope != null && this.fScope.length() > 0) {
            return String.valueOf(this.fScope) + SEPARATOR + this.fStringIdentifier;
        }
        return this.fStringIdentifier;
    }

    public Class<T> getType() {
        return this.fType;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        if (this.fScope != null && !this.fScope.equals(other.fScope)) {
            return false;
        }
        if (this.fScope == null && this.fScope != other.fScope) {
            return false;
        }
        return other.fType.equals(this.fType) && other.fStringIdentifier.equals(this.fStringIdentifier);
    }

    public int hashCode() {
        return 17 * this.fStringIdentifier.hashCode() + this.fType.hashCode() + (this.fScope != null ? this.fScope.hashCode() : 0);
    }

    public String toString() {
        return String.valueOf(this.fType.getName()) + SEPARATOR + (this.fScope != null ? String.valueOf(this.fScope) + SEPARATOR : "") + this.fStringIdentifier;
    }

    public static <T> void assertSameType(Class<T> type, Identifier<T> identifier) {
        Assert.isTrue((identifier == null || type.equals(identifier.fType) || InternalType.class.equals(identifier.fType) ? 1 : 0) != 0);
    }

    private static class InternalType {
        private InternalType() {
        }
    }
}

