/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.validation.IItemValidator;
import com.ibm.team.repository.common.validation.IStringSizeConstraintErrorStatus;
import com.ibm.team.workitem.common.internal.util.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ValidationUtils {
    public static String truncate(IItemType type, String propertyName, String value) {
        if (value == null) {
            return value;
        }
        IStatus status = IItemValidator.INSTANCE.validateAttribute((IType)type, propertyName, (Object)value);
        if (status instanceof IStringSizeConstraintErrorStatus) {
            long maxSize = ((IStringSizeConstraintErrorStatus)status).getMaxSize();
            String truncated = value.substring(0, (int)maxSize);
            do {
                truncated = ValidationUtils.endAtWordBoundary(truncated);
                status = IItemValidator.INSTANCE.validateAttribute((IType)type, propertyName, (Object)truncated);
            } while (truncated.length() > 0 && status instanceof IStringSizeConstraintErrorStatus);
            return truncated;
        }
        return value;
    }

    private static String endAtWordBoundary(String string) {
        int space = string.lastIndexOf(32);
        if (space > 0) {
            return string.substring(0, space);
        }
        if (string.length() > 1) {
            return string.substring(0, string.length() - 1);
        }
        return "";
    }

    public static String removePunctuation(String string) {
        return string.replaceAll("\\p{Punct}+", "").trim();
    }

    public static boolean isValidPhraseSearch(String search) {
        int quoteIndex;
        if (search == null || search.length() == 0) {
            return true;
        }
        search = search.trim();
        int quoteCount = 0;
        int i = 0;
        while (i < search.length()) {
            if (search.charAt(i) == '\"') {
                ++quoteCount;
            }
            ++i;
        }
        if (quoteCount < 2) {
            return true;
        }
        boolean startsWithQuote = search.startsWith("\"");
        boolean endsWithQuote = search.endsWith("\"");
        boolean containsQuote = search.contains("\"");
        if (startsWithQuote && !endsWithQuote) {
            return false;
        }
        if (!startsWithQuote && endsWithQuote) {
            return false;
        }
        if (!startsWithQuote && !endsWithQuote && containsQuote) {
            return false;
        }
        return !startsWithQuote || !endsWithQuote || (quoteIndex = search.indexOf("\"", 1)) + 1 == search.length();
    }

    public static IStatus validatePhraseSearch(String search) {
        if (!ValidationUtils.isValidPhraseSearch(search)) {
            return new Status(2, "com.ibm.team.workitem.common", Messages.getString("ValidationUtils.INVALID_PHRASE_SEARCH"));
        }
        return Status.OK_STATUS;
    }
}

