/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationsHelper {
    public static final String ITERATION_NAME_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"name");
    public static final String ITERATION_START_DATE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"startDate");
    public static final String ITERATION_END_DATE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"endDate");
    public static final String PATH_SEPARATOR = "/";
    public static final String PATH_SEPARATOR_ESCAPED = "//";

    public static IIterationHandle findCurrentMilestone(IAuditableCommon auditableCommon, IDevelopmentLineHandle developmentLine, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IIteration> currentIterations = auditableCommon.findCurrentIterations(developmentLine, monitor);
        return IterationsHelper.findCurrentMilestone(currentIterations);
    }

    private static IIterationHandle findCurrentMilestone(List<IIteration> currentIterations) {
        ListIterator<IIteration> iterator = currentIterations.listIterator(currentIterations.size());
        while (iterator.hasPrevious()) {
            IIteration iteration = iterator.previous();
            if (!iteration.hasDeliverable()) continue;
            return (IIterationHandle)iteration.getItemHandle();
        }
        return null;
    }

    public static List<IIteration> findIterations(IAuditableCommon auditableCommon, IProjectAreaHandle projectAreaHandle, ItemProfile<IIteration> profile, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IIteration> iterations = new ArrayList<IIteration>();
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, ItemProfile.createProfile(IProjectArea.ITEM_TYPE, ProcessCommon.getPropertyName(IProjectArea.class, (String)"developmentLines")), monitor);
        List<IDevelopmentLine> developmentLines = auditableCommon.resolveAuditablesPermissionAware(Arrays.asList(projectArea.getDevelopmentLines()), ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
        for (IDevelopmentLine line : developmentLines) {
            iterations.addAll(IterationsHelper.findIterations(auditableCommon, line.getIterations(), profile, includeArchived, monitor));
        }
        return iterations;
    }

    public static List<IIteration> findIterations(IAuditableCommon auditableCommon, IDevelopmentLineHandle developmentLine, ItemProfile<IIteration> profile, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        IDevelopmentLine line = auditableCommon.resolveAuditable((IAuditableHandle)developmentLine, ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
        return IterationsHelper.findIterations(auditableCommon, line.getIterations(), profile, includeArchived, monitor);
    }

    public static List<IIteration> findAllIterations(IAuditableCommon auditableCommon, IIterationHandle[] parents, ItemProfile<IIteration> profile, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        return IterationsHelper.findIterations(auditableCommon, parents, profile, includeArchived, monitor);
    }

    private static List<IIteration> findIterations(IAuditableCommon auditableCommon, IIterationHandle[] parents, ItemProfile<IIteration> profile, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        String isArchivedProperty;
        String hasDeliverableProperty;
        String childrenProperty = ProcessCommon.getPropertyName(IIteration.class, (String)"children");
        if (!profile.contains(childrenProperty)) {
            profile = profile.createExtension(Collections.singleton(childrenProperty));
        }
        if (!profile.contains(hasDeliverableProperty = ProcessCommon.getPropertyName(IIteration.class, (String)"hasDeliverable"))) {
            profile = profile.createExtension(Collections.singleton(hasDeliverableProperty));
        }
        if (!profile.contains(isArchivedProperty = ProcessCommon.getPropertyName(IIteration.class, (String)"archived"))) {
            profile = profile.createExtension(Collections.singleton(isArchivedProperty));
        }
        ArrayList<IIteration> all = new ArrayList<IIteration>();
        ArrayList<IIterationHandle> found = new ArrayList<IIterationHandle>(Arrays.asList(parents));
        while (!found.isEmpty()) {
            List<IIteration> list = auditableCommon.resolveAuditablesPermissionAware(found, profile, monitor);
            all.addAll(list);
            found.clear();
            for (IIteration iteration : list) {
                found.addAll(Arrays.asList(iteration.getChildren()));
            }
        }
        Iterator iter = all.iterator();
        while (iter.hasNext()) {
            IIteration iteration;
            iteration = (IIteration)iter.next();
            if ((!iteration.isArchived() || includeArchived) && iteration.hasDeliverable()) continue;
            iter.remove();
        }
        return all;
    }

    @Deprecated
    public static void setDefaultTeamArea(IAuditableCommon auditableCommon, ITeamAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        workItemCommon.setDefaultTeamArea(handle, monitor);
    }

    public static IIteration resolveIterationFromPath(IProcessAreaHandle processAreaHandle, String iterationPath, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        IProcessArea processArea = auditableCommon.resolveAuditable((IAuditableHandle)processAreaHandle, ItemProfile.PROCESS_AREA_DEFAULT, (IProgressMonitor)progress.newChild(1));
        IProjectArea projectArea = auditableCommon.resolveAuditable((IAuditableHandle)processArea.getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT, (IProgressMonitor)progress.newChild(1));
        if (iterationPath == null || iterationPath.length() == 0 || !iterationPath.startsWith(PATH_SEPARATOR)) {
            return null;
        }
        String escapeLiteral = UUID.generate().getUuidValue();
        iterationPath = new StringBuilder(iterationPath).reverse().toString();
        iterationPath = iterationPath.replace(PATH_SEPARATOR_ESCAPED, new StringBuilder(escapeLiteral).reverse().toString());
        StringTokenizer tokenizer = new StringTokenizer((iterationPath = new StringBuilder(iterationPath).reverse().toString()).substring(1), PATH_SEPARATOR);
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        String token = tokenizer.nextToken().replace(escapeLiteral, PATH_SEPARATOR);
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        IDevelopmentLineHandle[] lines = projectArea.getDevelopmentLines();
        IDevelopmentLine line = null;
        progress.setWorkRemaining(1 + lines.length);
        IDevelopmentLineHandle[] iDevelopmentLineHandleArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            IDevelopmentLineHandle lineHandle = iDevelopmentLineHandleArray[n2];
            IDevelopmentLine iDevelopmentLine = auditableCommon.resolveAuditable((IAuditableHandle)lineHandle, ItemProfile.DEVELOPMENT_LINE_DEFAULT, (IProgressMonitor)progress.newChild(1));
            if (iDevelopmentLine.getId().equals(token)) {
                line = iDevelopmentLine;
                break;
            }
            ++n2;
        }
        if (line == null) {
            return null;
        }
        IIteration result = null;
        IIterationHandle[] iterations = line.getIterations();
        progress.setWorkRemaining(tokenizer.countTokens() * iterations.length);
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken().replace(escapeLiteral, PATH_SEPARATOR);
            IIteration current = null;
            List<IIteration> items = auditableCommon.resolveAuditablesPermissionAware(Arrays.asList(iterations), ItemProfile.ITERATION_DEFAULT, (IProgressMonitor)progress.newChild(iterations.length));
            for (IIteration iIteration : items) {
                if (!token.equals(iIteration.getId())) continue;
                current = iIteration;
                break;
            }
            if (current != null && !tokenizer.hasMoreTokens()) {
                result = current;
                continue;
            }
            if (current == null) {
                return null;
            }
            iterations = current.getChildren();
        }
        if (monitor != null) {
            monitor.done();
        }
        return result;
    }

    public static String createIterationPath(IIterationHandle iterationHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        StringBuilder result = new StringBuilder();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        IIteration current = null;
        while (iterationHandle != null) {
            current = auditableCommon.resolveAuditable((IAuditableHandle)iterationHandle, ItemProfile.ITERATION_DEFAULT, (IProgressMonitor)progress.newChild(1));
            result.insert(0, current.getId().replace(PATH_SEPARATOR, PATH_SEPARATOR_ESCAPED));
            result.insert(0, PATH_SEPARATOR);
            iterationHandle = current.getParent();
        }
        Assert.isNotNull(current);
        IDevelopmentLine timeline = auditableCommon.resolveAuditable((IAuditableHandle)current.getDevelopmentLine(), ItemProfile.DEVELOPMENT_LINE_DEFAULT, (IProgressMonitor)progress.newChild(1));
        result.insert(0, timeline.getId().replace(PATH_SEPARATOR, PATH_SEPARATOR_ESCAPED));
        result.insert(0, PATH_SEPARATOR);
        return result.toString();
    }
}

