/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.ISaveOperationParameter;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateLinks {
    public List<IWorkItemHandle> computeAffectedWorkItems(ISaveParameter saveParameter) {
        if (!(saveParameter.getNewState() instanceof IWorkItem) || saveParameter.getNewReferences() == null) {
            return Collections.emptyList();
        }
        ArrayList<IReference> references = new ArrayList<IReference>();
        references.addAll(saveParameter.getNewReferences().getCreatedReferences(WorkItemEndPoints.DUPLICATE_OF_WORK_ITEM));
        references.addAll(saveParameter.getNewReferences().getCreatedReferences(WorkItemEndPoints.DUPLICATE_WORK_ITEM));
        references.addAll(saveParameter.getNewReferences().getDeletedReferences(WorkItemEndPoints.DUPLICATE_WORK_ITEM));
        ArrayList<IWorkItemHandle> handles = new ArrayList<IWorkItemHandle>();
        for (IReference reference : references) {
            IItemHandle handle = ((IItemReference)reference).getReferencedItem();
            if (!(handle instanceof IWorkItemHandle)) continue;
            handles.add((IWorkItemHandle)handle);
        }
        return handles;
    }

    public void handleNotifySave(ISaveOperationParameter saveOperationParameter) {
        List<ISaveParameter> saveParameters = saveOperationParameter.getSaveParameters();
        int i = 0;
        while (i < saveParameters.size()) {
            ISaveParameter saveParameter = saveParameters.get(i);
            if (saveParameter.getNewState() instanceof IWorkItem) {
                List<IReference> created = saveParameter.getNewReferences().getCreatedReferences(WorkItemEndPoints.DUPLICATE_WORK_ITEM);
                for (IReference reference : created) {
                    IItemHandle handle = ((IItemReference)reference).getReferencedItem();
                    if (!(handle instanceof IWorkItemHandle)) continue;
                    ISaveParameter opposite = saveOperationParameter.findSaveParameter((IWorkItemHandle)handle);
                    if (opposite == null) {
                        throw new IllegalStateException("Missing opposite work item of duplicates link");
                    }
                    saveParameter.getNewReferences().remove(reference);
                    IWorkItemReferences oppositeReferences = opposite.getNewReferences();
                    for (IReference tmp : oppositeReferences.getReferences(WorkItemEndPoints.DUPLICATE_OF_WORK_ITEM)) {
                        oppositeReferences.remove(tmp);
                    }
                    oppositeReferences.add(WorkItemEndPoints.DUPLICATE_OF_WORK_ITEM, (IReference)WorkItemLinkTypes.createWorkItemReference((IWorkItem)saveParameter.getNewState()));
                }
                List<IReference> deleted = saveParameter.getNewReferences().getDeletedReferences(WorkItemEndPoints.DUPLICATE_WORK_ITEM);
                for (IReference reference : deleted) {
                    IItemHandle handle = ((IItemReference)reference).getReferencedItem();
                    if (!(handle instanceof IWorkItemHandle)) continue;
                    ISaveParameter opposite = saveOperationParameter.findSaveParameter((IWorkItemHandle)handle);
                    if (opposite == null) {
                        throw new IllegalStateException("Missing opposite work item of duplicates link");
                    }
                    saveParameter.getNewReferences().add(WorkItemEndPoints.DUPLICATE_WORK_ITEM, reference);
                    IWorkItemReferences oppositeReferences = opposite.getNewReferences();
                    for (IReference tmp : oppositeReferences.getReferences(WorkItemEndPoints.DUPLICATE_OF_WORK_ITEM)) {
                        oppositeReferences.remove(tmp);
                    }
                }
            }
            ++i;
        }
    }
}

