/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.template;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.workitem.common.internal.template.Messages;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.template.IAttributeVariable;
import com.ibm.team.workitem.common.template.IWorkItemTemplateDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemTemplateDescriptor
implements IWorkItemTemplateDescriptor {
    private final String fIdentifier;
    private final IProjectAreaHandle fProjectArea;
    private String fName;
    private String fDescription;
    private List<IAttributeVariable> fVariables;
    private List<IWorkItemHandle> fItemHandles;

    public WorkItemTemplateDescriptor(String identifier, IProjectAreaHandle projectArea) {
        if (identifier == null || identifier.length() == 0 || projectArea == null) {
            throw new IllegalArgumentException(Messages.getString("WorkItemTemplateDescriptor.ERROR_ON_INITIALIZATION"));
        }
        this.fIdentifier = identifier;
        this.fProjectArea = projectArea;
    }

    @Override
    public String getId() {
        return this.fIdentifier;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        if (name != null && name.length() > 0) {
            this.fName = name;
        }
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    public void setDescription(String description) {
        if (description != null && description.length() > 0) {
            this.fDescription = description;
        }
    }

    @Override
    public IProjectAreaHandle getProjectArea() {
        return this.fProjectArea;
    }

    @Override
    public List<IAttributeVariable> getVariables() {
        return this.fVariables != null ? this.fVariables : Collections.emptyList();
    }

    public void setVariables(IAttributeVariable ... variables) {
        if (variables != null && variables.length > 0) {
            this.fVariables = new ArrayList<IAttributeVariable>(Arrays.asList(variables));
        }
    }

    @Override
    public List<IWorkItemHandle> getWorkItems() {
        return this.fItemHandles != null ? Collections.unmodifiableList(this.fItemHandles) : Collections.emptyList();
    }

    public void setWorkItems(List<IWorkItemHandle> handles) {
        this.fItemHandles = handles;
    }
}

