/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.template;

import com.ibm.team.links.common.ILink;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.template.IWorkItemDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemDescriptor
implements IWorkItemDescriptor {
    private final Map<Identifier<IAttribute>, Object> fAttributes = new HashMap<Identifier<IAttribute>, Object>();
    public final Map<Identifier<ILink>, Set<String>> fLinks = new HashMap<Identifier<ILink>, Set<String>>();

    public void addAttribute(Identifier<IAttribute> attributeId, Object value) {
        if (attributeId != null && value != null) {
            this.fAttributes.put(attributeId, value);
        }
    }

    @Override
    public Set<Identifier<IAttribute>> getAttributes() {
        Set<Identifier<IAttribute>> attrs = this.fAttributes.keySet();
        return attrs != null ? new HashSet<Identifier<IAttribute>>(attrs) : Collections.emptySet();
    }

    @Override
    public Object getValue(Identifier<IAttribute> handle) {
        return this.fAttributes.get(handle);
    }

    public void addLink(Identifier<ILink> linkId, String localItemId) {
        if (!this.fLinks.containsKey(linkId)) {
            this.fLinks.put(linkId, new HashSet());
        }
        this.fLinks.get(linkId).add(localItemId);
    }

    @Override
    public Map<Identifier<ILink>, Set<String>> getLinks() {
        return Collections.unmodifiableMap(this.fLinks);
    }

    @Override
    public int size() {
        return this.fAttributes.size();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fAttributes == null ? 0 : this.fAttributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkItemDescriptor other = (WorkItemDescriptor)obj;
        return !(this.fAttributes == null ? other.fAttributes != null : !this.fAttributes.equals(other.fAttributes));
    }
}

